/*
          ooo
   oo    ooo
    oo  ooo
v e r y a n t
      ooo

# 6390 Greenwich Drive, #225,
# San Diego, CA 92122, USA
#
# @COPYRIGHT@.
*/

# ifndef iscobolc_h
# define iscobolc_h  "$Id: iscobolc.h,v 1.5 2008/12/15 14:46:40 marco Exp $"

# ifdef WIN32
# define ISCOBOLEXPORT  __declspec(dllexport)
# else
# define ISCOBOLEXPORT
# endif

/**
 * isCOBOL interface from 'C' language.
 * Every function returns an int value, ISCOBOLC_SUCCESS if everything has 
 * gone well, ISCOBOLC_ERROR otherwise.
 */

# define ISCOBOLC_SUCCESS 0
# define ISCOBOLC_ERROR   (-1)
# define ISCOBOLC_THREAD   (-1)

/**
 * Initialize the JVM. Any item of optv is passed to the JVM as starting option.
 * If there is an option in the form "-Djava.class.path=", the classpath is
 * set accordingly, otherwise the classpath is got from the environment
 * variable.
 * optc < 0 means that third argument is a Java VM already created.
 * It is declared as void * to not bore people who do not need it
 * to include all the JNI headers.
 * If something goes wrong, the process is terminated.
 *
 * Arguments: optc = number of options;
 *            optv = starting options;
 *            ejvm = already created JavaVM;
 */
int ISCOBOLEXPORT isCobolInit (int optc, char *optv[], void *ejvm);
/**
 * An extended version of the above function allowing to pass a further
 * argument in order to receive a pointer to the isCobol interface environment;
 * this pointer shall be used in subsequent function call in threaded programs.
 *
 * When a thread needs to attach to an isCOBOL enverinment and the JVM is
 * already initialized, then the first paramater must be set to ISCOBOLC_THREAD
 * while the second and the third are ignored.
 */
int ISCOBOLEXPORT isCobolInitEx (int optc, char *optv[], void *ejvm,
                                 void **pice);
/**
 * A simplified version of the above function; it allows to initialize a new
 * thread when the JVM is already initialized.
 */
# define isCobolThreadInit(pice) \
                          isCobolInitEx(ISCOBOLC_THREAD,(char**)0,(void*)0,pice)
/**
 * Enables C programs to call COBOL programs. Parameters are passed BY REFERENCE
 * This function resembles the COBOL CALL statement.
 *
 * Arguments: name = program to call;
 *            argc = number of arguments;
 *            argv = arguments;
 *            argl = arguments length;
 *            rc   = CALL return code;
 */
int ISCOBOLEXPORT isCobolCall (char *name,int argc,char *argv[],int argl[],
                               long *crc);
/**
 * An extended version of the above function allowing to pass a further
 * argument specifying the isCOBOL environment when a call is performed
 * in a multi-threaded environment; the sixth argument must be a
 * pointer to the isCobol interface environment got by using an isCobolInitEx
 * call.
 */
int ISCOBOLEXPORT isCobolCallEx (char *name,int argc,char *argv[],int argl[],
                                 long *crc, void *ice);
/**
 * Same as isCobolCall(), however when a STOP RUN statement
 * is encountered, the run unit doesn't terminate and an exception
 * of class com.iscobol.java.StopRunAsException is set on isCobolError()
 */
int ISCOBOLEXPORT isCobolCallNoStop (char *name,int argc,char *argv[],int argl[],
                               long *crc);
/**
 * Same as isCobolCallEx(), however when a STOP RUN statement
 * is encountered, the run unit doesn't terminate and an exception
 * of class com.iscobol.java.StopRunAsException is set on isCobolError()
 */
int ISCOBOLEXPORT isCobolCallExNoStop (char *name,int argc,char *argv[],int argl[],
                                 long *crc, void *ice);                      
/**
 * Cancels the COBOL program name previously called.
 *
 * Arguments: name = program to cancel;
 */
int ISCOBOLEXPORT  isCobolCancel (char *name);
/**
 * An extended version of the above function allowing to pass a further
 * argument specifying the isCOBOL environment when a call is performed
 * in a multi-threaded environment; the second argument must be a
 * pointer to the isCobol interface environment got by using an isCobolInitEx
 * call.
 */
int ISCOBOLEXPORT  isCobolCancelEx (char *name, void *ice);

/**
 * Enables C programs to call COBOL programs. Parameters are passed BY REFERENCE
 * This function resembles the COBOL CALL statement immediatly followed by 
 * a CANCEL statement.
 *
 * Arguments: name = program to call;
 *            argc = number of arguments;
 *            argv = arguments;
 *            argl = arguments length;
 *            rc   = CALL return code;
 */
int ISCOBOLEXPORT isCobolFunc (char *name,int argc,char *argv[],int argl[],long *crc);
/**
 * An extended version of the above function allowing to pass a further
 * argument specifying the isCOBOL environment when a call is performed
 * in a multi-threaded environment; the sixth argument must be a
 * pointer to the isCobol interface environment got by using an isCobolInitEx
 * call.
 */
int ISCOBOLEXPORT isCobolFuncEx (char *name,int argc,char *argv[],int argl[],long *crc, void *ice);

/**
 * Shut down the JVM.
 */
int ISCOBOLEXPORT isCobolTidy (void);
/**
 * This call shut down a single thread, not the JVM. The argument must be a
 * pointer to the isCobol interface environment got by using either isCobolInitEx
 * or isCobolThreadInit call, and after this call it cannot be used anymore.
 */
int ISCOBOLEXPORT isCobolThreadTidy (void *ice);

/**
 * Shut down the JVM and exit.
 */
int ISCOBOLEXPORT isCobolExit (int exitCode);

/**
 * Get the last error messages, if available. If this function returns
 * ISCOBOLC_ERROR, means that there were no errors. The message is
 * got calling the Java method ex.toString().
 */
int ISCOBOLEXPORT  isCobolError (char *msg, int len);
/**
 * An extended version of the above function allowing to pass a further
 * argument specifying the isCOBOL environment when a call is performed
 * in a multi-threaded environment; the third argument must be a
 * pointer to the isCobol interface environment got by using an isCobolInitEx
 * call.
 */
int ISCOBOLEXPORT  isCobolErrorEx (char *msg, int len, void *ice);
/**
 * Returns the JNIEnv pointer to handle directly the JNI API.
 */
void ISCOBOLEXPORT  * isCobolGetJNIEnv ();
/**
 * Returns the JNIEnv pointer bound to an iscobol interface environment, got
 * by calling isCobolInitEx, in order to handle directly the JNI API.
 */
void ISCOBOLEXPORT  * isCobolGetJNIEnvEx (void *ice);

/**
 * throw a Java exception of type com.iscobol.so.GobackException
 */
int ISCOBOLEXPORT  isCobolGoback (void);
/**
 * An extended version of the above function allowing to pass a further
 * argument specifying the isCOBOL environment when a call is performed
 * in a multi-threaded environment; the argument must be a
 * pointer to the isCobol interface environment got by using an isCobolInitEx
 * call.
 */
int ISCOBOLEXPORT  isCobolGobackEx (void *ice);

/**
 * the EXTFH function
 */
void ISCOBOLEXPORT EXTFH (char* op, char* fcd);

# endif
