package calendarpanel;

import java.util.Calendar;
import java.util.Date;

import javax.swing.Icon;

import org.jbundle.util.calendarpanel.model.CalendarConstants;
import org.jbundle.util.calendarpanel.model.CalendarItem;

public class CalendarPanelItem implements CalendarItem, Comparable<CalendarPanelItem> {
   
   private static Calendar calendar = Calendar.getInstance();

   private Date startDate;
   private Date endDate;
   private String description;  
   private String mealDescription;
   private Icon iconStart;
   private Icon iconEnd;
   private int highlightColor;
   private int selectColor;

   public CalendarPanelItem(Date startDate, String description) {
      this(startDate, null, description, null, null, null, 0, 0);
   }

   public CalendarPanelItem(Date startDate, Date endDate, String description,
         String mealDescription, Icon iconStart, Icon iconEnd,
         int highlightColor, int selectColor) {
      setStartDate(startDate);
      setEndDate(endDate);
      setDescription(description);
      setMealDescription(mealDescription);
      setIcon(iconStart, CalendarConstants.START_ICON);
      setIcon(iconEnd, CalendarConstants.END_ICON);
      setHighlightColor(highlightColor);
      setSelectColor(selectColor);
   }

   @Override
   public boolean remove() {
      return false;
   }

   @Override
   public String getDescription() {
      return description;
   }

   @Override
   public Date getStartDate() {
      return startDate;
   }

   @Override
   public Date getEndDate() {
      return endDate;
   }

   @Override
   public String getMealDesc(Date date) {
      if (!date.before(startDate) && !date.after(endDate)) {
         return mealDescription;
      }
      return null;
   }

   @Override
   public Object getIcon(int iIconType) {
      if (iIconType == CalendarConstants.START_ICON)
         return iconStart;
      else if (iIconType == CalendarConstants.END_ICON)
         return iconEnd;
      else
         return null;
   }

   @Override
   public int getHighlightColor() {
      return highlightColor;
   }

   @Override
   public int getSelectColor() {
      return selectColor;
   }

   @Override
   public Date setStartDate(Date startDate) {
      this.startDate = startDate;
      return startDate;
   }

   @Override
   public Date setEndDate(Date endDate) {
      this.endDate = endDate;
      if(this.endDate == null) {
         calendar.setTime(this.startDate);
         calendar.add(Calendar.DAY_OF_MONTH, 1);
         this.endDate = calendar.getTime();
      }
      return this.endDate;
   }

   @Override
   public void setIcon(Object icon, int iIconType) {
      if(icon instanceof Icon) {
         if(iIconType == CalendarConstants.START_ICON)
            this.iconStart = (Icon) icon;
         else if(iIconType == CalendarConstants.END_ICON)
            this.iconEnd = (Icon) icon;
      } else if(icon == null) {
         if(iIconType == CalendarConstants.START_ICON)
            this.iconStart = null;
         else if(iIconType == CalendarConstants.END_ICON)
            this.iconEnd = null;
      }
   }

   @Override
   public Object getVisualJavaBean(int iPanelType) {
      return null;
   }

   @Override
   public int getStatus() {
      return 1;
   }

   @Override
   public int setStatus(int iStatus) {
      return 0;
   }
   
   public void setDescription(String description) {
      this.description = description;
   }
   
   public void setMealDescription(String description) {
      this.mealDescription = description;
   }
   
   public void setHighlightColor(int highlightColor) {
      this.highlightColor = highlightColor;
   }
   
   public void setSelectColor(int selectColor) {
      this.selectColor = selectColor;
   }
   
   @Override
   public boolean equals(Object o) {
      if(o instanceof CalendarPanelItem) {
         CalendarPanelItem cpi = (CalendarPanelItem) o;
         return startDate.equals(cpi.startDate) && description.equals(cpi.description);
      } else
         return false;
   }

   @Override
   public int compareTo(CalendarPanelItem o) {
      int r = startDate.compareTo(o.startDate);
      if(r == 0)
         r = description.compareTo(o.description);
      return r;
   }
   
   @Override
   public int hashCode() {
      return toString().hashCode();
   }
   
   @Override
   public String toString() {
      return startDate.toString() + "/" + description;
   }

}
