      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. MULTIFOLDER.   

       WORKING-STORAGE SECTION.
       copy "iscobol.def".
       77  hdir             handle.
       77  dat-files        pic x(5)  value "*.dat".
       77  curr-dir         pic x(256).
       77  input-folder     pic x(256).
       77  output-folder    pic x(256).
       77  filename         pic x(256).
       77  ismigrate-input  pic x(256).
       77  ismigrate-output pic x(256).
       77  data-folder      pic x(50).

       01  more-info.
           03 read-count    long.
           03 write-count   long.
           03 skip-count    long.
           03 error-buffer. 
              05 err-1      pic x(128).
              05 err-2      pic x(256).


       PROCEDURE DIVISION.
       main. 
           call "c$chdir" using curr-dir.
           
           perform create-output-folders.
           
           set environment "ismigrate_input_file_index"  to "jisam". 
           set environment "ismigrate_output_file_index" to "ctreej".
           set environment "ismigrate_no_directories"    to "1".
           set environment "ismigrate_no_echo"           to "1".
           set environment "file.index.index_suffix"     to ".idx"
           set environment "file.index.data_suffix"      to ".dat".

           string curr-dir              delimited by trailing spaces
                  "/"                   delimited by size
                  data-folder           delimited by trailing spaces
                  "/"                   delimited by size
                  "jisam_files/folder1" delimited by size
                                        into input-folder.
           string curr-dir              delimited by trailing spaces
                  "/"                   delimited by size
                  data-folder           delimited by trailing spaces
                  "/"                   delimited by size
                  "ctree_files/folder1" delimited by size
                                        into output-folder.
           perform process-folder.

           string curr-dir              delimited by trailing spaces
                  "/"                   delimited by size
                  data-folder           delimited by trailing spaces
                  "/"                   delimited by size
                  "jisam_files/folder2" delimited by size
                                        into input-folder.
           string curr-dir              delimited by trailing spaces
                  "/"                   delimited by size
                  data-folder           delimited by trailing spaces
                  "/"                   delimited by size
                  "ctree_files/folder2" delimited by size
                                        into output-folder.
           perform process-folder.
           string curr-dir              delimited by trailing spaces
                  "/"                   delimited by size
                  data-folder           delimited by trailing spaces
                  "/"                   delimited by size
                  "jisam_files/folder3" delimited by size
                                        into input-folder.
           string curr-dir              delimited by trailing spaces
                  "/"                   delimited by size
                  data-folder           delimited by trailing spaces
                  "/"                   delimited by size
                  "ctree_files/folder3" delimited by size
                                        into output-folder.
           perform process-folder.  

           goback.

       create-output-folders.
           accept data-folder from environment "multifolder.data"
           if data-folder = spaces
              move "." to data-folder
           end-if

           string curr-dir       delimited by trailing spaces
                  "/"            delimited by size
                  data-folder    delimited by trailing spaces
                  "/ctree_files" delimited by size
                  into output-folder
           end-string.
           call "c$makedir" using output-folder.

           string curr-dir       delimited by trailing spaces
                  "/"            delimited by size
                  data-folder    delimited by trailing spaces
                  "/ctree_files/folder1" delimited by size
                  into output-folder
           end-string.
           call "c$makedir" using output-folder.
       
           string curr-dir       delimited by trailing spaces
                  "/"            delimited by size
                  data-folder    delimited by trailing spaces
                  "/ctree_files/folder2" delimited by size
                  into output-folder
           end-string.
           call "c$makedir" using output-folder.       

           string curr-dir       delimited by trailing spaces
                  "/"            delimited by size
                  data-folder    delimited by trailing spaces
                  "/ctree_files/folder3" delimited by size
                  into output-folder
           end-string.
           call "c$makedir" using output-folder.       
       
       
       process-folder.
           call "c$list-directory" using listdir-open
                                         input-folder
                                         dat-files
                                  giving hdir.
           if hdir = 0
              stop run
           end-if.

           perform until exit

             call "c$list-directory" using listdir-next
                                           hdir
                                           filename
              if filename = spaces
                 exit perform
              end-if

              initialize ismigrate-input, ismigrate-output

              string input-folder delimited by trailing spaces
                     "/"          delimited by size
                     filename     delimited by ".dat"
                                  into ismigrate-input

              string output-folder delimited by trailing spaces
                     "/"          delimited by size
                     filename     delimited by ".dat"
                                  into ismigrate-output

              display "Migrating " ismigrate-input

              call "ISMIGRATE" using ismigrate-input, 
                                     ismigrate-output,
                                     more-info
                              giving return-code
              if return-code = 0
                display "migration OK"
                display read-count  " read, "
                        write-count " written, "
                        skip-count  " skipped"
              else
                 display err-1
                 display err-2
              end-if

           end-perform

           call "c$list-directory" using listdir-close, hdir.
