      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. tab-flat.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       01  tab-album.
      ***
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Yellow Submarine".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Help!".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Yesterday".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Angie".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Start Me Up".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Satisfaction".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Rain Fall Down".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Maria Maria".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Oye como va".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Lightning in the sky".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Foo Foo".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Money for Nothing".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "After Midnight".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "Bad Love".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "Next Time You See Her".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "Albachiara".
           03 filler pic x(20) value "Vasco Rossi".
      ***
           03 filler pic x(30) value "Tango".
           03 filler pic x(20) value "Vasco Rossi".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(20) value "Vasco Rossi".
      ***
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(20) value "Vasco Rossi".

       01  tab-album-red     redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-title    pic x(30).
              05 ta-Artist   pic x(20).
              
       77  cont              pic 9(2).

       SCREEN SECTION.

       01  Mask.
           03 Tb1-container
              tab-control
              line                          2 
              col                           2
              lines                         17 cells
              size                          68 cells
              allow-container
              tab-flat
              active-tab-border-width       (0 0 2 0)
              tab-border-width              (0 0 1 0)
              tab-foreground-color          rgb x#ACACAC
              tab-border-color              rgb x#ACACAC
              active-tab-border-color       rgb x#395a9d
              active-tab-background-color   rgb x#dae1e5 
              active-tab-foreground-color   rgb x#354c5c
              .
           03 tb1-container-page1 
              tab-group Tb1-container       tab-group-value 1.
              05 label 
                 line                       4
                 col                        4
                 title                      "This is the first page"
                 .
              05 ef1-container
                 entry-field
                 line                       6
                 col                        4
                 .
           03 tb1-container-page2 
              tab-group Tb1-container       tab-group-value 2.
              05 label
                 line                       4
                 col                        4 
                 title                      "This is the second page"
                 .
              05 cb1-container
                 combo-box
                 line                       6
                 col                        4
                 .
           03 tb1-container-page3  
              tab-group Tb1-container       tab-group-value 3.
              05 label
                 line                       4
                 col                        4
                 title                      "This is the third page"
                 .
              05 ls1-container 
                 list-box
                 line                       6
                 col                        4
                 size                       61
                 lines                      12
                 display-columns            (1, 31)
                 data-columns               (1, 31)
                 alignment                  ("L", "L")
                 separation                 (0, 0)
                 dividers                   (1, 1)
                 .
           03 push-button
              line                          20
              col                           2
              size                          20 cells
              title                         "View &Source [F2]"
              exception-value               2
              .
           03 push-button
              line                          20
              col                           62
              size                          8 cells
              title                         "Exit" 
              exception-value               27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "TAB Control flat"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify Tb1-container tab-to-add ("Page1", "Page2", "Songs")

           modify Cb1-container item-to-add ("item1", "item2")

           perform varying cont from 1 by 1 until cont > 20
              modify ls1-container item-to-add ta-item(cont)
           end-perform

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception
                    continue 
              end-accept
              if crt-status = 2
                 perform VIEW-SORG
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin 
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path   delimited by trailing space
                  "s-gui"          delimited by space
                  "/TAB-FLAT.cbl"  delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.

