      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. cblscrchattrs.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  fixed-font              handle of font fixed-font.
       77  close-win               pic 9 value 0.

       01  screen-position. 
           03 row-number           pic x comp-x. 
           03 column-number        pic x comp-x.
       77  character-buffer        pic x(128).
       77  attribute-buffer        pic x(128).
       77  string-length           pic xx comp-x.
       77  status-code             pic s9.
       77  type-of-read            pic 9.
       77  new-string              pic x(30) value "My new string".
       77  wcharacter              pic x comp-x.
 

       PROCEDURE DIVISION.
       MAIN.
           display window
                   line 2
                   title  "CBL_READ_SCR_CHATTRS and CBL_WRITE_SCR_CHATTR
      -                   "S Routines"
                   lines 24
                   size 80
                   font fixed-font
                   handle hWin 
                   event  WIN-EVT
                   .

           perform DRAW-MASK

           perform until crt-status = 27 or close-win = 1
              accept new-string at 1304 update
                    on exception 
                       continue 
              end-accept
              evaluate crt-status
              when 1
                   move 1 to type-of-read
                   perform SHOW-RESULT
              when 2
                   move 2 to type-of-read
                   perform SHOW-RESULT
              when 3
                   move 3 to type-of-read
                   perform SHOW-RESULT
              when 4
                   move 4 to type-of-read
                   perform SHOW-RESULT
              when 5
                   perform WRITE-N-CHAR
              when 27
                   exit perform
              end-evaluate
           end-perform

           destroy hWin
           goback
           .

       DRAW-MASK.
           display box line 1 col 2 lines 10 size 78

           display "String and attribute to read" line 01 position 4.

           display "This line is with reverse" 
                                         line 03 position 25 reverse.
           display "This line is with high"    
                                         line 05 position 25 high.
           display "This line is with low" 
                                         line 07 position 25 low.
           display "This line is with underline" 
                                         line 09 position 25 underline.

           display box line 11 col 2 lines 4 size 78
           display "New String"      line 11 position 4.

           display box line 15 col 2 lines 5 size 78
           display "Writen strings" line 15 position 4.

           display box line 20 col 2 lines 6 size 78

           display "F1  - Read the line with reverse" 
                                         line 21 position 4.
           display "F2  - Read the line with high"    
                                         line 21 position 40.
           display "F3  - Read the line with low" 
                                         line 22 position 4.
           display "F4  - Read the line underline" 
                                         line 22 position 40.
           display "F5  - Replace string to read" 
                                         line 23 position 4.
           display "ESC - exit" 
                                         line 23 position 40.
           .
           
       SHOW-RESULT.
           initialize character-buffer
                      attribute-buffer
                      string-length
                      status-code

           perform READ-SCR.

           move 16  to row-number, 
           move 3   to column-number

           perform WRITE-SCR
           move 17  to row-number
           move new-string   to character-buffer
           perform WRITE-SCR
           .

       READ-SCR.
       
           evaluate type-of-read
           when 1
                move 2   to row-number 
                move 24  to column-number
           when 2
                move 4   to row-number 
                move 24   to column-number
           when 3
                move 6  to row-number 
                move 24 to column-number
           when 4
                move 8  to row-number 
                move 24 to column-number
           end-evaluate

           move 30 to string-length.
           call "cbl_read_scr_chattrs"  
                 using screen-position, 
                       character-buffer, 
                       attribute-buffer, 
                       string-length  
             returning status-code  
           if status-code = 0
              display message box "Unable to read from the screen"
           end-if
           .

       WRITE-SCR.
           display space line row-number + 1 size 60 col 5.

           move 50 to string-length.
           call "cbl_write_scr_chattrs"  
                 using screen-position, 
                       character-buffer, 
                       attribute-buffer, 
                       string-length  
             returning status-code
           if status-code = 0
              display message box "Unable to write to the screen"
           end-if
           .

       WRITE-N-CHAR.

           perform varying type-of-read from 1 by 1 
                          until type-of-read > 4
              perform READ-SCR
       
              move 42  to wcharacter
              call "CBL_WRITE_SCR_N_CHATTR"  
                    using screen-position, 
                          wcharacter, 
                          attribute-buffer, 
                          string-length  
              returning status-code
           end-perform.

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .