      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CREPLACEALL.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
                                           
       77  source-str              pic x any length.
       77  dest-str                pic x any length.
       77  wrk-str                 pic x any length.

       77  expression              pic x any length.
       77  new-text                pic x any length.

       77  W-error                 pic x(50).
       77  wstatus                 pic 9(3).

       77  Cont                    pic 9(3).

       SCREEN SECTION.
       01  Mask.
           03 label 
              line                 2
              col                  2
              size                 22 cells
              title                "Original String:" 
              .
           03 entry-field 
              line                 2
              lines                3
              col                  20
              size                 50 cells
              multiline 
              value                source-str  
              .   
           03 label 
              line                 6
              col                  2
              size                 22 cells
              title                "Regular Expression:" 
              .
           03 entry-field 
              line                 6
              col                  20
              size                 50 cells 
              value                expression
              .   
           03 label 
              line                 8
              col                  2
              size                 22 cells
              title                "Text to replace:" 
              .
           03 entry-field 
              line                 8
              col                  20
              size                 50 cells 
              value                new-text
              .   
           03 push-button
              line                 10
              col                  2
              size                 10 cells
              title                "&Replace"
              exception-value      101
              .
           03 label 
              line                 12
              col                  2
              size                 22 cells
              title                "New String:" 
              .
           03 new-str entry-field 
              read-only
              multiline
              line                 12
              lines                3
              col                  20
              size                 50 cells 
              value                dest-str  
              .   
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$REPLACE_ALL Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           move "This is an example of the routine REPLACE_ALL" 
                          to source-str
           move space to dest-str

           move "RE" to expression

           move "C\$RE" to new-text

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
                       when 101 
                            perform REPLACE-ALL
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       REPLACE-ALL.
           move source-str   to wrk-str

           CALL "C$REPLACE-ALL" USING wrk-str 
                                      expression 
                                      new-text
                                      crep-right-trimmed 
                                      W-error
                                giving wstatus

           evaluate wstatus
           when 0
                continue
           when 1
                display message box "Invalid regular expression" 
                                     x"0D0A"
                                     W-error
                move space   to wrk-str
           when 2
                display message box "Insufficient paramters"
                                     x"0D0A"
                                     W-error
                move space   to wrk-str
           when 3
                display message box "Malformed replacement"
                                     x"0D0A"
                                     W-error
                move space   to wrk-str
           end-evaluate.
           move wrk-str   to dest-str
           modify new-str value dest-str.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
