      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CTOLOWER. 

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  text-len                usage unsigned-int.
       77  e-text-len              pic 9.
       77  text-data               pic x(25).
       77  text-result-data        pic x(25).

       01                          pic 9.
           88 full-string          value 1 false zero.
       77  rb-value                pic 9.

       SCREEN SECTION.
       01  Mask.
           03  label 
               line                3 
               col                 3
               size                13 cells
               title               "Input text: "
               .
           03  entry-field   
               line                3 
               col                 35
               value               text-data
               .
           03  radio-button 
               line                5 
               col                 3
               left-text
               Left-Text-Alignment 1
               title               "Entire text"
               group               1
               group-value         1 
               value               rb-value
               size                31 cells
               exception-value     103
               . 
           03  radio-button 
               line                7
               left-text
               Left-Text-Alignment 1
               col                 3
               title               "Select the n� of chars to convert: "
               group               1
               group-value         2
               value               rb-value
               size                31 cells
               exception-value     103
               . 
           03  ef-text-len
               entry-field  
               line                07 
               col                 35 
               value               text-len
               enabled             e-text-len
               .
           03  push-button
               line                 10
               col                  2
               title                "C$TOLOWER"
               size                 15 cells
               exception-value      101
               self-act
               .
           03  label
               line                12
               col                 03
               size                23 cells
               title               "Result: "
               .
           03  result
               label  
               line                12
               col                 35
               title               text-result-data
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.     
           set full-string            to true
           move 1                     to rb-value.
           move 0                     to e-text-len.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$TOLOWER Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           move 0 to text-len
           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept 
              evaluate crt-status 
              when 101
                   move text-data  to text-result-data
                   if full-string
                      call "C$TOLOWER" using text-result-data 
                   else
                      call "C$TOLOWER" using text-result-data, 
                                             text-len
                   end-if
                   modify result title text-result-data
              when 103
                   if rb-value = 1
                      set full-string   to true
                      move 0            to e-text-len
                   else
                      set full-string   to false
                      move 1            to e-text-len
                   end-if
                   modify ef-text-len enabled e-text-len
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
           
       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
