      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. keymap.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  new-exc                 pic 9(2) value 1.
       77  f1-data                 pic x(12).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 18 cells
              title                "Exception for F1:" 
              .
           03 entry-field
              line                 2
              col                  19
              size                 4 cells
              min-val              1
              max-val              10 
              max-text             2
              value                new-exc
              .
           03 push-button
              line                 2 
              col                  23
              size                 4 cells
              title                "Set"
              exception-value      1000
              .
           03 push-button
              line                 4 
              col                  2 
              size                 20 cells
              title                "Backup Keystrokes"
              exception-value      1001
              .
           03 push-button
              line                 6
              col                  2
              size                 20 cells
              title                "Restore Keystrokes"
              exception-value      1002
              .
           03 label
              line                 9 
              col                  2
              size                 30 cells
              title                "Press F1 to check its exception"
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$KEYMAP routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                  on exception
                    continue
              end-accept 
              evaluate crt-status
              when 1000
                   initialize f1-data
                   string "exception=" delimited by size
                           new-exc     delimited by size 
                                       into f1-data
                   set environment "key.f1" to f1-data
              when 1001
                   call "C$KEYMAP" using 1
              when 1002
                   call "C$KEYMAP" using 0
              when other
                   display message "crt status = " 
                                   crt-status
              end-evaluate
              move 4   to accept-control
           end-perform
           
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
