      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. RIO.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isfilesys.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  h-float                 handle of window.
       77  PBOK                    handle of push-button.
       77  f                       handle .
       77  file-io                 pic x(128).
       77  rec-buffer              pic x(22).
       77  frel                    pic x(32).

       77  wrk-line                pic 99.

       01  rio-lparms.
           03 max-rec-sz           pic 999.
           03 filler               pic x value ",".
           03 min-rec-sz           pic 999.

       77  key-val                 pic 9(5) value 0.

       77  edit-9                  pic z(15)9.
       77  edit-x                  pic x(16)   redefines edit-9.
       77  error-desc              pic x(50).
       01                          pic 0.
           88 operation-failed     value 1 false zero.
       
       SCREEN SECTION.
       01  Mask. 
           03  label 
               line                4
               col                 3
               title               "current file.relative:"
               .
           03  label  
               col                 20
               title               frel
               .  
           03 push-button
              line                 06 
              col                  02
              size                 12
              title                "&File handling"
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.  
           accept frel from environment "file.relative"
              on exception 
                 move "relative " to frel
           end-accept.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "R$IO Routine"
                   lines 21
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 102
                   perform FILE-HANDLING
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       FILE-HANDLING.
           display independent window
                   system menu
                   lines 19, size 40
                   title "i-o operations"
                   control font control-font 
                   font control-font 
                   handle h-float

           set operation-failed to false.

      *creates the file
      *this is the FD
      * 01 record.
      *  03 record-key  pic 99.
      *  03 record-data pic x(20).

           move 2   to wrk-line
           display "Creating file..." line wrk-line col 2 

           call  "C$GETENV" USING "user.home"
                                  file-io.
           string file-io          delimited by trailing space
                  "/iss-file-rio"   delimited by size
                  into file-io
           move 22 to max-rec-sz, min-rec-sz
           set r-make-function to true
           call "r$io" using rio-function, file-io, rio-lparms

           if return-code = 0
              perform DISPLAY-ERROR
           else
              perform DISPLAY-OK
           end-if

      *opening 
           if not operation-failed 
              add 2 to wrk-line
              display "Opening file..." line wrk-line col 2 
           
              set r-open-function to true
              move fio to open-mode
              move 22  to max-rec-size, min-rec-size
              call "r$io" using rio-function, file-io, open-mode 
                                max-rec-size, min-rec-size
              if return-code > 0
                 move return-code to f
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if
      *record writing
           if not operation-failed 
              move 0 to key-val
              add 2 to wrk-line
              display "Writing into file..." line wrk-line col 2
              set r-write-function to true
              perform 3 times
                 add 1 to key-val
                 move "00xxx" to rec-buffer
                 call "r$io" using rio-function, f, rec-buffer,
                                   max-rec-size, key-val
                 if return-code = 0
                    perform DISPLAY-ERROR
                    exit perform
                 else
                    perform DISPLAY-OK
                 end-if
              end-perform
           end-if
      *start
           if not operation-failed
              add 2 to wrk-line 
              display title "Getting the first record..." line wrk-line
                                                          col 2 
              set r-start-function to true
              set f-equals       to true
              move 1             to key-val
              call "r$io" using rio-function, f, key-val, start-mode
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *read next
           if not operation-failed 
              add 2 to wrk-line
              display "Reading next record..." line wrk-line col 2
              set r-next-function to true
              call "r$io" using rio-function, f, rec-buffer 
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *record rewriting
           if not operation-failed 
              add 2 to wrk-line
              display "Rewriting into file..." line wrk-line col 2
              set r-rewrite-function to true
              move "00zzz" to rec-buffer     
              call "r$io" using rio-function, f, rec-buffer, 
                                max-rec-size, key-val
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if.
      *record deleting
           if not operation-failed 
              add 1 to key-val
              add 2 to wrk-line
              display "Deleting record..." line wrk-line col 2
              set r-delete-function to true
              call "r$io" using rio-function, f, key-val, 
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *close
           if not operation-failed
              add 2 to wrk-line 
              display "Closing file..." line wrk-line col 2
              set r-close-function to true
              call "r$io" using rio-function, f
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
           
           add 2 to wrk-line
           display push-button line wrk-line col 2 title "OK" 
                   handle PBOK 
           accept PBOK
           destroy h-float
           .

       DISPLAY-ERROR.
           set operation-failed to true.
           display "FAILED" col 34.

           move f-errno      to edit-9
           call "C$JUSTIFY" using edit-x, "L"
           
           initialize error-desc
           string "f-errno: "   delimited by size
                  edit-x        delimited by trailing space
                  into error-desc 
           add 2 to wrk-line
           display error-desc   line wrk-line col 2
           add 2 to wrk-line
           display f-errmsg line wrk-line col 2.

           evaluate true
           when e-sys-err   
                move "system or interface error"        to error-desc
           when e-param-err
                move "wrong data for r$io"              to error-desc
           when e-too-many-files              
                move "too many files opened"            to error-desc
           when e-mode-clash
                move "mode clash"                       to error-desc
           when e-rec-locked
                move "record locked"                    to error-desc
           when e-broken
                move "file broken"                      to error-desc
           when e-duplicate
                move "duplicated record"                to error-desc
           when e-not-found
                move "record not found"                 to error-desc
           when e-undef-record
                move "undefined record"                 to error-desc
           when e-disk-full
                move "disk full"                        to error-desc
           when e-file-locked
                move "file locked"                      to error-desc
           when e-rec-changed
                move "record size changed"              to error-desc
           when e-mismatch
                move "record mismatch"                  to error-desc
           when e-no-memory
                move "no more memory"                   to error-desc
           when e-missing-file 
                move "file not found or unrecognized"   to error-desc
           when e-permission
                move "no permission"                    to error-desc
           when e-no-support
                move "unsupported operation"            to error-desc
           when e-no-locks
                move "no more locks available"          to error-desc
           when e-interface
                move "interface error (9D)"             to error-desc
           when e-license-err
                move "license expired"                  to error-desc
           when other
                move "unknown error"                    to error-desc
           end-evaluate.  

           add 2 to wrk-line
           display error-desc line wrk-line col 2. 

       DISPLAY-OK.
           display "OK" col 34.

       WIN-EVT.  
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
