      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. SIO.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isfilesys.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  h-float                 handle of window.
       77  PBOK                    handle of push-button.
       77  f                       handle .
       77  file-io                 pic x(128).
       77  flseq                   pic x(32).
       
       77  wrk-line                pic 99.

       01  sio-lparms.
           03 max-rec-sz           pic 9.
           03 filler               pic x value ",".
           03 file-type            signed-short.
           03 filler               pic x value ",".
           03 block-sz             pic 9 value 0.

       01  rec-buffer.
           03 rec-val              pic 9(5).
           03 filler               pic x value x"00".

       77  edit-9                  pic z(15)9.
       77  edit-x                  pic x(16)   redefines edit-9.
       77  error-desc              pic x(50).
       01                          pic 0.
           88 operation-failed     value 1 false zero.

       SCREEN SECTION.
       01  Mask. 
           03  label 
               line                4
               col                 3
               title               "current file.linesequential:"
               .
           03  label  
               col                 25
               title               flseq
               .  
           03 push-button
              line                 06 
              col                  02
              size                 12
              title                "&File handling"
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.  
           accept flseq from environment "file.linesequential"
              on exception 
                 move "lseq8bit" to flseq
           end-accept.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "S$IO Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 102
                   perform FILE-HANDLING
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       FILE-HANDLING.
           display independent window
                   system menu
                   lines 19, size 40
                   title "i-o operations"
                   control font control-font
                   font control-font 
                   handle h-float

           set operation-failed to false.

      *creates the file
           move 2   to wrk-line
           display "Creating file..." line wrk-line col 2

           call  "C$GETENV" USING "user.home"
                                  file-io.
           string file-io          delimited by trailing space
                  "/iss-file-sio"   delimited by size
                  into file-io
           inspect file-io replacing trailing space by low-value

           move s-line    to seq-type
           move seq-type  to file-type
           set max-rec-sz to size of rec-val.

           set s-make-function to true
           call "s$io" using sio-function, 
                             file-io, 
                             sio-lparms
           if return-code = 0
              perform DISPLAY-ERROR
           else
              perform DISPLAY-OK
           end-if

      *opening
           if not operation-failed
              add 2 to wrk-line
              display "Opening file..." line wrk-line col 2
              set s-open-function to true
              move foutput to open-mode
              call "s$io" using sio-function, 
                                file-io, 
                                open-mode, 
                                max-rec-sz, 
                                seq-type, 
                                0, 
                                0  
              if return-code > 0
                 move return-code to f
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

      *record writing
           if not operation-failed
              move 0 to rec-val
              add 2 to wrk-line
              display "Writing into file..." line wrk-line col 2
              set s-write-function to true
              perform 5 times
                 add 1 to rec-val
                 call "s$io" using sio-function, 
                                   f, 
                                   rec-buffer, 
                                   0, 
                                   0
                 if return-code = 0
                    perform DISPLAY-ERROR
                    exit perform
                 else
                    perform DISPLAY-OK
                 end-if
              end-perform
           end-if

      *close file  
           if not operation-failed
              add 2 to wrk-line
              display "Closing file..." line wrk-line col 2
              set s-close-function to true
              call "s$io" using sio-function, 
                                f
              if return-code > 0
                 move return-code to f
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if.

      *open file for i-o 
           if not operation-failed
              add 2 to wrk-line
              display "Opening file..." line wrk-line col 2
              set s-open-function to true
              move fio to open-mode
              call "s$io" using sio-function, 
                                file-io, 
                                open-mode, 
                                max-rec-sz, 
                                seq-type, 
                                0, 
                                0 
              if return-code > 0
                 move return-code to f
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

      *read 1 record
           if not operation-failed
              add 2 to wrk-line
              display "Reading next record..." line wrk-line col 2
              set s-read-function to true
              initialize rec-buffer
              call "s$io" using sio-function,
                                f, 
                                rec-buffer
              if return-code = zero
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if

      *rewrite current record
           if not operation-failed
              add 2 to wrk-line
              display "Rewriting into file..." line wrk-line col 2
              set s-rewrite-function to true 
              move 99999 to rec-val
              call "s$io" using sio-function, 
                                f, 
                                rec-buffer, 
                                0   
              if return-code = 0
                 perform DISPLAY-ERROR
                 move return-code to f
              else
                 perform DISPLAY-OK
              end-if
           end-if

      *close
           if not operation-failed
              add 2 to wrk-line
              display "Closing file..." line wrk-line col 2
              set r-close-function to true
              call "s$io" using rio-function, f

              if return-code > 0
                 move return-code to f
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

           add 2 to wrk-line
           display push-button line wrk-line col 2 title "OK" 
                   handle PBOK
           accept PBOK
           destroy h-float
           .

       DISPLAY-ERROR.
           set operation-failed to true.
           display "FAILED" col 34.

           move f-errno      to edit-9
           call "C$JUSTIFY" using edit-x, "L"
           
           initialize error-desc
           string "f-errno: "   delimited by size
                  edit-x        delimited by trailing space
                  into error-desc 
           add 2 to wrk-line
           display error-desc line wrk-line col 2
           add 2 to wrk-line
           display f-errmsg line wrk-line col 2.

           evaluate true
           when e-sys-err   
                move "system or interface error"        to error-desc
           when e-param-err
                move "wrong data for s$io"              to error-desc
           when e-too-many-files
                move "too many files opened"            to error-desc
           when e-mode-clash
                move "mode clash"                       to error-desc
           when e-rec-locked
                move "record locked"                    to error-desc
           when e-broken
                move "file broken"                      to error-desc
           when e-duplicate  
                move "duplicated record"                to error-desc
           when e-not-found
                move "record not found"                 to error-desc
           when e-undef-record
                move "undefined record"                 to error-desc
           when e-disk-full
                move "disk full"                        to error-desc
           when e-file-locked
                move "file locked"                      to error-desc
           when e-rec-changed
                move "record size changed"              to error-desc
           when e-mismatch
                move "record mismatch"                  to error-desc
           when e-no-memory
                move "no more memory"                   to error-desc
           when e-missing-file 
                move "file not found or unrecognized"   to error-desc
           when e-permission
                move "no permission"                    to error-desc
           when e-no-support
                move "unsupported operation"            to error-desc
           when e-no-locks
                move "no more locks available"          to error-desc
           when e-interface                   
                move "interface error (9D)"             to error-desc
           when e-license-err                 
                move "license expired"                  to error-desc
           when other
                move "unknown error"                    to error-desc
           end-evaluate.  

           add 2 to wrk-line
           display error-desc line wrk-line col 2. 

       DISPLAY-OK.
           display "OK" col 34.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
