      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WBITMAP-TEXT.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  p-text                  pic x any length.
       77  p-shape                 pic 9.
           88 p-circle             value 1.
           88 p-square             value 2.
       77  p-size                  pic 9(3).

       77  p-color-type            pic 9.
           88 p-solid              value 1.
           88 p-gradient           value 2.

       77  h-image-icon            pic s9(9) comp-4.
       77  h-font                  handle of font.

       77  font-name               pic x any length.
       77  title-font-name         pic x any length.

       77  color-text-hex          pic x(6).
       77  color-back-hex          pic x(6).
       77  color-gradient-hex      pic x(6).

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  v-gradient              pic 9 value 1.

       01  wrk-color-hex.
           03  wrk-hex-r           pic xx.
           03  wrk-hex-g           pic xx.
           03  wrk-hex-b           pic xx.
       77  wrk-color               pic s9(9).

       01  wrk-buffer-rgb.
           03  wrk-r               pic 999.
           03  wrk-g               pic 999.
           03  wrk-b               pic 999.
           
       77  hfont                   handle of font.

       77  orientation             pic x any length.
       77  w-orientation           pic 9.

       77  ed-font-size            pic z(3)9.
       
       77  title-lbl-color         pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 Bmp1 
              bitmap
              line                 1.5
              col                  2
              lines                6 cells
              size                 15 cells
              layout-data          rlm-resize-both
              visible              h-image-icon
              .
           03 label
              line                 2
              col                  19
              title                "Text:"
              .
           03 ef-title
              entry-field
              line                 2
              col                  26
              size                 10 cells
              value                p-text
              .
           03 label
              line                 4
              col                  19
              title                "Font:"
              .
           03 lbl-font-name
              label
              line                 4
              lines                1.2
              col                  26
              size                 40
              title                title-font-name
              .
           03 push-button
              line                 2
              col                  50
              size                 15 cells
              title                "Change font"
              exception-value      102
              .
           03 label
              line                 6
              col                  19
              size                 20
              title                "Shape:"
              .
           03 radio-button
              group                1
              group-value          1
              line                 6.1
              col                  26
              title                "Circle"
              value                p-shape
              .
           03 radio-button
              group                1
              group-value          2
              line                 6.1
              col                  35
              title                "Square"
              value                p-shape
              .
           03 label
              line                 6
              col                  50
              title                "Size in Pixel:"
              .
           03 entry-field
              numeric
              line                 6
              col                  62
              size                 4 cells
              value                p-size
              max-text             3
              right
              .
           03 frame
              engraved
              line                 8
              col                  2
              size                 68
              lines                9.5
              title                "Colors"
              .
           03 label
              line                 9.5
              col                  3
              size                 16 cells
              title                "Text:"
              transparent
              .
           03 ef-color-text
              entry-field
              line                 9.5
              col                  19
              size                 8 cells
              value                color-text-hex
              upper 
              max-text             6
              input-filter         "^[0-9a-fA-F]+$"
              .
           03 label
              line                 11.5
              col                  3
              size                 16 cells
              title                "background type:"
              transparent
              .
           03 radio-button
              group                2
              group-value          1
              line                 11.6
              col                  19
              title                "Color"
              value                p-color-type
              exception-value      103
              .
           03 radio-button
              group                2
              group-value          2
              line                 11.6
              col                  30
              title                "Gradient"
              value                p-color-type
              exception-value      103
              .
           03 lbl-color
              label
              line                 13.5
              col                  3
              size                 16 cells
              title                title-lbl-color
              transparent
              .
           03 ef-gradient-1
              entry-field
              line                 13.5
              col                  19
              size                 8 cells
              value                color-back-hex
              upper 
              max-text             6
              .
           03 label
              line                 13.5
              col                  30
              title                "Gradient 2:"
              transparent
              visible              v-gradient
              .
           03 ef-gradient-2
              entry-field
              line                 13.5
              col                  50
              size                 8 cells
              value                color-gradient-hex
              upper 
              max-text             6
              visible              v-gradient
              .
           03 label
              line                 15.5
              col                  3
              title                "Orientation:"
              transparent
              visible              v-gradient
              .
           03 cb-orientation 
              combo-box 
              unsorted
              drop-list 
              color                513
              line                 15.5
              col                  19
              size                 25 cells
              value                orientation
              visible              v-gradient
              .
           03 push-button
              line                 18
              col                  2
              size                 20 cells
              title                "Generate"
              exception-value      101
              .
           03 push-button
              line                 20
              col                  2
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".

           perform SET-INITIAL-VALUE

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$BITMAP Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           modify cb-orientation 
                   item-to-add ("north to south"
                                "northeast to southwest"
                                "east to west"
                                "southeast to northwest"
                                "south to north"
                                "southwest to northeast"
                                "west to east"
                                "northwest to southeast")

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-BITMAP.
           call "W$BITMAP" using wbitmap-destroy, h-image-icon
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 2
                perform VIEW-SORG
           when 101
                perform GENERATE-IMAGE
           when 102
                perform CHANGE-FONT
           when 103
                perform SWITCH-COLOR-TYPE
           end-evaluate
           .

       GENERATE-IMAGE.

           perform DESTROY-BITMAP

           initialize wbitmap-tb-data

           evaluate true
           when p-circle
                set wbitmap-tb-circle to true
           when p-square
                set wbitmap-tb-square to true
           end-evaluate

           move h-font to wbitmap-tb-font
           move p-size to wbitmap-tb-width
           
           move color-text-hex  to wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color       to wbitmap-tb-text-color

           move color-back-hex  to wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color       to wbitmap-tb-bg-color

           evaluate true
           when p-solid
                move -1   to wbitmap-tb-grd-or
           when p-gradient
                move color-gradient-hex  to wrk-color-hex
                perform CALCULATE-COLOR
                move wrk-color        to wbitmap-tb-bg-color-2
                evaluate orientation
                when "north to south"
                     move gradient-north-to-south to wbitmap-tb-grd-or
                when "northeast to southwest"
                     move gradient-northeast-to-southwest 
                                                  to wbitmap-tb-grd-or
                when "east to west"
                     move gradient-east-to-west   to wbitmap-tb-grd-or
                when "southeast to northwest"
                     move gradient-southeast-to-northwest 
                                                  to wbitmap-tb-grd-or
                when "south to north"
                     move gradient-south-to-north to wbitmap-tb-grd-or
                when "southwest to northeast"
                     move gradient-southwest-to-northeast 
                                                  to wbitmap-tb-grd-or
                when "west to east"
                     move gradient-west-to-east   to wbitmap-tb-grd-or
                when "northwest to southeast"
                     move gradient-northwest-to-southeast 
                                                  to wbitmap-tb-grd-or
                end-evaluate
           end-evaluate

           call "w$bitmap" using wbitmap-text-box 
                                 p-text 
                                 wbitmap-tb-data
                          giving h-image-icon.

           if h-image-icon = 0
                display message "Image not generated." x"0D0A"
                                "Please check the selected font."
                                icon mb-error-icon
           end-if

           modify Bmp1 bitmap-handle h-image-icon
           .

       SET-INITIAL-VALUE.

           move "VS"      to p-text
           set p-circle   to true
           move 50        to p-size
           move "585DC1"  to color-text-hex
           move "FFFFFF"  to color-back-hex
           move "C4DCF3"  to color-gradient-hex
           move "Gradient 1:"   to title-lbl-color 
           move 1         to v-gradient

           set p-gradient to true

           move "north to south"         to orientation
           move gradient-north-to-south  to w-orientation

           call "w$createfont" using "files/times.ttf" 
                                     font-name

           initialize wfont-data
           set wfdevice-console to true
           move font-name       to wfont-name
           move 12              to wfont-size
           perform LOAD-FONT-FROM-NAME
           perform CHANGE-FONT-LABEL
           .

       LOAD-FONT-FROM-NAME.
           if function handle-type (h-font) = handle-of-font
              destroy h-font
           end-if

           set wfdevice-console to true
           CALL "W$FONT" using wfont-get-font
                               h-font
                               wfont-data
           .

       CHANGE-FONT.
           initialize wfont-data
           set wfdevice-console to true
           move font-name       to wfont-name
           CALL "W$FONT" using wfont-choose-font
                               h-font
                               wfont-data

           if return-code = 1
              perform LOAD-FONT-FROM-NAME 
              perform CHANGE-FONT-LABEL
              modify lbl-font-name title title-font-name
           end-if
           .

       CHANGE-FONT-LABEL.
           initialize title-font-name

           if function handle-type (h-font) = handle-of-font
              move wfont-size   to ed-font-size
              string wfont-name delimited by trailing space
                     " "        delimited by size
                     function trim(ed-font-size) delimited by size
                     into title-font-name

              if wfont-bold
                 string title-font-name delimited by trailing space
                        " bold"       delimited by size
                        into title-font-name
              end-if

              if wfont-italic
                 string title-font-name delimited by trailing space
                        " italic"     delimited by size
                        into title-font-name
              end-if
           else
              move "Not Loaded" to title-font-name
           end-if
           .

       CALCULATE-COLOR.
           move function hex2dec(wrk-hex-r) to wrk-r.
           move function hex2dec(wrk-hex-g) to wrk-g.
           move function hex2dec(wrk-hex-b) to wrk-b.

           compute wrk-color = (wrk-r  * 65536 + 
                                wrk-g  * 256   + 
                                wrk-b) * -1
           .

       SWITCH-COLOR-TYPE.
           evaluate true
           when p-solid
                move 0             to v-gradient
                move "Color:"      to title-lbl-color
           when p-gradient
                move 1             to v-gradient
                move "Gradient 1:" to title-lbl-color
           end-evaluate

           display Mask 
           .

       DESTROY-BITMAP.
           if function handle-type (h-image-icon) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, h-image-icon
           end-if.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path      delimited by trailing space
                  "s-routines"        delimited by space
                  "/WBITMAP-TEXT.cbl" delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
