      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. wbitmap.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9    value 0.

       77  title-bmp-handling      pic x any length.
       77  title-bmp-icon          pic x any length.
       77  title-bmp-text          pic x any length.
       
       SCREEN SECTION.

       01  mask.
           03 frame
              engraved
              line                 2
              col                  3
              size                 32
              lines                9
              title                "Bitmap handling"
              .
           03 push-button 
              line                 4 
              col                  4 
              size                 10 
              title                "Demo" 
              exception-value      1
              .
           03 label
              line                 6
              lines                5
              col                  4
              size                 30
              title                title-bmp-handling
              transparent
              .
           03 frame
              engraved
              line                 2
              col                  38
              size                 32
              lines                9
              title                "Strip image or font as icon"
              .
           03 push-button 
              line                 4 
              col                  39 
              size                 10 
              title                "Demo"
              exception-value      2
              .
           03 label
              line                 6
              lines                5
              col                  39
              size                 30
              title                title-bmp-icon 
              transparent
              .
           03 frame
              engraved
              line                 12
              col                  3
              size                 32
              lines                9
              title                "Icon with text"
              .
           03 push-button 
              line                 14
              col                  4 
              size                 10 
              title                "Demo"
              exception-value      3
              .
           03 label
              line                 16
              lines                5
              col                  4
              size                 30
              title                title-bmp-text 
              transparent
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           move "Shows how to use the W$BITMAP function to load a " &
                "bitmap file in memory"  to title-bmp-handling

           move "Shows how to use W$BITMAP to load a strip image or " &
                "render characters with a given font as a bitmap " & 
                "and use it inside a control"  to title-bmp-icon

           move "Shows how to use the wbitmap-text-box op-code to " &
                "generate a configurable bitmap containg a given text" 
                to title-bmp-text

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$BITMAP Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           perform until crt-status = 27 or close-win = 1
              accept  mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 1 
                   call run "WBITMAP-HANDLING"
              when 2 
                   call run "WBITMAP-ICON"
              when 3
                   call run "WBITMAP-TEXT"
              end-evaluate
              move 4   to accept-control
           end-perform 

           destroy mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
