      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    WD2HANDLING.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  gui-factory-class       pic 9.
       77  browser-info            pic x any length.
       77  user-agent              pic x any length.
       77  s-field                 pic x(32).
       77  s-value                 pic x(128).
       77  g-field                 pic x any length.
       77  g-value                 pic x(128).

       SCREEN SECTION.
       01  Mask.
           03 label 
              line                 2
              col                  3 
              size                 30 cells
              title                "Set a custom session variable:"
              .
           03 label 
              line                 4
              col                  3 
              size                 8 cells
              title                "Name:"
              .
           03 entry-field
              line                 4
              col                  10
              size                 46 cells
              max-text             32
              value                s-field
              .
           03 label
              line                 6
              col                  3 
              size                 8 cells
              title                "Value:"
              .
           03 entry-field
              line                 6
              col                  10
              size                 46 cells
              max-text             128
              value                s-value
              .
           03 push-button
              line                 6
              col                  60
              title                "Set"
              exception-value      101
              .
           03 label 
              line                 9
              col                  3 
              size                 30 cells
              title                "Inquire a session variable:"
              .
           03 label 
              line                 11
              col                  3 
              size                 8 cells
              title                "Name:" 
              .
           03 cb-session-value
              combo-box
              Drop-Down
              line                 11
              col                  10
              size                 46 cells
              value                g-field
              . 
           03 push-button
              line                 11
              col                  60
              title                "Get"
              exception-value      102
              .
           03 label 
              line                 13
              col                  3 
              size                 70 cells
              title                "(Select a system variable to inquire
      -                            " or type a custom session variable)"
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.       
           display standard graphical window
                   background-low  
                   line 2
                   col 65
                   title  "Web Direct 2 session info"
                   lines 21 
                   size 70 
                   handle hWin 
                   event  WIN-EVT

           call "C$GETRUNENV" GIVING gui-factory-class
           if gui-factory-class not = runenv-wd2
              display message 
              "This sample works only in Web Direct 2 environment"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if

           call "WD2$CLIENT_INFO" using wd2-get-browser-name
                                        browser-info
           call "WD2$CLIENT_INFO" using wd2-get-user-agent
                                        user-agent  
           display message user-agent X"0D0A" browser-info
                   title   "Current browser"

           display Mask

           modify cb-session-value item-to-add (
                 "iscobol.wd2.on_client_info.desktop.width"
                 "iscobol.wd2.on_client_info.desktop.height" 
                 "iscobol.wd2.on_client_info.screen.width"
                 "iscobol.wd2.on_client_info.screen.height"
                 "iscobol.wd2.servletcontext.name"
                 "iscobol.wd2.servletcontext.realpath"
                 "iscobol.wd2.servletcontext.path"
                 "iscobol.wd2.servletcontext.serverinfo"
                 "iscobol.wd2.servletcontext.majorversion"
                 "iscobol.wd2.servletcontext.minorversion"
                 "iscobol.wd2.httpsession.id"
                 "iscobol.wd2.httpsession.creationtime")

           perform until crt-status = 27
              accept Mask 
                 on  exception
                    continue
              end-accept  
              evaluate crt-status
              when 101 
                   perform SET-VALUE
              when 102
                   perform GET-VALUE
              end-evaluate
              move 4   to accept-control 
           end-perform
                          
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       SET-VALUE.
           call "WD2$SESSION" using wd2-put-session-value
                                    s-field, s-value
           if return-code < 0
              display message "Operation failed: " return-code
           else
              display message "Field '" s-field "' set to '" s-value "'"
           end-if
           .

       GET-VALUE.       
           call "WD2$SESSION" using wd2-get-session-value
                                    g-field, g-value    
           if return-code < 0
              display message "Operation failed: " return-code
           else
              display message "Value of '" g-field "' is '" g-value "'"
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
