      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WINPLAYS.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4). 
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  v-local                 pic 9.
       77  sound-path              pic x(256).

       SCREEN SECTION.
       01  Mask.
           03 Ef1  
              entry-field 
              line                 2 
              col                  2 
              size                 62 cells
              value                sound-path
              .
           03 Pb1  
              push-button
              line                 2 
              col                  + 2 
              size                 4 cells
              title                "..." 
              exception-value      101
              visible              v-local
              self-act
              .
           03 Pb2 
              push-button
              line                 4
              col                  2
              size                 15 cells
              title                "Play Sound"
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       INI.
           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "WIN$PLAYSOUND Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           move "files/sound.wav" to sound-path
           display Mask 

           perform until crt-status = 27 or close-win = 1
              accept Mask on exception continue end-accept
              evaluate crt-status
              when 101
                   perform CHOOSE-SOUND 
              when 102
                   perform PLAY-SOUND
              end-evaluate
              move 4   to accept-control
           end-perform
                      
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CHOOSE-SOUND.
           initialize opensave-data

           string "WAV Files (*.wav)|*.wav"
                  "|"
                  "AIFF Files (*.aiff)|*.aiff"  
                  delimited by size into opnsav-filters

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data

           if return-code not < 0
              move opnsav-filename to sound-path 
              modify Ef1 value sound-path
           end-if
           .

       PLAY-SOUND.
           call "WIN$PLAYSOUND" using sound-path, 
                                      snd-async

           evaluate return-code
           when -1 
                display message "The WIN$PLAYSOUND library routine is "
                                "not supported."
                                icon mb-error-icon
           when 0 
                display message "Operation failed."
                                icon mb-error-icon
           end-evaluate.
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
