      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WROTATE.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  flag-destroy            pic 9 value 0.
       77  h-bitmap                pic s9(9) comp-4.
       77  h-bitmap-rotate         pic s9(9) comp-4.
       77  buffer                  pic 999 value 0.
       77  angle                   pic 9.99.
       77  rx                      pic 9.99.
       77  ry                      pic 9.99.

       77  v-local                 pic 9.
       77  bitmap-path             pic x(256).
       77  v-bmp1                  pic 9 value 1.

       SCREEN SECTION.
       01  Mask.
           03 Bmp1 
              bitmap
              line                 2
              col                  3
              lines                15 cells
              size                 66 cells
              layout-data          rlm-resize-both
              visible              v-bmp1
              .
           03 Ef1  
              entry-field 
              line                 18 
              col                  2 
              size                 60 cells
              value                bitmap-path
              .
           03 Pb1  
              push-button
              line                 18 
              col                  62 
              size                 8 cells
              title                "..." 
              exception-value      101
              visible              v-local
              .
           03 Pb-image  
              push-button
              line                 20 
              col                  2 
              size                 12 cells
              title                "Load image" 
              exception-value      104
              .
           03 Pb2 
              push-button 
              enabled              0
              line                 20
              col                  15
              size                 6 cells
              title                "+45�"
              exception-value      102
              .
           03 Pb3
              push-button 
              enabled              0
              line                 20
              col                  21
              size                 6 cells
              title                "-45�"
              exception-value      103
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
            
       PROCEDURE DIVISION.
       INI.
           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$ROTATE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           move "files/img.png" to bitmap-path
           display Mask

           perform SHOW-IMAGE

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 101
                   perform CHOOSE-IMAGE  
              when 102
                   if buffer not = 360
                      add 45 to buffer
                   else
                      move 45 to buffer
                   end-if
                   perform ROTATE
              when 103
                   if buffer not = 0
                      subtract 45 from buffer
                   else
                      move 315 to buffer
                   end-if 
                   perform ROTATE  
              when 104
                   perform SHOW-IMAGE
              end-evaluate
              move 4   to accept-control
           end-perform
           

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-IMAGE.
           goback
           .

       CHOOSE-IMAGE.
           initialize opensave-data
           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png|"
                  "All images (*.bmp;*.jpg;*.gif;*.png)|"
                  "*.bmp;*.jpg;*.gif;*.png"
                  delimited by size
                  into opnsav-filters.

           move 5   to opnsav-default-filter

           call "C$OPENSAVEBOX" using opensave-open-box
                                      opensave-data
           if opnsav-basename not = spaces
              move opnsav-filename to bitmap-path
              modify Ef1 value bitmap-path
              perform SHOW-IMAGE
           end-if
           .

       SHOW-IMAGE.
           if flag-destroy = 0    
              modify Pb3 enabled 1
              modify Pb2 enabled 1
              move 1 to flag-destroy
           else
              perform DESTROY-IMAGE
           end-if
           call "W$BITMAP" using wbitmap-load, bitmap-path
                           giving h-bitmap

           evaluate h-bitmap
           when -1
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "File not found or not readable"
                                icon mb-error-icon
           when -2
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "Out of memory loading the bitmap"
                                icon mb-error-icon
           when -3
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "Not a valid bitmap"
                                icon mb-error-icon
           when -4
                move 0 to v-bmp1
                display message "W$BITMAP Error: "
                                "Format not supported"
                                icon mb-error-icon
           when other
                move 1 to v-bmp1
                move 0    to angle
                move 0.5  to rx
                move 0.5  to ry
                modify Bmp1 bitmap-handle h-bitmap
           end-evaluate
           modify Bmp1 visible v-bmp1
           .

       DESTROY-IMAGE.
           if function handle-type (h-bitmap) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy h-bitmap
           end-if
           if function handle-type (h-bitmap-rotate) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy h-bitmap-rotate
           end-if
           .

       ROTATE.
           compute angle = buffer * 0.01745
           call "w$rotate" using h-bitmap angle rx ry
                          giving h-bitmap-rotate
           modify Bmp1 bitmap-handle h-bitmap-rotate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
