var vueApp = new Vue({
  el: '#vueApp',
  data:{
    htmlVersion: 'isCOBOL release 2024 R2 build#1131.8-20241108-38916',
    appVersion: null,
    notifications:[
      {
        expanded: false,
        type: 'messages',
        icon:'fa-envelope',
        entries:[
          {label: 'This is a sample message'},
          {label: 'This is another sample message'},
          {label: 'This is the third sample message'},
        ]
      },
    ],
    messages:[
      {
        expanded: false,
        sender: 'John Smith',
        title: 'Call me when you get in the office',
        timestamp: new Date(new Date().setHours(new Date().getHours(-6))),
        avatar: 'user8-128x128.jpg'
      },
      {
        expanded: false,
        sender: 'Patricia Clark',
        title: 'New deal terms',
        timestamp: new Date(new Date().setHours(new Date().getHours(-4))),
        avatar: 'user7-128x128.jpg'
      },
      {
        expanded: false,
        sender: 'Edward Callister',
        title: 'Here are some mockups',
        timestamp: new Date(new Date().setHours(new Date().getHours(-3))),
        avatar: 'user1-128x128.jpg'
      },
      {
        expanded: false,
        sender: 'Edna Newton',
        title: 'Let\'s get lunch together',
        timestamp: new Date(new Date().setHours(new Date().getHours(-1))),
        avatar: 'user3-128x128.jpg'
      },
    ]
  },
  methods:{
    setVersion: function(version){
      this.appVersion = version;
      document.getElementById('runtimeVersion').style.display='';
    },
    countNotifications: function(){
      let res = 0;
      this.notifications.forEach(n => res += n.entries.length);
      return res
    },
    addNotification: function(icon, type,  message){
      let notification = this.notifications.filter(n => n.type === type);
      // for the first notification type, add it to the array
      if (notification.length === 0){
        notification = this.createNotification(type, icon);
      } else {
        notification = notification[0];
      }
      notification.entries.push({label: message});
      document.getElementById('notificationBadge').classList += ' animate__heartBeat animate__repeat-2';
    },
    createNotification: function(type, icon){
      this.notifications.push({
        expanded: false,
        type: type,
        icon: icon,
        entries:[]
      });
      return this.notifications[this.notifications.length-1];
    },
    deleteNotification(payload){
      let notification = this.notifications.filter(n => n.type === payload.notificationType);
      if (notification.length > 0){
        notification[0].entries.splice(payload.index,1);
        if (notification[0].entries.length === 0){
          this.notifications = this.notifications.filter(n => n.type !== payload.notificationType);
        }
      }
      
    },
    countMessages: function(){
      return this.messages.length;
    },
    addMessage: function(sender, title, timestamp, avatar){
      this.messages.push({
        expanded: false,
        sender: sender,
        title: DataTransferItemList,
        timestamp: timestamp,
        avatar: avatar
      });
    },
    deleteMessage(index){
      this.messages.splice(index,1);
    },
    limitElements(arr, numberOfElements){
      return arr.slice(0,numberOfElements);
    },
    getCurerntYear: function(){
      return new Date().getFullYear();
    }
  }
})

