
##### isCOBOL release 2024 R2 build#1131.8-20241108-38916 ######
##### Copyright (c) 2005 - 2024 Veryant. ######

----------
**This sample shows the integration of an HTML menu and Cobol screens, where menu items are**
**generated by a COBOL program based on the user**

**This can be accomplished in two ways: each program invoked from the menu spawns a new**
**webclient application process, or each menu item starts a new thread on the**
**main webclient process using a "call run.." instruction. **
**This sample shows both approaches**

**You must have installed the isCOBOL WebClient to run this sample**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**


----------
 **On the isCOBOL application server machine**

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/webclient/encapsulated" 
     folder.

 - 2 Compile the programs

        iscc -sp=copylib -od=classes source/*.cbl 

 **NOTE:**

        The -sp option passes the copybook directories needed to compile the programs
        The -od option specifies the output directory for the generated java classes

 - 3 Start the Application Server

        iscserver -hostname <hostname | IP address> -port <port-number> 

 **NOTE:**

    If you have already started an instance of the Application Server,
    you can start a new instance of it on a different port.
    If you change the port you need to update the webclient.config file accordingly, or edit it using the WebClient admin console.

 **On the WebClient server machine**

 - 1 Open a new command prompt window of WebClient

 - 2 **Optional** Edit the iscobol.properties file in the "$ISCOBOL/sample/webclient/encapsulated/classes/cobol-login" folder of isCOBOL SDK
     to set the correct ip adress of isCOBOL Application server 
     (This step is not necessary when you start the WebClient and the Application server on the same machine)

 - 3 Set the ISCOBOL_SAMPLE environment variable. This variable needs to point to your isCOBOL SDK folder
     for example

        export ISCOBOL_SAMPLE=/Veryant/isCOBOL_SDK2024R2/sample

 - 4 If the WebClient server is not already running, start the it with the following command

        webcclient -c $ISCOBOL_SAMPLE/webclient/encapsulated/webclient.config

 **NOTE:**

    With the previous command WebClient is started using a specific configuration file needed for this sample.
    If you want use the standard configuration you can use the following command
    webcclient

**Optional steps**

   Follow the steps in this section if you want review the WebClient configuration or if you need to change the configuration 

 - 1 Open a new command prompt window of WebClient

 - 2 If the WebClient Adminstrator service is not already running, start it with the following command

        webcclient-admin

- 3 From your browser open the following url to access the WebClient Administrator panel, changing the address and port according to your deployment configuration:

        http://127.0.0.1:8090/

 - 4 use the default login credentials

        User: admin 
        Password: admin 

 **NOTE:**

     Instead of starting each process separately (see the previous section), you can start the WebClient server and WebClient Admin Console as a single process. This is helpful in a development environment.

     To do this, first edit the $ISCOBOL_SAMPLE/webclient/encapsulated/webclient.config file and replace:
     "adminConsoleUrl" : "http://localhost:8090"
     with:
     "adminConsoleUrl" : "http://localhost:8080/admin"

     And then run this command from the command prompt:
     webcclient-and-admin -c $ISCOBOL_SAMPLE/webclient/encapsulated/webclient.config

     Both the webcclient and webcclient-admin will be started together.  

     The admin link is http://127.0.0.1:8080/admin

 **On the WebClient machine**

 - 1 From your browser open the following url to test the sample with multi process approach:

        http://127.0.0.1:8080/samplemenu/ 
        changing the address and port according to your deployment configuration.


  - 2 Use the following link in a different browser window to test the sample with the "call run" approach

        http://127.0.0.1:8080/menurun/ 
        changing the address and port according to your deployment configuration.

 **NOTE:**

    This sample uses the "Customized" security module, where credentials are stored in the ISAM file "Users".
    The defalt value provides the following login credentials:
    - User: admin Password: admin
    - User: user  Password: user
    
    If you want to change the authentication method.


### To debug the programs in this environment follow the instructions below:

 - Follow the instruction of the specific README.md to add the needed compiler options

 - Modify the iscobol.properties adding the property

        iscobol.rundebug=1 

 - Start the application server:

        iscserver -hostname <hostname | IP address> -port <port-number> 

 - Using an additional command prompt window, navigate to the folder of the specific sample
   and run the remote debugger

        iscrun -d -r <hostname | IP address> <port-number> 

 **NOTE:**

        The remote debugger is started in the background with this command, and ill be automatically 
        activated when the remote program starts

 - Start a new instance of the sample from the browser, navigating to one of the following URLs: 

        http://127.0.0.1:8080/samplemenu/ 
        or 
        http://127.0.0.1:8080/menurun/ 

        changing the address and port according your deployment configuration.
        
        
 **NOTE:**
       The HTML used in the sample is based on the AdminLTE free template (https://adminlte.io/).
       Sources for the template have been modified to fit the sample, and the updated source code can be downloaded from the following link:

       https://www.veryant.com/resources/AdminLTE-3.1.0-modified.zip
       
  
