const baseAppUrl = baseAddress + '/' + appWebAppName +'?args='; 
var apps=[];

// actions
const actionBell = 'bell';
const actionWarning = 'warning';
const actionError = 'error';
const actionAddIcon = 'addIcon';
const actionRemoveIcon = 'removeIcon';
const actionClose = 'close'; //'close';
const actionCloseMenu = 'CloseMenu';
const actionQuit = 'quit';
const actionNotification = 'notification';
const actionAddNotification = 'addNotification';
const actionGetVersion = 'GetVersion';
const actionGetSessionID = 'GetSessionID';

const ARGS_SEPARATOR = '|';

// maps variables
var map = null;
var mapControl = null;
var centerMarker = null;
var marker = null;

toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-bottom-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
}

var menuAppInstance = {
  options: {
      autoStart: true,
      syncClipboard: true,
      args: '',
      recording: getParam('recording'),
      debugPort: getParam('debugPort'),
      connectionUrl:baseAddress + '/' + menuWebAppName,
      syncClipboard : true,
      compositingWindowsListener: {
        windowOpening: function(appWindow) {
          if (appWindow.name === 'f-map'){
            // set a timeout to allow the div framework to move window to the correct tab.
            setTimeout(() => {
              createMap(appWindow)
            }, 200);
         }
        },
        windowOpened: function(appWindow) {
          if (appWindow.htmlWindow){
            return;
          }
          // if a main window has been opened 
          // find the owning app and increment the window opened count
        
          var app = getWindowApp(appWindow);
          if (isMainWindow(appWindow)){
            // move the opened window to the application's tab
            moveWindowToAppDiv(appWindow);            
            if (app){
              app.windowsCount++;
            }

            // force focus on new window
            setTimeout(() => {
              appWindow.requestFocus()
            },
            1500)
            
          } else {
            app.instance.repaint();

          }
        },
        windowClosing: function(appWindow) {
        },
        windowClosed: function(appWindow) {
          // if a main window has been closed
          // decrement the opened window count
          // if all top windows have been closed
          // remove the application tab
          var app = getWindowApp(appWindow);
          if (isMainWindow(appWindow)){
            if (app){
              app.windowsCount--;
              if (app.windowsCount <= 0){
                removeApp(appWindow);
              }
              app.instance.repaint();
            }
          }
        },
        windowModalBlockedChanged: function(appWindow) {
          console.log(appWindow);
          console.log('windowModalBlockedChanged', appWindow);
        }
      },
      customization: function(injector) {
        injector.services.base.handleActionEvent = function(actionName, data, binaryData) {
            if (actionName === 'loadMenu'){
              // parse the menu info in the data argument
              var menu = JSON.parse(data);
              // build the menu UI
              buildMenu(menu);
              // show user info
              showUser();
              // perform UI updates
              checkUI();
            } else if (actionName === actionBell){
              window.appUI.notifyApp(data, 'fa-bell');
            } else if (actionName === actionWarning){
              window.appUI.notifyApp(data, 'fa-exclamation-triangle');
            } else if (actionName === actionError){
              window.top.appUI.notifyApp(appName, 'fa-warning');
            } else if (actionName === actionAddIcon){
              window.appUI.notifyApp(data.split(ARGS_SEPARATOR)[0], data.split(ARGS_SEPARATOR)[1]);
            } else if (actionName === actionRemoveIcon){
              window.appUI.removeNotification(data.split(ARGS_SEPARATOR)[0].trim());
            } else if (actionName === actionClose){
              window.appUI.quitApp(data);
            } else if (actionName === actionNotification){
              let params = data.split(ARGS_SEPARATOR);
              notification(params[0], params[1], params[2]);
            } else if (actionName === actionAddNotification){
              let params = data.split(ARGS_SEPARATOR);
              addNotification(params[0], params[1], params[2]);
            } else if (actionName === actionGetVersion){
              vueApp.setVersion(data);
            } else if (actionName === actionGetSessionID){
              let id = localStorage.getItem('webswingID')
              if (data && data.trim() !== ''){
                window.appUI.getSessionID(data.trim());
              } else {
                menuAppInstance.performAction({actionName: actionGetSessionID, data: id}) 
              }
              
            }
      },
      // mute the "starting application" standard message
      injector.services.dialog.content.startingDialog.content = null;
    }
  }
}

function isMainWindow (appWindow){
  // a window is considered "main" if the name starts with _ and has no parents
  return appWindow.name.startsWith('_') && appWindow.ownerId === undefined;
}

function findNewApp(apps){
  // find the first app with no instance set.
  // this happens when a window is opened for a new app
  for (var appName in apps){
    if(apps.hasOwnProperty(appName) && !apps[appName].instance){
      return apps[appName];
    }
  }
  
  // find the first app with no threadId set.
  // this happens when a window is opened for a new app
  for (var appName in apps){
    if(apps.hasOwnProperty(appName) && !apps[appName].threadId){
      return apps[appName];
    }
  }

  return null;
}

function findAppByThreadId(apps, threadId){
  // Find an app given the application thread id
  for (var appName in apps){
    if(apps.hasOwnProperty(appName) && apps[appName].threadId === threadId){
      return apps[appName];
    }
  }
  return null;
}

function findAppByWindowId(windowId){
  // find an app having a given main windowId
  for (var appName in apps){
    if(apps.hasOwnProperty(appName) && apps[appName].window.id === windowId){
      return apps[appName];
    }
  }
  return null;
}

// move a window to the tab that corresponds to the app that opened it
function moveWindowToAppDiv(appWindow){
  
  var div = null;
  // fine the app from the window
  var app = getWindowApp(appWindow);

  //if the window has no information in the name, find its parents
  // If no app is found, it's a system message, display it on the active program tab
  if (app !== null && appWindow.ownerId === undefined ){
    var div = document.getElementById('panel-'+ app.name);
  } else if (app === null){
    div = getActiveWindowDiv();
  }

  if (div !== null){
    // detach the window from default dom element
    appWindow.detach();

    // set window styles and dimensions
    appWindow.element.style.display = 'block';
    div.style.height = (($("[data-widget='idiv']").height() - $('.nav.navbar').height())) - 2 + 'px';
    div.style.width =  '100%';
    
    // attach the window to the parent div
    appWindow.attach(div);

  } 
}


function getActiveWindowDiv(){
  // find the application div that is currently active, and retun it
  const activePanel = $('.nav-item.div-title.active');
  let activeAppName = null;
  if (activePanel.length > 0){
    const id = activePanel[0].id;
    if (id.startsWith('div_panel')){
      activeAppName = id.substring('div_panel-'.length);
    }
    if (activeAppName !== null){
      return document.getElementById('panel-'+ activeAppName);
    }
  }
  return null;
}

function removeApp(appWindow){
  // remove the application div when app closes
  var app = getWindowApp(appWindow);
  if (app !== null){
    window.appUI.quitApp(app.name);
  }
}


function getWindowApp(appWindow){

  // find the main window for this window (the one without ownerId)
  while (appWindow.ownerId) {
    appWindow = appWindow.webswingInstance.getRenderedWindows().find(w => w.id === appWindow.ownerId);
  }

  // extract app info from appWindow
  const appData = appWindow.name.split('|');
  var  app = null;

  // search app for thread id, if any
  if (app === null && appData.length > 1){
    app = findAppByThreadId(window.apps, appData[1]);
  }

  // if no app is found, it's a newly opened app, create the
  // an app instance for it
  if (app === null){
    app = findNewApp(window.apps);

      // sets the instance variables for the first window
    if (app != null && app.instance === null){
      app.instance = appWindow.webswingInstance,
      app.window = appWindow
      app.threadId = appData[1];
      // initialize the windows opened count for the application
      if (!app.windowsCount){
        app.windowsCount = 0;
      }
    }
  }
  return app;
}

function showUser(){
  // nothing to do in this sample
}

function getUserName(){
  // Extract the user name from the instanceId property
  if (menuAppInstance && menuAppInstance.hasOwnProperty('instanceId') && menuAppInstance.instanceId()){

  if ( menuAppInstance.instanceId().split("_").length>0){
    return menuAppInstance.instanceId().split("_")[1];
    }
   } 
   return null;
}

function notifyApp(appName, notificationIcon){
  // add a notification icon to the application tab
  if (!document.getElementById('notification_' + appName)){
    var i = document.createElement('i');
    i.id='notification_' + appName;
    i.className = 'fa ' + notificationIcon +' mr-2 animate__animated animate__swing animate__repeat-2';
    document.getElementById('a_' + appName).insertBefore(i,document.getElementById('a_' + appName).childNodes[0]);
    i.onclick = function(){
      // remove the notification icon when the icon is clicked
      document.getElementById('notification_' + appName).remove();
    }
  }
  }

  function addBell(appName){
    // add a bell icon to the application tab
    if (!document.getElementById('bell_' + appName)){
      var i = document.createElement('i');
      i.id='bell_' + appName;
      i.className = 'fa fa-bell mr-2 animate__animated animate__swing animate__repeat-2';
    document.getElementById('a_' + appName).insertBefore(i,document.getElementById('a_' + appName).childNodes[0]);
    i.onclick = function(){
      document.getElementById('bell_' + appName).remove();
    }
    }
  }

  function removeNotification(appName){
    // remove the notification icon from the application tab
    if (document.getElementById('notification_' + appName)){
      document.getElementById('notification_' + appName).remove();
    }
  }


  function removeBell(appName){
    // remove the bell icon from the application tab
    if (document.getElementById('bell_' + appName)){
      document.getElementById('bell_' + appName).remove();
    }
  }



   function getInstance(instanceVar){
     return eval(instanceVar)
   }

  function getParam(name) {
    name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
    var results = new RegExp("[\\?&]" + name + "=([^&#]*)").exec(location.href);
    return results == null ? null : decodeURIComponent(results[1]);
  }



  (function (window, document) {
    document.getElementById('webclientLogin').style.height =  window.innerHeight-$('.main-header').height()-$('#app-container').height()

    var loader = function () {
         baseUrl = baseUrl.indexOf("/", baseUrl.length - 1) !== -1 ? baseUrl : (baseUrl + "/");
         var xmlhttp = new XMLHttpRequest();
         xmlhttp.onreadystatechange = function () {
             if (xmlhttp.readyState == XMLHttpRequest.DONE) {
                 var version = xmlhttp.status == 200 ? xmlhttp.responseText : "undefined";
                 var script = document.createElement("script"),
                     tag = document.getElementsByTagName("script")[0];
                 script.src =  "javascript/webswing-embed.js?version=" + (version? version: '1');
                 tag.parentNode.insertBefore(script, tag);
             }
         };
         xmlhttp.open("GET", "rest/version", true);
         xmlhttp.send();
     };
     window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);
  
     $('[data-widget="signout"]').on('click', signout);

     // resize the webclient login form to fill available space
     //document.getElementById('webclientLogin').style.height = '100%'; // $("[data-widget='idiv']").height() + 'px';

     $('body').height(window.innerHeight);

     $('.webswing-element-content').height = (($("[data-widget='idiv']").height() - $('.nav.navbar').height())) - 2 + 'px';

 
  })(window, document);

function startApplication(appTitle, appName){
  // start an application if it's not already opened
  // it it is, activate the corresponding div
  if (window.appUI.appIsOpen(appName)){
    activateApp(appName);
  } else {
    $('.content-wrapper').IDiv('createTab', appTitle,  baseAppUrl + appName + ' ' + getUserName(),  appName, true);

    // initalize the window.apps for this application, and sets its webclient instance to null
    // the instance will be filled when the first window for the app is opened
    window.apps[appName]={
      name: appName,
      instance: null
    }

    // ask the cobol APPLICATION program to execute the program the user selected
    menuAppInstance.performAction({actionName: 'ExecuteProgram', data: appName});


    // set up a click listener on the application tab
    // that will remove any notifications and force a repaint to update the content
    $('#tab-'+ appName).on('click', e => {
      const data = e.target.id.split('-');
      if (data.length > 1){
        const appName = data[1];

        activateApp(appName);
        appUI.removeNotification(appName);

        setTimeout( () => {
          // repaint the canvas to position popups correctly
          window.apps[appName].instance.repaint();
        }, 200);
      }
    })
  

  }
  return false;
}

function activateApp(appName) {
  $('.content-wrapper').IDiv('switchTab','#tab-' + appName);
  setTimeout(() => {

    apps[appName].window.requestFocus();
/*
    const canvas = document.querySelector('#panel-' + appName).children[0];
      
    // simulate a click on the window to activate it and restore focus
    var mouseDownEvent = new MouseEvent('mousedown',{bubbles: true, cancelable: true});
    var mouseUpEvent = new MouseEvent('mouseup',{bubbles: true, cancelable: true});

    canvas.dispatchEvent(mouseDownEvent);
    canvas.dispatchEvent(mouseUpEvent);
    */
  }, 200);
}

// close button override
// disable default behavior that is to just remove the tab
// notify the cobol program instead, and wait for it to close
// tab will be removed when the action quit is received

setTimeout(function(){
  $(document).off('click', '[data-widget="idiv-close"]')
  $(document).on('click', '[data-widget="idiv-close"]', e => {
    e.preventDefault();

    if (e.target.dataset['type'] === 'all'){
      //"Close all" was clicked
      closeAllPrograms();

    } else if (e.target.dataset['type'] === 'all-other'){ 
      // "Close all other" was clicked
      closeOtherPrograms();
    } else {
      // single tab is being closed  
      // get the <li> item and find out the involved program
      var li = e.target.parentElement.parentElement;
      // the program name is in the id attribute, preceded by the "frame_panel-" constant
      var appName = li.id.substring("div_panel-".length);

      activateApp(appName);

      // send the app the quit request, if instance is valid
      if (window.apps[appName].instance){
        window.apps[appName].instance.performAction({actionName: actionClose, data: appName});
      }
    }
  })
  checkUI();

},500);

function closeAllPrograms(){
  for (var appName in window.apps){
    if(window.apps.hasOwnProperty(appName)){
      window.apps[appName].instance.performAction({actionName: actionClose, data: appName})
    }
  }
}

function quitAllPrograms(){
  for (var appName in window.apps){
    if(window.apps.hasOwnProperty(appName)){
      window.apps[appName].instance.performAction({actionName: actionQuit})
    }
  }
}

function closeOtherPrograms(){
  const activeApp = $('.nav-link.active');
  if (activeApp.length > 0){
    const instancesToClose = [];
    const activeAppName = activeApp[0].id.substring("tab-".length);
    for (var appName in window.apps){
      if(window.apps.hasOwnProperty(appName) && appName !== activeAppName){
        instancesToClose.push({instance: window.apps[appName].instance, appName: appName});
      }
    }

    instancesToClose.forEach(instance => instance.instance.performAction({actionName: actionClose, data: instance.appName}));
    setTimeout(function(){
      $('.content-wrapper').IDiv('switchTab','#tab-' + activeAppName);
      repaintApps();
    }, 500);
  }
}


function checkUI(){
  var userName = getUserName();
}

function setVisibilityById(elementId, displayClass){
  if (document.getElementById(elementId)){
    document.getElementById(elementId).style.display = displayClass;
  }
}

function signout(){
  // when signing out, close all running programs
  // when all programs are closed, kill the webclient instance
  quitAllPrograms();
  setTimeout(killInstance, 500);
  
}

function killInstance(){
  // if no programs are running, kill the webclient instance
  if (Object.keys(apps).length === 0) {
    menuAppInstance.performAction({actionName: actionCloseMenu});
    menuAppInstance.kill();
  } else {
    setTimeout(killInstance, 500);
  }
}

function repaintApps(){
  for (var appName in apps){
    apps[appName].instance.repaint();
  }
}

function addNotification(icon, type, message){
  toastr.success(message, type);
  vueApp.addNotification(icon, type, message);
  animateCSS('#notificationBadge','heartBeat')
}

function notification( type, description, message){
  if (type === 'info'){
    toastr.info(message,description);
  } else if (type === 'warning'){
    toastr.warning(message,description);
  } else if (type === 'error'){
    toastr.error(message,description);
  } else if (type === 'success'){
    toastr.success(message,description);
  }
  
}

const animateCSS = (element, animation, prefix = 'animate__') =>
  // We create a Promise and return it
  new Promise((resolve, reject) => {
    const animationName = `${prefix}${animation}`;
    const node = document.querySelector(element);

    node.classList.add(`${prefix}animated`, animationName);

    // When the animation ends, we clean the classes and resolve the Promise
    function handleAnimationEnd(event) {
      event.stopPropagation();
      node.classList.remove(`${prefix}animated`, animationName);
      resolve('Animation ended');
    }

    node.addEventListener('animationend', handleAnimationEnd, {once: true});
  });


  function createMap(win) {
    setControlId(win.name);
    mapControl = win;

    map = L.map(win.name).setView([51.505, -0.09], 13);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: 'Veryant',
      attributionControl: false,
    }).addTo(map);

   win.performAction({actionName: 'mapCreated'});

   win.handleActionEvent = function(actionName, data, binaryData) {
       if (actionName === 'selectOffice'){
          let office = JSON.parse(data);
          selectOffice(office);
        } else if (actionName === 'showArea'){
          let office = JSON.parse(data);
          showArea(office);
        } else if (actionName === 'hideArea'){
          let office = JSON.parse(data);
          hideArea(office);
        } else if (actionName === 'centerMap'){
          let office = JSON.parse(data);
          centerMap(office);
        } else if (actionName === 'closeDescription') {
          if (marker) {
            marker.closePopup();
          }
        } else if (actionName === 'openDescription') {
          if (marker) {
            marker.openPopup();
          }
        }
    }
 }

 function addMarker(office){
  marker = L.marker([office.office.lat, office.office.lng]).addTo(map);
  marker.bindPopup(office.office.description).openPopup();

  // binds to popup close and open events and send message to the COBOL program
  marker.on('popupclose', () => {
    mapControl.performAction({actionName: 'closeDescription'})
  });
  marker.on('popupopen', () => {
    mapControl.performAction({actionName: 'openDescription'})
  });
}

function selectOffice(office){
  if (map != null){
    addMarker(office);

    map.setView([office.office.lat, office.office.lng], 14);
  }
}

function showArea(office) {
  centerMarker = L.circleMarker([office.office.lat, office.office.lng],{radius: 100}).addTo(map);
}

function hideArea(office) {
  if (centerMarker) {
    centerMarker.remove();      
    centerMarker = null;
  }
}

function centerMap(office) {
  map.setView([office.office.lat, office.office.lng], 14, {
      animate: true,
      duration: 1, // Duration of animation in seconds
      easeLinearity: 0.25, // Animation easing, 0.0 is linear, 1.0 is no easing
  });
}



function setControlId(elementName){
  var panel = menuAppInstance.getWindows().filter(w => w.name === elementName);
  if (panel.length > 0){
    panel[0].element.id = elementName;
    return true;
  } else {
    return false;
  }
}
