var appUI = new Object();


toastr.options = {
  "closeButton": true,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toast-bottom-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
}

appUI.notifyApp = function(appName, notificationIcon){
  //append an <i> element to the application tab
   if (!document.getElementById('notification_' + appName)){
     var i = document.createElement('i');
     i.id='notification_' + appName;
     i.className = 'fa ' + notificationIcon +' ml-1 animate__animated animate__swing animate__repeat-2';
     document.getElementById('tab-' + appName).parentElement.insertBefore(i,document.getElementById('tab-' + appName).parentElement.childNodes[0]);
    i.onclick = function(){
      document.getElementById('notification_' + appName).remove();
    }
   }
  }
  appUI.removeNotification = function (appName){
    // remove the <i> element from the application tab, if any
   if (document.getElementById('notification_' + appName)){
     document.getElementById('notification_' + appName).remove();
   }
 }

 appUI.appIsOpen = function(appName){
   return (window.apps[appName] != null)
 }


appUI.notification = function(type, description, message){
  if (type === 'info'){
    toastr.info(message,description);
  } else if (type === 'warning'){
    toastr.warning(message,description);
  } else if (type === 'error'){
    toastr.error(message,description);
  } else if (type === 'success'){
    toastr.success(message,description);
  }
  
}



appUI.quitApp = function(appName){   
  $('.tab-pane').removeClass('active');
  $('.content-wrapper').IFrame('switchTab','#tab-' + appName);
  $('.content-wrapper').IFrame('removeActiveTab');
  delete window.apps[appName]; 
}


appUI.getSessionID = function(appName){
  const id = localStorage.getItem('webswingID');
  window.apps[appName].instance.performAction({actionName: actionGetSessionID, data: id})              
}


 window.appUI = appUI;