      *>   Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *>   may freely modify and redistribute this program.
      
       PROGRAM-ID. ISINVOICELIST.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "invoice.sl".
           copy "customer.sl".
       DATA DIVISION.
       FILE SECTION.
           copy "invoice.fd".
           copy "customer.fd".
      
       WORKING-STORAGE SECTION.
      
           copy "common.wrk".
           copy "color.wrk".
           copy "isprintinvoice-link.lks".
           copy "iwc.wrk".
           copy "iwc.lks".
           copy "lookup.lks".

       77  status-invoice       pic xx.
       77  status-customer      pic xx.

       01  screen-value.
           05 scr-customer      pic  x(10).
           05 scr-lbl-customer  pic  x(71).
           05 scr-date-from     pic  9(8).
           05 scr-date-to       pic  9(8).
           
       01  old-screen-value.
           05 old-scr-customer  pic  x(10).
           05 old-scr-date-from pic  9(8).
           05 old-scr-date-to   pic  9(8).
           
       78  id-ef-customer       value 100.
       78  id-ef-date-from      value 101.
       78  id-ef-date-to        value 102.

       77  wrk-customer         pic  x(10).
       77  wrk-product          pic  x(10).

       01                       pic 9.
           88 all-ok            value 1 false zero.
       
       01                      pic 9.
           88 no-operation     value 0.
           88 record-selected  value 1 false zero.
           88 inv-print        value 2 false zero.
           88 inv-preview      value 3 false zero.
           88 inv-pdf          value 4 false zero.
       
       77  choice               pic x.
       77  wrk-Invoice          pic x(10).
       77  cont                 pic 9(3).
       77  key-used             pic x.
       77  wrk-y                pic 9(3).
                                
       01  wrk-date             pic 9(8).
       
       01  rec-grid.
           05 rg-year           pic  9(4).
           05 rg-number         pic  z(10).
           05 rg-inv-date       pic 99/99/9999.
           05 filler            pic x.
           05 filler            pic x.
           05 filler            pic x.

       77  row-price            pic 9(06)v99.
       77  wrk-price            pic 9(06)v99.
       77  row                  pic 9(4).

       77  last-invde-row       pic 9(4).
       77  last-row-h-grid      pic 9(4).

       01  wrk-inv-key.
           05 wrk-inv-year      pic  9(4).
           05 wrk-inv-number    pic  9(10).

       01  pgm-status           pic 9.
           88 pgm-force-close   value 1 false 0.

       screen section.

        01 mask-main.
           05 frame 
              raised
              line 1
              col 2
              lines 5 cells
              size 65 cells
              high-color rgb 78-frame-backback-color
              low-color rgb 78-frame-backback-color
              gradient-color-1 rgb 78-frame-backback-color
              gradient-color-2 rgb 78-frame-backback-color
              transparent
              .
           05 Label
              col 3
              line 2
              title r"Customer_id"
              transparent
              .
           05 ef-customer 
              entry-field
              col 16 
              line 2
              size 10
              max-text 10
              id id-ef-customer
              VALUE scr-customer
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-EF-CUSTOMER
              .
           05 lbl-customer 
              label
              col 29 
              line 2
              size 40
              title scr-lbl-customer
              transparent
              .
           05 Label
              COL 3
              LINE 4
              TITLE R"From_date"
              transparent
              .
           05 ef-date-from 
              date-entry, 
              col 16
              line 4
              size 10
              value scr-date-from
              id id-ef-date-from 
              notify-change
              after AFT-DATE
              .
           05 Label
              col 35
              line 4
              title r"To_date"
              transparent
              .
           05 ef-date-to 
              date-entry, 
              col 43
              line 4
              size 10
              value scr-date-to
              after AFT-DATE
              Notify-Change
              id id-ef-date-to 
              .
           05 h-grid
              grid
              reordering-columns
              sortable-columns
              adjustable-rows
              line 7 
              col 2
              lines 15
              size 65
              width-in-cells
              height-in-cells
              data-columns (1, 5,   15,   25,  26)
              alignment   ("C", "R", "C", "C", "C", "C")
              data-types  ("I", "I", "I", "I", "I", "I" )
              display-columns (1, 12, 25, 44, 51, 57) 
              color 513  
              vscroll
              centered-headings 
              column-headings
              adjustable-columns
              use-tab
              vpadding 70
              cursor-frame-width -1
              border-color rgb 78-ef-border-color
              divider-color rgb 78-ef-border-color
              end-color rgb 78-grid-end-color
              Row-Cursor-Background-Color 
                                      rgb 78-grid-row-cursor-back-color
              Row-Cursor-foreground-Color 
                                      rgb 78-grid-row-cursor-fore-color
              Row-Background-Color-Pattern 
                                (0, rgb 78-grid-Row-Back-Color-Pattern)
              event H-GRID-EVENT
              .

       01  mask-tool.
           05 Push-Button
              col + 1.2 
              line 3
              lines 2.2 
              cells
              size 13 cells
              bitmap-width 18
              bitmap-number 78-n-save
              bitmap-rollover 78-n-save-rollover
              exception-value 78-exe-save
              title R"&Select"
              hint R"(F3)"
              title-position 2
              self-act
              flat
              rollover-foreground-color 78-toolbar-pb-rollover-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              .
           05 bar
              col + 1.2
              lines 2 width 2
              color 16
              shading (-1, 1)
              .
           05 Push-Button
              col + 1.2
              lines 2.2 cells
              size 11 cells
              bitmap-width 18
              bitmap-handle h-tools
              bitmap-number 78-n-search
              bitmap-rollover 78-n-search-rollover
              exception-value 78-exe-zoom
              title R"Search"
              hint R"(F8)"
              title-position 2
              self-act
              flat
              rollover-foreground-color 78-toolbar-pb-rollover-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              .
           05 bar
              col + 1.2
              lines 2 width 2
              color 16
              shading (-1, 1)
              .
           05 push-button 
              title R"&Exit"
              hint R"(Esc)"
              bitmap-handle h-tools
              bitmap-number 78-n-exit
              bitmap-rollover 78-n-exit-rollover
              title-position 2
              lines 2.2 cells
              size 12 cells
              bitmap-width 18
              col + 1.2
              exception-value 27
              self-act
              flat
              rollover-foreground-color 78-toolbar-pb-rollover-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              .

       PROCEDURE DIVISION.
       DECLARATIVES.
       INVOICE-ERR section.
           use after standard error procedure on invoice.
           perform ERROR-FILE
           .
       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.

           set no-operation  to true.

           perform OPEN-FILES.
           
           initialize screen-value.
           move low-value to old-screen-value.
           accept scr-date-to from century-date
           move scr-date-to to scr-date-from
           move "01"  to scr-date-from(7:2)

           display independent graphical window
                   title R"isCOBOL_Application_InvoiceList"
                   lines 22
                   size 72
                   col 1
                   line 1
                   resizable
                   control font h-font
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   background-color rgb 78-window-independent-back-color
                   min-lines 15
                   min-size 80
                   undecorated
                   .

           display mask-main upon h-sta
           perform DISPLAY-TOOLBAR.

           perform DISPLAY-SCREEN.
           
           modify h-sta action action-maximize 
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
           
           perform EXIT-PRG.
           
           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-selected
                set record-selected   to true
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH

           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                when NTF-CHANGED
                     perform DISPLAY-SCREEN
                end-evaluate
           end-evaluate.

           copy "iwc-accept.prd".
           
           evaluate true
           when record-selected
                inquire h-grid cursor-y = wrk-y
                inquire h-grid(wrk-y, 1) hidden-data = inv-key
                call "ISINVOICE" using inv-key
                                       pgm-status
                cancel "ISINVOICE"
                if pgm-force-close
                   move 27   to key-status
                end-if
                set no-operation   to true
           
           when inv-print
                set no-operation   to true
                set ips-print      to true
                perform PRINT-INVOICE
           when inv-preview
                set no-operation   to true
                set ips-preview   to true
                perform PRINT-INVOICE
           when inv-pdf
                set no-operation   to true
                set ips-pdf        to true
                perform PRINT-INVOICE
           end-evaluate.

       PRINT-INVOICE.
           inquire h-grid cursor-y = wrk-y
           inquire h-grid(wrk-y, 1) hidden-data = inv-key
           move inv-key   to ips-inv-key
           call "ISPRINTINVOICE" using ips-linkage
           cancel "ISPRINTINVOICE".

       CONTROL-ALL.
           inquire ef-customer  value scr-customer
           inquire ef-date-from value scr-date-from
           inquire ef-date-to   value scr-date-to
           
           move id-ef-customer to control-id
           perform CONTROL-CUSTOMER.
            
           inquire h-grid last-row = last-row-h-grid
           
           if last-row-h-grid < 2
              display message box R"Detail_is_mandatory!"
                    icon mb-warning-icon
              set all-ok  to false
           end-if.

       DISPLAY-SCREEN.
           move scr-customer      to cust-id
           read customer no lock
              invalid
                 move space   to cust-fname
                                 cust-lname
           end-read
           initialize scr-lbl-customer
           string cust-fname  delimited by trailing space
                  " "         delimited by size
                  cust-lname  delimited by trailing space
                  into scr-lbl-customer
                                      
           display mask-main.
         
           if scr-customer  not = old-scr-customer  or
              scr-date-from not = old-scr-date-from or 
              scr-date-to   not = old-scr-date-to 
              perform DISPLAY-DETAIL
           end-if.

       DISPLAY-DETAIL.
           move scr-customer  to old-scr-customer
           move scr-date-from to old-scr-date-from 
           move scr-date-to   to old-scr-date-to 
           
           modify h-grid mass-update 1
                         reset-grid 1
           
           move 1   to row
           modify h-grid(1, 1) cell-data R"Year"
           modify h-grid(1, 2) cell-data R"Number"
           modify h-grid(1, 3) cell-data R"Date"

           move scr-customer to inv-customer
           move low-value    to inv-key
           start invoice key not < inv-k-cust
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read invoice next no lock
                       at end
                          exit perform
                    end-read
                    if scr-customer not = inv-customer
                       exit perform
                    end-if
                    if inv-date >= scr-date-from and 
                          inv-date <= scr-date-to
                      perform ADD-ROW-GRID
                    end-if
                 end-perform
           end-start.
           
           modify h-grid mass-update zero.
           move 2  to row.

       ADD-ROW-GRID.
           add 1 to row
           initialize rec-grid
           
           move inv-year    to rg-year
           move inv-number  to rg-number
           move inv-date(7:2) to wrk-date(1:2)
           move inv-date(5:2) to wrk-date(3:2)
           move inv-date(1:4) to wrk-date(5:4)
           move wrk-date      to rg-inv-date
           
           modify h-grid record-to-add rec-grid
           modify h-grid(row, 1) hidden-data inv-key.
           modify h-grid(row, 4) cell-background-color -6849454
                                cell-hint R"Print the invoice"
                                bitmap h-tools
                                bitmap-number 78-n-print
                                bitmap-width 18

           modify h-grid(row, 5) cell-background-color -6849454
                                cell-hint R"Preview the invoice"
                                bitmap h-tools
                                bitmap-number 78-n-preview
                                bitmap-width 18
           modify h-grid(row, 6) cell-background-color -6849454
                                cell-hint R"Open the invoice"
                                bitmap h-tools
                                bitmap-number 78-n-edit
                                bitmap-width 18
           .

       OPEN-FILES.
           open input invoice.
           if status-invoice = 35
              open output invoice
              close invoice
              open input invoice
           end-if.
           open input Customer.
           if status-Customer = 35
              open output Customer
              close Customer
              open input Customer
           end-if.

       EXIT-PRG.
           call "IWC-QUIT-TAB".
           
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close invoice.
           close customer.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-CUSTOMER.
           perform CONTROL-CUSTOMER.
           if all-ok
              perform DISPLAY-SCREEN
           end-if.

       AFT-DATE.
           perform DISPLAY-SCREEN.
 
       CONTROL-CUSTOMER.
           set all-ok          to true
           move scr-customer  to cust-id
           read customer no lock
              invalid
                 move space   to cust-fname
                                 cust-lname
                 display message box R"Wrong_Customer_id!"
                    icon mb-warning-icon
                 move id-ef-customer   to control-id
                 set all-ok            to false
           end-read
           
           initialize scr-lbl-customer
           string cust-fname  delimited by trailing space
                  " "         delimited by size
                  cust-lname  delimited by trailing space
                  into scr-lbl-customer
           modify lbl-customer   title scr-lbl-customer
           
           if not all-ok
              move 4  to accept-control
           end-if.
 
       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-customer
                call "ZCUSTOMER" using wrk-customer 
                                       lookup-status 
                cancel "ZCUSTOMER"
                evaluate true
                when ls-record-selected
                     move wrk-customer   to scr-customer
                     modify ef-customer value scr-customer
                     perform CONTROL-CUSTOMER
                when ls-force-close 
                     move 27 to key-status
                end-evaluate

           end-evaluate.

       H-GRID-EVENT.
           evaluate event-type
           when MSG-BEGIN-ENTRY
                inquire h-grid entry-reason = key-used
                if key-used = x"0D" or
                   key-used = x"00"
                   evaluate EVENT-DATA-1 
                   when 1
                   when 2
                   when 3
                   when 6
                        set record-selected   to true
                   when 4
                        set inv-print to true
                   when 5
                        set inv-preview    to true
                  end-evaluate
                  set event-action to EVENT-ACTION-FAIL-TERMINATE
                else
                   set event-action to EVENT-ACTION-FAIL
                end-if
           when msg-bitmap-clicked 
                evaluate EVENT-DATA-1 
                when 4
                     set inv-print to true
                     set event-action   to EVENT-ACTION-TERMINATE
                when 5
                     set inv-preview    to true
                     set event-action   to EVENT-ACTION-TERMINATE
                when 6
                     set record-selected   to true
                     set event-action   to EVENT-ACTION-TERMINATE
                end-evaluate
           end-evaluate.

           copy "dec-file.prd". 
           copy "standard-toolbar.prd".
