      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ISUSER.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "users.sl".
       DATA DIVISION.
       FILE SECTION.
           COPY "users.fd".
      
       WORKING-STORAGE SECTION.

       copy "common.wrk".
       copy "color.wrk".
       copy "iwc.wrk".
       copy "iwc.lks".
       copy "lookup.lks".

       77  STATUS-users                PIC XX.

       01  screen-value.
           05 scr-id-user              pic x(20).
           05 scr-name-user            pic x(50).
           05 scr-type-user            pic 9.

       01  screen-change-pwd-value.
           05 scr-password             pic x(20).
           05 scr-confirm-password     pic x(20).

       78  id-ef-id-user               value 100.
       78  id-ef-name-user             value 101.
       78  id-cb-type                  value 102.
       78  id-ef-password              value 103.
       78  id-ef-confirm-password      value 104.

       01                              pic 9.
           88 all-ok                   value 1 false zero.

       77  choice                      pic x.
       77  wrk-user                    pic x(20).
       77  e-change-pwd                pic 9.

       screen section.
       01  mask-main.
           05 frame 
              raised
              line 1
              col 2
              lines 3 cells
              size 106 cells
              high-color rgb 78-frame-backback-color
              low-color rgb 78-frame-backback-color
              gradient-color-1 rgb 78-frame-backback-color
              gradient-color-2 rgb 78-frame-backback-color
              transparent
              .
           05 Label
              col 3
              line 5
              title r"User_id"
              transparent
              .
           05 Label
              col 32
              line 7
              title r"Name"
              transparent
              .
           05 Label
              col 3
              line 9
              title r"Super_User"
              transparent
              .
           05 ef-id-user 
              entry-field
              col 21 
              line 5
              size 20
              id id-ef-id-user
              value scr-id-user
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-EF-ID-USER
              .
           05 ef-name-user 
              entry-field, 
              col 21
              line 7
              size 50
              value scr-name-user
              id id-ef-name-user
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 cb-type-user 
              check-box, 
              hint R"Super_User"
              col 21
              line 9
              size 5
              value scr-type-user
              id id-cb-type
              transparent
              .
           05 pb-change-pwd 
              Push-Button
              col 21 
              line 11
              lines 1.9 cells
              size 18 cells
              exception-value 2003
              title R"&Change_Password"
              self-act
              enabled e-change-pwd
              self-act
              flat
              background-color rgb 78-pb-background-color
              foreground-color rgb 78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color
              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              rollover-background-color 
                                   rgb 78-pb-rollover-background-color
               .

       01  mask-change-pwd.
           05 Label
              col 2
              line 2
              title r"Password"
              transparent
              .
           05 Label
              col 2
              line 4
              title r"Confirm_Password"
              transparent
              .
           05 ef-password 
              entry-field, 
              col 20
              line 2
              size 20
              VALUE scr-password
              max-text 20
              id id-ef-password
              secure
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .
           05 ef-confirm-password 
              entry-field
              col 20
              line 4
              size 20
              max-text 20
              VALUE scr-confirm-password
              id id-ef-confirm-password
              secure
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              .

           copy "standard-mask-tool.scr".

       01  mask-tool-floating.
           05 Push-Button
              col 2 
              line 3
              lines 1.9 cells
              size 20 cells
              bitmap-width 18
              bitmap-number 78-n-save
              bitmap-rollover 78-n-save-rollover
              exception-value 2001
              title R"Change_Password"
              title-position 2
              self-act
              flat
              rollover-foreground-color 78-toolbar-pb-rollover-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
               .
           05 bar
              col + 1.2
              lines 2 width 2
              color 16
              shading (-1, 1)
              .
           05 push-button 
              title R"&Exit"
              hint R"(Esc)"
              bitmap-handle h-tools
              bitmap-number 78-n-exit
              bitmap-rollover 78-n-exit-rollover
              title-position 2
              lines 1.9 cells
              size 12 cells
              bitmap-width 18
              col + 1.2
              exception-value 27
              self-act
              flat
              flat
              rollover-foreground-color 78-toolbar-pb-rollover-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              .

       PROCEDURE DIVISION.
       DECLARATIVES.
       USERS-ERR section.
           use after standard error procedure on users.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.

           if not user-super
              display message box R"For_Super_user_only!"
                    icon mb-warning-icon
              goback
           end-if.

           perform OPEN-FILES.

           initialize screen-value.
           
           display independent graphical window
                   title R"isCOBOL_Application_Users"
                   lines 27
                   size 108
                   resizable
                   layout-manager lm-scale
                   control font h-font
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   background-color rgb 78-window-independent-back-color
                   min-lines 15
                   min-size 80
                   undecorated
                   .
           
           display mask-main upon h-sta
           perform DISPLAY-TOOLBAR

           modify h-sta action action-maximize 
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
           
           perform EXIT-PRG.
           
           goback.

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-new
                initialize users-r
                perform DISPLAY-SCREEN
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize users-r
                perform DISPLAY-SCREEN
           when 78-exe-first
                perform READ-FIRST
                perform DISPLAY-SCREEN
           when 78-exe-prev
                perform READ-PREV
                perform DISPLAY-SCREEN
           when 78-exe-next
                perform READ-NEXT
                perform DISPLAY-SCREEN
           when 78-exe-last
                perform READ-LAST
                perform DISPLAY-SCREEN
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           when 2003
                perform CHANGE-PASSWORD
           end-evaluate.

           copy "iwc-accept.prd".
           .

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   icon mb-warning-icon 
                   giving choice
           if choice = mb-yes
              inquire ef-id-user  value scr-id-user
              move scr-id-user   to users-id
              delete users record
                 invalid
                    continue
              end-delete
              move R"User_deleted" to iwc-notification
              call "IWC-ADD-NOTIFICATION" using 78-sys-icon 
                                                78-evt-system
                                                iwc-notification
           end-if.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL
           
           if all-ok
              move scr-id-user    to users-id   
              move scr-name-user  to users-name 
              move scr-type-user  to users-type 
           
              rewrite users-r
                 invalid
                    write users-r
                       invalid
                          continue
                       not invalid
                          perform CHANGE-PASSWORD
                          move 1 to e-change-pwd
                          modify pb-change-pwd enabled e-change-pwd
                    end-write
              end-rewrite
              move R"Information"  to iwc-notification-description
              move R"User_saved_successfully"  to iwc-notification
              call "IWC-NOTIFY" using 78-notification-success
                                      iwc-notification-description
                                      iwc-notification
           end-if.
 
       CONTROL-ALL.
           set all-ok          to true
           inquire ef-id-user  value scr-id-user
           inquire ef-name-user value scr-name-user.
           inquire cb-type-user value scr-type-user.
           
           if scr-id-user = space
              display message box R"User_id_is_mandatory!"
                    icon mb-warning-icon
              move id-ef-id-user  to control-id
              set all-ok          to false
           end-if.

       READ-FIRST.
           move low-value  to users-id
           start users key not < users-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize users-r
              not invalid
                read users next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize users-r
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to users-id
           start users key not > users-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize users-r
              not invalid
                 read users previous no lock
                    at end
                       perform RECORD-NOT-FOUND
                       initialize users-r
                end-read
           end-start.

       READ-PREV.
           inquire ef-id-user VALUE scr-id-user.
           if scr-id-user = space
              perform READ-LAST
           else
              move scr-id-user  to users-id
              read users no lock
                invalid
                   start users key not < users-key
                      invalid
                         initialize users-r
                   end-start
              end-read
              read users previous no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.

       READ-NEXT.
           inquire ef-id-user VALUE scr-id-user.
           if scr-id-user = space
              perform READ-FIRST
           else
              move scr-id-user  to users-id
              read users no lock
                invalid
                   start users key not > users-key
                      invalid
                         initialize users-r
                   end-start
              end-read
              read users next no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.
 
       RECORD-NOT-FOUND.
           move "File user"           to iwc-notification-description
           move R"Record_not_found"   to iwc-notification
           call "IWC-NOTIFY" using 78-notification-warning
                                   iwc-notification-description
                                   iwc-notification
           .

       DISPLAY-SCREEN.
           move users-id     to scr-id-user
           move users-name   to scr-name-user
           move users-type   to scr-type-user
           
           if scr-id-user not = space
              move 1  to e-change-pwd
           else
              move 0  to e-change-pwd
           end-if
           
           display mask-main.
 
       OPEN-FILES.
           open I-O users.
      *     open I-O favrec.

       EXIT-PRG.
           call "IWC-QUIT-TAB".
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close users.
      *     close favrec.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-ID-USER.
           if key-status = 13
              perform LOAD-RECORD
           end-if.

       LOAD-RECORD.
           move scr-id-user  to users-id
           read users no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-id-user
                call "ZUSER" using wrk-user lookup-status 
                cancel "ZUSER"
                evaluate true
                when ls-record-selected 
                     move wrk-user   to scr-id-user
                     perform LOAD-RECORD
                when ls-force-close 
                     move 27 to key-status
                end-evaluate
           end-evaluate.

       CHANGE-PASSWORD.
           display floating graphical window
                   system menu 
                   title R"isCOBOL_Application_Change_Password"
                   lines 6
                   size 51
                   control font h-font
                   handle h-sta-floating
                   background-color  rgb 78-window-floating-back-color
                   background-low
                   undecorated
                   .

           initialize screen-change-pwd-value.

           display mask-change-pwd upon h-sta-floating
           perform DISPLAY-TOOLBAR-FLOATING

           perform until key-status = 27
              accept mask-change-pwd
                 on exception continue
              end-accept
              perform AFTER-ACCEPT-CHANGE-PASSWORD
           
              move 4 to accept-control
           end-perform.
           
           destroy h-sta-floating
           move zero to key-status.
           if ls-force-close
              move 27  to key-status
           end-if.
           
       AFTER-ACCEPT-CHANGE-PASSWORD.
           evaluate key-status 
           when 2001
                perform SAVE-PASSWORD
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           end-evaluate
           copy "iwc-accept.prd".
           .

       SAVE-PASSWORD.
           set all-ok          to true
           inquire ef-password VALUE scr-password
           inquire ef-confirm-password VALUE scr-confirm-password
           
           if scr-password not = scr-confirm-password
              display message box R"Password_mismatch"
                    icon mb-warning-icon
              move id-ef-password to control-id
              set all-ok          to false
           end-if.
           
           if all-ok
              move scr-id-user  to users-id
              read users no lock
                 invalid
                    continue
                 not invalid
                    move scr-password     to password
                    call "C$ENCRYPT" using function trimr(password), 
                                           "Veryant", 
                                           encrypted-data1
                    call "ASCII2HEX" using encrypted-data1, 
                                           encrypted-data2
                    move encrypted-data2   to users-pass
                    rewrite users-r
                       invalid
                          continue
                    end-rewrite  
                    move R"Information"  to iwc-notification-description
                    move R"Password_updated"   to iwc-notification
                    call "IWC-NOTIFY" using 78-notification-success
                                            iwc-notification-description
                                            iwc-notification
              end-read
              move 27 to key-status
           end-if.

           copy "dec-file.prd".
           copy "standard-toolbar.prd".
           copy "standard-toolbar-floating.prd".
