      *    Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.

       PROGRAM-ID. LOAD_MENU.
       configuration section.
       special-names.   

       REPOSITORY. 
           class json-stream     as "com.iscobol.rts.JSONStream"
           class j-string-buffer as "java.lang.StringBuffer"
           .

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "prog.sl".
       DATA DIVISION.
       FILE SECTION.
           COPY "prog.fd".

       WORKING-STORAGE SECTION.
       copy "common.wrk".
       copy "menu.wrk".
       copy "iwc.wrk".
       copy "iwc.lks".
       copy "settings.wrk".

       77  my-stream         object reference json-stream.
       77  buffer            object reference j-string-buffer.

       77  msg               pic x any length.

       77  status-prog       pic xx.
       77  status-users      pic xx.

       01                    pic 9.
           88 all-ok         value 1 false zero.

       77  wrk-user          pic x(20).
 
       77  idx-1             pic 9(2).
       77  idx-2             pic 9(2).
       77  idx-3             pic 9(2).
       77  idx-4             pic 9(2).
       77  idx-5             pic 9(2).
 
       01  level             pic 9.
           88 level-1        value 1.
           88 level-2        value 2.
           88 level-3        value 3.
           88 level-4        value 4.
           88 level-5        value 5.
 
      *
       78  78-no-exec        value "".
       78  78-graph-prog     value "gui".
       78  78-crt-prog       value "crt".
 
       77  wrk-calledby      pic x any length.
 
       77                    pic x.
           88 multi-webapp   value "m".
           88 single-webapp  value "s".

       77  save-indent       pic s9.
       77  save-rtrim        pic s9.
       77  save-omit-empty   pic s9.
 

       linkage section.
       77  lnk-user          pic x(20).

       screen section.

       PROCEDURE DIVISION using lnk-user.
       DECLARATIVES.
       PROG-ERR section.
           use after standard error procedure on prog.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
           call "C$CALLEDBY" using wrk-calledby
           if wrk-calledby = space
              set multi-webapp to true
              accept wrk-user from command-line
           else
              set single-webapp to true
              move lnk-user  to wrk-user
           end-if
       
           if multi-webapp
              perform SETTINGS
              call "CHECKFILE"
              call "IWC"
              call "IWC-START-COMUNICATION"
           end-if

           perform LOAD-VERSION

           perform OPEN-FILES.

           initialize UserMenu
                      idx-1
                      idx-2
                      idx-3
                      idx-4
                      idx-5

           move wrk-user  to prog-users-id
           move low-value to prog-menu-level

           start prog key not less prog-key
             invalid
               continue
              not invalid
                 perform until 1 = 2
                    read prog next
                       at end
                          exit perform
                    end-read
                    if wrk-user not = prog-users-id
                       exit perform
                    end-if
                    perform VAL-JSON
                 end-perform
           end-start.

           if single-webapp
              accept save-indent 
                       from environment "jsonstream.indent_number"
              accept save-rtrim 
                       from environment "jsonstream.rtrim"
              accept save-omit-empty 
                       from environment "jsonstream.omit_empty_elements"
           end-if

           set environment "jsonstream.indent_number"        to -1.
           set environment "jsonstream.rtrim"                to 1.
           set environment "jsonstream.omit_empty_elements"  to 1.

           set my-stream to json-stream:>new(UserMenu)
           set buffer to j-string-buffer:>new
           my-stream:>writeToStringBuffer ( buffer )

      *     initialize IWC-STRUCT
           move 78-iwc-load-menu   to iwc-send-action.
           set iwc-send-data       to buffer:>toString
           move space              to iwc-send-bytes
           call "IWC-SEND-MESSAGE" using iwc-send-action
                                         iwc-send-data
                                         iwc-send-bytes
 
           if single-webapp
              set environment "jsonstream.indent_number"
                                                     to save-indent
              set environment "jsonstream.rtrim"     to save-rtrim 
              set environment "jsonstream.omit_empty_elements"  
                                                     to save-omit-empty
           end-if

           set buffer     to null
           set my-stream to null

           if multi-webapp
              call "IWC-STOP-COMUNICATION"
              accept omitted
           end-if

           goback
           .

       LOAD-VERSION.
           move 78-iwc-get-version   to iwc-send-action.
           call "c$version"  using iwc-send-data
           move space              to iwc-send-bytes
           call "IWC-SEND-MESSAGE" using iwc-send-action
                                         iwc-send-data
                                         iwc-send-bytes
           .

       VAL-JSON.
           set level-5    to true
           if prog-level(5) = zero
              set level-4 to true
           end-if
           if prog-level(4) = zero
              set level-3 to true
           end-if
           if prog-level(3) = zero
              set level-2 to true
           end-if
           if prog-level(2) = zero
              set level-1 to true
           end-if.

           evaluate true
           when level-1
                add  1 to idx-1
                move 0 to idx-2
                          idx-3
                          idx-4
                          idx-5
               move function upper-case (prog-id) 
                                               to L1-prog-id-data(idx-1)
               evaluate true
               when prog-non-exec
                    move 78-no-exec      to L1-type-data(idx-1)
               when prog-graph-prog
                    move 78-graph-prog   to L1-type-data(idx-1)
               when prog-crt-prog
                    move 78-crt-prog     to L1-type-data(idx-1)
               end-evaluate
               move prog-s-desc          to L1-descripton-data(idx-1)

           when level-2
                add  1 to idx-2
                move 0 to idx-3
                          idx-4
                          idx-5
                move function upper-case (prog-id) 
                                       to L2-prog-id-data(idx-1, idx-2)
                evaluate true
                when prog-non-exec
                     move 78-no-exec     to L2-type-data(idx-1, idx-2)
                when prog-graph-prog
                     move 78-graph-prog  to L2-type-data(idx-1, idx-2)
                when prog-crt-prog
                     move 78-crt-prog    to L2-type-data(idx-1, idx-2)
                end-evaluate
                move prog-s-desc   to L2-descripton-data(idx-1, idx-2)
           when level-3
                add  1 to idx-3
                move 0 to idx-4
                          idx-5
               move function upper-case (prog-id)  
                                to L3-prog-id-data(idx-1, idx-2, idx-3)
               evaluate true
               when prog-non-exec
                    move 78-no-exec  
                                 to L3-type-data(idx-1, idx-2, idx-3)
               when prog-graph-prog
                    move 78-graph-prog  
                                 to L3-type-data(idx-1, idx-2, idx-3)
               when prog-crt-prog
                    move 78-crt-prog  
                                 to L3-type-data(idx-1, idx-2, idx-3)
               end-evaluate
               move prog-s-desc  
                             to L3-descripton-data(idx-1, idx-2, idx-3)
           when level-4
                add  1 to idx-4
                move 0 to idx-5
                move function upper-case (prog-id) 
                       to L4-prog-id-data(idx-1, idx-2, idx-3, idx-4)
                evaluate true
                when prog-non-exec
                     move 78-no-exec  
                       to L4-type-data(idx-1, idx-2, idx-3, idx-4)
                when prog-graph-prog
                     move 78-graph-prog  
                       to L4-type-data(idx-1, idx-2, idx-3, idx-4)
                when prog-crt-prog
                     move 78-crt-prog  
                       to L4-type-data(idx-1, idx-2, idx-3, idx-4)
                end-evaluate
                move prog-s-desc  
                       to L4-descripton-data(idx-1, idx-2, idx-3, idx-4)
           when level-5
                 add  1 to idx-5
                move function upper-case (prog-id) 
                to L5-prog-id-data(idx-1, idx-2, idx-3, idx-4, idx-5)
                evaluate true
                when prog-non-exec
                     move 78-no-exec  
                     to L5-type-data(idx-1, idx-2, idx-3, idx-4, idx-5)
                when prog-graph-prog
                     move 78-graph-prog  
                     to L5-type-data(idx-1, idx-2, idx-3, idx-4, idx-5)
                when prog-crt-prog
                     move 78-crt-prog  
                     to L5-type-data(idx-1, idx-2, idx-3, idx-4, idx-5)
                end-evaluate
                move prog-s-desc  
                to L5-descripton-data(idx-1, idx-2, idx-3, idx-4, idx-5)
           end-evaluate.

       OPEN-FILES.
           open input Prog.

       EXIT-PRG.
           perform CLOSE-FILE
           .

       DESTROY-RESOURCE.

       CLOSE-FILE.
           close Prog.

           copy "dec-file.prd".
           copy "settings.prd".