      *    Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.

       PROGRAM-ID. "MESSAGE-BOX-WEB" initial.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "isfonts.def".
       copy "iscobol.def".

       77  crt-status                 special-names crt status pic 9(5).
       77  close-win                  pic 9 value 0.
       77  hWin                       handle of window.
       77  rc                         pic s9 value -1.
       77  pb-1-col                   pic 99 value 0.
       77  pb-2-col                   pic 99 value 0.
       77  pb-3-col                   pic 99 value 0.
       77  pb-1-vis                   pic 9 value 0.
       77  pb-2-vis                   pic 9 value 0.
       77  pb-3-vis                   pic 9 value 0.
       77  pb-1-title                 pic x any length.
       77  pb-2-title                 pic x any length.
       77  pb-3-title                 pic x any length.
       77  pb-1-exec                  pic 9.
       77  pb-2-exec                  pic 9.
       77  pb-3-exec                  pic 9.
       77  pb-1-back-color            pic s9(9).
       77  pb-2-back-color            pic s9(9).
       77  pb-3-back-color            pic s9(9).
       77  id-ok                      pic 9 value 0.
       77  id-yes                     pic 9 value 0.
       77  id-no                      pic 9 value 0.
       77  id-cancel                  pic 9 value 0.
       77  id-abort                   pic 9 value 0.
       77  id-ignore                  pic 9 value 0.
       77  id-retry                   pic 9 value 0.
       77  id-continue                pic 9 value 0.
       
       78  78-id-pb-1                 value 1.
       78  78-id-pb-2                 value 2.
       78  78-id-pb-3                 value 3.

      * 77  control-font               handle of font.
       77  h-font                     handle of font.
       77  h-font-title               handle of font.
       
      * 77  wrk-gradient-color-1       pic s9(8).
      * 77  wrk-gradient-color-2       pic s9(8).

       77  time-out-rc                pic s9 value -1.

       77  font-path                  pic x any length.
       77  font-name                  pic x any length.
       77  wrk-font-name              pic x any length.
       77  h-font-awsome              handle of font.
       77  icon-number                pic 9.
       77  h-icon                     pic S9(9) comp-4 .

       77  message-back-color         pic s9(9).

       78  78-pb-warning-color        value -16301702.
       78  78-pb-error-color          value -15823731.
       78  78-pb-default-color        value -1549208.
       78  78-pb-no-default-color     value -12698049.
       77  pb-default-color           pic s9(9).
  

       LINKAGE SECTION. 
       77  msgbox-text                pic x any length.
       77  msgbox-title               pic x any length.
       77  msgbox-type                pic 9. 
       77  msgbox-icon                pic 9(5). 
       77  msgbox-btn-default         pic 9. 
       77  msgbox-timeout             pic 9(5).
       77  msgbox-centered            pic 9.

       SCREEN SECTION.
       01  Mask.   
           03 Bmp1 
              bitmap
              line                    2
      *        col                     25.5
              col                     22
              lines                   90 pixel
              size                    90 pixel
              bitmap-handle           h-icon
              bitmap-number           icon-number
              .
           03 label
              title                   msgbox-title
              line                    6.5
              lines                   1
              col                     2
              size                    51 cells
              font                    h-font-title
              centered
              transparent
      *        background-color        rgb x#FFFF00
              .

           03 label
              title                   msgbox-text
              line                    8
              lines                   3
              col                     2
              size                    51 cells
              centered
              transparent
      *        background-color        rgb x#FFFF00
              .
           03 push-button
              title                   pb-1-title
              line                    12
              col                     pb-1-col
              id                      78-id-pb-1
              visible                 pb-1-vis
              exception-value         pb-1-exec
              size                    11
              flat
      *        foreground-color
              background-color        pb-1-back-color
              font h-font-title 
              .
           03 push-button
              title                   pb-2-title
              line                    12
              col                     pb-2-col
              id                      78-id-pb-2
              visible                 pb-2-vis
              exception-value         pb-2-exec
              size                    11
              flat
              background-color        pb-2-back-color
              font h-font-title 
              .
           03 btn3 
              push-button
              title                   pb-3-title
              line                    12
              col                     pb-3-col
              id                      78-id-pb-3
              visible                 pb-3-vis
              exception-value         pb-3-exec
              size                    11
              flat
              background-color        pb-3-back-color
              font h-font-title 
              .

       procedure division using msgbox-text
                                msgbox-title
                                msgbox-type 
                                msgbox-icon
                                msgbox-btn-default
                                msgbox-timeout
                                msgbox-centered
                                .
       MAIN.
           perform LOAD-FONT.
           perform LOAD-ICON.

           evaluate msgbox-icon
           when MB-WARNING-ICON
                move -16708585           to message-back-color
                move 78-pb-warning-color to pb-default-color
           when MB-ERROR-ICON
                move -16640232           to message-back-color
                move 78-pb-error-color   to pb-default-color
           when MB-DEFAULT-ICON
           when other
                move -15990525           to message-back-color
                move 78-pb-default-color to pb-default-color
           end-evaluate

           evaluate msgbox-type
           when MB-OK
                move 1                to pb-1-vis
                move "Ok"             to pb-1-title
                move 20               to pb-1-col
                move MB-YES           to pb-1-exec
                move 78-id-pb-1       to id-ok
                move mb-ok            to time-out-rc
                move pb-default-color to pb-1-back-color 

           when MB-YES-NO
                move 1             to pb-1-vis
                move "Yes"         to pb-1-title
                move 11            to pb-1-col
                move MB-YES        to pb-1-exec
                move 78-id-pb-1    to id-yes
                move 1             to pb-2-vis
                move "No"          to pb-2-title
                move 29            to pb-2-col
                move MB-NO         to pb-2-exec
                move 78-id-pb-2    to id-no
                move mb-yes        to time-out-rc
                evaluate msgbox-btn-default
                when MB-NO
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move pb-default-color        to pb-2-back-color
                when MB-YES
                when other
                     move pb-default-color        to pb-1-back-color
                     move 78-pb-no-default-color  to pb-2-back-color  
                end-evaluate

           when MB-OK-CANCEL
                move 1             to pb-1-vis
                move "Ok"          to pb-1-title
                move 11            to pb-1-col
                move 78-id-pb-1    to id-ok
                move MB-YES        to pb-1-exec
                move 1             to pb-2-vis
                move "Cancel"      to pb-2-title
                move 29            to pb-2-col
                move MB-CANCEL     to pb-2-exec
                move 78-id-pb-2    to id-cancel
                move mb-ok         to time-out-rc
                evaluate msgbox-btn-default
                when MB-CANCEL
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move pb-default-color        to pb-2-back-color
                when MB-OK
                when other
                     move pb-default-color        to pb-1-back-color
                     move 78-pb-no-default-color  to pb-2-back-color  
                end-evaluate

           when MB-YES-NO-CANCEL
                move 1             to pb-1-vis
                move "Yes"         to pb-1-title
                move 3             to pb-1-col
                move MB-YES        to pb-1-exec
                move 78-id-pb-1    to id-yes
                move 1             to pb-2-vis
                move "No"          to pb-2-title
                move 20            to pb-2-col
                move MB-NO         to pb-2-exec
                move 2             to id-no
                move 1             to pb-3-vis
                move "Cancel"      to pb-3-title
                move 37            to pb-3-col
                move MB-CANCEL     to pb-3-exec
                move 78-id-pb-3    to id-cancel
                move mb-yes        to time-out-rc
                evaluate msgbox-btn-default
                when MB-NO
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move pb-default-color        to pb-2-back-color
                     move 78-pb-no-default-color  to pb-3-back-color  
                when MB-CANCEL
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move 78-pb-no-default-color  to pb-2-back-color  
                     move pb-default-color        to pb-3-back-color
                when MB-YES
                when other
                     move pb-default-color        to pb-1-back-color
                     move 78-pb-no-default-color  to pb-2-back-color  
                     move 78-pb-no-default-color  to pb-3-back-color  
                end-evaluate

           when MB-RETRY-CANCEL
                move 1             to pb-1-vis
                move "Retry"       to pb-1-title
                move 11            to pb-1-col
                move MB-RETRY      to pb-1-exec
                move 78-id-pb-1    to id-retry
                move 1             to pb-2-vis
                move "Cancel"      to pb-2-title
                move 29            to pb-2-col
                move MB-CANCEL     to pb-2-exec
                move 78-id-pb-2    to id-cancel
                move mb-cancel     to time-out-rc

                evaluate msgbox-btn-default
                when MB-CANCEL
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move pb-default-color        to pb-2-back-color
                when MB-RETRY
                when other
                     move pb-default-color        to pb-1-back-color
                     move 78-pb-no-default-color  to pb-2-back-color  
                end-evaluate

           when MB-ABORT-RETRY-IGNORE
                move 1             to pb-1-vis
                move "Abort"       to pb-1-title
                move 3             to pb-1-col
                move MB-ABORT      to pb-1-exec
                move 78-id-pb-1    to id-abort
                move 1             to pb-2-vis
                move "Retry"       to pb-2-title
                move 20            to pb-2-col
                move MB-RETRY      to pb-2-exec
                move 78-id-pb-2    to id-retry
                move 1             to pb-3-vis
                move "Ignore"      to pb-3-title
                move 37            to pb-3-col
                move MB-CANCEL     to pb-3-exec
                move 78-id-pb-3    to id-ignore
                move mb-yes        to time-out-rc
                evaluate msgbox-btn-default
                when MB-RETRY
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move pb-default-color        to pb-2-back-color
                     move 78-pb-no-default-color  to pb-3-back-color  
                when MB-IGNORE
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move 78-pb-no-default-color  to pb-2-back-color  
                     move pb-default-color        to pb-3-back-color
                when MB-ABORT
                when other
                     move pb-default-color        to pb-1-back-color
                     move 78-pb-no-default-color  to pb-2-back-color  
                     move 78-pb-no-default-color  to pb-3-back-color  
                end-evaluate

           when MB-CANCEL-RETRY-CONTINUE
                move 1             to pb-1-vis
                move "Cancel"      to pb-1-title
                move 3             to pb-1-col
                move MB-CANCEL     to pb-1-exec
                move 78-id-pb-1    to id-cancel
                move 1             to pb-2-vis
                move "Retry"       to pb-2-title
                move 20            to pb-2-col
                move MB-RETRY      to pb-2-exec
                move 78-id-pb-2    to id-retry
                move 1             to pb-3-vis
                move "Continue"    to pb-3-title
                move 37            to pb-3-col
                move MB-CONTINUE   to pb-3-exec
                move 78-id-pb-3    to id-continue
                move mb-yes        to time-out-rc
                evaluate msgbox-btn-default
                when MB-RETRY
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move pb-default-color        to pb-2-back-color
                     move 78-pb-no-default-color  to pb-3-back-color  
                when MB-CONTINUE
                     move 78-pb-no-default-color  to pb-1-back-color  
                     move 78-pb-no-default-color  to pb-2-back-color  
                     move pb-default-color        to pb-3-back-color
                when MB-CANCEL
                when other
                     move pb-default-color        to pb-1-back-color
                     move 78-pb-no-default-color  to pb-2-back-color  
                     move 78-pb-no-default-color  to pb-3-back-color  
                end-evaluate
           end-evaluate

           display floating graphical window
                   lines  13
                   size   53
                   foreground-color   rgb x#575757
                   background-color   message-back-color
                   control font h-font
                   handle hWin
                   visible 0
                   undecorated
                   event  WIN-EVT

           call "W$CENTER_WINDOW" using hWin

           display Mask

           modify hWin visible 1

           move 0 to rc
           move 0 to crt-status
           move 0 to close-win

           if msgbox-btn-default > 0
              evaluate msgbox-btn-default
              when MB-OK
                   move id-ok         to control-id
              when MB-YES
                   move id-yes        to control-id
              when MB-NO
                   move id-no         to control-id
              when MB-CANCEL
                   move id-cancel     to control-id
              when MB-ABORT
                   move id-abort      to control-id
              when MB-IGNORE
                   move id-ignore     to control-id
              when MB-CONTINUE
                   move id-continue   to control-id
              when MB-RETRY
                   move id-retry      to control-id
              end-evaluate
              move msgbox-btn-default to time-out-rc
           end-if
           move 4 to accept-control

           perform until crt-status = 99 or
                         crt-status = 27 or 
                         close-win = 1
              if msgbox-timeout > 0
                 accept Mask before time msgbox-timeout
                    on exception 
                       continue 
                 end-accept
              else
                 accept Mask 
                    on exception 
                       continue 
                 end-accept
              end-if 
              evaluate crt-status
              when 99 
                   move time-out-rc   to rc
              when MB-YES
              when MB-NO
              when MB-CANCEL
              when MB-RETRY
              when MB-IGNORE
              when MB-CONTINUE
              when MB-ABORT
                   move crt-status to rc
                   move 1 to close-win
              end-evaluate
           end-perform 
 
           destroy Mask
           destroy hWin
           destroy h-font 
                   h-font-title
                   h-font-awsome 
           call "W$BITMAP" using wbitmap-destroy h-icon
           goback rc
           .

       LOAD-FONT.
           accept font-path from environment "font_folder"

           initialize font-name
           string font-path                    delimited by size
                  "/SourceSansPro-Regular.ttf" delimited by size
                  into font-name

           call "w$createfont" using font-name
                                     wrk-font-name

           initialize wfont-data
           move wrk-font-name   to wfont-name
           move 13              to wfont-size
           call "W$FONT" using wfont-get-font 
                               h-font 
                               wfont-data

           move wrk-font-name   to wfont-name
           move 14              to wfont-size
           set wfont-bold to true
           call "W$FONT" using wfont-get-font 
                               h-font-title 
                               wfont-data
           .

       LOAD-ICON.
           evaluate msgbox-icon
           when MB-WARNING-ICON
                 move 2   to icon-number
           when MB-ERROR-ICON
                 move 1   to icon-number
           when MB-DEFAULT-ICON
           when other
                 move 3   to icon-number
           end-evaluate

           CALL "W$BITMAP" USING wbitmap-load
                           "message-icon.png"
                           GIVING h-icon
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
