       >>source format free
       
       identification division.
       class-id. MySecurityModule as "MySecurityModule" 
                    inherits AbstractUserPasswordSecurityModule.

       environment division.
       configuration section.
       repository.
           class MyUser                             as "MyUser"
           class WebswingAuthenticationException    
                  as "org.webswing.server.services.security.api.WebswingAuthenticationException"
           class AbstractUserPasswordSecurityModule 
                      as "org.webswing.server.services.security.modules.AbstractUserPasswordSecurityModule"
           class EmbeddedSecurityModuleConfig        
              as "org.webswing.server.core.services.security.modules.embedded.EmbeddedSecurityModuleConfig"
           class AuthenticatedWebswingUser          
                        as "org.webswing.server.common.service.security.AuthenticatedWebswingUser"
           class JString                           as "java.lang.String"
           class JSystem                           as "java.lang.System"
           .

       identification division.
       object.
       procedure division.

       identification division.
       method-id. new as "new".
       linkage section.
       77  config object reference EmbeddedSecurityModuleConfig.
       procedure division using config.
       main.
           super:>new(config).
       end method.

       identification division.

       method-id. verifyUserPassword as "verifyUserPassword" override.
       working-storage section.
       77  obj-MyUser  object reference AuthenticatedWebswingUser.
       77  wrk-user-id pic x(20).
       77  wrk-pwd     pic x(50).
       77  rc          pic s9(9).
       linkage section.
       77  user     object reference JString.
       77  password object reference JString.
       procedure division using user
                                password 
                      returning obj-MyUser
                        raising WebswingAuthenticationException.   
       main.
      | execution og a Cobol program for the authentication*
           set wrk-user-id to user.
           set wrk-pwd     to password.
           call "COB_CHECK_LOGIN" using wrk-user-id, wrk-pwd giving rc.
           cancel all.
           if rc = 1
              set obj-MyUser to MyUser:>new(user)
           else   
              raise WebswingAuthenticationException:>new
              ("Invalid Username or Password", 
              WebswingAuthenticationException:>INVALID_USER_OR_PASSWORD)
           end-if.   
       end method.

       end object.

       end class.  