      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. jbgmaps.

       configuration section.
       repository.
           class iscobol-java-bean
                       as "com.iscobol.gui.server.CobolGUIJavaBean"  
           class J-number          as "java.lang.Double"

           class zk-marker         as "org.zkoss.gmaps.Gmarker"
           class zk-gmaps          as "org.zkoss.gmaps.Gmaps"

           class j-boolean         as "java.lang.Boolean"
           class j-native-boolean  as "boolean"
           class j-double          as "java.lang.Double"
           class j-string          as "java.lang.String"
           class j-int             as "java.lang.Integer"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       77  key-status is special-names crt status pic 9(4) value 0.

       77  v-is-javabean        object reference iscobol-java-bean.

       77  J-num                object reference J-number.

       77  bool                 object reference j-boolean.
       77  native-boolean       object reference j-native-boolean.

       77  latitude             object reference j-double.
       77  longitude            object reference j-double.
       
       77  marker               object reference zk-marker.
       77  tmp-gmap             object reference zk-gmaps.

       77  string-to-hash-code  object reference j-string.
       77  hash-code            int.
       77  wrk-code             int.

       77  onMapMove-number     int.
       77  onSelect-number      int.

       77  element-name         pic x(30).
       77  element-size         pic 9(2)v9(2).
       
       77  wrk-latitude         double.
       77  wrk-longitude        double.
       77  zoom-level           int value 18. 

       77  jb-event-name        pic x any length.

       SCREEN SECTION.
       01 mask.
           03 Label
              line                 3
              lines                1.5
              column               2
              size                 10
              title                "latitude"
              .
           03 ef-latitude 
              Entry-Field
              line                 3
              lines                1.5
              column               13
              size                 20
              numeric
              placeholder          "Type the latitude"
              value                wrk-latitude
              .
           03 Label
              line                 6
              column               2
              size                 10
              title                "longitude"
              .
           03 ef-longitude
              Entry-Field
              line                 6
              lines                1.5
              column               13
              size                 20
              numeric
              placeholder          "Type the longitude"
              value                wrk-longitude
              .
           03 Push-Button
              line                 3.2
              column               40
              size                 20 
              lines                4
              css-base-style-name  "btn btn-success"
              title                "Show in map"
              css-icon             "fa-globe "
              title-position       2
              exception-value      100
              .
           03 Push-Button
              line                 3.2
              column               70
              size                 20 
              lines                4
              css-base-style-name  "btn btn-warning"
              title                "Add marker here"
              css-icon             "fa-map-marker "
              title-position       2
              exception-value      200
              .
           03 java-bean 
              clsid                "org.zkoss.gmaps.Gmaps"
              line                 10 
              col                  2 
              size                 96 
              lines                40
              object               v-is-javabean
              event-list           ( "onMapMove", "onSelect" )
              event                EVENT-JB
              .

       PROCEDURE DIVISION.

       MAIN.
       
           move 32.8548319    to wrk-latitude.
           move -117.1864619  to wrk-longitude. 

           perform GET-EVENT-NUMBER.

           display standard graphical window 
                   background-low 
                   lines 50
                   size 100
                   title "Google Maps Demo".

           display mask.
           
           perform INIT-MAP.

           perform until key-status = 27
              accept mask on exception 
                 continue
              end-accept
              evaluate key-status 
              when 100
                   perform SET-THE-MAP
              when 200
                   perform ADD-MARKER-TO-MAP
              end-evaluate
           end-perform.
    
           goback
           .
           
       INIT-MAP.
           inquire ef-latitude value wrk-latitude 
           inquire ef-longitude value wrk-longitude 

           set latitude to j-double:>new(wrk-latitude).
           set longitude to j-double:>new(wrk-longitude).

           set bool to j-boolean:>TRUE
           v-is-javabean:>callMethod ("setMapType" "hybrid" as String).
           v-is-javabean:>callMethod ("setZoom" zoom-level).
           v-is-javabean:>callMethod ("setLat" latitude).
           v-is-javabean:>callMethod ("setLng" longitude).

           call "C$SLEEP" using 2.

           set marker to zk-marker:>new();;
      
           marker:>setAnchor(latitude:>doubleValue(), 
                             longitude:>doubleValue());;

           marker:>setOpen ( bool:>booleanValue() );;
           v-is-javabean :>callMethod("appendChild" marker)
           .

       SET-THE-MAP.
           inquire ef-latitude value wrk-latitude 
           inquire ef-longitude value wrk-longitude 

           set latitude to j-double:>new(wrk-latitude).
           set longitude to j-double:>new(wrk-longitude).

           v-is-javabean:>callMethod ("setLat" wrk-latitude ).
           v-is-javabean:>callMethod ("setLng" wrk-longitude).
           .

       GET-FROM-MAP.
           move 0 to wrk-latitude.
           move 0 to wrk-longitude .
           set wrk-latitude 
                 to v-is-javabean:>callMethod ("getLat") as j-double.
           set wrk-longitude 
                 to v-is-javabean:>callMethod ("getLng") as j-double.
           modify ef-latitude value wrk-latitude.
           modify ef-longitude value wrk-longitude
           .

       ADD-MARKER-TO-MAP.
           move 0 to wrk-latitude.
           move 0 to wrk-longitude .
           set wrk-latitude 
                 to v-is-javabean:>callMethod ("getLat") as j-double.
           set wrk-longitude 
                 to v-is-javabean:>callMethod ("getLng") as j-double.

           set marker to zk-marker:>new()

           marker:>setAnchor(wrk-latitude, wrk-longitude);;
           marker:>setOpen ( bool:>booleanValue() );;
           v-is-javabean :>callMethod("appendChild" marker)
           .


       EVENT-JB.
           display "JaveBean event [" EVENT-DATA-1 "," EVENT-DATA-2 "]" 
             upon sysout.
             
           evaluate event-data-2
           when onMapMove-number 
                perform GET-FROM-MAP
           when onSelect-number  
                display "onSelect (marker selected)" upon sysout
           end-evaluate.

      *    retreive the hashcode of the jb event
       GET-EVENT-NUMBER.
           move "onMapMove"  to jb-event-name.
           perform GET-HASH-CODE.
           move hash-code to onMapMove-number.

           move "onSelect"  to jb-event-name.
           perform GET-HASH-CODE.
           move hash-code to onSelect-number.

           
       GET-HASH-CODE.
           set string-to-hash-code to j-string:>new().

           set string-to-hash-code to jb-event-name.
           
           set hash-code to J-int:>new(string-to-hash-code:>hashCode())
           if hash-code >= zero
              continue
           else
              set wrk-code = j-int:>MAX_VALUE()
              add wrk-code to hash-code
           end-if.
