/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.ctdb;

public class CTBase {
    protected CTHANDLE m_handle = null;

    private int GetError() {
        return ctdb.GetError(this.m_handle);
    }

    public boolean IsTransActive() {
        return ctdb.IsTransActive(this.m_handle);
    }

    public void Begin() throws CTException {
        int n = ctdb.Begin(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't begin a transaction.");
        }
    }

    public void Commit() throws CTException {
        int n = ctdb.Commit(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't commit a transaction.");
        }
    }

    public void Abort() throws CTException {
        int n = ctdb.Abort(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't abort a transaction.");
        }
    }

    public void PrepareCommit() throws CTException {
        int n = ctdb.PrepareCommit(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't prepare a transaction for commit.");
        }
    }

    public int SetSavePoint() throws CTException {
        int n = ctdb.SetSavePoint(this.m_handle);
        if (n == 0) {
            throw new CTException(this.GetError(), "Can't set save point");
        }
        return n;
    }

    public void RestoreSavePoint(int n) throws CTException {
        int n2 = ctdb.RestoreSavePoint(this.m_handle, n);
        if (n2 != 0) {
            throw new CTException(n2, "Can't restore save point");
        }
    }

    public void ClearSavePoint() throws CTException {
        int n = ctdb.ClearSavePoint(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't clear save point");
        }
    }

    public CTHANDLE GetHandle() {
        return this.m_handle;
    }

    public void SetHandle(CTHANDLE cTHANDLE) {
        this.m_handle = cTHANDLE;
    }

    public boolean GetAutoCommit() {
        return ctdb.GetAutoCommit(this.m_handle);
    }

    public boolean IsLockActive() {
        return ctdb.IsLockActive(this.m_handle);
    }

    public int GetLockMode() {
        return ctdb.GetLockMode(this.m_handle);
    }

    public void Lock(int n) throws CTException {
        int n2 = ctdb.Lock(this.m_handle, n);
        if (n2 != 0) {
            throw new CTException(n2, "Lock failed");
        }
    }

    public void Unlock() throws CTException {
        this.Lock(0);
    }

    public int GetKeepLock() {
        return ctdb.GetKeepLock(this.m_handle);
    }

    public void SetKeepLock(int n) throws CTException {
        int n2 = ctdb.SetKeepLock(this.m_handle, n);
        if (n2 != 0) {
            throw new CTException(n2, "Can't set keep lock mode");
        }
    }

    public void SetTransactionMode(int n) throws CTException {
        int n2 = ctdb.SetTransactionMode(this.m_handle, n);
        if (n2 != 0) {
            throw new CTException(n2, "Can't set the transaction mode");
        }
    }

    public int GetTransactionMode() {
        return ctdb.GetTransactionMode(this.m_handle);
    }

    public void SetAutoCommit(boolean bl) throws CTException {
        int n = ctdb.SetAutoCommit(this.m_handle, bl);
        if (n != 0) {
            throw new CTException(n, "Can't set auto commit state");
        }
    }

    public int GetOperation() {
        return ctdb.GetOperationState(this.m_handle);
    }

    public void SetOperation(int n, int n2) throws CTException {
        int n3 = ctdb.SetOperationState(this.m_handle, n, n2);
        if (n3 != 0) {
            throw new CTException(n3, "Can't set the operation state");
        }
    }

    public boolean IsUnicodeLib() {
        return ctdb.IsUnicodeLib();
    }
}

