/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTFullTextIndex
extends CTBase {
    public CTFullTextIndex() {
    }

    public CTFullTextIndex(CTFullTextIndex cTFullTextIndex) {
        this.m_handle = cTFullTextIndex.m_handle;
    }

    public void finalize() {
    }

    public void AddField(CTField cTField, int n) throws CTException {
        int n2 = ctdb.AddFTIField(this.m_handle, cTField.GetHandle(), n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't add field to full text index");
        }
    }

    public int GetFieldCount() throws CTException {
        int n = ctdb.GetFTIFieldCount(this.m_handle);
        if (n < 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't get full text index field count");
        }
        return n;
    }

    public CTField GetField(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetFTIField(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve the Full Text index field");
        }
        CTField cTField = new CTField();
        cTField.m_handle = cTHANDLE;
        return cTField;
    }

    public int GetStatus() {
        return ctdb.GetFTIStatus(this.m_handle);
    }

    public void SetOption(int n, String string, int n2) throws CTException {
        int n3 = ctdb.SetFTIOption(this.m_handle, n, string, n2);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Can't set the Full Text index option");
        }
    }

    public String GetName() throws CTException {
        String string = ctdb.GetFTIName(this.m_handle);
        if (string == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't get the Full Text index name");
        }
        return string;
    }

    public int GetNumber() throws CTException {
        int n = ctdb.GetFTINbr(this.m_handle);
        int n2 = ctdb.GetError(this.m_handle);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't retrieve index position in table indices list");
        }
        return n;
    }

    public int GetFieldMode(int n) throws CTException {
        int n2 = ctdb.GetFTIFieldMode(this.m_handle, n);
        if (n2 == 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve the Full Text index field mode");
        }
        return n2;
    }
}

