/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.CTSegment;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTIndex
extends CTBase {
    public CTIndex() {
    }

    public CTIndex(CTIndex cTIndex) {
        this.m_handle = cTIndex.m_handle;
    }

    public void finalize() {
    }

    public int GetKeyLength() {
        return ctdb.GetIndexKeyLength(this.m_handle);
    }

    public int GetKeyType() throws CTException {
        int n = ctdb.GetIndexKeyType(this.m_handle);
        if (n == 65535) {
            throw new CTException(n, "Cannot Retrieve Key Type");
        }
        return n;
    }

    public char GetEmptyChar() {
        return ctdb.GetIndexEmptyChar(this.m_handle);
    }

    public boolean GetDuplicateFlag() {
        return ctdb.GetIndexDuplicateFlag(this.m_handle);
    }

    public boolean GetNullFlag() {
        return ctdb.GetIndexNullFlag(this.m_handle);
    }

    public boolean GetTemporaryFlag() {
        return ctdb.GetIndexTemporaryFlag(this.m_handle);
    }

    public void SetEmptyChar(char c) throws CTException {
        int n = ctdb.SetIndexEmptyChar(this.m_handle, c);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the index empty character");
        }
    }

    public void SetDuplicateFlag(boolean bl) throws CTException {
        int n = ctdb.SetIndexDuplicateFlag(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the index duplicate flag");
        }
    }

    public void SetNullFlag(boolean bl) throws CTException {
        int n = ctdb.SetIndexNullFlag(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the index nul flag");
        }
    }

    public void SetTemporaryFlag(boolean bl) throws CTException {
        int n = ctdb.SetIndexTemporaryFlag(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the index temporary flag");
        }
    }

    public int GetSegmentCount() {
        return ctdb.GetIndexSegmentCount(this.m_handle);
    }

    public CTSegment AddSegment(CTField cTField, int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.AddSegment(this.m_handle, cTField.GetHandle(), n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't add index segment");
        }
        CTSegment cTSegment = new CTSegment();
        cTSegment.SetHandle(cTHANDLE);
        return cTSegment;
    }

    public CTSegment AddSegment(int n, int n2, int n3) throws CTException {
        CTHANDLE cTHANDLE = ctdb.AddSegmentEx(this.m_handle, n, n2, n3);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't add index segment");
        }
        CTSegment cTSegment = new CTSegment();
        cTSegment.SetHandle(cTHANDLE);
        return cTSegment;
    }

    public CTSegment AddJSONSegment(CTField cTField, String string, int n, int n2) throws CTException {
        CTHANDLE cTHANDLE = ctdb.AddJSONSegment(this.m_handle, cTField.GetHandle(), string, n, n2);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't add index JSON segment");
        }
        CTSegment cTSegment = new CTSegment();
        cTSegment.SetHandle(cTHANDLE);
        return cTSegment;
    }

    public CTSegment InsertSegment(int n, CTField cTField, int n2) throws CTException {
        CTHANDLE cTHANDLE = ctdb.InsSegment(this.m_handle, n, cTField.GetHandle(), n2);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't insert index segment");
        }
        CTSegment cTSegment = new CTSegment();
        cTSegment.SetHandle(cTHANDLE);
        return cTSegment;
    }

    public CTSegment InsertSegment(int n, int n2, int n3, int n4) throws CTException {
        CTHANDLE cTHANDLE = ctdb.InsSegmentEx(this.m_handle, n, n2, n3, n4);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't insert index segment");
        }
        CTSegment cTSegment = new CTSegment();
        cTSegment.SetHandle(cTHANDLE);
        return cTSegment;
    }

    public void DelSegment(int n) throws CTException {
        int n2 = ctdb.DelSegment(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't delete index segment");
        }
    }

    public CTSegment GetSegment(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetSegment(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve the index segment");
        }
        CTSegment cTSegment = new CTSegment();
        cTSegment.SetHandle(cTHANDLE);
        return cTSegment;
    }

    public int GetNumber() throws CTException {
        int n = ctdb.GetIndexNbr(this.m_handle);
        int n2 = ctdb.GetError(this.m_handle);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't retrieve index position in table indices list");
        }
        return n;
    }

    public String GetName() {
        return ctdb.GetIndexName(this.m_handle);
    }

    public long GetUID() throws CTException {
        long l = ctdb.GetIndexUID(this.m_handle, ctdb.GetIndexName(this.m_handle));
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot retrieve index UID");
        }
        return l;
    }

    public void SetName(String string) throws CTException {
        int n = ctdb.SetIndexName(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the index name");
        }
    }

    public void SetKeyType(int n) throws CTException {
        int n2 = ctdb.SetIndexKeyType(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the index key type");
        }
    }

    public void SetFilename(String string, String string2) throws CTException {
        int n = ctdb.SetIndexFilename(this.m_handle, string, string2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the index file name");
        }
    }

    public String GetFilename() {
        return ctdb.GetIndexFilename(this.m_handle);
    }

    public int GetIdxno() throws CTException {
        int n = ctdb.GetIdxno(this.m_handle);
        if (n < 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't get the index number");
        }
        return n;
    }

    public int GetStatus() {
        return ctdb.GetIndexStatus(this.m_handle);
    }

    public void MoveSegment(int n, int n2) throws CTException {
        CTSegment cTSegment = this.GetSegment(n);
        cTSegment.MoveSegment(n2);
    }

    public void SetCndxExpression(String string) throws CTException {
        int n = ctdb.SetIndexCndxExpression(this.m_handle, string);
        if (n != 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "Cannot set conditiona expression");
        }
    }
}

