/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.CTResultSet;
import FairCom.CtreeDb.CTTable;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.Types.FTS_ERROR_DETAIL;
import FairCom.CtreeDb.ctdb;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CTRecord
extends CTBase {
    private CTTable parent = null;

    public CTRecord(CTTable cTTable) throws CTException {
        if (cTTable.m_handle == null) {
            throw new CTException(CTDBRET.NOTTABLE.getErrno(), "Invalid table handle");
        }
        this.m_handle = ctdb.AllocRecord(cTTable.m_handle);
        if (this.m_handle == null) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't allocate record handle");
        }
        this.parent = cTTable;
    }

    public CTRecord(CTRecord cTRecord) throws CTException {
        if (cTRecord.m_handle == null) {
            throw new CTException(CTDBRET.NOTRECORD.getErrno(), "Invalid record handle");
        }
        this.m_handle = ctdb.DuplicateRecord(cTRecord.m_handle);
        if (this.m_handle == null) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't duplicate record handle");
        }
        this.parent = cTRecord.parent;
    }

    public CTTable getParent() {
        return this.parent;
    }

    public void finalize() {
        if (this.m_handle != null) {
            ctdb.FreeRecord(this.m_handle);
            this.m_handle = null;
        }
    }

    public boolean First() throws CTException {
        int n = ctdb.FirstRecord(this.m_handle);
        boolean bl = false;
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Cant move to first record in table");
        }
        return bl;
    }

    public boolean Last() throws CTException {
        int n = ctdb.LastRecord(this.m_handle);
        boolean bl = true;
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Cant move to last record in table");
        }
        return bl;
    }

    public boolean Next() throws CTException {
        boolean bl = false;
        int n = ctdb.NextRecord(this.m_handle);
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Cant move to next record in table");
        }
        return bl;
    }

    public boolean Prev() throws CTException {
        boolean bl = false;
        int n = ctdb.PrevRecord(this.m_handle);
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Cant move to prev record in table");
        }
        return bl;
    }

    public boolean Find(int n) throws CTException {
        boolean bl = false;
        int n2 = ctdb.FindRecord(this.m_handle, n);
        if (n2 == 0) {
            bl = true;
        } else if (n2 != 101) {
            throw new CTException(n2, "Error finding record");
        }
        return bl;
    }

    public void Clear() throws CTException {
        int n = ctdb.ClearRecord(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't clear record");
        }
    }

    public void Read() throws CTException {
        int n = ctdb.ReadRecord(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't read record");
        }
    }

    public void Write() throws CTException {
        int n = ctdb.WriteRecord(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't write record");
        }
    }

    public void Delete() throws CTException {
        int n = ctdb.DeleteRecord(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't delete record");
        }
    }

    public boolean IsNew() {
        return ctdb.IsNewRecord(this.m_handle);
    }

    public boolean IsEdited() {
        return ctdb.IsEditedRecord(this.m_handle);
    }

    public void SetNew(boolean bl) throws CTException {
        int n = ctdb.SetNewRecord(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the new record flag");
        }
    }

    public void SetEdited(boolean bl) throws CTException {
        int n = ctdb.SetEditedRecord(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the changed record flag");
        }
    }

    public int GetDefaultIndex() {
        return ctdb.GetDefaultIndex(this.m_handle);
    }

    public String GetDefaultIndexName() {
        return ctdb.GetDefaultIndexName(this.m_handle);
    }

    public void SetDefaultIndex(int n) throws CTException {
        int n2 = ctdb.SetDefaultIndex(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the default index");
        }
    }

    public void SetDefaultIndex(String string) throws CTException {
        int n = ctdb.SetDefaultIndexByName(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the default index name");
        }
    }

    public int GetRecordLength() {
        return ctdb.GetRecordLength(this.m_handle);
    }

    public int GetRecordSize() {
        return ctdb.GetRecordSize(this.m_handle);
    }

    public long GetRecordPos() throws CTException {
        long l = ctdb.GetRecordPos(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't retrieve current record offset");
        }
        return l;
    }

    long GetRecordPosAtPercentile(int n) throws CTException {
        long l = ctdb.GetRecordPosAtPercentile(this.m_handle, n);
        if (l == 0L) {
            throw new CTException((int)l, "Can't retrieve record offset");
        }
        return l;
    }

    public void SeekRecord(long l) throws CTException {
        int n = ctdb.SeekRecord(this.m_handle, l);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't seek to record offset");
        }
    }

    public boolean IsNullField(String string) throws CTException {
        return this.IsNullField(this.GetFieldByName(string));
    }

    public boolean IsNullField(int n) {
        return ctdb.IsNullField(this.m_handle, n);
    }

    public String GetFieldName(int n) throws CTException {
        return this.parent.GetField(n).GetName();
    }

    public int GetFieldType(String string) throws CTException {
        return this.GetFieldType(this.GetFieldByName(string));
    }

    public int GetFieldType(int n) throws CTException {
        return this.parent.GetField(n).GetType();
    }

    public String GetFieldAsString(String string) throws CTException {
        return this.GetFieldAsString(this.GetFieldByName(string));
    }

    public String GetFieldAsString(int n) throws CTException {
        return ctdb.GetFieldAsString(this.m_handle, n);
    }

    public String GetFieldAsJSON(String string) throws CTException {
        return this.GetFieldAsJSON(this.GetFieldByName(string));
    }

    public String GetFieldAsJSON(int n) throws CTException {
        return ctdb.GetFieldAsJSON(this.m_handle, n);
    }

    public void SetFieldAsBoolean(String string, Boolean bl) throws CTException {
        this.SetFieldAsBoolean(this.GetFieldByName(string), bl);
    }

    public void SetFieldAsBoolean(int n, Boolean bl) throws CTException {
        int n2 = ctdb.SetFieldAsBoolean(this.m_handle, n, bl);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field data");
        }
    }

    public void SetFieldAsLong(String string, Long l) throws CTException {
        this.SetFieldAsLong(this.GetFieldByName(string), l);
    }

    public void SetFieldAsLong(int n, Long l) throws CTException {
        int n2 = ctdb.SetFieldAsLong(this.m_handle, n, l);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field");
        }
    }

    public void SetFieldAsBigDecimal(String string, BigDecimal bigDecimal) throws CTException {
        this.SetFieldAsBigDecimal(this.GetFieldByName(string), bigDecimal);
    }

    public void SetFieldAsBigDecimal(int n, BigDecimal bigDecimal) throws CTException {
        int n2 = ctdb.SetFieldAsBigDecimal(this.m_handle, n, bigDecimal);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set number field");
        }
    }

    public void SetFieldAsBytes(String string, byte[] byArray) throws CTException {
        this.SetFieldAsBytes(this.GetFieldByName(string), byArray);
    }

    public void SetFieldAsBytes(int n, byte[] byArray) throws CTException {
        int n2 = ctdb.SetFieldAsBytes(this.m_handle, n, byArray);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field");
        }
    }

    public void SetFieldAsString(String string, String string2) throws CTException {
        this.SetFieldAsString(this.GetFieldByName(string), string2);
    }

    public void SetFieldAsString(int n, String string) throws CTException {
        int n2 = ctdb.SetFieldAsString(this.m_handle, n, string);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field data");
        }
    }

    public void SetFieldAsJSON(int n, String string) throws CTException {
        int n2 = ctdb.SetFieldAsJSON(this.m_handle, n, string);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field data as JSON");
        }
    }

    public void SetFieldAsJSON(String string, String string2) throws CTException {
        this.SetFieldAsJSON(this.GetFieldByName(string), string2);
    }

    public void SetFieldAsInt(String string, Integer n) throws CTException {
        this.SetFieldAsInt(this.GetFieldByName(string), n);
    }

    public void SetFieldAsInt(int n, Integer n2) throws CTException {
        int n3 = ctdb.SetFieldAsInt(this.m_handle, n, n2);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Can't set field data");
        }
    }

    public void SetFieldAsDouble(String string, Double d) throws CTException {
        this.SetFieldAsDouble(this.GetFieldByName(string), d);
    }

    public void SetFieldAsDouble(int n, Double d) throws CTException {
        int n2 = ctdb.SetFieldAsDouble(this.m_handle, n, d);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field data");
        }
    }

    public void SetFieldAsFloat(String string, Float f) throws CTException {
        this.SetFieldAsFloat(this.GetFieldByName(string), f);
    }

    public void SetFieldAsFloat(int n, Float f) throws CTException {
        int n2 = ctdb.SetFieldAsFloat(this.m_handle, n, f);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field data");
        }
    }

    public void SetFieldAsCalendar(String string, Calendar calendar) throws CTException {
        this.SetFieldAsCalendar(this.GetFieldByName(string), calendar);
    }

    public void SetFieldAsCalendar(int n, Calendar calendar) throws CTException {
        int n2 = ctdb.SetFieldAsCalendar(this.m_handle, n, calendar);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set field data");
        }
    }

    public int GetFieldByName(String string) throws CTException {
        int n = ctdb.GetFieldNumberByName(this.m_handle, string);
        if (n < CTDBRET.OK.getErrno()) {
            throw new CTException(CTDBRET.NOSUCHFIELD.getErrno(), "No such field");
        }
        return n;
    }

    public BigDecimal GetFieldAsBigDecimal(String string) throws CTException {
        return this.GetFieldAsBigDecimal(this.GetFieldByName(string));
    }

    public BigDecimal GetFieldAsBigDecimal(int n) throws CTException {
        return ctdb.GetFieldAsBigDecimal(this.m_handle, n);
    }

    public Boolean GetFieldAsBoolean(String string) throws CTException {
        return this.GetFieldAsBoolean(this.GetFieldByName(string));
    }

    public Boolean GetFieldAsBoolean(int n) throws CTException {
        return ctdb.GetFieldAsBoolean(this.m_handle, n);
    }

    public byte[] GetFieldAsBytes(String string) throws CTException {
        return this.GetFieldAsBytes(this.GetFieldByName(string));
    }

    public byte[] GetFieldAsBytes(int n) throws CTException {
        return ctdb.GetFieldAsBytes(this.m_handle, n);
    }

    public byte[] GetRecordBuffer() throws CTException {
        return ctdb.GetRecordBuffer(this.m_handle);
    }

    public void SetRecordBuffer(byte[] byArray) throws CTException {
        int n = ctdb.SetRecordBuffer(this.m_handle, byArray);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot set record buffer");
        }
    }

    public Calendar GetFieldAsCalendar(String string) throws CTException {
        return this.GetFieldAsCalendar(this.GetFieldByName(string));
    }

    public Calendar GetFieldAsCalendar(int n) throws CTException {
        return ctdb.GetFieldAsCalendar(this.m_handle, n);
    }

    public Double GetFieldAsDouble(String string) throws CTException {
        return this.GetFieldAsDouble(this.GetFieldByName(string));
    }

    public Double GetFieldAsDouble(int n) throws CTException {
        return ctdb.GetFieldAsDouble(this.m_handle, n);
    }

    public Float GetFieldAsFloat(String string) throws CTException {
        return this.GetFieldAsFloat(this.GetFieldByName(string));
    }

    public Float GetFieldAsFloat(int n) throws CTException {
        return ctdb.GetFieldAsFloat(this.m_handle, n);
    }

    public Integer GetFieldAsInt(String string) throws CTException {
        return this.GetFieldAsInt(this.GetFieldByName(string));
    }

    public Integer GetFieldAsInt(int n) throws CTException {
        return ctdb.GetFieldAsInt(this.m_handle, n);
    }

    public Long GetFieldAsLong(String string) throws CTException {
        return this.GetFieldAsLong(this.GetFieldByName(string));
    }

    public Long GetFieldAsLong(int n) throws CTException {
        return ctdb.GetFieldAsLong(this.m_handle, n);
    }

    public long GetRecordCount() throws CTException {
        return ctdb.GetRecordCount(this.m_handle);
    }

    public void RecordSetOn(int n) throws CTException {
        int n2 = ctdb.RecordSetOn(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't activate the record set");
        }
    }

    public void RecordSetOff() throws CTException {
        int n = ctdb.RecordSetOff(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't deactivate the record set");
        }
    }

    public void Reset() throws CTException {
        int n = ctdb.ResetRecord(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't reset record buffer");
        }
    }

    public boolean IsVariableField(String string) throws CTException {
        return this.IsVariableField(this.GetFieldByName(string));
    }

    public boolean IsVariableField(int n) {
        return ctdb.IsVariableField(this.m_handle, n);
    }

    public int GetFieldLength(String string) throws CTException {
        return this.GetFieldLength(this.GetFieldByName(string));
    }

    public int GetFieldLength(int n) {
        return ctdb.GetFieldDataLength(this.m_handle, n);
    }

    public int GetFieldSize(String string) throws CTException {
        return this.GetFieldSize(this.GetFieldByName(string));
    }

    public int GetFieldSize(int n) {
        return ctdb.GetFieldSize(this.m_handle, n);
    }

    public int GetFieldOffset(String string) throws CTException {
        return this.GetFieldOffset(this.GetFieldByName(string));
    }

    public int GetFieldOffset(int n) {
        return ctdb.GetFieldOffset(this.m_handle, n);
    }

    public void ClearField(String string) throws CTException {
        this.ClearField(this.GetFieldByName(string));
    }

    public void ClearField(int n) throws CTException {
        int n2 = ctdb.ClearField(this.m_handle, n);
        if (n2 != 0) {
            throw new CTException(n2, "Can't clear field");
        }
    }

    public void UnlockRecord() throws CTException {
        int n = ctdb.UnlockRecord(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "UnlockRecord failed");
        }
    }

    public long GetRowid() throws CTException {
        return ctdb.GetRowid(this.m_handle);
    }

    public boolean FindRowid(long l, int n) throws CTException {
        boolean bl = true;
        int n2 = ctdb.FindRowid(this.m_handle, l, n);
        if (n2 == 101) {
            bl = false;
        } else if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "FindRowid failed");
        }
        return bl;
    }

    public void CndxCompile(String string) throws CTException {
        int n = ctdb.CndxCompile(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "CndxCompile failed");
        }
    }

    public boolean CndxEval() throws CTException {
        boolean bl;
        int n = ctdb.CndxEval(this.m_handle);
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n == CTDBRET.CNDXFALSE.getErrno()) {
            bl = false;
        } else {
            throw new CTException(n, "CndxEval failed");
        }
        return bl;
    }

    public void CndxFree() {
        ctdb.CndxFree(this.m_handle);
    }

    public String CndxGetExpression() throws CTException {
        String string = ctdb.CndxGetExpression(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (string == null) {
            throw new CTException(CTDBRET.NULARG.getErrno(), "Conditional Expression not set");
        }
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot retrieve Conditional Expression");
        }
        return string;
    }

    public boolean Compare(CTRecord cTRecord) throws CTException {
        boolean bl = false;
        int n = CTDBRET.OK.getErrno();
        n = ctdb.CompareRecords(this.m_handle, cTRecord.m_handle);
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n == CTDBRET.DIFFERENT.getErrno()) {
            bl = false;
        } else {
            throw new CTException(n, "Cannot compare records");
        }
        return bl;
    }

    public boolean IsRecordSetOn() {
        return ctdb.IsRecordSetOn(this.m_handle);
    }

    public void SetFilter(String string) throws CTException {
        int n = ctdb.FilterRecord(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cant set filter");
        }
    }

    public boolean IsFiltered() {
        return ctdb.IsFilteredRecord(this.m_handle);
    }

    public String GetFilter() {
        return ctdb.GetFilter(this.m_handle);
    }

    public int BatchLoaded() {
        return ctdb.BatchLoaded(this.m_handle);
    }

    public int BatchLocked() {
        return ctdb.BatchLocked(this.m_handle);
    }

    public int BatchTotal() {
        return ctdb.BatchTotal(this.m_handle);
    }

    public int BatchMode() {
        return ctdb.BatchMode(this.m_handle);
    }

    public boolean IsBatchActive() {
        return ctdb.IsBatchActive(this.m_handle);
    }

    public void EndBatch() throws CTException {
        int n = ctdb.EndBatch(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "CTRecord.EndBatch failed");
        }
    }

    public void InsertBatch() throws CTException {
        int n = ctdb.InsertBatch(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "CTRecord.InsertBatch failed");
        }
    }

    public void NextBatch() throws CTException {
        int n = ctdb.NextBatch(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "CTRecord.NextBatch failed");
        }
    }

    public boolean NextInBatch() throws CTException {
        int n = ctdb.NextBatch(this.m_handle);
        boolean bl = false;
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 428) {
            throw new CTException(n, "CTRecord.NextInBatch failed");
        }
        return bl;
    }

    public void SetBatch(int n) throws CTException {
        this.SetBatch(n, 0, 0);
    }

    public void SetBatch(int n, int n2, int n3) throws CTException {
        int n4 = ctdb.SetBatch(this.m_handle, n, n2, n3);
        if (n4 != CTDBRET.OK.getErrno()) {
            throw new CTException(n4, "CTRecord.SetBatch failed");
        }
    }

    public long GetRecordKeyPos() throws CTException {
        long l = ctdb.GetRecordKeyPos(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't retrieve record position");
        }
        return l;
    }

    public long GetRecordPosAtOffset(long l) throws CTException {
        long l2 = ctdb.GetRecordPosAtOffset(this.m_handle, l);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't retrieve record offset");
        }
        return l2;
    }

    public boolean JumpTo(int n) throws CTException {
        int n2 = ctdb.JumpToRecord(this.m_handle, n);
        boolean bl = false;
        if (n2 == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n2 != 101) {
            throw new CTException(n2, "Can't jump to requested record");
        }
        return bl;
    }

    public CTResultSet GetActiveResultSet() {
        CTHANDLE cTHANDLE = ctdb.GetActiveResultSet(this.m_handle);
        CTResultSet cTResultSet = null;
        try {
            if (cTHANDLE != null) {
                cTResultSet = new CTResultSet(this.parent);
                cTResultSet.m_handle = cTHANDLE;
            }
        }
        catch (CTException cTException) {
            Logger.getLogger(CTRecord.class.getName()).log(Level.SEVERE, null, cTException);
        }
        return cTResultSet;
    }

    public int GetRecordLock() {
        return ctdb.GetRecordLock(this.m_handle);
    }

    public void SetDefaultFullTextIndex(int n) throws CTException {
        int n2 = ctdb.SetDefaultFTI(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the default Full Text index");
        }
    }

    public void FullTextSearchOn(String string) throws CTException {
        int n = ctdb.FTSearchOn(this.m_handle, string, 0);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set Full Text Search criteria");
        }
    }

    public boolean IsFullTextSearchOn() {
        return ctdb.IsFTSearchOn(this.m_handle);
    }

    public void FullTextSearchOff() throws CTException {
        int n = ctdb.FTSearchOff(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't turn off Full Text Search criteria");
        }
    }

    public FTS_ERROR_DETAIL GetFullTextSearchErrorDetails() throws CTException {
        int[] nArray = ctdb.GetFTSErrorDetails(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't retrieve Full Text Search detailed error");
        }
        return new FTS_ERROR_DETAIL(nArray[0], nArray[1]);
    }

    public boolean FindTarget(byte[] byArray, int n) throws CTException {
        boolean bl = false;
        CTHANDLE cTHANDLE = ctdb.GetIndex(this.m_handle, ctdb.GetDefaultIndex(this.m_handle));
        int n2 = ctdb.GetIndexKeyLength(cTHANDLE);
        if (byArray.length < n2) {
            throw new CTException(CTDBRET.ARGSMALL.getErrno(), "Error finding record");
        }
        int n3 = ctdb.FindTarget(this.m_handle, byArray, n);
        if (n3 == 0) {
            bl = true;
        } else if (n3 == 101) {
            bl = false;
        } else {
            throw new CTException(n3, "Error finding record");
        }
        return bl;
    }

    public byte[] BuildTargetKey(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetIndex(this.m_handle, ctdb.GetDefaultIndex(this.m_handle));
        int n2 = ctdb.GetIndexKeyLength(cTHANDLE);
        byte[] byArray = new byte[n2];
        int n3 = ctdb.BuildTargetKey(this.m_handle, byArray, n);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Error building target key");
        }
        return byArray;
    }
}

