/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTResultSetCriteria;
import FairCom.CtreeDb.CTTable;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTResultSet
extends CTBase {
    private CTTable parent = null;

    public CTResultSet(CTTable cTTable, String string) throws CTException {
        if (cTTable.m_handle == null) {
            throw new CTException(CTDBRET.NOTTABLE.getErrno(), "Invalid table handle");
        }
        this.m_handle = ctdb.AllocateResultSet(cTTable.m_handle, string);
        if (this.m_handle == null) {
            if (ctdb.GetError(cTTable.m_handle) != CTDBRET.OK.getErrno()) {
                throw new CTException(ctdb.GetError(cTTable.m_handle), "Can't allocate result set handle");
            }
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't allocate result set handle");
        }
        this.parent = cTTable;
    }

    public CTResultSet(CTTable cTTable) throws CTException {
        if (cTTable.m_handle == null) {
            throw new CTException(CTDBRET.NOTTABLE.getErrno(), "Invalid table handle");
        }
        this.parent = cTTable;
    }

    public void finalize() {
        if (this.m_handle != null) {
            try {
                ctdb.FreeResultSet(this.m_handle);
                this.m_handle = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void SetOnOff(CTRecord cTRecord, boolean bl, boolean bl2, int n) throws CTException {
        if (cTRecord.m_handle == null) {
            throw new CTException(CTDBRET.NOTRECORD.getErrno(), "Invalid record handle");
        }
        int n2 = ctdb.ResultSetOnOff(this.m_handle, cTRecord.m_handle, bl, bl2, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set result set on/off");
        }
    }

    public void AddCriteria(CTResultSetCriteria cTResultSetCriteria) throws CTException {
        if (cTResultSetCriteria.getOperator() == -1) {
            throw new CTException(CTDBRET.INVARG.getErrno(), "Invalid result set criteria handle");
        }
        cTResultSetCriteria.AddCriteria(this);
    }

    public void RemoveCriteria(CTResultSetCriteria cTResultSetCriteria) throws CTException {
        if (cTResultSetCriteria.m_handle == null) {
            throw new CTException(CTDBRET.INVARG.getErrno(), "Invalid result set criteria handle");
        }
        cTResultSetCriteria.RemoveCriteria(this);
    }
}

