/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTFullTextIndex;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.CTIndex;
import FairCom.CtreeDb.CTResultSet;
import FairCom.CtreeDb.CTSegment;
import FairCom.CtreeDb.CTSession;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTTable
extends CTBase {
    private CTBase parent = null;

    public CTTable(CTHANDLE cTHANDLE) throws CTException {
        if (cTHANDLE == null) {
            throw new CTException(CTDBRET.NULARG.getErrno(), "Invalid table handle");
        }
        this.m_handle = cTHANDLE;
        this.parent = null;
    }

    public CTTable(CTDatabase cTDatabase) throws CTException {
        this.m_handle = ctdb.AllocTable(cTDatabase.m_handle);
        if (this.m_handle == null) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't allocate table handle");
        }
        this.parent = cTDatabase;
    }

    public CTTable(CTSession cTSession) throws CTException {
        this.m_handle = ctdb.AllocTable(cTSession.m_handle);
        if (this.m_handle == null) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't allocate table handle");
        }
        this.parent = cTSession;
    }

    public void finalize() {
        if (this.m_handle != null) {
            ctdb.FreeTable(this.m_handle);
            this.m_handle = null;
        }
    }

    public void Open(String string, int n) throws CTException {
        int n2 = ctdb.OpenTable(this.m_handle, string, n);
        if (n2 != 0) {
            throw new CTException(n2, "Can't open table");
        }
    }

    public void Close() throws CTException {
        int n = ctdb.CloseTable(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't close table");
        }
    }

    public boolean IsActive() {
        return ctdb.IsActiveTable(this.m_handle);
    }

    public String GetName() throws CTException {
        String string = ctdb.GetTableName(this.m_handle);
        if (string.length() == 0) {
            throw new CTException(CTDBRET.NOTTABLE.getErrno(), "Can't get the table name");
        }
        return string;
    }

    public String GetPath() {
        return ctdb.GetTablePath(this.m_handle);
    }

    public String GetDataExtension() throws CTException {
        String string = ctdb.GetTableExtension(this.m_handle);
        if (string.length() == 0) {
            throw new CTException(CTDBRET.NOTTABLE.getErrno(), "Can't get the table data file extension");
        }
        return string;
    }

    public String GetIndexExtension() throws CTException {
        String string = ctdb.GetIndexExtension(this.m_handle);
        if (string.length() == 0) {
            throw new CTException(CTDBRET.NOTTABLE.getErrno(), "Can't get the table index file extension");
        }
        return string;
    }

    public int GetOpenMode() {
        return ctdb.GetTableOpenMode(this.m_handle);
    }

    public int GetCreateMode() {
        return ctdb.GetTableCreateMode(this.m_handle);
    }

    public int GetDataDefaultExtentSize() {
        return ctdb.GetTableDefaultDataExtentSize(this.m_handle);
    }

    public int GetIndexDefaultExtentSize() {
        return ctdb.GetTableDefaultIndexExtentSize(this.m_handle);
    }

    public String GetPassword() {
        return ctdb.GetTablePassword(this.m_handle);
    }

    public String GetGroupid() {
        return ctdb.GetTableGroupid(this.m_handle);
    }

    public int GetPermission() {
        return ctdb.GetTablePermission(this.m_handle);
    }

    public void SetPath(String string) throws CTException {
        int n = ctdb.SetTablePath(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the table path");
        }
    }

    public void SetDataExtension(String string) throws CTException {
        int n = ctdb.SetTableExtension(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the table Extension");
        }
    }

    public void SetIndexExtension(String string) throws CTException {
        int n = ctdb.SetIndexExtension(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the table index file Extension");
        }
    }

    public void SetDataDefaultExtentSize(int n) throws CTException {
        int n2 = ctdb.SetTableDefaultDataExtentSize(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the table data file default extent size");
        }
    }

    public void SetIndexDefaultExtentSize(int n) throws CTException {
        int n2 = ctdb.SetTableDefaultIndexExtentSize(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the table index file default extent size");
        }
    }

    public void SetPassword(String string) throws CTException {
        int n = ctdb.SetTablePassword(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the table password");
        }
    }

    public void SetGroupid(String string) throws CTException {
        int n = ctdb.SetTableGroupid(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the table groupid");
        }
    }

    public void SetPermission(int n) throws CTException {
        int n2 = ctdb.SetTablePermission(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the table permission mask");
        }
    }

    public void Create(String string, int n) throws CTException {
        int n2 = ctdb.CreateTable(this.m_handle, string, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't create table");
        }
    }

    public int GetFieldCount() {
        return ctdb.GetTableFieldCount(this.m_handle);
    }

    public CTField AddField(String string, int n, int n2) throws CTException {
        CTField cTField = new CTField();
        CTHANDLE cTHANDLE = ctdb.AddField(this.m_handle, string, n, n2);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't add new field to table");
        }
        cTField.m_handle = cTHANDLE;
        return cTField;
    }

    public CTField InsertField(int n, String string, int n2, int n3) throws CTException {
        CTHANDLE cTHANDLE = ctdb.InsField(this.m_handle, n, string, n2, n3);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't insert new field to table");
        }
        CTField cTField = new CTField();
        cTField.m_handle = cTHANDLE;
        return cTField;
    }

    public CTField InsertField(String string, String string2, int n, int n2) throws CTException {
        CTHANDLE cTHANDLE = ctdb.InsFieldByName(this.m_handle, string, string2, n, n2);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't insert new field to table");
        }
        CTField cTField = new CTField();
        cTField.m_handle = cTHANDLE;
        return cTField;
    }

    public void DeleteField(int n) throws CTException {
        int n2 = ctdb.DelField(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't delete field from table");
        }
    }

    public void DeleteField(String string) throws CTException {
        int n = ctdb.DelFieldByName(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't delete field from table");
        }
    }

    public void MoveField(int n, int n2) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetField(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(CTDBRET.FLDISNULL.getErrno(), "Cannot get field.");
        }
        int n3 = ctdb.MoveField(cTHANDLE, n2);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Can't move field");
        }
    }

    public void MoveField(String string, int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetFieldByName(this.m_handle, string);
        int n2 = ctdb.MoveField(cTHANDLE, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't move field");
        }
    }

    public CTField GetField(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetField(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve field");
        }
        CTField cTField = new CTField();
        cTField.m_handle = cTHANDLE;
        return cTField;
    }

    public CTField GetField(String string) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetFieldByName(this.m_handle, string);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve field");
        }
        CTField cTField = new CTField();
        cTField.m_handle = cTHANDLE;
        return cTField;
    }

    public int GetFieldNumber(String string) throws CTException {
        int n = ctdb.GetFieldNumber(this.m_handle, string);
        if (n < 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve the field number");
        }
        return n;
    }

    public int GetIndexCount() {
        return ctdb.GetTableIndexCount(this.m_handle);
    }

    public CTIndex AddIndex(String string, int n, boolean bl, boolean bl2) throws CTException {
        CTHANDLE cTHANDLE = ctdb.AddIndex(this.m_handle, string, n, bl, bl2);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't add new index to table");
        }
        CTIndex cTIndex = new CTIndex();
        cTIndex.SetHandle(cTHANDLE);
        return cTIndex;
    }

    public void AddMRTTable(CTDatabase cTDatabase, String string, String string2, int n) throws CTException {
        int n2 = ctdb.AddMRTTable(cTDatabase.GetHandle(), string, string2, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't add MRT table");
        }
    }

    public long GetVTableNumber() {
        return ctdb.GetVTableNumber(this.m_handle);
    }

    public boolean IsVTable() {
        return ctdb.IsVTable(this.m_handle);
    }

    public void RemoveVTableResource(CTTable cTTable, int n) throws CTException {
        int n2 = ctdb.RemoveVTableResource(cTTable.GetHandle(), n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't remove MRT table resource");
        }
    }

    public void SetMRTTableFilter(String string) throws CTException {
        int n = ctdb.SetMRTTableFilter(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't set MRT table filter");
        }
    }

    public void DelIndex(int n) throws CTException {
        int n2 = ctdb.DelIndex(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't delete index");
        }
    }

    public void DelIndex(String string) throws CTException {
        int n = ctdb.GetIndexNbrByName(this.m_handle, string);
        if (n < 0) {
            throw new CTException(CTDBRET.NOSUCHINDEX.getErrno(), "Can't delete index");
        }
        this.DelIndex(n);
    }

    public CTIndex GetIndex(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetIndex(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve index");
        }
        CTIndex cTIndex = new CTIndex();
        cTIndex.SetHandle(cTHANDLE);
        return cTIndex;
    }

    public CTIndex GetIndex(String string) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetIndexByName(this.m_handle, string);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve index");
        }
        CTIndex cTIndex = new CTIndex();
        cTIndex.m_handle = cTHANDLE;
        return cTIndex;
    }

    public CTSegment AddSegment(CTIndex cTIndex, CTField cTField, int n) throws CTException {
        return cTIndex.AddSegment(cTField, n);
    }

    public CTSegment AddSegment(CTIndex cTIndex, String string, int n) throws CTException {
        CTField cTField = this.GetField(string);
        return this.AddSegment(cTIndex, cTField, n);
    }

    public CTSegment AddSegment(CTIndex cTIndex, int n, int n2) throws CTException {
        CTField cTField = this.GetField(n);
        return this.AddSegment(cTIndex, cTField, n2);
    }

    public CTSegment AddSegment(CTIndex cTIndex, int n, int n2, int n3) throws CTException {
        return cTIndex.AddSegment(n, n2, n3);
    }

    public CTSegment AddSegment(int n, int n2, int n3) throws CTException {
        return this.AddSegment(this.GetIndex(n), this.GetField(n2), n3);
    }

    public CTSegment AddSegment(int n, String string, int n2) throws CTException {
        return this.AddSegment(this.GetIndex(n), this.GetField(string), n2);
    }

    public CTSegment AddSegment(int n, CTField cTField, int n2) throws CTException {
        return this.AddSegment(this.GetIndex(n), cTField, n2);
    }

    public CTSegment AddSegment(String string, String string2, int n) throws CTException {
        return this.AddSegment(this.GetIndex(string), this.GetField(string2), n);
    }

    public CTSegment AddSegment(String string, int n, int n2) throws CTException {
        return this.AddSegment(this.GetIndex(string), this.GetField(n), n2);
    }

    public CTSegment AddSegment(String string, CTField cTField, int n) throws CTException {
        return this.AddSegment(this.GetIndex(string), cTField, n);
    }

    public CTSegment InsertSegment(CTIndex cTIndex, int n, CTField cTField, int n2) throws CTException {
        return cTIndex.InsertSegment(n, cTField, n2);
    }

    public CTSegment InsertSegment(CTIndex cTIndex, int n, String string, int n2) throws CTException {
        CTField cTField = this.GetField(string);
        return this.InsertSegment(cTIndex, n, cTField, n2);
    }

    public CTSegment InsertSegment(CTIndex cTIndex, int n, int n2, int n3) throws CTException {
        CTField cTField = this.GetField(n2);
        return this.InsertSegment(cTIndex, n, cTField, n3);
    }

    public CTSegment InsertSegment(CTIndex cTIndex, int n, int n2, int n3, int n4) throws CTException {
        return cTIndex.InsertSegment(n, n2, n3, n4);
    }

    public CTSegment InsertSegment(int n, int n2, int n3, int n4) throws CTException {
        return this.InsertSegment(this.GetIndex(n), n2, this.GetField(n3), n4);
    }

    public CTSegment InsertSegment(int n, int n2, String string, int n3) throws CTException {
        return this.InsertSegment(this.GetIndex(n), n2, this.GetField(string), n3);
    }

    public CTSegment InsertSegment(String string, int n, String string2, int n2) throws CTException {
        return this.InsertSegment(this.GetIndex(string), n, this.GetField(string2), n2);
    }

    public CTSegment InsertSegment(String string, int n, int n2, int n3) throws CTException {
        return this.InsertSegment(this.GetIndex(string), n, this.GetField(n2), n3);
    }

    public CTSegment InsertSegment(String string, int n, CTField cTField, int n2) throws CTException {
        return this.InsertSegment(this.GetIndex(string), n, cTField, n2);
    }

    public CTSegment InsertSegment(int n, int n2, CTField cTField, int n3) throws CTException {
        return this.InsertSegment(this.GetIndex(n), n2, cTField, n3);
    }

    public void DelSegment(int n, int n2) throws CTException {
        CTIndex cTIndex = this.GetIndex(n);
        cTIndex.DelSegment(n2);
    }

    public void DelSegment(String string, int n) throws CTException {
        this.GetIndex(string).DelSegment(n);
    }

    public CTSegment GetSegment(CTIndex cTIndex, int n) throws CTException {
        return cTIndex.GetSegment(n);
    }

    public void Alter(int n) throws CTException {
        int n2 = ctdb.AlterTable(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't alter table");
        }
    }

    public void ResetAll() throws CTException {
        int n = ctdb.ResetAll(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Reset all record buffers failed");
        }
    }

    public boolean HasNullFieldSupport() {
        return ctdb.HasNullFieldSupport(this.m_handle);
    }

    public CTIndex GetIndexByUID(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetIndexByUID(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve index");
        }
        CTIndex cTIndex = new CTIndex();
        cTIndex.SetHandle(cTHANDLE);
        return cTIndex;
    }

    public boolean HasRecbyt() {
        return ctdb.HasRecbyt(this.m_handle);
    }

    public boolean HasRowid() {
        return ctdb.HasRowid(this.m_handle);
    }

    public void UnlockTable() throws CTException {
        int n = ctdb.UnlockTable(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't release table record locks");
        }
    }

    public void UpdateCndxIndex(int n, String string) throws CTException {
        int n2 = ctdb.UpdateCndxIndex(this.m_handle, n, string);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "UpdateCndxIndex failed");
        }
    }

    public void UpdateCndxIndex(String string, String string2) throws CTException {
        int n = ctdb.UpdateCndxIndexByName(this.m_handle, string, string2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "UpdateCndxIndex failed");
        }
    }

    public String GetCndxIndex(int n) throws CTException {
        String string = ctdb.GetCndxIndex(this.m_handle, n);
        int n2 = ctdb.GetError(this.m_handle);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "GetCndxIndex failed");
        }
        return string;
    }

    public String GetCndxIndex(String string) throws CTException {
        String string2 = ctdb.GetCndxIndexByName(this.m_handle, string);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "GetCndxIndex failed");
        }
        return string2;
    }

    public void FilterRecord(String string) throws CTException {
        int n = ctdb.FilterRecord(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "FilterRecord failed");
        }
    }

    public boolean IsFilteredRecord() throws CTException {
        return ctdb.IsFilteredRecord(this.m_handle);
    }

    public String GetFilter() throws CTException {
        return ctdb.GetFilter(this.m_handle);
    }

    public void UpdateCreateMode(int n) throws CTException {
        int n2 = ctdb.UpdateCreateMode(this.m_handle, n);
        if (n2 != 0) {
            throw new CTException(n2, "UpdateCreateMode failed");
        }
    }

    public char GetPadChar() throws CTException {
        return ctdb.GetPadChar(this.m_handle);
    }

    public char GetDlmChar() throws CTException {
        return ctdb.GetDlmChar(this.m_handle);
    }

    public void SetPadChar(char c, char c2) throws CTException {
        int n = ctdb.SetPadChar(this.m_handle, c, c2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "SetPadChar failed");
        }
    }

    public void UpdatePadChar(char c, char c2, boolean bl) throws CTException {
        int n = ctdb.UpdatePadChar(this.m_handle, c, c2, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "UpdatePadChar failed");
        }
    }

    public boolean HasDelField() {
        return ctdb.HasDelField(this.m_handle);
    }

    public void SetIndexFilename(int n, String string, String string2) throws CTException {
        CTIndex cTIndex = this.GetIndex(n);
        cTIndex.SetFilename(string, string2);
    }

    public void SetIndexFilename(String string, String string2, String string3) throws CTException {
        CTIndex cTIndex = this.GetIndex(string);
        cTIndex.SetFilename(string2, string3);
    }

    public String GetIndexFilename(int n) throws CTException {
        CTIndex cTIndex = this.GetIndex(n);
        return cTIndex.GetFilename();
    }

    public String GetIndexFilename(String string) throws CTException {
        CTIndex cTIndex = this.GetIndex(string);
        return cTIndex.GetFilename();
    }

    public int GetDatno() throws CTException {
        int n = ctdb.GetDatno(this.m_handle);
        if (n < 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "can't retrieve datno");
        }
        return n;
    }

    public int GetIdxno(int n) throws CTException {
        int n2 = ctdb.GetIdxnoByNumber(this.m_handle, n);
        if (n2 < 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "can't retrieve idxno");
        }
        return n2;
    }

    public int GetIdxno(String string) throws CTException {
        int n = ctdb.GetIdxnoByName(this.m_handle, string);
        if (n < 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "can't retrieve idxno");
        }
        return n;
    }

    public void Remove() throws CTException {
        int n = ctdb.RemoveTable(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "can't remove table");
        }
    }

    public void ClearAllFieldDefaultValue() throws CTException {
        int n = ctdb.ClearAllFieldDefaultValue(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't clear all field default value");
        }
    }

    public int GetStatus() {
        return ctdb.GetTableStatus(this.m_handle);
    }

    public String GetOwner() {
        return ctdb.GetTableOwner(this.m_handle);
    }

    public void SetOwner(String string) throws CTException {
        int n = string == null || string.length() == 0 ? ctdb.SetTableOwner(this.m_handle, null) : ctdb.SetTableOwner(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set table owner");
        }
    }

    public void Rebuild(int n) throws CTException {
        int n2 = ctdb.RebuildTable(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't rebuild table");
        }
    }

    public void Compact() throws CTException {
        this.Rebuild(8);
    }

    public void Attach(int n) throws CTException {
        int n2 = ctdb.AttachTable(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't attach table");
        }
    }

    public void Detach() throws CTException {
        int n = ctdb.DetachTable(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't detach table");
        }
    }

    public void MoveSegment(CTIndex cTIndex, int n, int n2) throws CTException {
        cTIndex.MoveSegment(n, n2);
    }

    public void MoveSegment(int n, int n2, int n3) throws CTException {
        CTIndex cTIndex = this.GetIndex(n);
        cTIndex.MoveSegment(n2, n3);
    }

    public void MoveSegment(String string, int n, int n2) throws CTException {
        CTIndex cTIndex = this.GetIndex(string);
        cTIndex.MoveSegment(n, n2);
    }

    public int PartAdminByName(String string, int n) throws CTException {
        int n2 = 0;
        int n3 = ctdb.PartAdminByName(this.m_handle, string, n, n2);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Can't perform partition admin");
        }
        if ((n & 0x800) == 2048) {
            return n2;
        }
        return 0;
    }

    public int PartAdminByNumber(int n, int n2) throws CTException {
        int n3 = 0;
        int n4 = ctdb.PartAdminByNumber(this.m_handle, n, n2, n3);
        if (n4 != CTDBRET.OK.getErrno()) {
            throw new CTException(n4, "Can't perform partition admin");
        }
        if ((n2 & 0x800) == 2048) {
            return n3;
        }
        return 0;
    }

    public void SetIdentityField(String string, long l, long l2) throws CTException {
        int n = ctdb.SetIdentityField(this.m_handle, string, l, l2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the field as identity");
        }
    }

    public long NumberOfKeyEntries(int n) throws CTException {
        long l = ctdb.NumberOfKeyEntries(this.m_handle, n);
        if (l < 0L) {
            throw new CTException(ctdb.GetError(this.m_handle), "NumberOfKeyEntries failed");
        }
        return l;
    }

    public long NumberOfKeyEntries(String string) throws CTException {
        return this.NumberOfKeyEntries(ctdb.GetIndexNbrByName(this.m_handle, string));
    }

    public String GetIdentityField() {
        return ctdb.GetIdentityField(this.m_handle);
    }

    public long GetIdentityFieldSeed() throws CTException {
        long l = ctdb.GetIdentityFieldSeed(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot get identity field seed.");
        }
        return l;
    }

    public long GetIdentityFieldIncrement() throws CTException {
        long l = ctdb.GetIdentityFieldIncrement(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot get identity field increment.");
        }
        return l;
    }

    public long GetLastIdentity() throws CTException {
        long l = ctdb.GetLastIdentity(this.m_handle);
        int n = ctdb.GetError(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot get identity value.");
        }
        return l;
    }

    public int GetBinaryFlag(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetField(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve field");
        }
        return ctdb.GetFieldBinaryFlag(cTHANDLE);
    }

    public int GetBinaryFlag(String string) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetFieldByName(this.m_handle, string);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve field");
        }
        return ctdb.GetFieldBinaryFlag(cTHANDLE);
    }

    public void SetBinaryFlag(int n, int n2) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetField(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve field");
        }
        ctdb.SetFieldBinaryFlag(cTHANDLE, n2);
    }

    public void SetBinaryFlag(String string, int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetFieldByName(this.m_handle, string);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve field");
        }
        ctdb.SetFieldBinaryFlag(cTHANDLE, n);
    }

    public void Clone(CTTable cTTable, String string) throws CTException {
        int n = ctdb.CloneTable(cTTable.GetHandle(), string, this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't clone table");
        }
    }

    public CTResultSet CreateResultSet(String string) throws CTException {
        return new CTResultSet(this, string);
    }

    public void CreateMRTTable(String string, String string2, int n, String string3) throws CTException {
        int n2 = ctdb.CreateMRTTable(this.m_handle, string, string2, n, string3);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't create MRT table");
        }
    }

    public CTResultSet GetResultSetByName(String string) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetResultSetByName(this.m_handle, string);
        if (cTHANDLE == null) {
            throw new CTException(CTDBRET.NULHANDLE.getErrno(), "Can't retrieve result set by name");
        }
        CTResultSet cTResultSet = new CTResultSet(this);
        cTResultSet.m_handle = cTHANDLE;
        return cTResultSet;
    }

    public CTFullTextIndex AddFullTextIndex(String string) throws CTException {
        CTFullTextIndex cTFullTextIndex = new CTFullTextIndex();
        CTHANDLE cTHANDLE = ctdb.AddFTI(this.m_handle, string);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't add new index to table");
        }
        cTFullTextIndex.SetHandle(cTHANDLE);
        return cTFullTextIndex;
    }

    public void DelFullTextIndex(int n) throws CTException {
        int n2 = ctdb.DelFTI(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't delete index");
        }
    }

    public void DelFullTextIndex(String string) throws CTException {
        int n = ctdb.GetFTINbrByName(this.m_handle, string);
        if (n < 0) {
            throw new CTException(CTDBRET.NOSUCHINDEX.getErrno(), "Can't delete index");
        }
        this.DelFullTextIndex(n);
    }

    public CTFullTextIndex GetFullTextIndex(int n) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetFTI(this.m_handle, n);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve index");
        }
        CTFullTextIndex cTFullTextIndex = new CTFullTextIndex();
        cTFullTextIndex.SetHandle(cTHANDLE);
        return cTFullTextIndex;
    }

    public CTFullTextIndex GetFullTextIndex(String string) throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetFTIByName(this.m_handle, string);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve index");
        }
        CTFullTextIndex cTFullTextIndex = new CTFullTextIndex();
        cTFullTextIndex.SetHandle(cTHANDLE);
        return cTFullTextIndex;
    }

    public int GetFullTextIndexCount() {
        return ctdb.GetTableFTICount(this.m_handle);
    }

    public void SetFullTextIndexOption(CTFullTextIndex cTFullTextIndex, int n, String string, int n2) throws CTException {
        cTFullTextIndex.SetOption(n, string, n2);
    }

    public void SetFullTextIndexOption(int n, int n2, String string, int n3) throws CTException {
        CTFullTextIndex cTFullTextIndex = this.GetFullTextIndex(n);
        cTFullTextIndex.SetOption(n2, string, n3);
    }

    public void SetFullTextIndexOption(String string, int n, String string2, int n2) throws CTException {
        CTFullTextIndex cTFullTextIndex = this.GetFullTextIndex(string);
        cTFullTextIndex.SetOption(n, string2, n2);
    }

    public int GetPartitionIndexNbr() {
        return ctdb.GetPartitionIndexNbr(this.m_handle);
    }
}

