/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.CTJSema;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdbJNI;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

class ctdb {
    static final int invalidenv = -1;
    static final int notsrvrenv = -2;
    private static HashMap<Integer, CTJSema> ThrdsMap = new HashMap();
    private static int envOwner = -1;
    private static boolean shutdown = false;
    protected static int library = 0;
    protected static boolean libLoaded = false;
    protected static final ReentrantLock liblock = new ReentrantLock();

    ctdb() {
    }

    protected static void loadCtreeLib() throws CTException {
        liblock.lock();
        try {
            if (!libLoaded) {
                String string = null;
                switch (library) {
                    case 0: {
                        if (System.getProperty("java.vendor").toLowerCase().contains("android")) {
                            if (ctdb.class.getPackage().getName().contains("CtreeDbSrv")) {
                                library = 2;
                                string = "ctreedbs";
                                break;
                            }
                            if (ctdb.class.getPackage().getName().contains("CtreeDbSgl")) {
                                library = 3;
                                string = "ctreestd";
                                break;
                            }
                            library = 1;
                            string = "native-lib";
                            break;
                        }
                        library = 1;
                        string = "mtclijni" + System.getProperty("sun.arch.data.model");
                        break;
                    }
                    case 1: {
                        if (System.getProperty("java.vendor").toLowerCase().contains("android")) {
                            string = "native-lib";
                            break;
                        }
                        string = "mtclijni" + System.getProperty("sun.arch.data.model");
                        break;
                    }
                    case 2: {
                        string = "ctdbsjni" + System.getProperty("sun.arch.data.model");
                        break;
                    }
                    case 3: {
                        string = "ctstdjni" + System.getProperty("sun.arch.data.model");
                    }
                }
                System.loadLibrary(string);
                libLoaded = true;
            }
        }
        catch (Exception exception) {
            throw new CTException(CTDBRET.INTERNAL.getErrno(), exception.getMessage());
        }
        finally {
            liblock.unlock();
        }
    }

    static synchronized CTHANDLE AllocSession(int n) {
        long l;
        CTJSema cTJSema = null;
        if (envOwner == -1) {
            if ((ctdbJNI.GetLibType(0L) & 0x10) == 0) {
                envOwner = -2;
            } else {
                return null;
            }
        }
        if (ThrdsMap.isEmpty()) {
            int n2 = ctdbJNI.ThrdInit();
            if (n2 != 0) {
                return null;
            }
            ctdbJNI.SetOwner(-1);
        }
        if ((l = ctdbJNI.AllocSession(n)) == 0L) {
            return null;
        }
        int n3 = ctdbJNI.GetOwner();
        if (ThrdsMap.containsKey(n3)) {
            ctdbJNI.SetOwner(-1);
            return null;
        }
        cTJSema = new CTJSema(1);
        ThrdsMap.put(n3, cTJSema);
        ctdbJNI.SetOwner(-1);
        return new CTHANDLE(l, cTJSema, n3);
    }

    static synchronized void FreeSession(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1 || shutdown)) {
            return;
        }
        CTJSema cTJSema = null;
        int n = cTHANDLE.getOwner();
        cTJSema = ThrdsMap.get(n);
        ctdbJNI.FreeSession(cTHANDLE.nativeType());
        cTHANDLE.Post();
        ThrdsMap.remove(n);
        if (shutdown && ThrdsMap.size() == 0) {
            ctdbJNI.StopDatabaseEngine();
            shutdown = false;
        }
    }

    static int Logon(CTHANDLE cTHANDLE, String string, String string2, String string3) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.Logon(cTHANDLE.nativeType(), string, string2, string3);
        cTHANDLE.Post();
        return n;
    }

    static int Logoff(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.Logoff(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static boolean IsTransActive(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsTransActive(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int Begin(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.Begin(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int Commit(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.Commit(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int Abort(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.Abort(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int PrepareCommit(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.PrepareCommit(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetSavePoint(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetSavePoint(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetError(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetError(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int RestoreSavePoint(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.RestoreSavePoint(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static boolean GetAutoCommit(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetAutoCommit(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean IsLockActive(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsLockActive(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int SetAutoCommit(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetAutoCommit(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static boolean IsUnicodeLib() {
        boolean bl = ctdbJNI.IsUnicodeLib();
        return bl;
    }

    static String GetServerName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetServerName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int GetLockMode(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetLockMode(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int Lock(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.Lock(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetKeepLock(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetKeepLock(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetKeepLock(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetKeepLock(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetTransactionMode(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetTransactionMode(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetTransactionMode(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTransactionMode(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetOperationState(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetOperationState(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetOperationState(CTHANDLE cTHANDLE, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetOperationState(cTHANDLE.nativeType(), n, n2);
        cTHANDLE.Post();
        return n3;
    }

    static String GetUserLogonName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetUserLogonName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static String GetUserPassword(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetUserPassword(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int GetSessionParams(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.GetSessionParams(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetSessionParams(CTHANDLE cTHANDLE, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetSessionParams(cTHANDLE.nativeType(), n, n2);
        cTHANDLE.Post();
        return n3;
    }

    static boolean IsActiveSession(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsActiveSession(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static String GetSessionPath(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetSessionPath(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int SetSessionPath(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetSessionPath(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetLogPath(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetLogPath(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetStatusLogPath(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetStatusLogPath(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int FirstDatabase(CTHANDLE cTHANDLE, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer != null & stringBuffer2 != null) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string = ctdbJNI.FirstDatabase(cTHANDLE.nativeType());
            cTHANDLE.Post();
            if (string != null) {
                stringBuffer.replace(0, stringBuffer.length(), string);
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                string = ctdbJNI.FindDatabase(cTHANDLE.nativeType(), stringBuffer.toString());
                cTHANDLE.Post();
                if (string != null) {
                    stringBuffer2.replace(0, stringBuffer2.length(), string);
                }
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            return n;
        }
        return CTDBRET.NULARG.getErrno();
    }

    static int NextDatabase(CTHANDLE cTHANDLE, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer != null & stringBuffer2 != null) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string = ctdbJNI.NextDatabase(cTHANDLE.nativeType());
            cTHANDLE.Post();
            if (string != null) {
                stringBuffer.replace(0, stringBuffer.length(), string);
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                string = ctdbJNI.FindDatabase(cTHANDLE.nativeType(), stringBuffer.toString());
                cTHANDLE.Post();
                if (string != null) {
                    stringBuffer2.replace(0, stringBuffer2.length(), string);
                }
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            return n;
        }
        return CTDBRET.NULARG.getErrno();
    }

    static int FindDatabase(CTHANDLE cTHANDLE, String string, StringBuffer stringBuffer) {
        if (string != null & stringBuffer != null) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string2 = ctdbJNI.FindDatabase(cTHANDLE.nativeType(), string.toString());
            cTHANDLE.Post();
            if (string2 != null) {
                stringBuffer.replace(0, stringBuffer.length(), string2);
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            return n;
        }
        return CTDBRET.NULARG.getErrno();
    }

    static int CreateSession(CTHANDLE cTHANDLE, String string, String string2, String string3) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CreateSession(cTHANDLE.nativeType(), string, string2, string3);
        cTHANDLE.Post();
        return n;
    }

    static int DisconnectAll(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DisconnectAll(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int CreateDatabase(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CreateDatabase(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static int AddDatabase(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.AddDatabase(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static int DeleteDatabase(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DeleteDatabase(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int DropDatabase(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DropDatabase(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int GetDatabaseUID(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetDatabaseUID(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetSessionExclusive(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetSessionExclusive(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static boolean IsSessionExclusive(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsSessionExclusive(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean IsSQLServer(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsSQLServer(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int SetLogonOnly(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetLogonOnly(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static boolean GetLogonOnly(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetLogonOnly(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int GetAttachMode(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetAttachMode(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetDatabaseCount(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetDatabaseCount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetSessionType(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetSessionType(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static void SetSessionId(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return;
        }
        ctdbJNI.SetSessionId(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
    }

    static int GetSessionId(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetSessionId(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetSessionType(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetSessionType(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetLibType(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetLibType(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetConfigurationFile(String string) {
        return ctdbJNI.SetConfigurationFile(string);
    }

    static int SetCurrentNodeName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetCurrentNodeName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetPathPrefix(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetPathPrefix(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int ClearPathPrefix(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ClearPathPrefix(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetPathPrefix(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetPathPrefix(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int AttachSession(CTHANDLE cTHANDLE, int n, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.AttachSession(cTHANDLE.nativeType(), 0L, n, bl);
        cTHANDLE.Post();
        return n2;
    }

    static int AttachSession(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2, int n, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.AttachSession(cTHANDLE.nativeType(), cTHANDLE2.nativeType(), n, bl);
        cTHANDLE.Post();
        return n2;
    }

    static int DetachSession(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DetachSession(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static synchronized int StartDatabaseEngine() {
        if (envOwner == -1 && ThrdsMap.isEmpty()) {
            if ((ctdbJNI.GetLibType(0L) & 0x10) == 0) {
                envOwner = -2;
                return 0;
            }
            CTJSema cTJSema = null;
            int n = ctdbJNI.StartDatabaseEngine();
            if (n == 0) {
                int n2;
                envOwner = n2 = ctdbJNI.GetOwner();
                cTJSema = new CTJSema(1);
                ThrdsMap.put(n2, cTJSema);
                ctdbJNI.SetOwner(-1);
                Runtime.getRuntime().addShutdownHook(new Thread("jtdb-srvShutdownHook"){

                    @Override
                    public void run() {
                        ctdb.StopDatabaseEngine(true);
                    }
                });
            }
            return n;
        }
        return 125;
    }

    private static synchronized void StopDatabaseEngine(boolean bl) {
        if (envOwner != -2) {
            if (bl) {
                if (envOwner != -1 || shutdown) {
                    ThrdsMap.clear();
                    ctdbJNI.StopDatabaseEngine();
                    shutdown = false;
                }
                return;
            }
            if (envOwner != -1) {
                CTJSema cTJSema = null;
                cTJSema = ThrdsMap.get(envOwner);
                try {
                    cTJSema.acquire();
                    ctdbJNI.SetOwner(envOwner);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ThrdsMap.remove(envOwner);
                if (ThrdsMap.size() == 0) {
                    ctdbJNI.StopDatabaseEngine();
                }
                shutdown = true;
                envOwner = -1;
                cTJSema.release();
                ctdbJNI.SetOwner(-1);
            }
        }
    }

    static void StopDatabaseEngine() {
        ctdb.StopDatabaseEngine(false);
    }

    static CTHANDLE AllocRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AllocRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE DuplicateRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.DuplicateRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static void FreeRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1 || shutdown)) {
            return;
        }
        ctdbJNI.FreeRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
    }

    static int FirstRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.FirstRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int LastRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.LastRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int NextRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.NextRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int PrevRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.PrevRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int ClearRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ClearRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetFieldNumberByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldNumberByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE AllocTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AllocTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static void FreeTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return;
        }
        ctdbJNI.FreeTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
    }

    static int OpenTable(CTHANDLE cTHANDLE, String string, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.OpenTable(cTHANDLE.nativeType(), string, n);
        cTHANDLE.Post();
        return n2;
    }

    static int CloseTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CloseTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static boolean IsActiveTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsActiveTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static CTHANDLE AllocDatabase(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AllocDatabase(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static void FreeDatabase(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1 || shutdown)) {
            return;
        }
        ctdbJNI.FreeDatabase(cTHANDLE.nativeType());
        cTHANDLE.Post();
    }

    static int Connect(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.Connect(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int Disconnect(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.Disconnect(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetFieldAsString(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetFieldAsString(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value");
        }
        return string;
    }

    static String GetFieldAsJSON(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetFieldAsJSON(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value as JSON");
        }
        return string;
    }

    static int GetFieldDataLength(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.GetFieldDataLength(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsBoolean(CTHANDLE cTHANDLE, int n, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, bl);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsString(CTHANDLE cTHANDLE, int n, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, string);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsJSON(CTHANDLE cTHANDLE, int n, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldAsJSON(cTHANDLE.nativeType(), n, string);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsLong(CTHANDLE cTHANDLE, int n, long l) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, l);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsInt(CTHANDLE cTHANDLE, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, n2);
        cTHANDLE.Post();
        return n3;
    }

    static int SetFieldAsDouble(CTHANDLE cTHANDLE, int n, double d) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, d);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsBytes(CTHANDLE cTHANDLE, int n, byte[] byArray) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, byArray);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsCalendar(CTHANDLE cTHANDLE, int n, Calendar calendar) throws CTException {
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        CTHANDLE cTHANDLE2 = ctdb.GetField(cTHANDLE, n);
        if (cTHANDLE2 == null) {
            throw new CTException(CTDBRET.FLDISNULL.getErrno(), "Cannot get field.");
        }
        switch (ctdb.GetFieldType(cTHANDLE2)) {
            case 75: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                d = ctdbJNI.DatePack(cTHANDLE.nativeType(), calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (n2 != 0) {
                    throw new CTException(n2, "Cannot pack date");
                }
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                n3 = ctdbJNI.SetFieldAsDate(cTHANDLE.nativeType(), n, (long)d);
                cTHANDLE.Post();
                break;
            }
            case 83: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                d = ctdbJNI.TimePack(cTHANDLE.nativeType(), calendar.get(11), calendar.get(12), calendar.get(13));
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (n2 != 0) {
                    throw new CTException(n2, "Cannot pack time");
                }
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                n3 = ctdbJNI.SetFieldAsTime(cTHANDLE.nativeType(), n, (long)d);
                cTHANDLE.Post();
                break;
            }
            case 124: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                d = ctdbJNI.DateTimePack(cTHANDLE.nativeType(), calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (n2 != 0) {
                    throw new CTException(n2, "Cannot pack datetime");
                }
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                n3 = ctdbJNI.SetFieldAsDateTime(cTHANDLE.nativeType(), n, d);
                cTHANDLE.Post();
                break;
            }
            case 258: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                d = ctdbJNI.TimePackMsec(cTHANDLE.nativeType(), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (n2 != 0) {
                    throw new CTException(n2, "Cannot pack datetime");
                }
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                n3 = ctdbJNI.SetFieldAsTimeMsec(cTHANDLE.nativeType(), n, (long)d);
                cTHANDLE.Post();
                break;
            }
            case 257: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                d = ctdbJNI.DateTimePackMsec(cTHANDLE.nativeType(), calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (n2 != 0) {
                    throw new CTException(n2, "Cannot pack datetime");
                }
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                n3 = ctdbJNI.SetFieldAsDateTimeMsec(cTHANDLE.nativeType(), n, d);
                cTHANDLE.Post();
            }
        }
        return n3;
    }

    static int SetFieldAsBigDecimal(CTHANDLE cTHANDLE, int n, BigDecimal bigDecimal) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, bigDecimal.toString());
        cTHANDLE.Post();
        return n2;
    }

    static BigDecimal GetFieldAsBigDecimal(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetFieldAsString(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value");
        }
        return new BigDecimal(string);
    }

    static Boolean GetFieldAsBoolean(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetFieldAsBoolean(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value");
        }
        return bl;
    }

    static byte[] GetFieldAsBytes(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        byte[] byArray = ctdbJNI.GetFieldAsBytes(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value");
        }
        return byArray;
    }

    static Calendar GetFieldAsCalendar(CTHANDLE cTHANDLE, int n) throws CTException {
        double d = 0.0;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int n2 = 0;
        CTHANDLE cTHANDLE2 = ctdb.GetField(cTHANDLE, n);
        if (cTHANDLE2 == null) {
            throw new CTException(CTDBRET.FLDISNULL.getErrno(), "Cannot get field.");
        }
        switch (ctdb.GetFieldType(cTHANDLE2)) {
            case 75: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return null;
                }
                d = ctdbJNI.GetFieldAsDate(cTHANDLE.nativeType(), n);
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (d == 0.0) {
                    return null;
                }
                if (n2 != 0) {
                    if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                        return null;
                    }
                    throw new CTException(n2, "Cannot get field value");
                }
                calendar = ctdb.DateUnpack((long)d);
                break;
            }
            case 83: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return null;
                }
                d = ctdbJNI.GetFieldAsTime(cTHANDLE.nativeType(), n);
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (n2 != 0) {
                    if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                        return null;
                    }
                    throw new CTException(n2, "Cannot get field value");
                }
                calendar = ctdb.TimeUnpack((long)d);
                break;
            }
            case 124: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return null;
                }
                d = ctdbJNI.GetFieldAsCalendar(cTHANDLE.nativeType(), n);
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (d == 0.0) {
                    return null;
                }
                if (n2 != 0) {
                    if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                        return null;
                    }
                    throw new CTException(n2, "Cannot get field value");
                }
                calendar = ctdb.DateTimeUnpack(d);
                break;
            }
            case 258: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return null;
                }
                d = ctdbJNI.GetFieldAsTimeMsec(cTHANDLE.nativeType(), n);
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (n2 != 0) {
                    if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                        return null;
                    }
                    throw new CTException(n2, "Cannot get field value");
                }
                calendar = ctdb.TimeUnpackMsec((long)d);
                break;
            }
            case 257: {
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return null;
                }
                d = ctdbJNI.GetFieldAsCalendarMsec(cTHANDLE.nativeType(), n);
                cTHANDLE.Post();
                n2 = ctdb.GetError(cTHANDLE);
                if (d == 0.0) {
                    return null;
                }
                if (n2 != 0) {
                    if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                        return null;
                    }
                    throw new CTException(n2, "Cannot get field value");
                }
                calendar = ctdb.DateTimeUnpackMsec(d);
            }
        }
        return calendar;
    }

    static Calendar GetServerDateTime(CTHANDLE cTHANDLE) throws CTException {
        double d = 0.0;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int n = 0;
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        d = ctdbJNI.GetServerDateTime(cTHANDLE.nativeType());
        cTHANDLE.Post();
        n = ctdb.GetError(cTHANDLE);
        if (n != 0) {
            throw new CTException(n, "Cannot get server date and time");
        }
        if (d == 0.0) {
            return null;
        }
        calendar = ctdb.DateTimeUnpack(d);
        return calendar;
    }

    static Calendar DateTimeUnpack(double d) throws CTException {
        int n;
        int n2;
        int n3;
        double d2 = (int)d;
        double d3 = d - d2;
        double d4 = d2 + 72987.0 + 1.0;
        if (d3 < 0.0) {
            d3 = -1.0 * d3;
        }
        if ((d2 = d3 * 86400.0) == 0.0) {
            n3 = 0;
            n2 = 0;
            n = 0;
        } else {
            d2 = d2 - (double)((long)d2) >= 0.5 ? Math.ceil(d2) : Math.floor(d2);
            d3 = d2 / 3600.0;
            n = Math.ceil(d3) - d3 < 0.0 ? (int)Math.ceil(d3) : (int)Math.floor(d3);
            d3 = (d2 -= (double)(n * 3600)) / 60.0;
            n2 = Math.ceil(d3) - d3 < 0.0 ? (int)Math.ceil(d3) : (int)Math.floor(d3);
            n3 = (int)((d2 -= (double)(n2 * 60)) + 1.0E-5);
            if (n < 0 || n > 23) {
                throw new CTException(CTDBRET.INVHOUR.getErrno(), "Invalid Hour");
            }
            if (n2 < 0 || n2 > 59) {
                throw new CTException(CTDBRET.INVMINUTE.getErrno(), "Invalid Minute");
            }
            if (n3 < 0 || n3 > 59) {
                throw new CTException(CTDBRET.INVSECOND.getErrno(), "Invalid Second");
            }
        }
        Calendar calendar = ctdb.DateUnpack((long)d4);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        return calendar;
    }

    static Calendar DateUnpack(long l) throws CTException {
        int n;
        long l2 = l;
        long l3 = 146098L;
        long l4 = 36525L;
        long l5 = 73048L;
        long l6 = 621049L;
        long l7 = 100L;
        long l8 = 10L;
        long l9 = 306L;
        int[] nArray = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (l2 == 0L) {
            throw new CTException(CTDBRET.INVDATE.getErrno(), "Invalid Date");
        }
        if (l2 >= l3) {
            long l10 = (l2 - l3) / (l4 - 1L) + 1L;
            long l11 = l10 / 4L;
            l2 += (l10 -= l11);
        } else if (l2 <= l5) {
            long l12 = (l5 - l2) / (l4 - 1L) + 1L;
            l2 -= l12;
        }
        long l13 = l2 + l6;
        int n2 = (int)(l13 * l7 / l4);
        int n3 = (int)((l13 -= l4 * (long)n2 / l7) * l8 / l9);
        if (n3 < 4) {
            l13 = l2 + l6 - l4 * (long)(n2 - 1) / l7;
            n3 = (int)(l13 * l8 / l9);
            n = (int)(l13 - l9 * (long)n3 / l8);
            n3 -= 13;
        } else {
            n = (int)(l13 - l9 * (long)n3 / l8);
            --n3;
        }
        if (n3 < 1) {
            n3 += 12;
            --n2;
        }
        if (n == 0) {
            n = nArray[--n3];
        }
        if (n == 29 && n3 == 2 && !ctdb.isLeapYear(n2)) {
            n = 28;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n2, n3 - 1, n);
        return calendar;
    }

    static boolean isLeapYear(int n) {
        if (n < 0) {
            return false;
        }
        if (n % 400 == 0) {
            return true;
        }
        if (n % 100 == 0) {
            return false;
        }
        return n % 4 == 0;
    }

    static Calendar TimeUnpack(long l) throws CTException {
        int n = (int)(l / 3600L);
        int n2 = (int)((l -= (long)(n * 3600)) / 60L);
        int n3 = (int)(l - (long)(n2 * 60));
        if (n < 0 || n > 23) {
            throw new CTException(CTDBRET.INVHOUR.getErrno(), "Invalid Hour");
        }
        if (n2 < 0 || n2 > 59) {
            throw new CTException(CTDBRET.INVMINUTE.getErrno(), "Invalid Minute");
        }
        if (n3 < 0 || n3 > 59) {
            throw new CTException(CTDBRET.INVSECOND.getErrno(), "Invalid Second");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        return calendar;
    }

    static Calendar TimeUnpackMsec(long l) throws CTException {
        int n = (int)(l / 3600000L);
        int n2 = (int)((l -= (long)(n * 3600000)) / 60000L);
        int n3 = (int)((l -= (long)(n2 * 60000)) / 1000L);
        int n4 = (int)(l - (long)(n3 * 1000));
        if (n < 0 || n > 23) {
            throw new CTException(CTDBRET.INVHOUR.getErrno(), "Invalid Hour");
        }
        if (n2 < 0 || n2 > 59) {
            throw new CTException(CTDBRET.INVMINUTE.getErrno(), "Invalid Minute");
        }
        if (n3 < 0 || n3 > 59) {
            throw new CTException(CTDBRET.INVSECOND.getErrno(), "Invalid Second");
        }
        if (n4 < 0 || n4 > 999) {
            throw new CTException(CTDBRET.INVMILLISECOND.getErrno(), "Invalid Millisecond");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4);
        return calendar;
    }

    static int GetFieldType(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldType(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static Double GetFieldAsDouble(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        double d = ctdbJNI.GetFieldAsDouble(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value");
        }
        return d;
    }

    static Integer GetFieldAsInt(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.GetFieldAsInt(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n3 = ctdb.GetError(cTHANDLE);
        if (n3 != 0) {
            if (n3 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n3, "Cannot get field value");
        }
        return n2;
    }

    static Long GetFieldAsLong(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetFieldAsLong(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value");
        }
        return l;
    }

    static int WriteRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.WriteRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int DeleteRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DeleteRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static long GetRecordCount(CTHANDLE cTHANDLE) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetRecordCount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        int n = ctdb.GetError(cTHANDLE);
        if (n != 0) {
            throw new CTException(n, "Cannot retrieve the number of records");
        }
        return l;
    }

    static int ClearField(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.ClearField(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static long GetRowid(CTHANDLE cTHANDLE) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetRowid(cTHANDLE.nativeType());
        cTHANDLE.Post();
        int n = ctdb.GetError(cTHANDLE);
        if (n != 0) {
            throw new CTException(n, "Cannot retrieve ROWID");
        }
        return l;
    }

    static int SetDefaultIndex(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetDefaultIndex(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetDefaultIndexByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetDefaultIndexByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int FindRecord(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.FindRecord(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int RecordSetOn(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.RecordSetOn(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int RecordSetOff(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.RecordSetOff(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static boolean IsRecordSetOn(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsRecordSetOn(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean IsNullField(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsNullField(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return bl;
    }

    static int ResetRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ResetRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static boolean IsVariableField(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsVariableField(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return bl;
    }

    static int GetFieldSize(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.GetFieldSize(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetFieldOffset(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.GetFieldOffset(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int FindRowid(CTHANDLE cTHANDLE, long l, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.FindRowid(cTHANDLE.nativeType(), l, n);
        cTHANDLE.Post();
        return n2;
    }

    static int JumpToRecord(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.JumpToRecord(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static boolean IsNewRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsNewRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean IsEditedRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsEditedRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int SetNewRecord(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetNewRecord(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static int SetEditedRecord(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetEditedRecord(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static int GetDefaultIndex(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetDefaultIndex(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetDefaultIndexName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetDefaultIndexName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int ReadRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ReadRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetIdentityField(CTHANDLE cTHANDLE, String string, long l, long l2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIdentityField(cTHANDLE.nativeType(), string, l, l2);
        cTHANDLE.Post();
        return n;
    }

    static int GetRecordLength(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetRecordLength(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetRecordSize(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetRecordSize(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static long GetRecordPos(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetRecordPos(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return l;
    }

    static String GetFieldName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetFieldName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int CndxCompile(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CndxCompile(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int CndxEval(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CndxEval(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int CndxFree(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CndxFree(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String CndxGetExpression(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.CndxGetExpression(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int CreateTable(CTHANDLE cTHANDLE, String string, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.CreateTable(cTHANDLE.nativeType(), string, n);
        cTHANDLE.Post();
        return n2;
    }

    static long GetVTableNumber(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetVTableNumber(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return l;
    }

    static boolean IsVTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsVTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int RemoveVTableResource(CTHANDLE cTHANDLE, long l) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.RemoveVTableResource(cTHANDLE.nativeType(), l);
        cTHANDLE.Post();
        return n;
    }

    static int CreateMRTTable(CTHANDLE cTHANDLE, String string, String string2, int n, String string3) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.CreateMRTTable(cTHANDLE.nativeType(), string, string2, n, string3);
        cTHANDLE.Post();
        return n2;
    }

    static int DelField(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.DelField(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int DelFieldByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DelFieldByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int GetTableCreateMode(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableCreateMode(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetTableDefaultDataExtentSize(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableDefaultDataExtentSize(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetTableExtension(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetTableExtension(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static String GetIndexExtension(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetIndexExtension(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int GetTableOpenMode(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableOpenMode(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetTableFieldCount(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableFieldCount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetFieldNumber(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldNumber(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int UpdateCreateMode(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.UpdateCreateMode(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetFieldLength(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldLength(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetFieldName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetFieldName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetFieldType(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldType(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldLength(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldLength(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetFieldNbr(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldNbr(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static boolean GetFieldNullFlag(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetFieldNullFlag(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int GetFieldPrecision(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldPrecision(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetFieldScale(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldScale(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetFieldNullFlag(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetFieldNullFlag(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static int SetFieldPrecision(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldPrecision(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldScale(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldScale(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static boolean IsFieldNumeric(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsFieldNumeric(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int SetFieldDefaultValue(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetFieldDefaultValue(cTHANDLE.nativeType(), string, string.length());
        cTHANDLE.Post();
        return n;
    }

    static String GetFieldDefaultValue(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        int n = 0;
        String string = ctdbJNI.GetFieldDefaultValue(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return string;
    }

    static int ClearFieldDefaultValue(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ClearFieldDefaultValue(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetFieldDefaultDateTimeType(CTHANDLE cTHANDLE, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetFieldDefaultDateTimeType(cTHANDLE.nativeType(), n, n2);
        cTHANDLE.Post();
        return n3;
    }

    static boolean IsFieldDefaultValueSet(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsFieldDefaultValueSet(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int GetFieldDefaultDateType(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldDefaultDateType(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetFieldDefaultTimeType(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldDefaultTimeType(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetFieldStatus(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldStatus(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE GetField(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetField(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE AddField(CTHANDLE cTHANDLE, String string, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AddField(cTHANDLE.nativeType(), string, n, n2);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int FirstTable(CTHANDLE cTHANDLE, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer != null & stringBuffer2 != null) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string = ctdbJNI.FirstTable(cTHANDLE.nativeType());
            cTHANDLE.Post();
            if (string != null) {
                stringBuffer.replace(0, stringBuffer.length(), string);
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                string = ctdbJNI.FindTable(cTHANDLE.nativeType(), stringBuffer.toString());
                cTHANDLE.Post();
                if (string != null) {
                    stringBuffer2.replace(0, stringBuffer2.length(), string);
                }
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            return n;
        }
        return CTDBRET.NULARG.getErrno();
    }

    static int NextTable(CTHANDLE cTHANDLE, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer != null & stringBuffer2 != null) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string = ctdbJNI.NextTable(cTHANDLE.nativeType());
            cTHANDLE.Post();
            if (string != null) {
                stringBuffer.replace(0, stringBuffer.length(), string);
                if (!cTHANDLE.Pre(envOwner != -1)) {
                    return 0;
                }
                string = ctdbJNI.FindTable(cTHANDLE.nativeType(), stringBuffer.toString());
                cTHANDLE.Post();
                if (string != null) {
                    stringBuffer2.replace(0, stringBuffer2.length(), string);
                }
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            return n;
        }
        return CTDBRET.NULARG.getErrno();
    }

    static int FindTable(CTHANDLE cTHANDLE, String string, StringBuffer stringBuffer) {
        if (string != null & stringBuffer != null) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string2 = ctdbJNI.FindTable(cTHANDLE.nativeType(), string.toString());
            cTHANDLE.Post();
            if (string2 != null) {
                stringBuffer.replace(0, stringBuffer.length(), string2);
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            return n;
        }
        return CTDBRET.NULARG.getErrno();
    }

    static int AddTable(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.AddTable(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static int AddMRTTable(CTHANDLE cTHANDLE, String string, String string2, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.AddMRTTable(cTHANDLE.nativeType(), string, string2, n);
        cTHANDLE.Post();
        return n2;
    }

    static int DeleteTable(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DeleteTable(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static int DropTable(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DropTable(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int GetTableUID(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableUID(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static boolean IsActiveDatabase(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsActiveDatabase(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static String GetDatabasePath(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetDatabasePath(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static String GetDatabaseName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetDatabaseName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int CloseAll(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CloseAll(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetTableCount(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableCount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetDefaultSqlTableOwner(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetDefaultSqlTableOwner(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int SetDefaultSqlTableOwner(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetDefaultSqlTableOwner(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static boolean IsSQLDatabase(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsSQLDatabase(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int SetDatabaseExclusive(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetDatabaseExclusive(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static boolean IsDatabaseExclusive(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsDatabaseExclusive(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int RenameTable(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.RenameTable(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static int FindTableByUID(CTHANDLE cTHANDLE, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer != null & stringBuffer2 != null) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string = ctdbJNI.FindTableByUID(cTHANDLE.nativeType(), n);
            cTHANDLE.Post();
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n2 = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            if (n2 != CTDBRET.OK.getErrno()) {
                return n2;
            }
            if (string != null) {
                stringBuffer.replace(0, stringBuffer.length(), string);
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            String string2 = ctdbJNI.FindTable(cTHANDLE.nativeType(), stringBuffer.toString());
            cTHANDLE.Post();
            if (string2 != null) {
                stringBuffer2.replace(0, stringBuffer2.length(), string2);
            }
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            n2 = ctdbJNI.GetError(cTHANDLE.nativeType());
            cTHANDLE.Post();
            return n2;
        }
        return CTDBRET.NULARG.getErrno();
    }

    static int GetTableDefaultIndexExtentSize(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableDefaultIndexExtentSize(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetTablePassword(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetTablePassword(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static String GetTableGroupid(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetTableGroupid(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int GetTablePermission(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTablePermission(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetTablePath(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetTablePath(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetTableExtension(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetTableExtension(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetIndexExtension(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexExtension(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetMRTTableDefaultIndex(CTHANDLE cTHANDLE, int n, byte[] byArray, byte[] byArray2, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetMRTTableDefaultIndex(cTHANDLE.nativeType(), n, byArray, byArray2, n2);
        cTHANDLE.Post();
        return n3;
    }

    static int SetMRTTableFilter(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetMRTTableFilter(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetTableDefaultDataExtentSize(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetTableDefaultDataExtentSize(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetTableDefaultIndexExtentSize(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetTableDefaultIndexExtentSize(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetTablePassword(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetTablePassword(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetTableGroupid(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetTableGroupid(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetTablePermission(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetTablePermission(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static CTHANDLE InsField(CTHANDLE cTHANDLE, int n, String string, int n2, int n3) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.InsField(cTHANDLE.nativeType(), n, string, n2, n3);
        cTHANDLE.Post();
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE InsFieldByName(CTHANDLE cTHANDLE, String string, String string2, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.InsFieldByName(cTHANDLE.nativeType(), string, string2, n, n2);
        cTHANDLE.Post();
        return new CTHANDLE(l, cTHANDLE);
    }

    static int MoveField(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.MoveField(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static CTHANDLE GetFieldByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetFieldByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int GetTableIndexCount(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableIndexCount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int DelIndex(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.DelIndex(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetIndexNbrByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIndexNbrByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int AlterTable(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.AlterTable(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int ResetAll(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ResetAll(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static boolean HasNullFieldSupport(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.HasNullFieldSupport(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean HasRecbyt(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.HasRecbyt(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean HasRowid(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.HasRowid(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int UnlockTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.UnlockTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int UpdateCndxIndex(CTHANDLE cTHANDLE, int n, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.UpdateCndxIndex(cTHANDLE.nativeType(), n, string);
        cTHANDLE.Post();
        return n2;
    }

    static int UpdateCndxIndexByName(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.UpdateCndxIndexByName(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static String GetCndxIndex(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetCndxIndex(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return string;
    }

    static String GetCndxIndexByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string2 = ctdbJNI.GetCndxIndexByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return string2;
    }

    static int FilterRecord(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.FilterRecord(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static boolean IsFilteredRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsFilteredRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static String GetFilter(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetFilter(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static char GetPadChar(CTHANDLE cTHANDLE) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return '\u0000';
        }
        char c = ctdbJNI.GetPadChar(cTHANDLE.nativeType(), 0);
        cTHANDLE.Post();
        int n = ctdb.GetError(cTHANDLE);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot retrieve pad char");
        }
        return c;
    }

    static char GetDlmChar(CTHANDLE cTHANDLE) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return '\u0000';
        }
        char c = ctdbJNI.GetPadChar(cTHANDLE.nativeType(), 1);
        cTHANDLE.Post();
        int n = ctdb.GetError(cTHANDLE);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Cannot retrieve delimiter char");
        }
        return c;
    }

    static int SetPadChar(CTHANDLE cTHANDLE, char c, char c2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetPadChar(cTHANDLE.nativeType(), c, c2);
        cTHANDLE.Post();
        return n;
    }

    static int UpdatePadChar(CTHANDLE cTHANDLE, char c, char c2, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.UpdatePadChar(cTHANDLE.nativeType(), c, c2, bl);
        cTHANDLE.Post();
        return n;
    }

    static boolean HasDelField(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.HasDelField(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int GetDatno(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetDatno(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetIdxnoByNumber(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.GetIdxnoByNumber(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetIdxnoByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIdxnoByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int RemoveTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.RemoveTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int ClearAllFieldDefaultValue(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ClearAllFieldDefaultValue(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetTableStatus(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableStatus(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetTableOwner(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetTableOwner(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int SetTableOwner(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetTableOwner(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int RebuildTable(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.RebuildTable(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int PartAdminByName(CTHANDLE cTHANDLE, String string, int n, int n2) throws CTException {
        int n3 = 0;
        if (n == 2048) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            n3 = ctdbJNI.PartAdminByName(cTHANDLE.nativeType(), string, n, 1);
            cTHANDLE.Post();
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n4 = ctdb.GetError(cTHANDLE);
            cTHANDLE.Post();
            if (n4 != CTDBRET.OK.getErrno()) {
                throw new CTException(n4, "Can't perform partition admin");
            }
        } else {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            n3 = ctdbJNI.PartAdminByName(cTHANDLE.nativeType(), string, n, 0);
            cTHANDLE.Post();
        }
        return n3;
    }

    static int PartAdminByNumber(CTHANDLE cTHANDLE, int n, int n2, int n3) throws CTException {
        int n4 = 0;
        if (n2 == 2048) {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            n4 = ctdbJNI.PartAdminByNumber(cTHANDLE.nativeType(), n, n2, 1);
            cTHANDLE.Post();
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            int n5 = ctdb.GetError(cTHANDLE);
            cTHANDLE.Post();
            if (n5 != CTDBRET.OK.getErrno()) {
                throw new CTException(n5, "Can't perform partition admin");
            }
        } else {
            if (!cTHANDLE.Pre(envOwner != -1)) {
                return 0;
            }
            n4 = ctdbJNI.PartAdminByNumber(cTHANDLE.nativeType(), n, n2, 0);
            cTHANDLE.Post();
        }
        return n4;
    }

    static CTHANDLE GetSegmentField(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetSegmentField(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE GetSegmentPartialField(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetSegmentPartialField(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int GetSegmentMode(CTHANDLE cTHANDLE) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetSegmentMode(cTHANDLE.nativeType());
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            throw new CTException(n2, "Cannot retrieve segment mode");
        }
        return n;
    }

    static int SetSegmentMode(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetSegmentMode(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetSegmentNbr(CTHANDLE cTHANDLE) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetSegmentNbr(cTHANDLE.nativeType());
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't retrieve the segment index position in index segments list");
        }
        return n;
    }

    static int GetSegmentStatus(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetSegmentStatus(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int MoveSegment(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.MoveSegment(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetSegmentField(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetSegmentField(cTHANDLE.nativeType(), cTHANDLE2.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetJSONSegmentField(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2, String string, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetJSONSegmentField(cTHANDLE.nativeType(), cTHANDLE2.nativeType(), string, n, n2);
        cTHANDLE.Post();
        return n3;
    }

    static int GetIndexKeyLength(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIndexKeyLength(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetIndexKeyType(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIndexKeyType(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static char GetIndexEmptyChar(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return '\u0000';
        }
        char c = ctdbJNI.GetIndexEmptyChar(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return c;
    }

    static boolean GetIndexDuplicateFlag(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetIndexDuplicateFlag(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean GetIndexNullFlag(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetIndexNullFlag(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static boolean GetIndexTemporaryFlag(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetIndexTemporaryFlag(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int SetIndexEmptyChar(CTHANDLE cTHANDLE, char c) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexEmptyChar(cTHANDLE.nativeType(), c);
        cTHANDLE.Post();
        return n;
    }

    static int SetIndexDuplicateFlag(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexDuplicateFlag(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static int SetIndexNullFlag(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexNullFlag(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static int SetIndexTemporaryFlag(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexTemporaryFlag(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static int GetIndexSegmentCount(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIndexSegmentCount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE AddSegment(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AddSegment(cTHANDLE.nativeType(), cTHANDLE2.nativeType(), n);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE AddSegmentEx(CTHANDLE cTHANDLE, int n, int n2, int n3) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AddSegmentEx(cTHANDLE.nativeType(), n, n2, n3);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE AddJSONSegment(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2, String string, int n, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AddJSONSegment(cTHANDLE.nativeType(), cTHANDLE2.nativeType(), string, n, n2);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE InsSegment(CTHANDLE cTHANDLE, int n, CTHANDLE cTHANDLE2, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.InsSegment(cTHANDLE.nativeType(), n, cTHANDLE2.nativeType(), n2);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE InsSegmentEx(CTHANDLE cTHANDLE, int n, int n2, int n3, int n4) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.InsSegmentEx(cTHANDLE.nativeType(), n, n2, n3, n4);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int DelSegment(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.DelSegment(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static CTHANDLE GetSegment(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetSegment(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int GetIndexNbr(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIndexNbr(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetIndexName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetIndexName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static long GetIndexUID(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetIndexUID(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return l;
    }

    static int SetIndexName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int SetIndexKeyType(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetIndexKeyType(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetIndexFilename(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexFilename(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static String GetIndexFilename(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetIndexFilename(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int GetIdxno(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIdxno(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetIndexStatus(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetIndexStatus(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE GetIndex(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetIndex(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE GetIndexByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetIndexByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static String GetTableName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetTableName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static String GetTablePath(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetTablePath(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static CTHANDLE AddIndex(CTHANDLE cTHANDLE, String string, int n, boolean bl, boolean bl2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AddIndex(cTHANDLE.nativeType(), string, n, bl, bl2);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE GetIndexByUID(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetIndexByUID(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int CompareRecords(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CompareRecords(cTHANDLE.nativeType(), cTHANDLE2.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static long NumberOfKeyEntries(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.NumberOfKeyEntries(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return l;
    }

    static int SetIndexCndxExpression(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetIndexCndxExpression(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static int BatchLoaded(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.BatchLoaded(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int BatchLocked(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.BatchLoaded(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int BatchTotal(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.BatchTotal(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int BatchMode(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.BatchMode(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static boolean IsBatchActive(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsBatchActive(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int EndBatch(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.EndBatch(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int InsertBatch(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.InsertBatch(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int NextBatch(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.NextBatch(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetBatch(CTHANDLE cTHANDLE, int n, int n2, int n3) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n4 = ctdbJNI.SetBatch(cTHANDLE.nativeType(), n, n2, n3);
        cTHANDLE.Post();
        return n4;
    }

    static long GetRecordPosAtPercentile(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetRecordPosAtPercentile(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return l;
    }

    static long GetRecordKeyPos(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetRecordKeyPos(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return l;
    }

    static long GetRecordPosAtOffset(CTHANDLE cTHANDLE, long l) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l2 = ctdbJNI.GetRecordPosAtOffset(cTHANDLE.nativeType(), l);
        cTHANDLE.Post();
        return l2;
    }

    static int SeekRecord(CTHANDLE cTHANDLE, long l) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SeekRecord(cTHANDLE.nativeType(), l);
        cTHANDLE.Post();
        return n;
    }

    static String GetIdentityField(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetIdentityField(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static long GetIdentityFieldSeed(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetIdentityFieldSeed(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return l;
    }

    static long GetIdentityFieldIncrement(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetIdentityFieldIncrement(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return l;
    }

    static long GetLastIdentity(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0L;
        }
        long l = ctdbJNI.GetLastIdentity(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return l;
    }

    static int AttachTable(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.AttachTable(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int DetachTable(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.DetachTable(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static String GetProductName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetProductName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static String GetProductVersion(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetProductVersion(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int GetMaxConnections(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetMaxConnections(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetFieldBinaryFlag(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFieldBinaryFlag(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int LoadCallbackLib(CTHANDLE cTHANDLE, String string, String string2, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.LoadCallbackLib(cTHANDLE.nativeType(), string, string2, bl);
        cTHANDLE.Post();
        return n;
    }

    static int UnLoadCallbackLib(CTHANDLE cTHANDLE, boolean bl) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.UnLoadCallbackLib(cTHANDLE.nativeType(), bl);
        cTHANDLE.Post();
        return n;
    }

    static int AddTableXtd(CTHANDLE cTHANDLE, String string, String string2, String string3) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.AddTableXtd(cTHANDLE.nativeType(), string, string2, string3);
        cTHANDLE.Post();
        return n;
    }

    static int SetCallbackOnRebuild(Object object, String string, int n) {
        int n2 = ctdbJNI.SetCallbackOnRebuild(object, string, n);
        return n2;
    }

    static int SetSqlCallback(CTHANDLE cTHANDLE, Object object, String string) {
        int n = ctdbJNI.SetSqlCallback(cTHANDLE.nativeType(), object, string);
        return n;
    }

    static int ClearSavePoint(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.ClearSavePoint(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int CloneTable(CTHANDLE cTHANDLE, String string, CTHANDLE cTHANDLE2) {
        if (!cTHANDLE2.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.CloneTable(cTHANDLE.nativeType(), string, cTHANDLE2.nativeType());
        cTHANDLE2.Post();
        return n;
    }

    static CTHANDLE FindActiveTable(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.FindActiveTable(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE AllocateResultSet(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AllocateResultSet(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static void FreeResultSet(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1 || shutdown)) {
            return;
        }
        ctdbJNI.FreeResultSet(cTHANDLE.nativeType());
        cTHANDLE.Post();
    }

    static int ResultSetOnOff(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2, boolean bl, boolean bl2, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.ResultSetOnOff(cTHANDLE.nativeType(), cTHANDLE2.nativeType(), bl, bl2, n);
        cTHANDLE.Post();
        return n2;
    }

    static CTHANDLE AddCriteria(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2, String string, String string2, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AddCriteria(cTHANDLE.nativeType(), cTHANDLE2.nativeType(), string, string2, n);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int RemoveCriteria(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.RemoveCriteria(cTHANDLE.nativeType(), cTHANDLE2.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int UpdateCriteria(CTHANDLE cTHANDLE, String string, String string2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.UpdateCriteria(cTHANDLE.nativeType(), string, string2);
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE GetResultSetByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetResultSetByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE GetActiveResultSet(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetActiveResultSet(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int UnlockRecord(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.UnlockRecord(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int GetRecordLock(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetRecordLock(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetFieldBinaryFlag(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldBinaryFlag(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetFieldAsFloat(CTHANDLE cTHANDLE, int n, Float f) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetFieldValue(cTHANDLE.nativeType(), n, f.floatValue());
        cTHANDLE.Post();
        return n2;
    }

    static Float GetFieldAsFloat(CTHANDLE cTHANDLE, int n) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        Float f = Float.valueOf(ctdbJNI.GetFieldAsFloat(cTHANDLE.nativeType(), n));
        cTHANDLE.Post();
        int n2 = ctdb.GetError(cTHANDLE);
        if (n2 != 0) {
            if (n2 == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n2, "Cannot get field value");
        }
        return f;
    }

    static int FTSearchOn(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.FTSearchOn(cTHANDLE.nativeType(), string, 0);
        cTHANDLE.Post();
        return n;
    }

    static int AddFTIField(CTHANDLE cTHANDLE, CTHANDLE cTHANDLE2, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.AddFTIField(cTHANDLE.nativeType(), cTHANDLE2.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetFTIFieldCount(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFTIFieldCount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE GetFTIField(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetFTIField(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return new CTHANDLE(l, cTHANDLE);
    }

    static int GetFTIStatus(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFTIStatus(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetFTIOption(CTHANDLE cTHANDLE, int n, String string, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetFTIOption(cTHANDLE.nativeType(), n, string, n2);
        cTHANDLE.Post();
        return n3;
    }

    static String GetFTIName(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetFTIName(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static int GetFTINbr(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFTINbr(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE AllocFTIDict(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AllocFTIDict(cTHANDLE.nativeType());
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int SetFTIDictOption(CTHANDLE cTHANDLE, int n, String string, int n2) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n3 = ctdbJNI.SetFTIDictOption(cTHANDLE.nativeType(), n, string, n2);
        cTHANDLE.Post();
        return n3;
    }

    static int CreateFTIDict(CTHANDLE cTHANDLE, String string, String string2, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.CreateFTIDict(cTHANDLE.nativeType(), string, string2, n);
        cTHANDLE.Post();
        return n2;
    }

    static CTHANDLE AddFTI(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.AddFTI(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int DelFTI(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.DelFTI(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int GetFTINbrByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetFTINbrByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static CTHANDLE GetFTI(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetFTI(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static CTHANDLE GetFTIByName(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        long l = ctdbJNI.GetFTIByName(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        if (l == 0L) {
            return null;
        }
        return new CTHANDLE(l, cTHANDLE);
    }

    static int GetTableFTICount(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetTableFTICount(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetDefaultFTI(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.SetDefaultFTI(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int FTSearchOn(CTHANDLE cTHANDLE, String string, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.FTSearchOn(cTHANDLE.nativeType(), string, n);
        cTHANDLE.Post();
        return n2;
    }

    static boolean IsFTSearchOn(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.IsFTSearchOn(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static int FTSearchOff(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.FTSearchOff(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int[] GetFTSErrorDetails(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        int[] nArray = ctdbJNI.GetFTSErrorDetails(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return nArray;
    }

    static int GetFTIFieldMode(CTHANDLE cTHANDLE, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.GetFTIFieldMode(cTHANDLE.nativeType(), n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetTempPath(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetTempPath(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    private static Calendar DateTimeUnpackMsec(double d) throws CTException {
        int n;
        int n2;
        int n3;
        int n4;
        if (d == 0.0) {
            throw new CTException(CTDBRET.INVDATETIME.getErrno(), "Invalid Timestamp");
        }
        double d2 = (int)d;
        double d3 = d - d2;
        double d4 = d2 + 72987.0 + 1.0;
        if (d3 < 0.0) {
            d3 = -1.0 * d3;
        }
        if ((d2 = d3 * 8.64E7) == 0.0) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
        } else {
            d2 = d2 - (double)((long)d2) >= 0.5 ? Math.ceil(d2) : Math.floor(d2);
            d3 = d2 / 3600000.0;
            n = Math.ceil(d3) - d3 < 0.0 ? (int)Math.ceil(d3) : (int)Math.floor(d3);
            d3 = (d2 -= (double)(n * 3600000)) / 60000.0;
            n2 = Math.ceil(d3) - d3 < 0.0 ? (int)Math.ceil(d3) : (int)Math.floor(d3);
            d3 = (d2 -= (double)(n2 * 60000)) / 1000.0;
            n3 = Math.ceil(d3) - d3 < 0.0 ? (int)Math.ceil(d3) : (int)Math.floor(d3);
            n4 = (int)((d2 -= (double)(n3 * 1000)) + 1.0E-5);
            if (n < 0 || n > 23) {
                throw new CTException(CTDBRET.INVHOUR.getErrno(), "Invalid Hour");
            }
            if (n2 < 0 || n2 > 59) {
                throw new CTException(CTDBRET.INVMINUTE.getErrno(), "Invalid Minute");
            }
            if (n3 < 0 || n3 > 59) {
                throw new CTException(CTDBRET.INVSECOND.getErrno(), "Invalid Second");
            }
            if (n4 < 0 || n4 > 999) {
                throw new CTException(CTDBRET.INVMILLISECOND.getErrno(), "Invalid Millisecond");
            }
        }
        Calendar calendar = ctdb.DateUnpack((long)d4);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4);
        return calendar;
    }

    static int SetLicenseFile(String string) {
        return ctdbJNI.SetLicenseFile(string);
    }

    static int SetLocalDir(String string) {
        return ctdbJNI.SetLocalDir(string);
    }

    static int GetPartitionIndexNbr(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.GetPartitionIndexNbr(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return n;
    }

    static int SetFieldStringEncoding(CTHANDLE cTHANDLE, String string) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetFieldStringEncoding(cTHANDLE.nativeType(), string);
        cTHANDLE.Post();
        return n;
    }

    static String GetFieldStringEncoding(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        String string = ctdbJNI.GetFieldStringEncoding(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return string;
    }

    static byte[] GetRecordBuffer(CTHANDLE cTHANDLE) throws CTException {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return null;
        }
        byte[] byArray = ctdbJNI.GetRecordBuffer(cTHANDLE.nativeType());
        cTHANDLE.Post();
        int n = ctdb.GetError(cTHANDLE);
        if (n != 0) {
            if (n == CTDBRET.FLDISNULL.getErrno()) {
                return null;
            }
            throw new CTException(n, "Cannot get field value");
        }
        return byArray;
    }

    static int SetRecordBuffer(CTHANDLE cTHANDLE, byte[] byArray) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.SetRecordBuffer(cTHANDLE.nativeType(), byArray);
        cTHANDLE.Post();
        return n;
    }

    static int FindTarget(CTHANDLE cTHANDLE, byte[] byArray, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.FindTarget(cTHANDLE.nativeType(), byArray, n);
        cTHANDLE.Post();
        return n2;
    }

    static int BuildTargetKey(CTHANDLE cTHANDLE, byte[] byArray, int n) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n2 = ctdbJNI.BuildTargetKey(cTHANDLE.nativeType(), byArray, n);
        cTHANDLE.Post();
        return n2;
    }

    static int SetCommProtocolOption(int n, String string) {
        return ctdbJNI.SetCommProtocolOption(n, string);
    }

    static int SetClientLibraryOption(int n, String string) {
        return ctdbJNI.SetClientLibraryOption(n, string);
    }

    static boolean GetFailOverState(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return false;
        }
        boolean bl = ctdbJNI.GetFailOverState(cTHANDLE.nativeType());
        cTHANDLE.Post();
        return bl;
    }

    static void ResetFailOverState(CTHANDLE cTHANDLE) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return;
        }
        ctdbJNI.ResetFailOverState(cTHANDLE.nativeType());
        cTHANDLE.Post();
    }

    public static int IsPrimaryServer(CTHANDLE cTHANDLE, boolean[] blArray) {
        if (!cTHANDLE.Pre(envOwner != -1)) {
            return 0;
        }
        int n = ctdbJNI.IsPrimaryServer(cTHANDLE.nativeType(), blArray);
        cTHANDLE.Post();
        return n;
    }
}

