/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeConnection;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeJDBCObject;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeStatement;
import ctree.jdbc.JDBCType;
import ctree.jdbc.SQLType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;

public class CtreeDatabaseMetaData
extends CtreeJDBCObject
implements DatabaseMetaData,
Wrapper {
    CtreeConnection connection;
    int procedureResultUnknown = 0;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown = 0;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int procedureColumnResult = 3;
    int procedureNoNulls = 0;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeNoNulls = 0;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredNone = 0;
    int typePredChar = 1;
    int typePredBasic = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;

    protected CtreeDatabaseMetaData(CtreeConnection ctreeConnection) throws SQLException {
        this.connection = ctreeConnection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getuserid();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "c-treeACE SQL";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "12.0.2.1113";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "ctree.jdbc.ctreeDriver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "12.0.2.1113";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1300;
    }

    @Override
    public int getDriverMinorVersion() {
        return 1113;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.connection.connectionID.identifier_case.equals("IC_SENSITIVE");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.connection.connectionID.identifier_case.equals("IC_UPPER");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.connection.connectionID.identifier_case.equals("IC_LOWER");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.connection.connectionID.identifier_case.equals("IC_MIXED");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.connection.connectionID.quoted_identifier_case.equals("IC_SENSITIVE");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.connection.connectionID.quoted_identifier_case.equals("IC_UPPER");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.connection.connectionID.quoted_identifier_case.equals("IC_LOWER");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.connection.connectionID.quoted_identifier_case.equals("IC_MIXED");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "after, before, bigint, binary, call, clustered, colgroup, compress, contains, database, datapages, dateadd, datediff, day, dayofyear, dba, definition, each, exclusive, file, hash, hour, identified, index, indexpages, inout, link, lock, log, long, lvarbinary, lvarchar, metadata_only, millisecond, minus, minute mode, modify, money, month, newrow, nocompress, nowait, oldrow, out, pctfree, quarter, raw, range, referencing, rename, resource, result, return, row, rowid, rownum, share, second, sql_tsi_day, sql_tsi_dayofyear, sql_tsi_frac_second, sql_tsi_hour, sql_tsi_minute, sql_tsi_month, sql_tsi_quarter, sql_tsi_second, sql_tsi_week, sql_tsi_year, statement, statistics, storage_attributes, storage_manager, store_in_dharma, synonym, sysdate, systime, systimestamp, tinyint, trigger, truncate, uid, varbinary, week, year ";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        String string = "ABS,ACOS,ASIN,";
        string = string + "ATAN,ATAN2,CEILING,";
        string = string + "COS,COT,DEGREES,EXP,";
        string = string + "FLOOR,LOG,LOG10,MOD,";
        string = string + "PI,POWER,RADIANS,";
        string = string + "RAND,ROUND,SIGN,SIN,";
        string = string + "SQRT,TAN,TRUNCATE";
        return string;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        String string = "ASCII,LTRIM,";
        string = string + "CHAR,DIFFERENCE,INSERT,";
        string = string + "OVERLAY,POSITION,";
        string = string + "LCASE,LEFT,REPEAT,";
        string = string + "REPLACE,SOUNDEX,SPACE,";
        string = string + "SUBSTRING,UCASE,";
        string = string + "RTRIM,CONCAT,LENGTH,";
        string = string + "LOCATE";
        return string;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "SQL_FN_SYS_USERNAME,SQL_FN_SYS_IFNULL,SQL_FN_SYS_DBNAME";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        String string = "CURDATE,CURTIME,";
        string = string + "CURRENR_DATE,EXTRACT,";
        string = string + "DAYOFMONTH,DAYOFWEEK,";
        string = string + "DAYOFYEAR,MONTH,NOW,";
        string = string + "QUARTER,";
        string = string + "WEEK,YEAR,HOUR,";
        string = string + "MINUTE,SECOND";
        return string;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        SQLType sQLType = CtreeDA.typesToJdbcTypes(n);
        SQLType sQLType2 = CtreeDA.typesToJdbcTypes(n2);
        this.checkType(sQLType2);
        switch ((JDBCType)sQLType) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case NUMERIC: 
            case BIT: {
                return sQLType2 != JDBCType.BINARY && sQLType2 != JDBCType.VARBINARY && sQLType2 != JDBCType.DATE && sQLType2 != JDBCType.TIME && sQLType2 != JDBCType.TIMESTAMP;
            }
            case CHAR: 
            case VARCHAR: {
                return true;
            }
            case BINARY: 
            case VARBINARY: {
                if (sQLType2 == JDBCType.BINARY || sQLType2 == JDBCType.VARBINARY || sQLType2 == JDBCType.CHAR || sQLType2 == JDBCType.VARCHAR) {
                    return true;
                }
            }
            case DATE: {
                return sQLType2 == JDBCType.CHAR || sQLType2 == JDBCType.VARCHAR || sQLType2 == JDBCType.DATE || sQLType2 == JDBCType.TIMESTAMP;
            }
            case TIME: {
                return sQLType2 == JDBCType.CHAR || sQLType2 == JDBCType.VARCHAR || sQLType2 == JDBCType.TIME || sQLType2 == JDBCType.TIMESTAMP;
            }
            case TIMESTAMP: {
                return sQLType2 == JDBCType.CHAR || sQLType2 == JDBCType.VARCHAR || sQLType2 == JDBCType.TIME || sQLType2 == JDBCType.DATE || sQLType2 == JDBCType.TIMESTAMP;
            }
            case LONGVARCHAR: {
                return true;
            }
            case LONGVARBINARY: {
                return sQLType2 == JDBCType.BINARY || sQLType2 == JDBCType.VARBINARY || sQLType2 == JDBCType.CHAR || sQLType2 == JDBCType.VARCHAR;
            }
        }
        throw new CtreeSQLException(26065);
    }

    public void checkType(SQLType sQLType) throws SQLException {
        switch ((JDBCType)sQLType) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case NUMERIC: 
            case BIT: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case LONGVARCHAR: 
            case LONGVARBINARY: {
                break;
            }
            default: {
                throw new CtreeSQLException(26028);
            }
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "Owner";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 100;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 500;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 10;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 250;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        switch (1) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        return 8;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.Procedures(string, string2, string3);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.ProcedureColumns(string, string2, string3, string4);
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.Tables(string, string2, string3, stringArray);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.Schemas();
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.Catalogs();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.TableTypes();
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.Columns(string, string2, string3, string4);
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.ColumnPrivileges(string, string2, string3, string4);
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.TablePrivileges(string, string2, string3);
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.BestRowIdentifier(string, string2, string3, n, bl, this);
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.VersionColumns(string, string2, string3);
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.PrimaryKeys(string, string2, string3);
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.ImportedKeys(string, string2, string3, this);
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.ExportedKeys(string, string2, string3, this);
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.CrossReference(string, string2, string3, string4, string5, string6, this);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.TypeInfo();
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.IndexInfo(string, string2, string3, bl, bl2, this);
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        if (n == 1003) {
            if (CtreeDatabaseMetaData.traceOn()) {
                CtreeDatabaseMetaData.trace("@CtreeDatabaseMetaData, supportsResultSetType: type forward only = true ");
            }
            return true;
        }
        if (n == 1004) {
            if (CtreeDatabaseMetaData.traceOn()) {
                CtreeDatabaseMetaData.trace("@CtreeDatabaseMetaData, supportsResultSetType: type scroll insensitive = true ");
            }
            return true;
        }
        if (CtreeDatabaseMetaData.traceOn()) {
            CtreeDatabaseMetaData.trace("@CtreeDatabaseMetaData, supportsResultSetType: type other than forward only or scroll insensitive = false ");
        }
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.UDTs(string, string2, string3, nArray);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n == 1003 && n2 == 1007;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.SuperTypes(string, string2, string3);
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.SuperTables(string, string2, string3);
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.Attributes(string, string2, string3, string4);
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 2;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1300;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 1113;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 13;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.getClientInfoProperties();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.getFunctions(string, string2, string3);
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.getFunctionColumns(string, string2, string3, string4);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.getSchemas(string, string2);
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.getClass().getName().equals(clazz.getName());
    }

    public CtreeDatabaseMetaData unwrap(Class clazz) throws SQLException {
        boolean bl = clazz.getName().equals(this.getClass().getName());
        if (!bl) {
            throw new CtreeSQLException(26094);
        }
        return this;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        CtreeStatement ctreeStatement = (CtreeStatement)this.connection.createStatement();
        return ctreeStatement.PseudoColumns(string, string2, string3, string4);
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSharding() throws SQLException {
        return false;
    }
}

