/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCA;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeInt;
import ctree.jdbc.CtreeSQLProcInfo;
import ctree.jdbc.CtreeSnDesc;
import ctree.jdbc.CtreeSnFst;
import ctree.jdbc.CtreeSnGetData;
import ctree.jdbc.CtreeSnIoSqlda;
import ctree.jdbc.CtreeSnPutData;
import ctree.jdbc.CtreeTmHdl;
import ctree.jdbc.CtreeUUid;
import ctree.jdbc.SQLNetwork;
import ctree.jdbc.SQLNetworkException;
import ctree.jdbc.SQLPacket;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class NetfnsCS
implements CtreeError {
    SQLNetwork NetworkHandle = null;
    private int charsize = 1;
    private boolean unicode = false;
    private Charset csm = null;

    public NetfnsCS(SQLNetwork sQLNetwork, int n, boolean bl, Charset charset) {
        this.NetworkHandle = sQLNetwork;
        this.charsize = n;
        this.unicode = bl;
        this.csm = charset;
    }

    public synchronized void RemAttach(String string, String string2, String string3, String string4, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n = 1;
        String string5 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n);
        this.NetworkHandle.setInterfaceName(string5);
        try {
            sQLPacket2.marshalString(string);
            sQLPacket2.marshalString(string2);
            sQLPacket2.marshalString("");
            sQLPacket2.marshalString(string4);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = 68;
            int n3 = 20;
            int n4 = n2;
            byte by = 2;
            if (dataInputStream.available() == n4) {
                byte[] byArray = new byte[n4];
                byte[] byArray2 = null;
                byte[] byArray3 = null;
                dataInputStream.read(byArray);
                if (byArray[0] == by) {
                    int n5;
                    byte[] byArray4;
                    ByteBuffer byteBuffer;
                    Object object;
                    if ((byArray[1] & 8) == 8) {
                        object = MessageDigest.getInstance("SHA-512");
                        byteBuffer = ByteBuffer.wrap(byArray, 4, 32);
                        byArray4 = new byte[32];
                        byteBuffer.get(byArray4);
                        ((MessageDigest)object).update(byArray4);
                        int n6 = string3.length();
                        if (n6 >= 64) {
                            n6 = 63;
                        }
                        ((MessageDigest)object).update(string3.substring(0, n6).getBytes());
                        byArray2 = ((MessageDigest)object).digest();
                    } else if ((byArray[1] & 0x10) == 16) {
                        ctreeCA.setErrorCode(-18160);
                        ctreeCA.setErrorMessage("The server logon protocol requires MD5 hash support but this driver does not support MD5 hash.");
                        ctreeInt.setValue(-18160);
                        bl = true;
                    } else if ((byArray[1] & 0x20) == 32 && byArray[5] < 2) {
                        ctreeCA.setErrorCode(-18161);
                        ctreeCA.setErrorMessage("The client logon protocol requires SHA512 hash support but the server does not support it.");
                        ctreeInt.setValue(-18161);
                        bl = true;
                    } else if ((byArray[1] & 0x20) == 32 && byArray[5] > 2) {
                        ctreeCA.setErrorCode(-17941);
                        ctreeCA.setErrorMessage("The server logon protocol requires a secure logon (version " + byArray[5] + ") that this driver does not support.");
                        ctreeInt.setValue(-17941);
                        bl = true;
                    } else if ((byArray[1] & 0x20) == 32 && byArray[5] == 2) {
                        int n7;
                        int n8 = 0;
                        if (byArray[4] == 1) {
                            for (n7 = 6; n7 < 9; ++n7) {
                                n8 += byArray[n7];
                                if (byArray[n7] < 0) {
                                    n8 += 256;
                                }
                                n8 *= 256;
                            }
                        } else {
                            for (n7 = 9; n7 > 6; --n7) {
                                n8 += byArray[n7];
                                if (byArray[n7] < 0) {
                                    n8 += 256;
                                }
                                n8 *= 256;
                            }
                        }
                        n8 += byArray[n7];
                        if (byArray[n7] < 0) {
                            n8 += 256;
                        }
                        int n9 = (n8 - 1) / 2;
                        n5 = 72;
                        sQLPacket2.reset();
                        DataOutputStream dataOutputStream = sQLPacket2.getOutputStream();
                        byte[] byArray5 = ByteBuffer.allocate(4).putInt(n5).array();
                        ((OutputStream)dataOutputStream).write(byArray5);
                        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
                        dataInputStream = sQLPacket.getInputStream();
                        byArray = new byte[n8];
                        dataInputStream.read(byArray);
                        byteBuffer = ByteBuffer.wrap(byArray, 0, 1);
                        byArray5 = new byte[1];
                        byteBuffer.get(byArray5);
                        BigInteger bigInteger = new BigInteger(1, byArray5);
                        byteBuffer = ByteBuffer.wrap(byArray, 1, n9);
                        byArray5 = new byte[n9];
                        byteBuffer.get(byArray5);
                        BigInteger bigInteger2 = new BigInteger(1, byArray5);
                        byteBuffer = ByteBuffer.wrap(byArray, 1 + n9, n9);
                        byArray5 = new byte[n9];
                        byteBuffer.get(byArray5);
                        BigInteger bigInteger3 = new BigInteger(1, byArray5);
                        DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger3, bigInteger2, bigInteger);
                        KeyFactory keyFactory = KeyFactory.getInstance("DH");
                        PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
                        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
                        DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger2, bigInteger, n9 * 8);
                        keyPairGenerator.initialize(dHParameterSpec);
                        KeyPair keyPair = keyPairGenerator.generateKeyPair();
                        PrivateKey privateKey = keyPair.getPrivate();
                        PublicKey publicKey2 = keyPair.getPublic();
                        DHPublicKeySpec dHPublicKeySpec2 = keyFactory.getKeySpec(publicKey2, DHPublicKeySpec.class);
                        BigInteger bigInteger4 = dHPublicKeySpec2.getY();
                        sQLPacket2.reset();
                        dataOutputStream = sQLPacket2.getOutputStream();
                        byteBuffer = ByteBuffer.wrap(bigInteger4.toByteArray());
                        int n10 = byteBuffer.array().length;
                        int n11 = 0;
                        if (n10 == n9 + 1) {
                            if (byteBuffer.array()[0] == 0) {
                                n11 = 1;
                            } else {
                                --n10;
                            }
                        }
                        for (int i = 0; i < n9 - (n10 - n11); ++i) {
                            ((OutputStream)dataOutputStream).write(0);
                        }
                        ((OutputStream)dataOutputStream).write(byteBuffer.array(), n11, n10 - n11);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        int n12 = string3.length();
                        if (n12 > 64) {
                            n12 = 64;
                        }
                        byteArrayOutputStream.write(string3.substring(0, n12).getBytes());
                        while (n12 < 64) {
                            byteArrayOutputStream.write(0);
                            ++n12;
                        }
                        int n13 = 16779442;
                        byArray5 = ByteBuffer.allocate(4).putInt(n13).array();
                        byteArrayOutputStream.write(byArray5);
                        int n14 = 12;
                        byteArrayOutputStream.write(n14);
                        n14 = 0;
                        byteArrayOutputStream.write(n14);
                        n14 = 2;
                        byteArrayOutputStream.write(n14);
                        byteArrayOutputStream.write(0);
                        for (int i = 0; i < 8; ++i) {
                            byteArrayOutputStream.write(0);
                        }
                        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
                        byte[] byArray6 = byteArrayOutputStream.toByteArray();
                        messageDigest.update(byArray6);
                        byteArrayOutputStream.write(messageDigest.digest());
                        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
                        keyAgreement.init(privateKey);
                        keyAgreement.doPhase(publicKey, true);
                        byArray3 = keyAgreement.generateSecret();
                        MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-256");
                        messageDigest2.update(byArray3);
                        byArray3 = messageDigest2.digest();
                        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "AES");
                        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                        byte[] byArray7 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                        cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray7));
                        byte[] byArray8 = byteArrayOutputStream.toByteArray();
                        byte[] byArray9 = cipher.doFinal(byArray8);
                        ((OutputStream)dataOutputStream).write(byArray9, 0, byArray8.length);
                        bl3 = true;
                    } else {
                        ctreeCA.setErrorCode(-17959);
                        ctreeCA.setErrorMessage("This c-tree client uses a different secure logon version than your c-tree Server. Update your c-tree client.");
                        ctreeInt.setValue(-17959);
                        bl = true;
                    }
                    if (!bl && !bl3) {
                        object = MessageDigest.getInstance("SHA-512");
                        byteBuffer = ByteBuffer.wrap(byArray2, 0, 64);
                        byArray4 = new byte[64];
                        byteBuffer.get(byArray4);
                        ((MessageDigest)object).update(byArray4);
                        byteBuffer = ByteBuffer.wrap(byArray, 36, 32);
                        byte[] byArray10 = new byte[32];
                        byteBuffer.get(byArray10);
                        ((MessageDigest)object).update(byArray10);
                        byArray2 = ((MessageDigest)object).digest();
                    }
                    if (!bl) {
                        if (bl3) {
                            object = sQLPacket2.getOutputStream();
                        } else {
                            sQLPacket2.reset();
                            object = sQLPacket2.getOutputStream();
                            ((OutputStream)object).write(byArray2);
                        }
                        if (!bl3) {
                            int n15 = 16779442;
                            byte[] byArray11 = ByteBuffer.allocate(4).putInt(n15).array();
                            ((OutputStream)object).write(byArray11);
                            n5 = 12;
                            ((OutputStream)object).write(n5);
                            n5 = 0;
                            ((OutputStream)object).write(n5);
                            n5 = 2;
                            ((OutputStream)object).write(n5);
                        }
                        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
                        dataInputStream = sQLPacket.getInputStream();
                        bl2 = true;
                    }
                } else {
                    ctreeCA.setErrorCode(-17959);
                    ctreeCA.setErrorMessage("This c-tree client uses a different secure logon version than your c-tree Server. Update your c-tree client.");
                    ctreeInt.setValue(-17959);
                    bl = true;
                }
            } else if (dataInputStream.available() == n3) {
                byte[] byArray = new byte[n3];
                dataInputStream.read(byArray);
                if (byArray[0] == 1) {
                    ctreeCA.setErrorCode(-17959);
                    ctreeCA.setErrorMessage("This c-tree client uses a different secure logon version than your c-tree Server. Update your c-tree client.");
                    ctreeInt.setValue(-17959);
                } else {
                    ctreeCA.setErrorCode(-17959);
                    ctreeCA.setErrorMessage("This c-tree client uses a different secure logon version than your c-tree Server. Update your c-tree client.");
                    ctreeInt.setValue(-17959);
                }
                bl = true;
            }
            if (!bl) {
                ctreeCA.unmarshal(sQLPacket);
                ctreeInt.unmarshal(dataInputStream);
            }
            if (!bl && !bl2) {
                ctreeCA.setErrorCode(-17942);
                ctreeCA.setErrorMessage("This c-tree client uses a secure logon that your c-tree Server does not support. Update your c-tree Server.");
                ctreeInt.setValue(-17942);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            throw new SQLNetworkException(-30100, exception);
        }
    }

    public synchronized void RemSQLSelect(int n, CtreeTmHdl ctreeTmHdl, CtreeUUid ctreeUUid, String string, int n2, String string2, int n3, CtreeDA ctreeDA, CtreeSnFst ctreeSnFst, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n4 = 3;
        String string3 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n4);
        this.NetworkHandle.setInterfaceName(string3);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
            ctreeUUid.marshal(sQLPacket2);
            sQLPacket2.marshalString(string);
            sQLPacket2.marshalInt(n2);
            sQLPacket2.marshalString(string2);
            sQLPacket2.marshalInt(n3);
            if (ctreeDA != null) {
                ctreeDA.marshal(sQLPacket2);
            } else {
                sQLPacket2.marshalInt(0);
            }
            ctreeSnFst.marshal(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeSnFst.unmarshal(sQLPacket);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLGetData(int n, CtreeTmHdl ctreeTmHdl, CtreeUUid ctreeUUid, String string, int n2, String string2, CtreeSnGetData ctreeSnGetData, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n3 = 4;
        String string3 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n3);
        this.NetworkHandle.setInterfaceName(string3);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
            ctreeUUid.marshal(sQLPacket2);
            sQLPacket2.marshalString(string);
            sQLPacket2.marshalInt(n2);
            sQLPacket2.marshalString(string2);
            ctreeSnGetData.marshal(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeSnGetData.unmarshal(dataInputStream);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLFetch(int n, CtreeTmHdl ctreeTmHdl, CtreeUUid ctreeUUid, String string, int n2, String string2, int n3, CtreeSnFst ctreeSnFst, CtreeCA ctreeCA, CtreeInt ctreeInt, CtreeInt ctreeInt2) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n4 = 15;
        String string3 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n4);
        this.NetworkHandle.setInterfaceName(string3);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
            ctreeUUid.marshal(sQLPacket2);
            sQLPacket2.marshalString(string);
            sQLPacket2.marshalInt(n2);
            sQLPacket2.marshalInt(ctreeInt2.getValue());
            sQLPacket2.marshalString(string2);
            sQLPacket2.marshalInt(n3);
            ctreeSnFst.marshal(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        try {
            this.NetworkHandle.setInputCaching(false);
            this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        }
        catch (SQLNetworkException sQLNetworkException) {
            throw sQLNetworkException;
        }
        finally {
            this.NetworkHandle.setInputCaching(true);
        }
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeInt2.setValue(sQLPacket.unmarshalInt());
            ctreeSnFst.unmarshal(sQLPacket);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.setValue(sQLPacket.unmarshalInt());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLDescribe(int n, CtreeTmHdl ctreeTmHdl, CtreeUUid ctreeUUid, String string, int n2, String string2, int n3, CtreeSnDesc ctreeSnDesc, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n4 = 6;
        String string3 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n4);
        this.NetworkHandle.setInterfaceName(string3);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
            ctreeUUid.marshal(sQLPacket2);
            sQLPacket2.marshalString(string);
            sQLPacket2.marshalInt(n2);
            sQLPacket2.marshalString(string2);
            sQLPacket2.marshalInt(n3);
            ctreeSnDesc.marshal(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeSnDesc.unmarshal(sQLPacket);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLDescribeParam(int n, CtreeTmHdl ctreeTmHdl, CtreeUUid ctreeUUid, int n2, String string, CtreeSnDesc ctreeSnDesc, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n3 = 7;
        String string2 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n3);
        this.NetworkHandle.setInterfaceName(string2);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
            ctreeUUid.marshal(sQLPacket2);
            sQLPacket2.marshalInt(n2);
            sQLPacket2.marshalString(string);
            ctreeSnDesc.marshal(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeSnDesc.unmarshal(sQLPacket);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemTmExec(int n, CtreeTmHdl ctreeTmHdl, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n2 = 8;
        String string = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n2);
        this.NetworkHandle.setInterfaceName(string);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLExec(int n, CtreeTmHdl ctreeTmHdl, CtreeUUid ctreeUUid, String string, int n2, String string2, int n3, CtreeSnIoSqlda ctreeSnIoSqlda, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n4 = 10;
        String string3 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n4);
        this.NetworkHandle.setInterfaceName(string3);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
            ctreeUUid.marshal(sQLPacket2);
            sQLPacket2.marshalString(string);
            sQLPacket2.marshalInt(n2);
            sQLPacket2.marshalString(string2);
            sQLPacket2.marshalInt(n3);
            ctreeSnIoSqlda.marshal_DA(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeSnIoSqlda.unmarshal(sQLPacket);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLPutData(int n, CtreeTmHdl ctreeTmHdl, CtreeUUid ctreeUUid, String string, int n2, String string2, CtreeSnPutData ctreeSnPutData, CtreeCA ctreeCA, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n3 = 11;
        String string3 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n3);
        this.NetworkHandle.setInterfaceName(string3);
        try {
            sQLPacket2.marshalInt(n);
            ctreeTmHdl.marshal(sQLPacket2);
            ctreeUUid.marshal(sQLPacket2);
            sQLPacket2.marshalString(string);
            sQLPacket2.marshalInt(n2);
            sQLPacket2.marshalString(string2);
            ctreeSnPutData.marshal(sQLPacket2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeSnPutData.unmarshal(dataInputStream);
            ctreeCA.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLFetch2(String string) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n = 12;
        String string2 = new String("netfns");
        this.NetworkHandle.setProcedureNumber(n);
        this.NetworkHandle.setInterfaceName(string2);
        DataOutputStream dataOutputStream = sQLPacket2.getOutputStream();
        try {
            sQLPacket2.marshalString(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
    }

    public synchronized void RemSQLDump(CtreeTmHdl ctreeTmHdl, CtreeSQLProcInfo ctreeSQLProcInfo, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n = 2;
        String string = new String("fcfns");
        this.NetworkHandle.setProcedureNumber(n);
        this.NetworkHandle.setInterfaceName(string);
        try {
            int n2 = 0;
            ctreeTmHdl.marshal(sQLPacket2);
            sQLPacket2.marshalInt(0);
            sQLPacket2.marshalInt(n2);
            ctreeSQLProcInfo.marshal(sQLPacket2, n2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            int n3 = sQLPacket.unmarshalInt();
            int n4 = sQLPacket.unmarshalInt();
            if (n3 == 0 && n4 >= 0 && n4 <= 1) {
                ctreeSQLProcInfo.unmarshal(sQLPacket, n4);
            } else {
                ctreeInt.setValue(n3);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }

    public synchronized void RemSQLDeploy(CtreeTmHdl ctreeTmHdl, CtreeSQLProcInfo ctreeSQLProcInfo, CtreeInt ctreeInt) throws SQLNetworkException, SQLException {
        SQLPacket sQLPacket;
        SQLPacket sQLPacket2;
        try {
            sQLPacket2 = new SQLPacket(this.charsize, this.unicode, this.csm);
            sQLPacket = new SQLPacket(this.charsize, this.unicode, this.csm);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30011, iOException);
        }
        int n = 3;
        String string = new String("fcfns");
        this.NetworkHandle.setProcedureNumber(n);
        this.NetworkHandle.setInterfaceName(string);
        DataOutputStream dataOutputStream = sQLPacket2.getOutputStream();
        try {
            int n2 = 1;
            ctreeTmHdl.marshal(sQLPacket2);
            sQLPacket2.marshalInt(0);
            sQLPacket2.marshalInt(n2);
            ctreeSQLProcInfo.marshal(sQLPacket2, n2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30099, iOException);
        }
        this.NetworkHandle.rsvp(sQLPacket2, sQLPacket);
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        try {
            ctreeTmHdl.unmarshal(sQLPacket);
            ctreeInt.unmarshal(dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            throw new SQLNetworkException(-30100, iOException);
        }
    }
}

