/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbcx;

import ctree.jdbc.CtreeCallableStatement;
import ctree.jdbc.CtreeConnection;
import ctree.jdbc.CtreeDatabaseMetaData;
import ctree.jdbc.CtreePreparedStatement;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeStatement;
import ctree.jdbc.SQLXApi;
import ctree.jdbcx.CtreePooledCallableStatement;
import ctree.jdbcx.CtreePooledConnection;
import ctree.jdbcx.CtreePooledDatabaseMetaData;
import ctree.jdbcx.CtreePooledPreparedStatement;
import ctree.jdbcx.CtreePooledStatement;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class CtreeConnectionHandle
extends CtreeConnection {
    private boolean isHandleClosed = false;
    private CtreePooledConnection pooledConnection;

    public CtreeConnectionHandle(String string, String string2, String string3, CtreePooledConnection ctreePooledConnection) throws SQLException {
        super(string, string2, string3, null);
        this.pooledConnection = ctreePooledConnection;
    }

    public CtreeConnectionHandle(String string, String string2, String string3, CtreePooledConnection ctreePooledConnection, SQLXApi sQLXApi) throws SQLException {
        super(string, string2, string3, null, sQLXApi);
        this.pooledConnection = ctreePooledConnection;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = super.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = super.prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return callableStatement;
    }

    @Override
    public void commit() throws SQLException {
        try {
            super.commit();
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            super.rollback();
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isHandleClosed) {
            return;
        }
        this.closeHandle();
        this.pooledConnection.fireConnectionClosed();
    }

    synchronized void closeHandle() throws SQLException {
        try {
            if (!this.isHandleClosed) {
                this.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isHandleClosed = true;
    }

    synchronized void closeBackendConnection() throws SQLException {
        super.close();
        this.isHandleClosed = true;
    }

    protected CtreeStatement createCtreeStatement(int n, int n2) throws SQLException {
        return new CtreePooledStatement(this.pooledConnection, this, n, n2);
    }

    @Override
    protected CtreePreparedStatement createCtreePreparedStatement(String string) throws SQLException {
        return new CtreePooledPreparedStatement(this.pooledConnection, this, string);
    }

    @Override
    protected CtreeCallableStatement createCtreeCallableStatement(String string) throws SQLException {
        return new CtreePooledCallableStatement(this.pooledConnection, this, string);
    }

    @Override
    protected CtreeDatabaseMetaData createCtreeDatabaseMetaData() throws SQLException {
        return new CtreePooledDatabaseMetaData(this.pooledConnection, this);
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isHandleClosed;
    }

    protected void checkConnection() throws SQLException {
        if (this.isClosed()) {
            throw new CtreeSQLException(26002);
        }
    }
}

