/*
 * Decompiled with CFR 0.152.
 */
package FairCom.ServerCounters;

import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.CounterType;
import FairCom.ServerCounters.ServerCounters;
import ServerMonitor.CtreeMonitor;
import ServerMonitor.Structures;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Counter {
    private ServerCounters.COUNTERS_TYPE family;
    private ServerCounters.COUNTER_CATEGORY category;
    private String type;
    private String name;
    private String description;
    private ServerCounters.FORMAT format;
    private boolean isPerSecondValid;
    private boolean inPerfMon;
    private boolean mayDecrease;
    private Double value = 0.0;
    private Double previousValue = 0.0;
    private Double valuePerSecond = 0.0;
    private Double resetValue = 0.0;
    private Double functionTotalElapsedTime;
    private String stringValue;
    private boolean firstPass = true;
    private long divisor;
    private long divisorPerSecond;
    private int length;
    private int arrIndex;
    private long bitMask;

    public Counter(ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE, ServerCounters.COUNTER_CATEGORY cOUNTER_CATEGORY, String string, String string2, Class clazz, int n, ServerCounters.FORMAT fORMAT, boolean bl, boolean bl2, boolean bl3) {
        this(cOUNTERS_TYPE, cOUNTER_CATEGORY, string, string2, clazz, n, fORMAT, bl, bl2, bl3, -1, -1L);
    }

    public Counter(ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE, ServerCounters.COUNTER_CATEGORY cOUNTER_CATEGORY, String string, String string2, Class clazz, int n, ServerCounters.FORMAT fORMAT, boolean bl, boolean bl2, boolean bl3, int n2) {
        this(cOUNTERS_TYPE, cOUNTER_CATEGORY, string, string2, clazz, n, fORMAT, bl, bl2, bl3, n2, -1L);
    }

    public Counter(ServerCounters.COUNTERS_TYPE cOUNTERS_TYPE, ServerCounters.COUNTER_CATEGORY cOUNTER_CATEGORY, String string, String string2, Class clazz, int n, ServerCounters.FORMAT fORMAT, boolean bl, boolean bl2, boolean bl3, int n2, long l) {
        this.family = cOUNTERS_TYPE;
        this.category = cOUNTER_CATEGORY;
        this.name = string;
        this.description = string2;
        this.type = clazz.getName();
        this.length = n;
        if (n == 0) {
            n = 1000;
        }
        this.divisor = n;
        this.divisorPerSecond = n / 1000;
        this.format = fORMAT;
        this.isPerSecondValid = bl;
        this.inPerfMon = bl2;
        this.mayDecrease = bl3;
        this.arrIndex = n2;
        this.bitMask = l;
    }

    public Counter(String string) {
        this.name = string;
        this.description = "";
        this.divisor = 1000L;
        this.divisorPerSecond = 1000L;
        this.format = ServerCounters.FORMAT.INTDEC;
        this.format = ServerCounters.FORMAT.INTDEC;
    }

    public double getValue() {
        return this.value;
    }

    public double getValuePerSecond() {
        return this.valuePerSecond;
    }

    public double getAccumulatedValue() {
        return this.getValue() - this.resetValue;
    }

    public String getFormattedAccumulatedValue() {
        return this.valToString(this.getValue() - this.resetValue);
    }

    public String getFormattedValue() {
        if (this.format == ServerCounters.FORMAT.IP6_ADDRESS) {
            this.stringValue = "N/A";
        }
        if (this.getType().equals("java.lang.String")) {
            return this.stringValue;
        }
        return this.valToString(this.getValue());
    }

    public String getFormattedValuePerSecond() {
        if (this.isIsPerSecondValid()) {
            return this.valToString(this.getValuePerSecond());
        }
        return "";
    }

    public String valToString(Double d) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        if (d != null) {
            switch (this.getFormat()) {
                case CHAR: {
                    Character c = Character.valueOf((char)d.intValue());
                    return c.toString();
                }
                case INTDEC: {
                    Long l = d.longValue();
                    return numberFormat.format(l);
                }
                case INTHEX: {
                    Long l = d.longValue();
                    return "0x" + Long.toHexString(l);
                }
                case INTHEX_NO_PREFIX: {
                    Long l = d.longValue();
                    return Long.toHexString(l);
                }
                case DATE: {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(1970, 0, 1, 1, 0, 0);
                    calendar.add(13, d.intValue());
                    Date date = calendar.getTime();
                    return dateFormat.format(date);
                }
                case ELAP_TIME_DAY: 
                case ELAP_TIME_SEC: 
                case ELAP_TIME_MSEC: {
                    return this.convert2hms(d.longValue(), this.getFormat());
                }
                case IP_ADDRESS: {
                    Integer n = d.intValue();
                    String string = (n & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 24 & 0xFF);
                    if (string.equals("0.0.0.0")) {
                        return "";
                    }
                    return string;
                }
                case VERSION_ID: {
                    Integer n = d.intValue();
                    if (n > -1073741824) {
                        String string = "V";
                        Integer n2 = (n >>> 25 & 0x1F) + 10;
                        string = string + Integer.toString(n2);
                        n2 = n >> 20 & 0x1F;
                        string = string + "." + Integer.toString(n2);
                        n2 = n & 0xFFFFF;
                        string = string + "." + Integer.toString(n2);
                        return string;
                    }
                    if (n > -1459617792) {
                        String string = "V";
                        Integer n3 = (n >>> 24) - 160;
                        string = string + Integer.toHexString(n3);
                        n3 = n >> 20 & 0xF;
                        string = string + "." + Integer.toHexString(n3);
                        n3 = n & 0xFFFFF;
                        string = string + "." + Integer.toHexString(n3);
                        return string;
                    }
                    if (n > -1610612736) {
                        String string = "V";
                        Integer n4 = (n >>> 24) - 160;
                        string = string + Integer.toHexString(n4);
                        n4 = n >> 12 & 0xFFF;
                        string = string + "." + Integer.toHexString(n4);
                        n4 = n & 0xFFF;
                        string = string + "." + Integer.toHexString(n4);
                        return string;
                    }
                    return "";
                }
                case VERSION_ID2: {
                    Integer n = d.intValue();
                    Integer n5 = n & 0x7F;
                    Integer n6 = n >> 7;
                    String string = "Mini = " + n5;
                    string = string + " - Build = " + n6;
                    return string;
                }
                case PORT_ID: {
                    Integer n = d.intValue();
                    switch (n) {
                        case 0x11222211: {
                            return "ctPort88OPEN";
                        }
                        case 0x11333311: {
                            return "ctPortATTUNIX386";
                        }
                        case 0x11444411: {
                            return "ctPortVINES";
                        }
                        case 0x11555511: {
                            return "ctPortCHORUS";
                        }
                        case 0x11666611: {
                            return "ctPortOS2_2x";
                        }
                        case 0x11777711: {
                            return "ctPortALPHA";
                        }
                        case 0x11888811: {
                            return "ctPortHP9000";
                        }
                        case 0x11999911: {
                            return "ctPortINTERACTIVE";
                        }
                        case 0x11AAAA11: {
                            return "ctPortLYNXOS386";
                        }
                        case 0x11BBBB11: {
                            return "ctPortAPPLEAUX";
                        }
                        case 0x11CCCC11: {
                            return "ctPortNECEWS4800";
                        }
                        case 0x11DDDD11: {
                            return "ctPortWNT386";
                        }
                        case 0x11EEEE11: {
                            return "ctPortQNX";
                        }
                        case 0x11FFFF11: {
                            return "ctPortRS6000";
                        }
                        case 0x22111122: {
                            return "ctPortQNXRTP";
                        }
                        case 0x22333322: {
                            return "ctPortOS2_1x";
                        }
                        case 0x22444422: {
                            return "ctPortSCO386";
                        }
                        case 0x22555522: {
                            return "ctPortMSDOS";
                        }
                        case 0x22666622: {
                            return "ctPortSUN41";
                        }
                        case 0x22777722: {
                            return "ctPortMSWINDOWS";
                        }
                        case 0x22888822: {
                            return "ctPortSOLARIS";
                        }
                        case 0x22999922: {
                            return "ctPortNLM";
                        }
                        case 0x22AAAA22: {
                            return "ctPortMIPSABI";
                        }
                        case 0x22BBBB22: {
                            return "ctPortAPPLE7";
                        }
                        case 0x22CCCC22: {
                            return "ctPortWIN95";
                        }
                        case 0x22DDDD22: {
                            return "ctPortLINUX";
                        }
                        case 0x22EEEE22: {
                            return "ctPortSYSMAN";
                        }
                        case 0x22FFFF22: {
                            return "ctPortWNTALPHA";
                        }
                        case 0x33111133: {
                            return "ctPortWNTMIPS";
                        }
                        case 0x33222233: {
                            return "ctPortSOL386";
                        }
                        case 0x33333333: {
                            return "ctPortWindowsNT_PowerPC";
                        }
                        case 0x33444433: {
                            return "ctPortSolarisPowerPC";
                        }
                        case 0x33555533: {
                            return "ctPort386BSD";
                        }
                        case 0x33666633: {
                            return "ctPortSGI";
                        }
                        case 0x33777733: {
                            return "ctPortSPARC_LINUX";
                        }
                        case 0x33888833: {
                            return "ctPortMACOSX";
                        }
                        case 0x33999933: {
                            return "ctPortMACLNX";
                        }
                        case 0x33AAAA33: {
                            return "ctPortNETBSD386";
                        }
                        case 0x33BBBB33: {
                            return "ctPortDGU386";
                        }
                        case 0x33CCCC33: {
                            return "ctPortWINCE";
                        }
                    }
                    return "Unknown Port";
                }
                case YES_NO: {
                    Integer n = d.intValue();
                    if (n > 0) {
                        return "Yes";
                    }
                    return "No";
                }
            }
            return "Invalid DisplayFormat";
        }
        return "Null value";
    }

    public void clear() {
        this.value = this.previousValue = Double.valueOf(0.0);
        this.valuePerSecond = this.previousValue;
        this.firstPass = true;
    }

    private String convert2hms(long l, ServerCounters.FORMAT fORMAT) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        String string = simpleDateFormat.format(calendar.getTime());
        char c = decimalFormatSymbols.getDecimalSeparator();
        char c2 = ':';
        if (ServerCounters.scthrtimbas == 0L) {
            ServerCounters.scthrtimbas = 1L;
        }
        Long l2 = l / ServerCounters.scthrtimbas;
        Long l3 = l % ServerCounters.scthrtimbas * 1000L / ServerCounters.scthrtimbas;
        Integer n = (int)(l2 / 86400L);
        l2 = l2 - (long)(n * 3600 * 24);
        Integer n2 = (int)(l2 / 3600L);
        l2 = l2 - (long)(n2 * 3600);
        Integer n3 = (int)(l2 / 60L);
        l2 = l2 - (long)(n3 * 60);
        if (fORMAT == ServerCounters.FORMAT.ELAP_TIME_DAY) {
            return String.format("%2d - %02d %c %02d %c %02d", n, n2, Character.valueOf(c2), n3, Character.valueOf(c2), l2);
        }
        if (fORMAT == ServerCounters.FORMAT.ELAP_TIME_SEC) {
            return String.format("%02d %c %02d %c %02d %c %03d", n2, Character.valueOf(c2), n3, Character.valueOf(c2), l2, Character.valueOf(c), l3);
        }
        if (fORMAT == ServerCounters.FORMAT.ELAP_TIME_MSEC) {
            return String.format("%02d %c %03d", l2, Character.valueOf(c), l3);
        }
        return "Invalid DisplayFormat";
    }

    public void setValue(Double d, boolean bl, long l, int n) {
        this.previousValue = this.getValue();
        this.value = bl ? Double.valueOf(CtreeMonitor.RevInt32((int)d.intValue())) : d;
        if (this.firstPass) {
            this.previousValue = this.getValue();
            this.firstPass = false;
        }
        this.valuePerSecond = (this.getValue() - this.getPreviousValue()) / (double)n;
        if (this.getValuePerSecond() < 0.0 && !this.isMayDecrease()) {
            this.valuePerSecond = 0.0;
        }
        this.previousValue = this.getValue();
    }

    public void setGUMSValue(Structures.GUMS gUMS, boolean bl, long l, int n) {
        int n2 = 0;
        boolean bl2 = false;
        Class<Structures.GUMS> clazz = Structures.GUMS.class;
        String string = this.getName();
        try {
            Object object;
            int n3 = this.getName().indexOf("[");
            int n4 = this.getName().indexOf("]");
            if (n3 >= 0) {
                object = this.getName().substring(n3 + 1, n4);
                n2 = Integer.parseInt((String)object);
                bl2 = true;
                string = this.getName().substring(0, n3);
            }
            object = clazz.getField(string);
            try {
                Object object2 = ((Field)object).get(gUMS);
                this.setValue(object2, n2, bl2, bl, l, n);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, securityException);
        }
    }

    public void setGFMSValue(Structures.GFMS gFMS, boolean bl, long l, int n) {
        int n2 = 0;
        boolean bl2 = false;
        Class<Structures.GFMS> clazz = Structures.GFMS.class;
        String string = this.getName();
        try {
            Object object;
            int n3 = this.getName().indexOf("[");
            int n4 = this.getName().indexOf("]");
            if (n3 >= 0) {
                object = this.getName().substring(n3 + 1, n4);
                n2 = Integer.parseInt((String)object);
                bl2 = true;
                string = this.getName().substring(0, n3);
            }
            object = clazz.getField(string);
            try {
                Object object2 = ((Field)object).get(gFMS);
                this.setValue(object2, n2, bl2, bl, l, n);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, securityException);
        }
    }

    public void reset() {
        this.resetValue = this.getValue();
    }

    public void setGSMSValue(Structures.GSMS gSMS, boolean bl, long l, int n) {
        int n2 = 0;
        boolean bl2 = false;
        Class<Structures.GSMS> clazz = Structures.GSMS.class;
        String string = this.getName();
        try {
            Object object;
            int n3 = this.getName().indexOf("[");
            int n4 = this.getName().indexOf("]");
            if (n3 >= 0) {
                object = this.getName().substring(n3 + 1, n4);
                n2 = Integer.parseInt((String)object);
                bl2 = true;
                string = this.getName().substring(0, n3);
            }
            object = clazz.getField(string);
            try {
                Object object2 = ((Field)object).get(gSMS);
                this.setValue(object2, n2, bl2, bl, l, n);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, securityException);
        }
    }

    public void setSQLSValue(Structures.SQLS sQLS, boolean bl, long l, int n) {
        int n2 = 0;
        boolean bl2 = false;
        Class<Structures.SQLS> clazz = Structures.SQLS.class;
        String string = this.getName();
        try {
            Object object;
            int n3 = this.getName().indexOf("[");
            int n4 = this.getName().indexOf("]");
            if (n3 >= 0) {
                object = this.getName().substring(n3 + 1, n4);
                n2 = Integer.parseInt((String)object);
                bl2 = true;
                string = this.getName().substring(0, n3);
            }
            object = clazz.getField(string);
            try {
                Object object2 = ((Field)object).get(sQLS);
                this.setValue(object2, n2, bl2, bl, l, n);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, securityException);
        }
    }

    private void setValue(Object object, int n, boolean bl, boolean bl2, long l, int n2) {
        try {
            if (object != null) {
                Object object2;
                Object object3;
                if (this.getType().equals("java.lang.String")) {
                    this.stringValue = object.toString();
                } else if (this.getType().equals("java.lang.Long")) {
                    if (bl) {
                        object3 = (long[])object;
                        object2 = object3[n];
                    } else {
                        object2 = (Long)object;
                    }
                    if (bl2) {
                        object2 = CtreeMonitor.RevInt64((long)((Long)object2));
                    }
                    this.value = ((Long)object2).doubleValue();
                    if (this.firstPass) {
                        this.previousValue = this.getValue();
                        this.firstPass = false;
                    }
                    this.valuePerSecond = (this.value - this.getPreviousValue()) / (double)n2;
                    if (this.getValuePerSecond() < 0.0 && !this.isMayDecrease()) {
                        this.valuePerSecond = 0.0;
                    }
                    this.previousValue = this.getValue();
                } else if (this.getType().equals("java.lang.Integer")) {
                    if (bl) {
                        object3 = (int[])object;
                        object2 = (int)object3[n];
                    } else {
                        object2 = (Integer)object;
                    }
                    if (bl2) {
                        object2 = CtreeMonitor.RevInt32((int)((Integer)object2));
                    }
                    if (this.getFormat() == ServerCounters.FORMAT.IP_ADDRESS) {
                        this.value = ServerCounters.clientByteOrder == 2 ? (bl2 ? Double.valueOf(CtreeMonitor.RevInt32((int)((Integer)object2))) : Double.valueOf(((Integer)object2).doubleValue())) : (bl2 ? Double.valueOf(((Integer)object2).doubleValue()) : Double.valueOf(CtreeMonitor.RevInt32((int)((Integer)object2))));
                    }
                    if (this.getFormat() == ServerCounters.FORMAT.IP6_ADDRESS) {
                        object3 = (int[])object;
                        this.value = ServerCounters.clientByteOrder == 2 ? (bl2 ? Double.valueOf(CtreeMonitor.RevInt32((int)((Integer)object2))) : Double.valueOf(((Integer)object2).doubleValue())) : (bl2 ? Double.valueOf(((Integer)object2).doubleValue()) : Double.valueOf(CtreeMonitor.RevInt32((int)((Integer)object2))));
                    }
                    this.value = ((Integer)object2).doubleValue();
                    if (this.firstPass) {
                        this.previousValue = this.value;
                        this.firstPass = false;
                    }
                    this.valuePerSecond = (this.value - this.getPreviousValue()) / (double)n2;
                    if (this.getValuePerSecond() < 0.0 && !this.isMayDecrease()) {
                        this.valuePerSecond = 0.0;
                    }
                    this.previousValue = this.getValue();
                } else if (this.getType().equals("java.lang.Short")) {
                    if (bl) {
                        object3 = (short[])object;
                        object2 = (short)object3[n];
                    } else {
                        object2 = (Short)object;
                    }
                    if (bl2) {
                        object2 = CtreeMonitor.RevInt16((short)((Short)object2));
                    }
                    this.value = ((Short)object2).doubleValue();
                }
                if (this.getType().equals("java.lang.Character")) {
                    if (bl) {
                        object2 = (byte[])object;
                        object3 = (byte)object2[n];
                        this.stringValue = object3.toString();
                    } else {
                        this.stringValue = object.toString();
                    }
                    try {
                        this.value = Double.parseDouble(this.stringValue);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        catch (ClassCastException classCastException) {
            Logger.getLogger(Counter.class.getName()).log(Level.SEVERE, null, classCastException);
        }
    }

    public boolean isIsPerSecondValid() {
        return this.isPerSecondValid;
    }

    public boolean isInPerfMon() {
        return this.inPerfMon;
    }

    public Double getFunctionTotalElapsedTime() {
        return this.functionTotalElapsedTime;
    }

    public long getDivisor() {
        if (this.divisor == 0L) {
            return 1L;
        }
        return this.divisor;
    }

    public void setDivisor(long l) {
        this.divisor = l;
    }

    public ServerCounters.COUNTERS_TYPE getFamily() {
        return this.family;
    }

    public String getFamilyDescription() {
        for (CounterType counterType : ServerCounters.countersTypes) {
            if (this.family != counterType.ID) continue;
            return counterType.description;
        }
        return null;
    }

    public ServerCounters.COUNTER_CATEGORY getCategory() {
        return this.category;
    }

    public String getCategoryDescription() {
        for (Category category : ServerCounters.categories) {
            if (this.category != category.ID) continue;
            return category.description;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ServerCounters.FORMAT getFormat() {
        return this.format;
    }

    public boolean isMayDecrease() {
        return this.mayDecrease;
    }

    public Double getPreviousValue() {
        return this.previousValue;
    }

    public long getDivisorPerSecond() {
        if (this.divisorPerSecond == 0L) {
            return 1L;
        }
        return this.divisorPerSecond;
    }

    public int getLength() {
        return this.length;
    }

    public void setFunctionTotalElapsedTime(Double d) {
        this.functionTotalElapsedTime = d;
    }

    public int getArrIndex() {
        return this.arrIndex;
    }

    public long getBitMask() {
        return this.bitMask;
    }
}

