/*
 * Decompiled with CFR 0.152.
 */
package FairCom.ServerCounters;

import FairCom.ServerCounters.Category;
import FairCom.ServerCounters.Counter;
import FairCom.ServerCounters.CounterType;
import ServerMonitor.CtreeMonitor;
import ServerMonitor.Enums;
import ServerMonitor.Structures;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ServerCounters {
    public static final int ctGSMSvern = 21;
    public static ArrayList<Category> categories = new ArrayList();
    public static ArrayList<CounterType> countersTypes = new ArrayList();
    public ArrayList<Counter> counters = new ArrayList();
    private COUNTERS_TYPE cType;
    private int IP_PERF_CNTS = 32;
    private CtreeMonitor session = null;
    private ERROR error;
    private boolean revertBytes;
    public static long scthrtimbas = 0L;
    private int refreshInterval;
    private Calendar previousUpdateTime = Calendar.getInstance();
    public static int clientByteOrder;

    /*
     * Opcode count of 18210 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public ServerCounters(COUNTERS_TYPE cOUNTERS_TYPE) {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        clientByteOrder = byteOrder.equals(ByteOrder.BIG_ENDIAN) ? 1 : 2;
        this.cType = cOUNTERS_TYPE;
        if (countersTypes.isEmpty()) {
            this.initializeCountersTypes();
        }
        if (categories.isEmpty()) {
            this.initializeCategories();
        }
        if (cOUNTERS_TYPE == COUNTERS_TYPE.SYSTEM_CONFIG) {
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DYN_SYS_RES, "cfgMEMORY_USAGE", "Current system memory usage", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMEMORY_USAGE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DYN_SYS_RES, "cfgMEMORY_HIGH", "Highest system memory use", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMEMORY_HIGH.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DYN_SYS_RES, "cfgNET_ALLOCS", "Current system net allocations", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgNET_ALLOCS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DYN_SYS_RES, "cfgOPEN_FILES", "c-tree files opened by system", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgOPEN_FILES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DYN_SYS_RES, "cfgPHYSICAL_FILES", "Physical c-tree files open. Includes superfile members omitted from cfgOPEN_FILES count", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgPHYSICAL_FILES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DYN_SYS_RES, "cfgOPEN_FCBS", "c-tree file control blocks in use by system", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgOPEN_FCBS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DYN_SYS_RES, "cfgLOGIDX", "Is file mode ctLOGIDX supported?", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgLOGIDX.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgDNODE_QLENGTH", "Messages in delete node queue", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgDNODE_QLENGTH.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgCHKPNT_QLENGTH", "Messages in checkpoint queue", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCHKPNT_QLENGTH.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgSYSMON_QLENGTH", "Messages in system monitor queue", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgSYSMON_QLENGTH.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgLOGONS", "Current number of logons", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLOGONS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgNET_LOCKS", "Current number of pending locks (system wide)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgNET_LOCKS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgUSERS", "Maximum number of logons", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgUSERS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgMAX_CONNECT", "The limit for the maximum number of logons", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_CONNECT.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgUSER_FILES", "Number of c-tree files opened by calling user", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgUSER_FILES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgUSER_MEMORY", "Current user memory usage", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgUSER_MEMORY.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgPATH_SEPARATOR", "ASCII value for the file name path separator", Integer.class, 0, FORMAT.CHAR, false, false, false, SYSCFG_IDX.cfgPATH_SEPARATOR.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgMAX_CLIENT_NODES", "The maximum number of client nodes that can be connected at a time (a value of zero indicates no limit)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_CLIENT_NODES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgMAX_CONN_PER_NODE", "The maximum number of concurrent connections per client node (a value of zero indicates no limit)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_CONN_PER_NODE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SRV_IMPL, "cfgLOCAL_CONN_ONLY", "Whether or not connections from remote systems are allowed (a value of zero indicates that remote connections are allowed)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLOCAL_CONN_ONLY.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.COMP_TIME, "cfgFILES", "Maximum number of c-tree file control blocks available system wide.", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgFILES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.COMP_TIME, "cfgMAX_DAT_KEY", "Maximum number of indices per data file", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_DAT_KEY.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.COMP_TIME, "cfgMAX_KEY_SEG", "Maximum number of key segments per index", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_KEY_SEG.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgSERIALNBR", "The c-treeACE Server serial number", Integer.class, 0, FORMAT.INTHEX_NO_PREFIX, false, false, false, SYSCFG_IDX.cfgSERIALNBR.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgBOUND", "Indicates if the application is bound to a database library. See the discussion on the different FairCom I/O models in these notes", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgBOUND.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgDISKIO_MODEL", "Disk I/O model in use (0=NOTFORCE, 1=FPUTFGET)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgDISKIO_MODEL.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgLOCLIB", "Local Library support", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgLOCLIB.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgNOGLOBALS", "Globals are supported i.e. indicating all globals are stored in an allocated structure. This is the default setting", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgNOGLOBALS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgUNIFRMAT", "FairCom\u00e2\u20ac\u2122s automatic byte flipping (UNIFRMAT) is active", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgUNIFRMAT.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgANSI", "Specifies whether to use ANSI", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgANSI.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgCONDIDX", "Application supports FairCom\u00e2\u20ac\u2122s Conditional Index Logic", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCONDIDX.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgCTBATCH", "Application supports Batch Operations", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCTBATCH.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgCTSUPER", "Application supports Superfiles", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCTSUPER.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgCTS_ISAM", "Application supports FairCom\u00e2\u20ac\u2122s ISAM API", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCTS_ISAM.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgHISTORY", "Application supports FairCom\u00e2\u20ac\u2122s History Logic", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgHISTORY.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgINIT_CTREEapp", "Determine whether c-tree has been initialized", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgINIT_CTREEapp.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgLOGIDXapp", "Application supports the ctLOGIDX Logic", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgLOGIDXapp.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgPARMFILE", "Parameter files are supported", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgPARMFILE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgPASCAL24", "2-byte/4-byte length delimited strings are using the traditional pascal length convention", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgPASCAL24.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgPASCALst", "Byte length delimited strings are using the traditional pascal length convention", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgPASCALst.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgPROTOTYPE", "Application supports Prototypes", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgPROTOTYPE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgRESOURCE", "Application supports Resource Records", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgRESOURCE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgRTREE", "Application supports r-tree", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgRTREE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgTHREADapp", "Indicates if threading has been enabled", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgTHREADapp.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgTRANPROC", "Application supports Transaction Processing", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgTRANPROC.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgVARLDATA", "Application supports Variable-length Records", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgVARLDATA.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgVARLKEYS", "Application supports Variable-length Keys i.e. Key compression", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgVARLKEYS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.APP, "cfgWORD_ORDER", "Indicates the client data order: Low_High or High_Low. A non-zero value indicates Low_High", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgWORD_ORDER.ordinal()));
            int n = 1;
            int n2 = 2;
            int n3 = 4;
            int n4 = 8;
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONFIG, "cfgCFGCHK", "Config Bitmap", Integer.class, 0, FORMAT.INTHEX, false, false, false, SYSCFG_IDX.cfgCFGCHK.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONFIG, "cfgCFGCHKreplmap", "REPL_MAPPINGS is in effect for c-treeACE Server", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCFGCHK.ordinal(), n));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONFIG, "cfgCFGCHKmtclient", "mtclient DLL loaded (V11 and later)", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCFGCHK.ordinal(), n2));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONFIG, "cfgCFGCHKxfrfile", "File transfer API enabled (V11 and later)", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCFGCHK.ordinal(), n3));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONFIG, "cfgCFGCHKadvenc", "Advanced encryption enabled", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgCFGCHK.ordinal(), n4));
            int n5 = 1;
            int n6 = 2;
            int n7 = 4;
            int n8 = 8;
            int n9 = 16;
            int n10 = 32;
            int n11 = 64;
            int n12 = 128;
            int n13 = 256;
            int n14 = 512;
            int n15 = 1024;
            int n16 = 2048;
            int n17 = 4096;
            int n18 = 8192;
            int n19 = 16384;
            int n20 = 32768;
            int n21 = 65536;
            int n22 = 131072;
            int n23 = 262144;
            int n24 = 524288;
            int n25 = 0x100000;
            int n26 = 0x200000;
            int n27 = 0x400000;
            int n28 = 0x800000;
            int n29 = 0x1000000;
            int n30 = 0x2000000;
            int n31 = 0x4000000;
            int n32 = 0x8000000;
            int n33 = 0x10000000;
            int n34 = 0x20000000;
            int n35 = 0x40000000;
            long l = Integer.MIN_VALUE;
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHK", "Features Bitmap", Integer.class, 0, FORMAT.INTHEX, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKplusName", "+index name support for PermIIndex.", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n5));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKhugeFile", "Huge file support", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n6));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKcloseInTran", "Close or delete of an updated file inside an active transaction does not abort the transaction: either an error is returned, or the close or delete is deferred until transaction commit or abort", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n7));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKencryption", "Encryption is supported", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n8));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKflexFile", "Flexible file limits are supported", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n9));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKdiskFull", "Support disk full checks", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n11));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKuniqFile", "Support auto reassignment of duplicated file IDs", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n10));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKxtdCmp", "Extended key compression", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n12));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHK6BT", "Extended 6-byte tran#", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n13));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKoldBCD", "Old BCD compatibility", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n14));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKeventLogVer2", "Advanced event log", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n15));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKchkPntLst", "Adj checkpoint list counters", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n16));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKnoFlushDel", "Suppress flush on delete", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n17));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKzeroRecbyt", "Zero RECBYT support", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n18));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKsysView", "System view log", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n19));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKencrypTCPIP", "Encrypt TCPIP", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n20));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKlowlCRC", "Common low-level CRC", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n21));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKcommSUMCHK", "Common sum check", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n22));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKpag64K", "64K page size supported", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n23));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKreadShare", "Read-only for shared files", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n24));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKsplCache", "Cache priming support", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n25));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKpriCache", "Dedicated cache support", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n26));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKnoCache", "No cache data file list", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n27));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKnoFlush", "Suppress flush on delete", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n28));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKfpgCache", "Data cache FPUTFGET", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n29));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKdataFilter", "Data filters", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n30));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKdepRename", "TRANDEP rename support", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n31));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKchannels", "Flexible I/O channels", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n32));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKalgnchnl", "Aligned I/O channels", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n33));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKkeepopen", "KEEPOPEN 4 nonMEMFILES", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n34));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKiict", "Immediate Commit Transaction (IICT) support", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), n35));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHKxtdfldtyp", "Extended Data Types", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK.ordinal(), l));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHK2", "Features Bitmap", Integer.class, 0, FORMAT.INTHEX, false, false, false, SYSCFG_IDX.cfgFEACHK2.ordinal()));
            long l2 = 1L;
            long l3 = 2L;
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHK2copyfile", "File copy API enabled (V11 and later)", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK2.ordinal(), l2));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.FEATURE, "cfgFEACHK2repldefertran", "Repl defer tran feature (V11 and later)", Integer.class, 0, FORMAT.YES_NO, false, false, false, SYSCFG_IDX.cfgFEACHK2.ordinal(), l3));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgCACHE_PAGES", "Available cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgCACHE_PAGES_INUSE", "Cache pages in use", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_INUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgCACHE_PAGES_MXUSE", "Maximum cache pages used", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_MXUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgCACHE_PAGES_DED", "Available dedicated cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_DED.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgCACHE_PAGES_DEDINUSE", "Dedicated cache pages in use", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_DEDINUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgCACHE_PAGES_DEDMXUSE", "Maximum dedicated cache pages used", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_DEDMXUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgBUFFER_PAGES", "Available index buffers", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgBUFFER_PAGES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgBUFFER_PAGES_INUSE", "Index buffers in use", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgBUFFER_PAGES_INUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.STATS, "cfgBUFFER_PAGES_MXUSE", "Maximum index buffers used", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgBUFFER_PAGES_MXUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.VERSION, "cfgVERSIONID", "The version number", Integer.class, 0, FORMAT.VERSION_ID, false, false, false, SYSCFG_IDX.cfgVERSIONID.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.VERSION, "cfgVERSIONID2", "The mini version and build date values (V10.3 and later)", Integer.class, 0, FORMAT.VERSION_ID2, false, false, false, SYSCFG_IDX.cfgVERSIONID2.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.VERSION, "cfgVERSIONID_BASE", "The base build date value (V10.3 and later)", Integer.class, 0, FORMAT.VERSION_ID2, false, false, false, SYSCFG_IDX.cfgVERSIONID_BASE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.VERSION, "cfgPORTID", "OS identifier", Integer.class, 0, FORMAT.PORT_ID, false, false, false, SYSCFG_IDX.cfgPORTID.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.BROADCAST, "cfgBROADCAST_PORT", "The TCP/IP port used for the broadcast (default: 5595)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgBROADCAST_PORT.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.BROADCAST, "cfgBROADCAST_INTERVAL", "The number of seconds between broadcasts", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgBROADCAST_INTERVAL.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.BROADCAST, "cfgBROADCAST_DATA", "A token to be broadcast following the Server Name", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgBROADCAST_DATA.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CACHE, "cfgCACHE_LINE", "The smallest amount of memory a processor will retrieve and store in its highest speed cache", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_LINE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CACHE, "cfgCACHE_PAGES_SCN", "The number of data cache pages allowed to be used as scanner LRU pages. The configuration option SCAN_CACHE_PERCENT can be used to set this value as a percentage of the total data cache size", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_SCN.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CACHE, "cfgCACHE_PAGES_SCNINUSE", "The current number of data cache pages that are being used as scanner LRU pages", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_SCNINUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CACHE, "cfgCACHE_PAGES_SCNMXUSE", "The high-water mark (maximum number at any time in the past) of data cache pages that have been used as scanner LRU pages", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_PAGES_SCNMXUSE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CACHE, "cfgCACHE_STAT_ARRAY_SIZE", "The number of memory locations for each counter (data cache requests, data cache hits, index cache requests, index cache hits)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCACHE_STAT_ARRAY_SIZE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CACHE, "cfgDATA_LRU_LISTS", "The number of LRU lists maintained for data cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgDATA_LRU_LISTS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CACHE, "cfgINDEX_LRU_LISTS", "The number of LRU lists maintained for index buffer pages", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgINDEX_LRU_LISTS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONNECTIONS, "cfgCONNECTIONS", "The maximum number of connections to the c-treeACE Server", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCONNECTIONS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONNECTIONS, "cfgCOUNTED_LOGONS", "The current number of logons that count toward the connection limit if the server uses connection group support (otherwise, the value is 0)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgCOUNTED_LOGONS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONNECTIONS, "cfgLOGON_FAIL_LIMIT", "The optional limit on the number of consecutive failed logons that causes subsequent logon attempts to fail for LOGON_FAIL_TIME minutes", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLOGON_FAIL_LIMIT.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONNECTIONS, "cfgLOGON_FAIL_TIME", "The length of time logons are blocked after the logon limit is exceeded", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLOGON_FAIL_TIME.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONNECTIONS, "cfgLOGON_MUST_TIME", "A non-zero value requires users to log on at-least-once within the defined time or else their profile will be deactivated", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLOGON_MUST_TIME.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONNECTIONS, "cfgMAX_LOGONS", "High-water mark of concurrent logons: the largest number of connections that have existed at one time since server startup", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_LOGONS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "cfgLANGUAGE", "Support the r-tree language feature in an r-tree enabled server", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLANGUAGE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "cfgMAX_PHYSICAL_FILES", "High-water mark of open physical files: the largest number of physically opened files that have existed at one time since server startup", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_PHYSICAL_FILES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "cfgMAX_VIRTUAL_FILES", "The maximum number of virtual files that may be opened at one time", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMAX_VIRTUAL_FILES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "cfgPROCESS_ID", "The process ID of the c-tree Server process", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgPROCESS_ID.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MEMORY, "cfgMEMORY_HASH", "The number of internal memory suballocator lists to be created for each of 11 ranges of allocation size (an entry of N indicates 11N lists are created, with N dedicated to a particular range of allocation size)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgMEMORY_HASH.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "cfgFLEX_FCBS", "System file number high-water mark: the largest system file number that has been used since server startup", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgFLEX_FCBS.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "cfgRECOVER_FILES", "The number of files used during automatic recovery if greater than the FILES keyword", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgRECOVER_FILES.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "cfgRSPACE_QLENGTH", "Current number of entries in the space reclamation queue", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgRSPACE_QLENGTH.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.CONFIG, "cfgSRV_MODEL", "This value indicates whether the server supports only ISAM functionality (1) or SQL functionality (2)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgSRV_MODEL.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "cfgLOG_SPACE", "The number of megabytes of disk space allocated to storing active transaction logs", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLOG_SPACE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "cfgLOG_RECORD_LIMIT", "The data record length limit that triggers an increase the size of the log files", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgLOG_RECORD_LIMIT.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "cfgFIXED_LOG_SIZE", "Indicates if the feature to automatically adjust the size of the log files to accommodate long records has been disabled (see also cfgLOG_RECORD_LIMIT)", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgFIXED_LOG_SIZE.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "cfgSYNC_DELAY", "The number of seconds between log flushes", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgSYNC_DELAY.ordinal()));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "cfgSYSLOG_QLENGTH", "The current number of entries in the SYSLOG queue. This queue contains entries that the system logging thread is going to write to the SYSLOG file", Integer.class, 0, FORMAT.INTDEC, false, false, false, SYSCFG_IDX.cfgSYSLOG_QLENGTH.ordinal()));
        } else if (cOUNTERS_TYPE == COUNTERS_TYPE.USER_SNAPSHOT) {
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "client_ver", "client version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "server_ver", "server version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "fixlen", "length of fixed portion of snapshot", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "varlen", "length of variable region (if any)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "contents", "bit map of var len contents", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "unused", "available for use", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "snapshottm", "snapshot time stamp", Long.class, 0, FORMAT.DATE, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntsum", "user trntime sum", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntmax", "user trntime max", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "scthrtimbas", "high res timer ticks per sec.", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "strntbox", "width of trntdet boxes", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[0]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[1]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[2]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[3]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[4]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[5]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[6]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[7]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[0]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[1]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[2]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[3]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[4]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[5]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[6]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarktim[7]", "user mark elapsed times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[0]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[1]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[2]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[3]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[4]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[5]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[6]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "smarkcnt[7]", "user mark counts", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[0]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[1]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[2]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[3]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[4]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[5]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[6]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[7]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[8]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[9]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[10]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[11]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[12]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[13]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[14]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[15]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[16]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[17]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[18]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[19]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[20]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[21]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[22]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntdet[23]", "trntime detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "slOWNR", "thread handle (OWNER)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sisolev", "transaction isolation level", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctops", "set operation state bit mask", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctstate", "internal state bit mask", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sabnlog", "begtran log for abandoned tran", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "strntcnt", "user trntime count", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctutrbeg", "user tran begin count", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctutrend", "user tran end count", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctutrabt", "user tran abort count", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "snbrfile", "number of files in use", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "slogtime", "logon time", Integer.class, 0, FORMAT.DATE, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "srqstime", "last request time", Integer.class, 0, FORMAT.DATE, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "srqsfunc", "last request function #", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "srqssubf", "last request sub-function #", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sactflag", "active / inactive flag", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sct_trdflg", "thread operation flag", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sabnflg", "stage of abandon tran processing", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctusrprf", "user profile word", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctumxfil", "max files for user", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "scthghfil", "highest file number limit", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sloktry", "total lock attempts", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokhlk", "header lock attempts", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokblk", "total lock wait count", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokhbk", "header lock wait count", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokdlk", "deadlocks", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokdny", "total locks denied", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokfre", "total locks freed", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokrel", "total blocks released", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokcur", "current count of locks held", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sblkcur", "current count of blocked requests", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctstat2", "internal state bit mask2", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "slokkil", "killed: removed from lock wait list", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sipaddr", "host ip address", Integer.class, 0, FORMAT.IP_ADDRESS, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sip6addr", "host ipV6 address", String.class, 32, FORMAT.CHAR, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail4", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail41", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail42", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "clflvr", "user flavor", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "clalgn", "user alignment", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "clpntr", "user pointer size", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sflvr", "server byte order", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "salgn", "server alignment", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "spntr", "server pointer size", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[0]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[1]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[2]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[3]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[4]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[5]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[6]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[7]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[8]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[9]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[10]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[11]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[12]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[13]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[14]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[15]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[16]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[17]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[18]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[19]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[20]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[21]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[22]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[23]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[24]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[25]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "snodname", "node name", String.class, 32, FORMAT.CHAR, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sct_userid", "user id", String.class, 32, FORMAT.CHAR, false, false, false));
        } else if (cOUNTERS_TYPE == COUNTERS_TYPE.FILE_SNAPSHOT) {
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "client_ver", "client version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "server_ver", "server version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "fixlen", "length of fixed portion of snapshot", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "varlen", "length of variable region (if any)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "snapshottm", "snapshot time stamp: seconds since 70", Long.class, 0, FORMAT.DATE, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "phyrec", "physical file size", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "numrec", "logical file size", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sernum", "serial number", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "nument", "active entries", Long.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "hghtrn", "tran# high water mark for idx", Long.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "tstamp", "update time stamp", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "mxfilz", "max file size", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "fredops", "file specific # of read  ops", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "fredbyt", "file specific # of bytes read", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "fwrtops", "file specific # of write ops", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "fwrtbyt", "file specific # of bytes written", Long.class, 1, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "scthrtimbas", "high res timer ticks per sec", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "mhghbyt", "memory file high water bytes", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "fredtim", "file specific disk read call time", Long.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "fwrttim", "file specific disk write call time", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[0]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[1]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[2]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[3]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[4]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail8[5]", "available for future use", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "idxhgt", "index height", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "fileid", "unique file id", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "servid", "unique server id", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "timeid", "time id#", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "nodsiz", "node size", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "reclen", "fixed data record length", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "logtyp", "permanent components of file mode", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "maxkbl", "maximum key bytes leaf-var", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "maxkbn", "maximum key bytes non leaf-var", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "filtyp", "flag for file type", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "keylen", "key length", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "kmem", "key member #", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "nmem", "number of members", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "suptyp", "super file type", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "maxmrk", "maximum exc mark entries per leaf", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "hdrseq", "wrthdr sequence #", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "floktry", "total lock attempts", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokhlk", "header lock attempts", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokblk", "total lock wait count", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokhbk", "header lock wait count", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokdlk", "deadlocks", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokdny", "total locks denied", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokfre", "total locks freed", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokrel", "total blocks released", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokcur", "current count of locks held", Integer.class, 0, FORMAT.INTDEC, true, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "fblkcur", "current count of blocked requests", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "datlmt", "max number of special cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "datspl", "actual number of special cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "bufcnt", "number of buffer pages", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "datcnt", "number of data cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "numchn", "number of channels", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "fusrcnt", "number of users with file open", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "memcnt", "current # of memory records", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "hghcnt", "high water # of memory recors", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "flokkil", "killed locks", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail4[0]", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail4[1]", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail4[2]", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail4[3]", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "avail4[4]", "available for future use", Integer.class, 7, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "contents", "bit map of var len contents", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "segmax", "maximum # of segments", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "seglst", "# activated segments", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "updflg", "update (corrupt) flag", Character.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "ktype", "file type flag", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "autodup", "duplicate flag", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "deltyp", "flag for type of idx delete", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "keypad", "padding byte", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "flflvr", "file flavor", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "flalgn", "file alignment", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "flpntr", "file pointer size", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sflvr", "server byte order", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "salgn", "server alignment", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "spntr", "server pointer size", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[0]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[1]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[2]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[3]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[4]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[5]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[6]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[7]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt[8]", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "filename", "file name", String.class, 256, FORMAT.CHAR, false, false, false));
        } else if (cOUNTERS_TYPE == COUNTERS_TYPE.SYSTEM_SNAPSHOT) {
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "client_ver", "client version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "server_ver", "server version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "fixlen", "length of fixed portion of snapshot", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "varlen", "length of variable region (if any)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "contents", "bit map of var len contents", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "logsets", "number of multiple log sets", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "snapshottm", "snapshot time stamp", Long.class, 0, FORMAT.DATE, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctdnd_red", "delete node thread queue reads", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctdnd_wrt", "delete node thread queue writes", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctdnd_rwt", "delete node thread queue rewrites", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctdnd_abn", "delete node thread queue abandons", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctdnd_rmv", "delete node thread queue removals", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctdnd_non", "delete node thread queue no action", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctloktry", "count of lock attempts", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokhlk", "subcount of hdr lock attempts", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdny", "count of locks denied", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokblk", "count of locks blocked", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokhbk", "subcount of header blocks", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdlk", "count of dead locks", Long.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokfre", "count of locks freed", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokrel", "count of blocks released", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokcur", "current count of locks held", Long.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctblkcur", "current count of blocked requests", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrntim", "cumulative transaction time", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrncnt", "cumulative transaction count", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrnmax", "maximum elapsed tran time", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sct_compflg3", "3rd compatibility word", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctrqtmonint", "request time monitor interval", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "scttot_call", "system-wide c-tree calls", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "scttot_recv", "system-wide time waiting for request", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "scttot_work", "system-wide time performing requests", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "scttot_send", "system-wide time to send request", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MEMORY, "sctmemhgh", "system memory highwater mark", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MEMORY, "sctmemsum", "current aggregate sum", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sct_dbrqs", "data buffer requests", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sct_dbhit", "data buffer hits", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sct_ibrqs", "index buffer requests", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sct_ibhit", "index buffer hits", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_rdops", "number of read operations", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_rdbyt", "bytes read", Long.class, 1000000, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_wrops", "number of write operations", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_wrbyt", "bytes written", Long.class, 1000000, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_rcops", "number of comm read operations", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_rcbyt", "comm bytes read", Long.class, 1000000, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_wcops", "number of comm write operations", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_wcbyt", "comm bytes written", Long.class, 1000000, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctwlgops", "number of log write operations", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctwlgbyt", "bytes written to log file", Long.class, 1000000, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctrlgops", "number of log read operations", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctrlgbyt", "bytes read from log file", Long.class, 1000000, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctxlgops", "number of log extension operations", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctxlgbyt", "log file extension bytes", Long.class, 1000000, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_trbeg", "# transaction begins", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_trend", "# transaction ends", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_trabt", "# transaction aborts", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_trsav", "# transaction savepoints", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_trrst", "# transaction restores", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_trfls", "# transaction log flush writes", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctsync_dosfls", "DOSFLUSH sync calls", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctsync_logfil", "transaction log sync calls", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctsync_regfil", "c-tree file sync calls", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "scthrtimbas", "high res timer ticks per sec", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnttim", "cumulative checkpoint time", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpntsiz", "cumulative checkpoint size", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[0]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[1]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[2]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[3]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[4]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[5]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[6]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctchkpnt[7]", "intermediate checkpoint times", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtdlytry", "cmtdly eligible count", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtdlycnt", "cmtdly concurrent trans exist", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtdlycoh", "cmtdly cohorts exist (success)", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtcohmax", "cmtdly max cohort count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtdlyclr", "cmtdly cohort appeared (success)", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtlopclr", "cmtdly appeared loop count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtdlynot", "cmtdly direct flush count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtlopfls", "cmtdly log flush loop count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtdlydfr", "cmtdly loop defer count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtlopmax", "max loop defer count", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtmaxadp", "max adaptive LFW loop counter", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtavgadp", "avg adaptive LFW loop counter", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtlopfls2", "cmtdly log flush2 loop count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[0]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[1]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[2]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[3]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[4]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[5]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[6]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchk[7]", "diagnostic time ct_udefer check", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "selapwrktim", "elapsed time func timings turned on", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "selapsrvtim", "elapsed server operation time", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtblktim", "accum time for cmtdly blocks", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtclrtim", "accum time for cmtdly clears", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchktarget", "ct_udefer expected result", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchkconsec", "time between consecutive hrt in usec", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchkavg", "avg time ofr hrtimer call in usec", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctcmtdlyfls", "cmtdly log flushed anyway (success)", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctcmtfls", "commit/abort tran log flush rqst", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctbegfls", "begin tran log flush rqst", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctidxfls", "LOGIDX tran log flush rqst", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctupdfls", "file 1st upd tran log flush rqst", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtavgdfr", "avg commit delay block time", Long.class, 0, FORMAT.ELAP_TIME_MSEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcmtmaxdfr", "max commit delay block time", Long.class, 0, FORMAT.ELAP_TIME_MSEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SYNC, "sctcmtdlyfls2", "dmtdly log flushed anyway2 (success)", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "scttrnbox", "width of cttrndet boxes", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctlogfls", "log flush count", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctlogtim", "log flush time", Long.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctSQLmemsum", "current aggregate sum for SQL", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctDBmemsum", "current aggregate sum for CTDB-STUB", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctredcmtlpc", "RED_CMTLOK loop count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctrepfls", "replication log flush rqst", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctchkbufwrt", "checkpoint index buffer writes", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sctchkchewrt", "checkpoint data cache writes", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[0]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[1]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[2]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[3]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[4]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[5]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[6]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[7]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[8]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[9]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[10]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[11]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[12]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[13]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[14]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[15]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[16]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[17]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[18]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[19]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[20]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[21]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[22]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scttrndet[23]", "tran time detail", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctactfil", "# open physical files", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "scttotfil", "# open logical files", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "scttotblk", "# c-tree FCBs in use", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctactfilx", "max physical files opened", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "scttotfilx", "max logical files opened", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "scttotblkx", "max c-tree FCBs in use", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctnusers", "number of users", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctnusersx", "max number of users", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctloknm", "net locks over unlocks", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctloknmx", "max net locks over unlocks", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sct_mxbuf", "number of index buffer pages", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sctbufcnt", "index buffer pages in use", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sctbufhgh", "max index buffers in use", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sct_dxbuf", "available data cache pages", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sctdatcnt", "data cache pages in use", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.DATIDX, "sctdathgh", "max data cache pages in use", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "scmtblkseq", "not flow through cmtdly block", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sct_compflg", "compatibility flag", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sct_compflg2", "2nd compatibility word", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sct_diagflg", "diagnostic flag", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sct_diagflg2", "2nd diagnostic flag", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_cmtdly", "commit delay", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_chkdly", "checkpoint tranac_cnt delay", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_cmtscl", "cmtdlytim block to clear ratio", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sct_cmtbas", "cmtdlytim cohort size measure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchkusec", "ct_udefer test interval in usec's", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "stimchkiter", "ct_udefer test iterations", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sct_udefer_thld", "ct_udefer usec threshold", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "sct_udefer_64yd", "sleep duration for 64 yields (usec)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctITIMretry", "ITIM_ERR auto retry count", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctTPNDretry", "TPND_ERR auto retry count", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctITIMlimit", "ITIM_ERR auto retry limit", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctITIMfailed", "ITIM_ERR auto retry failed", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctredcmtdfr", "RED_CMTLOK loop defer time millisecs", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctredcmtlpr", "RED_CMTLOK loopers", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctITIMdefer", "ITIM_ERR auto retry defer", Integer.class, 0, FORMAT.ELAP_TIME_SEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.ISAM, "sctismaddcnt", "ISAM record add count", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.ISAM, "sctismdelcnt", "ISAM record delete count", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_dxspllmt", "avail   data file special cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_dxsplcnt", "actual  data file special cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_dxsplhgh", "maximum data file special cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.TRANS, "sctcpcnt", "check point count", Integer.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sct_numvfil", "number of virtual files open", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sct_avlfil", "# available file control blocks", Integer.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctactusr", " number of threads active in foregrnd", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_nutcnt", "# of index buffers on upd list (tran)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_nupcnt", "# of index buffers on upd list", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_dutcnt", "# of data caches on upd list (tran)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.RW, "sct_dupcnt", "# of data caches on upd list", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sctwatshtdwn", "wait on shut down in seconds", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sct_wrtcmp", "calls to ctwrtlog", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sct_no_cmp", "ctwrtlog below compression threshold", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sct_tp_cmp", "trantyp not compressed (DIFIMAGE)", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sct_rj_cmp", "ctwrtlg compression not effective", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sct_bytcmp", "total bytes saved by log compression", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctlogcmpfloor", "no log compression below this size", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOGS, "sctlogcmpfactor", "out-size must not > this % of in-size", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sct_mxfil", "total number of c-tree FCBs", Short.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "sct_ndsec", "# of sectors per node", Short.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sflvr", "server byte order", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "salgn", "server alignment", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "spntr", "server pointer size", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt", "available for future use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokkil", "count of killed locks", Long.class, 1, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.ISAM, "sctismupdcnt", "ISAM record update count", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.ISAM, "sctismredcnt", "ISAM record read count", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctloktim", "cumulative lock wait time", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokcnt", "cumulative lock wait count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokmax", "maximum elapsed lock wait time", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokbox", "width of detail boxes", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[0]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[1]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[2]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[3]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[4]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[5]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[6]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[7]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[8]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[9]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[10]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[11]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[12]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[13]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[14]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctlokdet[15]", "lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlktim", "cumulative idx lock wait time", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkcnt", "cumulative idx lock wait count", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkmax", "maximum elapsed idx lock wait time", Long.class, 0, FORMAT.ELAP_TIME_DAY, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkbox", "width of detail boxes", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[0]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[1]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[2]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[3]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[4]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[5]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[6]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[7]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[8]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[9]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[10]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[11]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[12]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[13]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[14]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.LOCKS, "sctxlkdet[15]", "idx lock block time details", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "description", "optional text description", Character.class, 128, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctcurusr", "threads in use total\t(ctaddwork)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctmaxusr", "max threads in use   (ctaddwork)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.MISC, "scti_svvr", "internal version number (hover to decode)", Integer.class, 0, FORMAT.INTHEX, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sctioblkretry", "I/O error auto retry count", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sct_compflg4", "4th compatibility word", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.MEMORY, "sct_dxscan", "avail scan cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.MEMORY, "sct_dxscancnt", "actual scan cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.MEMORY, "sct_dxscanhgh", "maximum scan cache pages", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.DATIDX, "sct_hbTbuf", "index hash bin Threshold", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.DATIDX, "sct_hbRbuf", "index hash bin Reset limit", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.DATIDX, "sct_hbTcac", "data hash bin Threshold", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.DATIDX, "sct_hbRcac", "data hash bin Reset limit", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.INTERNAL, "sct_diagflg3", "3rd diagnostic flag", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.INTERNAL, "sctmldmsec", "MAX_LOG_DEFER_SEC (in msecs)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.LOGS, "sarplogint", "auto restore point log interval", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sarptimout", "auto restore point tran timeout", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctdatflschk", "data cache tran log checks", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctdatfls", "data cache tran log flush rqst", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctmldfls", "MAX LOG DEFER log flush rqst", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sarpoptions", "auto restore point options", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sarplastlog", "auto restore point last log written", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdfls0", "data cache flush count (non TRNLOG)", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntifls0", "index buffer flush count (non TRNLOG)", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdlmt0", "data file flush time limit (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntilmt0", "index flush time limit (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdage0", "oldest dirty data page (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntiage0", "oldest dirty index buffer (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdbkt0", "data file flush buckets (nominal) (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdbkc0", "data file flush buckets (current) (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntibkt0", "index flush buckets (nominal) (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntibkc0", "data file flush buckets (current) (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdmax0", "max dirty time for non-tran dat page (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntimax0", "max dirty time for non-tran idx bufr (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdMsec0", "defer time after data flush (msec) (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdFlsh0", "# of data flushes before deferring (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntiMsec0", "defer time after index flush (msec) (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntiFlsh0", "# of index flushes before deferring (non TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdfls1", "data cache flush count (TRNLOG)", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntifls1", "index buffer flush count (TRNLOG)", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdlmt1", "data file flush time limit (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntilmt1", "index flush time limit (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdage1", "oldest dirty data page (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntiage1", "oldest dirty index buffer (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdbkt1", "data file flush buckets (nominal) (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdbkc1", "data file flush buckets (current) (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntibkt1", "index flush buckets (nominal) (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntibkc1", "data file flush buckets (current) (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdmax1", "max dirty time for non-tran dat page (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntimax1", "max dirty time for non-tran idx bufr (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdMsec1", "defer time after data flush (msec) (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntdFlsh1", "# of data flushes before deferring (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntiMsec1", "defer time after index flush (msec) (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.TRANS, "sctntiFlsh1", "# of index flushes before deferring (TRNLOG)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.FILE_OPERATIONS, "sphyopncnt", "number of physical file opens", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.FILE_OPERATIONS, "sphyclscnt", "number of physical file closes", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.FILE_OPERATIONS, "slogopncnt", "number of logical file opens", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.FILE_OPERATIONS, "slogclscnt", "number of logical file closes", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.FILE_OPERATIONS, "sfilcrecnt", "number of file creates", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.FILE_OPERATIONS, "sfilrencnt", "number of file renames", Long.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.FILE_OPERATIONS, "sfildelcnt", "number of file deletes", Long.class, 0, FORMAT.INTDEC, true, false, false));
        } else if (cOUNTERS_TYPE == COUNTERS_TYPE.SQL_SNAPSHOT) {
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "client_ver", "client version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "server_ver", "server version of structure", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "fixlen", "length of fixed portion of snapshot", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "varlen", "length of variable region (if any)", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "contents", "bit map of var len contents", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "unused", "available for use", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "snapshottm", "snapshot time stamp: seconds since 70", Long.class, 0, FORMAT.DATE, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctmemhgh", "SQL memory highwater mark", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctmemsum", "current aggregate sum", Long.class, 0, FORMAT.INTDEC, false, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctdscrqs", "dynamic statement cache requests", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctdschit", "dynamic statement cache hits", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctsscrqs", "static statement cache requests", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctsschit", "static statement cache hits", Long.class, 0, FORMAT.INTDEC, true, true, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctmemcnt", "current net SQL memory allocations", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctdsctot", "current dynamic stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctdschgh", "highest dynamic stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctdscmax", "maximum dynamic stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctssctot", "current static stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, true));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctsschgh", "highest static stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.SQLS, "sctsscmax", "maximum static stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "sflvr", "server byte order", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "salgn", "server alignment", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.INTERNAL, "spntr", "server pointer size", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "availt", "available for use", Character.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctdyn", "current number of dynamic caches", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctsta", "current number of static caches", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctloc", "current number of local caches", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctlsctot", "current local stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctlschgh", "highest local stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctlscmax", "maximum local stmt cache entries", Integer.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctlscrqs", "local statement cache requests", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctlschit", "local statement cache hits", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctidxonly", "Tuple fetches by index only scan", Long.class, 0, FORMAT.INTDEC, false, false, false));
            this.counters.add(new Counter(this.cType, COUNTER_CATEGORY.SQLS, "sctidxrec", "Tuple fetches by index scan with record retrival", Long.class, 0, FORMAT.INTDEC, false, false, false));
        } else if (cOUNTERS_TYPE == COUNTERS_TYPE.IO_PERF) {
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DataBufferRequests", "DataBufferRequests", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DataBufferHits", "DataBufferHits", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "IndexBufferRequests", "IndexBufferRequests", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "IndexBufferHits", "IndexBufferHits", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrReadOperations", "NbrReadOperations", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrBytesRead", "NbrBytesRead", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrWriteOperations", "NbrWriteOperations", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrBytesWritten", "NbrBytesWritten", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrCommReadOperations", "NbrCommReadOperations", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrCommBytesRead", "NbrCommBytesRead", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrCommWriteOperations", "NbrCommWriteOperations", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrCommBytesWritten", "NbrCommBytesWritten", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrTranSavepoint", "NbrTranSavepoint", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrTranRestores", "NbrTranRestores", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrTranBegins", "NbrTranBegins", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrTranEnds", "NbrTranEnds", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrTranAborts", "NbrTranAborts", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrCheckPoints", "NbrCheckPoints", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SystemTimeValue", "SystemTimeValue", Integer.class, 0, FORMAT.DATE, false, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrSyncDosFlush", "NbrSyncDosFlush", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrSyncLogFile", "NbrSyncLogFile", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NbrSyncCtreeFile", "NbrSyncCtreeFile", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Not Implemented", "Not Implemented", Integer.class, 0, FORMAT.INTDEC, true, false, false));
        } else if (cOUNTERS_TYPE == COUNTERS_TYPE.FUNCTIONS) {
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "Totals", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PUTFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "UPDCURI", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LKISAM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ALCSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CHGSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CLISAM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "STPUSR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRESET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CLSFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANEND", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANRST", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANABT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANCLR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CLRFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELRFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ALCBAT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CHGBAT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FREBAT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PERFORM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "USERLIST", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "USERINFO", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTKLUSR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTTESTFUNC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CHGICON", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CLSICON", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTFLUSH", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTCHKPNT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANABTX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CHGHST", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FREHST", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SAVPCLR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TESTHUGE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctRENFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "UPDCIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETFLTR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ADDUSR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ADDREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RWTREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NXTREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRSREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LSTREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RRDREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NXTSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRVSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETALTSEQ", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETALTSEQ", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETDEFBLKX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "MIDSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PUTDODAX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETVARBYTS", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRSVSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LSTVSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "MIDVSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANRDY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SYSMON", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "WRTVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RDVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "REDREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "WRTREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETCURI", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RETREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RETVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "reset_cur", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETCURI", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "EQLVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GTEVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LTEVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GTVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LTVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETMNAME", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETNAM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETSEG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETMAP", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SECURITY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SYSLOG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRSSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LSTSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "EQLREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GTEREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LTEREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GTREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LTREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "REDIREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "STPUSRA", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CHGUSR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CREISAM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "OPNISAM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANISO", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RBLIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CREIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CLIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "OPNIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRMIIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TMPIIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PUTIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CMPIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "EXPIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RBLIIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NXTVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRVVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRSVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LSTVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NXTVSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRVVSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "INTREE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "INTISAM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETFLTRN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RESETFLTR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RENIFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETNODE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "UNDOFLEX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSETSEG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctLOKDMP", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RWTPREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ADDVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RWTVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "REDVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELRES", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ENARES", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "UPDRES", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ADDRES", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PUTCRES", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "?? 128 ??", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PTADMIN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ADDKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LOADKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELCHK", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FREBATN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRESETN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FREHSTN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETOPS", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRERNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRSRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRSVRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CREDAT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CREIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CREMEM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctDROPIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LSTRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LSTVRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NXTRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NXTVRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRVRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRVVRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GTEKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GTKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LTKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LTEKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DELBLD", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "EQLKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRSKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LSTKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETCURP", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NEWREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DATENT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "IDXENT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SERIALNUM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANBEG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NXTKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PRVKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETRES", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTDIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctDISTINCTest", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTUSER", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SEPLNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTUSERX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTSQLCTL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTSRVCTL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctDISTINCTset", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTUSERX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctImpersonateTask", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "?? 178 ??", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "?? 179 ??", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GTVLEN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETVLEN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETIFILX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETDODAX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETCRES", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETCIDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "?? 186 ??", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOTSENT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TFRMKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETCURK", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETCURKL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "BATSETX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTSBLDX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TSTVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "COMMBUF", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SQR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "OPNRFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TMPNAME", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DYNDMP", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "FRCKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "AVLFILNUM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "OPNFIL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "BATSET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "LOKREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ESTKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NEWVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANSAV", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANBAK", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETFNDVAL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "IOPERFORMANCE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CLNIDXX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RNGENT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ORDKEY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "OPNICON", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SYSCFG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PUTHDR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CUST_LOGON", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CUST_LOGOFF", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CUST_OPC1", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CUST_OPC2", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CUST_OPC3", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CUST_OPC4", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTHIST", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "IOPERFORMANCEX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "REDIVREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "reset_cur2", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTSCRIPT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSETENCRYPT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SESSVAL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SESSINC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SPCLSAV", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOFUNCT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOFUNCT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOFUNCT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOFUNCT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOFUNCT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOFUNCT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_MAKE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_OPEN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_CLOSE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_WRITE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_READ", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_START", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_NEXTPREV", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_REWDEL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_DELETE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_UNLOCK", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_VERSION", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_SQLINFO", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_SQLLINK", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "RTG_COPY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DUMMY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DUMMY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DUMMY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "DUMMY", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "NOFUNCSEP", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "PUTKSEGDEF", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETKSEGDEF", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "XFMKSEGDEF", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctunic", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "GETXCREBLK", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTFLUSHX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "CTASYNC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctksegswpchk", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSNAPSHOT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSYSPUT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctCLSNAM", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSysQueueOpen", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSysQueueClose", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSysQueueWrite", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSysQueueLIFOWrite", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSysQueueRead", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSysQueueMlen", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSysQueueCount", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctNotify", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ALCRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "BLKIREC", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "TRANUSR", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctReplSetPosByLogPos", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctReplSetPosByTime", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctReplGetFileName", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctReplGetNextChange", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctReplPersistMinLog", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "SETCBRBL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctFILMTX", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctLOKLST", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctFILBLK", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSETCFG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctFILWCD", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctQUIET", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctLOKTIMOUT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctUPDTICU", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctGetOpenFiles", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctGetFileUsers", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctGetFileLocks", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctGetFileLocks", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctLOKDYN", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctReplAgentOp", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctTransferFile", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ESTRNG", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSEQUENCE", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctMASTERCTL", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctDISTINCTestXtd", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctDISTINCTsetXtd", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctVERIFYidx", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "addIDfield", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "delIDfield", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "getIDfield", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "resetIDfield", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "wchIDfield", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctMEMSTAT", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
            this.counters.add(new Counter(cOUNTERS_TYPE, COUNTER_CATEGORY.NONE, "ctSETCOMPRESS", "", Integer.class, 0, FORMAT.INTDEC, true, false, false));
        }
    }

    private void initializeCountersTypes() {
        countersTypes.add(new CounterType(COUNTERS_TYPE.CONN_USERS, "Connected Users", false));
        countersTypes.add(new CounterType(COUNTERS_TYPE.FILE_SNAPSHOT, "File Snapshot", false));
        countersTypes.add(new CounterType(COUNTERS_TYPE.FUNCTIONS, "Function Stats", false));
        countersTypes.add(new CounterType(COUNTERS_TYPE.IO_PERF, "IO Performances", false));
        countersTypes.add(new CounterType(COUNTERS_TYPE.SQL_SNAPSHOT, "Sql Snapshot", true));
        countersTypes.add(new CounterType(COUNTERS_TYPE.SYSTEM_CONFIG, "System Config", false));
        countersTypes.add(new CounterType(COUNTERS_TYPE.SYSTEM_SNAPSHOT, "System Snapshot", true));
        countersTypes.add(new CounterType(COUNTERS_TYPE.USER_SNAPSHOT, "User Snapshot", true));
    }

    private void initializeCategories() {
        categories.add(new Category(COUNTER_CATEGORY.NONE, "", false));
        categories.add(new Category(COUNTER_CATEGORY.RW, "Read / Write", true));
        categories.add(new Category(COUNTER_CATEGORY.LOCKS, "Locks", true));
        categories.add(new Category(COUNTER_CATEGORY.MISC, "Miscellaneous", true));
        categories.add(new Category(COUNTER_CATEGORY.LOGS, "Logs", true));
        categories.add(new Category(COUNTER_CATEGORY.DATIDX, "Data / Index", true));
        categories.add(new Category(COUNTER_CATEGORY.TRANS, "Transactions", true));
        categories.add(new Category(COUNTER_CATEGORY.NO_TRANS, "Non Transactions", true));
        categories.add(new Category(COUNTER_CATEGORY.SYNC, "Sync / Flush", true));
        categories.add(new Category(COUNTER_CATEGORY.ISAM, "Isam Operations", true));
        categories.add(new Category(COUNTER_CATEGORY.MEMORY, "Memory", true));
        categories.add(new Category(COUNTER_CATEGORY.INTERNAL, "Internal", true));
        categories.add(new Category(COUNTER_CATEGORY.SQLS, "Sql Cache", true));
        categories.add(new Category(COUNTER_CATEGORY.DYN_SYS_RES, "Dynamic System Resources", true));
        categories.add(new Category(COUNTER_CATEGORY.SRV_IMPL, "Server Implementations", true));
        categories.add(new Category(COUNTER_CATEGORY.COMP_TIME, "Static Compile-Time Values", true));
        categories.add(new Category(COUNTER_CATEGORY.APP, "Client and Server Versions", true));
        categories.add(new Category(COUNTER_CATEGORY.CONFIG, "Configuration Bitmaps", true));
        categories.add(new Category(COUNTER_CATEGORY.FEATURE, "Feature Bitmaps", true));
        categories.add(new Category(COUNTER_CATEGORY.STATS, "Cache and Buffer Statistics", true));
        categories.add(new Category(COUNTER_CATEGORY.VERSION, "Version Information", true));
        categories.add(new Category(COUNTER_CATEGORY.BROADCAST, "Broadcast", true));
        categories.add(new Category(COUNTER_CATEGORY.CACHE, "Cache", true));
        categories.add(new Category(COUNTER_CATEGORY.CONNECTIONS, "Connections / Logons", true));
        categories.add(new Category(COUNTER_CATEGORY.FILE_OPERATIONS, "File Operations", true));
    }

    public COUNTERS_TYPE getType() {
        return this.cType;
    }

    public ERROR getError() {
        return this.error;
    }

    public ArrayList<String> getUsersTaskId() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.session != null) {
            short[] sArray = new short[8193];
            if (this.session != null) {
                short s = this.session.GetUserList(sArray);
                if (sArray != null) {
                    Short s2 = 1;
                    while (s2 <= sArray[0] && s2 < 8193) {
                        Structures.MUSRPRF mUSRPRF = this.session.GetUserInfo(sArray[s2]);
                        if (mUSRPRF.utaskid == sArray[s2]) {
                            arrayList.add(Short.valueOf(mUSRPRF.utaskid).toString());
                        }
                        Short s3 = s2;
                        Short s4 = s2 = Short.valueOf((short)(s2 + 1));
                    }
                }
            }
        } else {
            this.error = ERROR.INVALID_SESSION;
        }
        return arrayList;
    }

    public Counter getCounter(String string) {
        for (int i = 0; i < this.counters.size(); ++i) {
            Counter counter = this.counters.get(i);
            if (!counter.getName().equals(string)) continue;
            return counter;
        }
        return null;
    }

    public USER_INFO getUserInfo(String string) {
        USER_INFO uSER_INFO = new USER_INFO();
        if (this.session != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
            short s = Short.parseShort(string);
            uSER_INFO.TaskId = s;
            Structures.MUSRPRF mUSRPRF = this.session.GetUserInfo(s);
            uSER_INFO.TaskId = s;
            uSER_INFO.ActiveRequestIndicator = mUSRPRF.uactflg;
            try {
                uSER_INFO.Name = mUSRPRF.uname;
                uSER_INFO.CommInfo = mUSRPRF.ucominfo;
                uSER_INFO.LastFunctionName = mUSRPRF.urqst;
                uSER_INFO.UserMemory = mUSRPRF.umemsum;
                String string2 = CtreeMonitor.DateFromTicks((int)mUSRPRF.ulogtim);
                uSER_INFO.LogonTime = simpleDateFormat.parse(string2);
                string2 = CtreeMonitor.DateFromTicks((int)mUSRPRF.ucurtim);
                uSER_INFO.CurrentTime = simpleDateFormat.parse(string2);
                string2 = CtreeMonitor.DateFromTicks((int)mUSRPRF.urqstim);
                uSER_INFO.TimeOfLastRequest = simpleDateFormat.parse(string2);
                string2 = CtreeMonitor.DateFromTicks((int)mUSRPRF.utrntim);
                uSER_INFO.TimeOfLastTranBeg = simpleDateFormat.parse(string2);
                uSER_INFO.NumberOfOpenFiles = mUSRPRF.unbrfil;
                uSER_INFO.LastFunctionNumber = mUSRPRF.urqstfn;
                uSER_INFO.NodeIdInfo = mUSRPRF.unodnam;
            }
            catch (Exception exception) {}
        } else {
            this.error = ERROR.INVALID_SESSION;
        }
        return uSER_INFO;
    }

    public boolean isFunctionTimingActive() {
        Structures.GSMS gSMS = this.session.GetSystemSnapshot();
        if (gSMS != null) {
            long l = gSMS.sflvr != clientByteOrder ? (long)CtreeMonitor.RevInt32((int)gSMS.sct_diagflg) : (long)gSMS.sct_diagflg;
            return (l & 0x10000000L) != 0L;
        }
        return false;
    }

    public void startFunctionTiming() {
        if (!this.isFunctionTimingActive()) {
            this.session.StartFunctionTiming();
        }
    }

    public void stopFunctionTiming() {
        if (this.isFunctionTimingActive()) {
            this.session.StopFunctionTiming();
        }
    }

    public void clearFunctionTiming() {
        if (!this.isFunctionTimingActive()) {
            this.session.ClearFunctionTiming();
        }
    }

    public void clear() {
        for (Counter counter : this.counters) {
            counter.clear();
        }
    }

    public boolean isServerActive() {
        if (this.session != null) {
            short s = this.session.KeepAlive();
            return s == 0;
        }
        this.error = ERROR.INVALID_SESSION;
        return false;
    }

    public void setSession(CtreeMonitor ctreeMonitor) {
        this.session = ctreeMonitor;
    }

    public ERROR update() {
        return this.update(null);
    }

    public ERROR update(String string) {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis();
        long l2 = this.previousUpdateTime.getTimeInMillis();
        Long l3 = l - l2;
        this.refreshInterval = l3.intValue() / 1000;
        if (this.refreshInterval < 1) {
            this.refreshInterval = 1;
        }
        this.previousUpdateTime = calendar;
        if (this.session != null) {
            if (this.cType == COUNTERS_TYPE.SYSTEM_CONFIG) {
                int[] nArray = new int[Enums.SYSCFG.ctCFGLMT.value];
                this.session.SysCfg(nArray);
                for (Counter counter : this.counters) {
                    int n = counter.getArrIndex();
                    long l4 = counter.getBitMask();
                    if (l4 > 0L) {
                        long l5 = nArray[n];
                        counter.setValue(Double.valueOf(l5 &= l4), this.revertBytes, scthrtimbas, this.refreshInterval);
                        continue;
                    }
                    counter.setValue(Double.valueOf(nArray[n]), this.revertBytes, scthrtimbas, this.refreshInterval);
                }
            } else if (this.cType == COUNTERS_TYPE.SYSTEM_SNAPSHOT) {
                Structures.GSMS gSMS = this.session.GetSystemSnapshot();
                if (gSMS != null) {
                    this.revertBytes = gSMS.sflvr != clientByteOrder;
                    scthrtimbas = this.revertBytes ? CtreeMonitor.RevInt64((long)gSMS.scthrtimbas) : gSMS.scthrtimbas;
                    if (scthrtimbas == 0L) {
                        scthrtimbas = 1L;
                    }
                    boolean bl = false;
                    for (Counter counter : this.counters) {
                        counter.setGSMSValue(gSMS, this.revertBytes, scthrtimbas, this.refreshInterval);
                    }
                }
            } else if (this.cType == COUNTERS_TYPE.USER_SNAPSHOT) {
                Structures.GUMS gUMS = string == null ? this.session.GetUserSnapshot() : this.session.GetUserSnapshotByTaskId(string);
                if (gUMS != null) {
                    this.revertBytes = gUMS.sflvr != clientByteOrder;
                    scthrtimbas = this.revertBytes ? CtreeMonitor.RevInt64((long)gUMS.scthrtimbas) : gUMS.scthrtimbas;
                    if (scthrtimbas == 0L) {
                        scthrtimbas = 1L;
                    }
                    for (Counter counter : this.counters) {
                        counter.setGUMSValue(gUMS, this.revertBytes, scthrtimbas, this.refreshInterval);
                    }
                }
            } else if (this.cType == COUNTERS_TYPE.FILE_SNAPSHOT) {
                Structures.GFMS gFMS = this.session.GetFileSnapshot(string);
                if (gFMS != null) {
                    this.revertBytes = gFMS.sflvr == 1;
                    scthrtimbas = this.revertBytes ? CtreeMonitor.RevInt64((long)gFMS.scthrtimbas) : gFMS.scthrtimbas;
                    if (scthrtimbas == 0L) {
                        scthrtimbas = 1L;
                    }
                    for (Counter counter : this.counters) {
                        counter.setGFMSValue(gFMS, this.revertBytes, scthrtimbas, this.refreshInterval);
                    }
                }
            } else if (this.cType == COUNTERS_TYPE.SQL_SNAPSHOT) {
                Structures.SQLS sQLS = this.session.GetSqlSnapshot();
                if (sQLS != null) {
                    this.revertBytes = sQLS.sflvr == 1;
                    if (scthrtimbas == 0L) {
                        scthrtimbas = 1L;
                    }
                    for (Counter counter : this.counters) {
                        counter.setSQLSValue(sQLS, this.revertBytes, scthrtimbas, this.refreshInterval);
                    }
                }
            } else if (this.cType == COUNTERS_TYPE.IO_PERF) {
                int[] nArray = new int[this.IP_PERF_CNTS];
                this.session.IOPerformanceX(nArray);
                int n = 0;
                for (Counter counter : this.counters) {
                    long l6;
                    if ((l6 = (long)nArray[n++]) < 0L) {
                        l6 &= 0xFFFFFFFFL;
                    }
                    counter.setValue(Double.valueOf(l6), this.revertBytes, scthrtimbas, this.refreshInterval);
                }
            } else if (this.cType == COUNTERS_TYPE.FUNCTIONS) {
                Structures.GSMS gSMS = this.session.GetSystemSnapshot();
                this.revertBytes = gSMS.sflvr != clientByteOrder;
                scthrtimbas = this.revertBytes ? CtreeMonitor.RevInt64((long)gSMS.scthrtimbas) : gSMS.scthrtimbas;
                if (scthrtimbas == 0L) {
                    scthrtimbas = 1L;
                }
                Structures.WRKSTT[] wRKSTTArray = this.session.GetFunctionsSnapshot();
                int n = this.revertBytes ? CtreeMonitor.RevInt32((int)wRKSTTArray[0].cnt) : wRKSTTArray[0].cnt;
                for (int i = 0; i <= n; ++i) {
                    try {
                        int n2 = this.revertBytes ? CtreeMonitor.RevInt32((int)wRKSTTArray[i].fnc) : wRKSTTArray[i].fnc;
                        if (n2 < 256 ? n2 > this.counters.size() : n2 < 512 && n2 > this.counters.size()) break;
                        double d = wRKSTTArray[i].cnt;
                        this.counters.get(n2).setValue(d, this.revertBytes, scthrtimbas, this.refreshInterval);
                        Long l7 = this.revertBytes ? Long.valueOf(CtreeMonitor.RevInt64((long)wRKSTTArray[i].tim)) : Long.valueOf(wRKSTTArray[i].tim);
                        Double d2 = 0.0;
                        try {
                            d2 = l7.doubleValue() / (double)scthrtimbas;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.counters.get(n2).setFunctionTotalElapsedTime(d2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (i < this.counters.size()) {
                        continue;
                    }
                    break;
                }
            }
            return ERROR.NO_ERROR;
        }
        this.error = ERROR.INVALID_SESSION;
        return ERROR.INVALID_SESSION;
    }

    public class USER_INFO {
        public int TaskId;
        public int ActiveRequestIndicator;
        public String Name;
        public String CommInfo;
        public String LastFunctionName;
        public long UserMemory;
        public Date LogonTime;
        public Date CurrentTime;
        public Date TimeOfLastRequest;
        public Date TimeOfLastTranBeg;
        public int NumberOfOpenFiles;
        public int LastFunctionNumber;
        public String NodeIdInfo;
    }

    public static enum SYSCFG_IDX {
        cfgFILES,
        cfgUSERS,
        cfgIDX_MEMORY,
        cfgDAT_MEMORY,
        cfgTOT_MEMORY,
        cfgUSR_MEMORY,
        cfgPREIMAGE_FILE,
        cfgPAGE_SIZE,
        cfgCOMMIT_DELAY_USEC,
        cfgLOG_SPACE,
        cfgLOG_EVEN,
        cfgLOG_ODD,
        cfgSTART_EVEN,
        cfgSTART_ODD,
        cfgSERVER_DIRECTORY,
        cfgLOCAL_DIRECTORY,
        cfgSERVER_NAME,
        cfgDUMP,
        cfgSQL_DATABASE,
        cfgKEEP_LOGS,
        cfgCOMM_PROTOCOL,
        cfgMPAGE_CACHE,
        cfgLIST_MEMORY,
        cfgSORT_MEMORY,
        cfgBUFR_MEMORY,
        cfgPREIMAGE_HASH,
        cfgLOCK_HASH,
        cfgUSR_MEM_RULE,
        cfgGUEST_MEMORY,
        cfgQUERY_MEMORY,
        cfgTRAN_TIMEOUT,
        cfgMAX_DAT_KEY,
        cfgBUFFER_RUNLENGTH,
        cfgSEMAPHORE_BLK,
        cfgSESSION_TIMEOUT,
        cfgTASKER_SLEEP,
        cfgFILE_HANDLES,
        cfgMEMORY_MONITOR,
        cfgTASKER_PC,
        cfgTASKER_SP,
        cfgTASKER_NP,
        cfgNODE_DELAY,
        cfgDEADLOCK_MONITOR,
        cfgNODEQ_MONITOR,
        cfgCOMMIT_DELAY,
        cfgCHECKPOINT_MONITOR,
        cfgNODEQ_SEARCH,
        cfgMAX_KEY_SEG,
        cfgFUNCTION_MONITOR,
        cfgTASKER_LOOP,
        cfgREQUEST_DELAY,
        cfgREQUEST_DELTA,
        cfg9074_MONITOR,
        cfg9477_MONITOR,
        cfgSKIP_MISSING_FILES,
        cfgTMPNAME_PATH,
        cfgLOG_EVEN_MIRROR,
        cfgLOG_ODD_MIRROR,
        cfgSTART_EVEN_MIRROR,
        cfgSTART_ODD_MIRROR,
        cfgADMIN_MIRROR,
        cfgSKIP_MISSING_MIRRORS,
        cfgCOMMENTS,
        cfgMIRRORS,
        cfg749X_MONITOR,
        cfgCOMPATIBILITY,
        cfgDIAGNOSTICS,
        cfgCONTEXT_HASH,
        cfgGUEST_LOGON,
        cfgTRANSACTION_FLUSH,
        cfgCHECKPOINT_FLUSH,
        cfgLOCK_MONITOR,
        cfgMEMORY_TRACK,
        cfgSUPPRESS_LOG_FLUSH,
        cfgPREIMAGE_DUMP,
        cfgRECOVER_MEMLOG,
        cfgRECOVER_DETAILS,
        cfgCHECKPOINT_INTERVAL,
        cfgRECOVER_SKIPCLEAN,
        cfgSIGNAL_READY,
        cfgSIGNAL_MIRROR_EVENT,
        cfgCHECKPOINT_IDLE,
        cfgSIGNAL_DOWN,
        cfgFORCE_LOGIDX,
        cfgCHECKPOINT_PREVIOUS,
        cfgTRAN_HIGH_MARK,
        cfgCTSTATUS_MASK,
        cfgCTSTATUS_SIZE,
        cfgMONITOR_MASK,
        cfgRECOVER_FILES,
        cfgSYNC_DELAY,
        cfgDIAGNOSTIC_INT,
        cfgDIAGNOSTIC_STR,
        cfgMAX_VIRTUAL_FILES,
        cfgFIXED_LOG_SIZE,
        cfgLANGUAGE,
        cfgMAX_FILES_PER_USER,
        cfgLOG_ENCRYPT,
        cfgCONSOLE,
        cfgSKIP_MISSING_LOG_MIRRORS,
        cfgCONNECTIONS,
        cfgNULL_STRING,
        cfgLOGON_FAIL_LIMIT,
        cfgLOGON_FAIL_TIME,
        cfgADMIN_ENCRYPT,
        cfgDISK_FULL_LIMIT,
        cfgDISK_FULL_VOLUME,
        cfgSESSCHG_ENABLE,
        cfgADMIN_WORD,
        cfgADMIN_KEY,
        cfgSYSLOG,
        cfgLOGON_MUST_TIME,
        cfgBROADCAST_PORT,
        cfgBROADCAST_DATA,
        cfgBROADCAST_INTERVAL,
        cfgLMT_MEMORY,
        cfgMIRROR_DIRECTORY,
        cfgCTSRVR_CFG,
        cfgCACHE_LINE,
        cfgSYSVIEW_WHAT,
        cfgSYSVIEW_WHEN,
        cfgDEAD_CLIENT_INTERVAL,
        cfgSERVER_SDK,
        cfgSTARTUP_BLOCK_LOGONS,
        cfgPROCESS_PRIORITY,
        cfgSQL_PORT,
        cfgLAST,
        cfg127,
        cfgDISKIO_MODEL,
        cfgTRANPROC,
        cfgRESOURCE,
        cfgCTBATCH,
        cfgCTSUPER,
        cfgFUTURE1,
        cfgVARLDATA,
        cfgVARLKEYS,
        cfgPARMFILE,
        cfgRTREE,
        cfgCTS_ISAM,
        cfgBOUND,
        cfgNOGLOBALS,
        cfgPROTOTYPE,
        cfgPASCALst,
        cfgPASCAL24,
        cfgWORD_ORDER,
        cfgFUTURE2,
        cfgUNIFRMAT,
        cfgLOCLIB,
        cfgANSI,
        cfgFILE_SPECS,
        cfgPATH_SEPARATOR,
        cfgLOGIDX,
        cfgHISTORY,
        cfgCONDIDX,
        cfgSRV_MODEL,
        cfg155,
        cfg156,
        cfg157,
        cfg158,
        cfg159,
        cfg160,
        cfgTRANPROCapp,
        cfgRESOURCEapp,
        cfgCTBATCHapp,
        cfgCTSUPERapp,
        cfgFUTURE1app,
        cfgVARLDATAapp,
        cfgVARLKEYSapp,
        cfgPARMFILEapp,
        cfgRTREEapp,
        cfgCTS_ISAMapp,
        cfgTHREADapp,
        cfgINIT_CTREEapp,
        cfgPROTOTYPEapp,
        cfgPASCALstapp,
        cfgPASCAL24app,
        cfgWORD_ORDERapp,
        cfgFUTURE2app,
        cfgANSIapp,
        cfgPATH_SEPARATORapp,
        cfgLOGIDXapp,
        cfgHISTORYapp,
        cfgCONDIDXapp,
        cfgSERIALNBR,
        cfgVERSIONID,
        cfgPORTID,
        cfgMAX_CONNECT,
        cfgVERSIONID2,
        cfgVERSIONID_BASE,
        cfg189,
        cfg190,
        cfg191,
        cfgMEMORY_USAGE,
        cfgMEMORY_HIGH,
        cfgNET_ALLOCS,
        cfgDNODE_QLENGTH,
        cfgCHKPNT_QLENGTH,
        cfgSYSMON_QLENGTH,
        cfgMONAL1_QLENGTH,
        cfgMONAL2_QLENGTH,
        cfgLOGONS,
        cfgNET_LOCKS,
        cfgPHYSICAL_FILES,
        cfgOPEN_FILES,
        cfgOPEN_FCBS,
        cfgUSER_FILES,
        cfgUSER_MEMORY,
        cfgLOG_RECORD_LIMIT,
        cfgFEACHK,
        cfgMAX_LOGONS,
        cfgMAX_NET_LOCKS,
        cfgMAX_PHYSICAL_FILES,
        cfgMAX_OPEN_FILES,
        cfgMAX_OPEN_FCBS,
        cfgFLEX_FCBS,
        cfgSYSLOG_QLENGTH,
        cfgRSPACE_QLENGTH,
        cfgCACHE_PAGES,
        cfgCACHE_PAGES_INUSE,
        cfgCACHE_PAGES_MXUSE,
        cfgCACHE_PAGES_DED,
        cfgCACHE_PAGES_DEDINUSE,
        cfgCACHE_PAGES_DEDMXUSE,
        cfgBUFFER_PAGES,
        cfgBUFFER_PAGES_INUSE,
        cfgBUFFER_PAGES_MXUSE,
        cfgMAX_CLIENT_NODES,
        cfgMAX_CONN_PER_NODE,
        cfgLOCAL_CONN_ONLY,
        cfgPROCESS_ID,
        cfgCOUNTED_LOGONS,
        cfgCFGCHK,
        cfgCACHE_STAT_ARRAY_SIZE,
        cfgDATA_LRU_LISTS,
        cfgINDEX_LRU_LISTS,
        cfgMEMORY_HASH,
        cfgCACHE_PAGES_SCN,
        cfgCACHE_PAGES_SCNINUSE,
        cfgCACHE_PAGES_SCNMXUSE,
        cfgFEACHK2,
        DUMMY;

    }

    public static enum FORMAT {
        CHAR,
        INTDEC,
        INTHEX,
        INTHEX_NO_PREFIX,
        DATE,
        ELAP_TIME_DAY,
        ELAP_TIME_SEC,
        ELAP_TIME_MSEC,
        VERSION_ID,
        PORT_ID,
        IP_ADDRESS,
        IP6_ADDRESS,
        VERSION_ID2,
        VERSIONID_BASE,
        YES_NO;

    }

    public static enum COUNTER_CATEGORY {
        NONE,
        RW,
        LOCKS,
        MISC,
        LOGS,
        DATIDX,
        TRANS,
        NO_TRANS,
        SYNC,
        ISAM,
        MEMORY,
        INTERNAL,
        SQLS,
        DYN_SYS_RES,
        SRV_IMPL,
        COMP_TIME,
        APP,
        CONFIG,
        FEATURE,
        STATS,
        VERSION,
        BROADCAST,
        CACHE,
        CONNECTIONS,
        FILE_OPERATIONS,
        SIZE_OF_CATEGORIES_ENUM;

    }

    public static enum COUNTERS_TYPE {
        SYSTEM_CONFIG,
        SYSTEM_SNAPSHOT,
        USER_SNAPSHOT,
        FILE_SNAPSHOT,
        CONN_USERS,
        IO_PERF,
        FUNCTIONS,
        SQL_SNAPSHOT;

    }

    public static enum ERROR {
        NO_ERROR(0),
        LOST_CONNECTION(1),
        INVALID_SESSION(-1);

        public final int value;

        private ERROR(int n2) {
            this.value = n2;
        }

        public short value() {
            return (short)this.value;
        }
    }
}

