/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.CtreeACEExplorerView;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppProperties {
    public String lookAndFeel = "System";
    public String sqlServerNameOrAddress = "localhost";
    public int sqlServerPort = 6597;
    public String sqlUserPassword = "ADMIN";
    public String sqlDatabase = "ctreeSQL";
    public String sqlUserName = "ADMIN";
    public boolean sqlAutoCommit = true;
    public int sqlIsolationLevel = 1;
    public int sqlQueryTimeOut = 0;
    public boolean sqlAutoConnect;
    public boolean sqlRememberPassword;
    public boolean sqlAllowMultiple;
    public String isamHostNameOrAddress = "localhost";
    public String isamServerName = "FAIRCOMS";
    public int isamServerPort = 6597;
    public boolean isamUseServerPort;
    public String isamUserPassword = "ADMIN";
    public String isamUserName = "ADMIN";
    public String callBackLib = "";
    public boolean isamAutoConnect;
    public boolean isamRememberPassword;
    public boolean isamAllowMultiple;
    public boolean sqlAskForPlan;
    public boolean useMachineLocale = true;
    public boolean sqlInputBoxExpaned = false;
    public int maxCharsInColumns = 256;
    public Rectangle bounds;
    Properties applicationProps = new Properties();

    public void loadProperties() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("./c-treeACEExplorer.cfg");
            this.applicationProps.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(CtreeACEExplorerView.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(CtreeACEExplorerView.class.getName()).log(Level.SEVERE, null, iOException);
        }
        if (!this.applicationProps.isEmpty()) {
            String string = this.applicationProps.getProperty("bounds");
            if (string != null) {
                String[] stringArray = string.split(",");
                this.bounds = new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
            }
            if ((string = this.applicationProps.getProperty("sqlAllowMultipleConnect")) != null) {
                boolean bl = this.sqlAllowMultiple = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("sqlAutoConnect")) != null) {
                boolean bl = this.sqlAutoConnect = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("isamAllowMultipleConnect")) != null) {
                boolean bl = this.isamAllowMultiple = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("isamAutoConnect")) != null) {
                boolean bl = this.isamAutoConnect = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("lookAndFeel")) != null) {
                this.lookAndFeel = string;
            }
            if ((string = this.applicationProps.getProperty("callBackLib")) != null) {
                this.callBackLib = string;
            }
            if ((string = this.applicationProps.getProperty("sqlAutoCommit")) != null) {
                boolean bl = this.sqlAutoCommit = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("sqlIsolationLevel", "1")) != null) {
                this.sqlIsolationLevel = Integer.parseInt(string);
            }
            if ((string = this.applicationProps.getProperty("sqlAskForPlan")) != null) {
                boolean bl = this.sqlAskForPlan = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("useMachineLocale")) != null) {
                boolean bl = this.useMachineLocale = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("sqlInputBoxExpaned")) != null) {
                boolean bl = this.sqlInputBoxExpaned = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("maxCharsInColumns")) != null) {
                this.maxCharsInColumns = Integer.parseInt(string);
            }
        }
    }

    public void saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("./c-treeACEExplorer.cfg");
            if (this.bounds != null) {
                this.applicationProps.setProperty("bounds", Integer.toString(this.bounds.x) + "," + Integer.toString(this.bounds.y) + "," + Integer.toString(this.bounds.width) + "," + Integer.toString(this.bounds.height));
            }
            this.applicationProps.setProperty("sqlAllowMultipleConnect", this.sqlAllowMultiple ? "true" : "false");
            this.applicationProps.setProperty("sqlAutoConnect", this.sqlAutoConnect ? "true" : "false");
            this.applicationProps.setProperty("isamAllowMultipleConnect", this.isamAllowMultiple ? "true" : "false");
            this.applicationProps.setProperty("isamAutoConnect", this.isamAutoConnect ? "true" : "false");
            if (this.lookAndFeel != null) {
                this.applicationProps.setProperty("lookAndFeel", this.lookAndFeel);
            }
            if (this.callBackLib != null) {
                this.applicationProps.setProperty("callBackLib", this.callBackLib);
            }
            this.applicationProps.setProperty("sqlAutoCommit", this.sqlAutoCommit ? "true" : "false");
            this.applicationProps.setProperty("sqlIsolationLevel", Integer.toString(this.sqlIsolationLevel));
            this.applicationProps.setProperty("sqlAskForPlan", this.sqlAskForPlan ? "true" : "false");
            this.applicationProps.setProperty("useMachineLocale", this.useMachineLocale ? "true" : "false");
            this.applicationProps.setProperty("sqlInputBoxExpaned", this.sqlInputBoxExpaned ? "true" : "false");
            this.applicationProps.setProperty("maxCharsInColumns", Integer.toString(this.maxCharsInColumns));
            this.applicationProps.store(fileOutputStream, "---c-treeACEExplorer---");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(CtreeACEExplorerView.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(CtreeACEExplorerView.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }
}

