/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ISAM_MODE;
import ctreeaceexplorer.sql.SQL_MODE;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DbTableDialog
extends JDialog {
    ISAM_MODE isamMode;
    SQL_MODE sqlMode;
    JFileChooser fc = new JFileChooser();
    FileNameExtensionFilter filter;
    boolean okClicked;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField nameTB;
    private JButton okButton;
    private JTextField pathTB;
    private JLabel warningLabel;

    public DbTableDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.nameTB = new JTextField();
        this.pathTB = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.browseButton = new JButton();
        this.warningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Database");
        this.setResizable(false);
        this.jPanel1.setName("jPanel1");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbTableDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbTableDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(91, 91, 91).addComponent(this.okButton, -2, 72, -2).addGap(48, 48, 48).addComponent(this.cancelButton, -2, 75, -2).addContainerGap(101, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameTB.setName("nameTB");
        this.pathTB.setName("pathTB");
        this.jLabel1.setText("Name :");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText("Path :");
        this.jLabel2.setName("jLabel2");
        this.browseButton.setText("...");
        this.browseButton.setName("browseButton");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbTableDialog.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.warningLabel.setText("( Leave \"Path\" empty to use default directory )");
        this.warningLabel.setName("warningLabel");
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(16, 16, 16).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pathTB, -1, 255, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.nameTB, -2, 207, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, 24, -2))).addGap(64, 64, 64)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGap(21, 21, 21).addComponent(this.warningLabel).addContainerGap(141, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGap(26, 26, 26).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTB, -2, -1, -2).addComponent(this.browseButton).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.pathTB, -2, -1, -2)).addGap(16, 16, 16).addComponent(this.warningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (Globals.appMode) {
            switch (this.sqlMode) {
                case DATABASE_CREATE: {
                    try {
                        Globals.currentSqlConnection.createDatabase(this.nameTB.getText());
                        Globals.currentSqlConnection.commit();
                    }
                    catch (SQLException sQLException) {
                        Globals.showException(sQLException, "Create Database");
                    }
                    break;
                }
                case DATABASE_ADD: {
                    String string = this.nameTB.getText();
                    if (string.endsWith(".fdd")) {
                        string = string.substring(0, string.length() - 4);
                    }
                    Globals.currentSqlConnection.addDatabase(string);
                    Globals.currentSqlConnection.commit();
                }
            }
        } else {
            switch (this.isamMode) {
                case DB_CREATE: {
                    Globals.currentIsamConnection.createDatabase(this.nameTB.getText(), this.pathTB.getText());
                    break;
                }
                case DB_ADD: {
                    Globals.currentIsamConnection.addDatabase(this.nameTB.getText(), this.pathTB.getText());
                    break;
                }
                case DB_DROP: {
                    Globals.currentIsamConnection.dropDatabase(this.nameTB.getText());
                    Globals.currentIsamConnection.setDatabaseName("");
                    break;
                }
                case DB_DELETE: {
                    Globals.currentIsamConnection.deleteDatabase(this.nameTB.getText());
                    break;
                }
                case TABLE_ADD: {
                    Globals.currentIsamConnection.addTable(this.nameTB.getText(), this.pathTB.getText());
                    break;
                }
                case TABLE_DROP: {
                    Globals.currentIsamConnection.dropTable(this.nameTB.getText());
                    break;
                }
                case TABLE_DELETE: {
                    Globals.currentIsamConnection.deleteTable(this.nameTB.getText());
                }
            }
        }
        this.okClicked = true;
        this.setVisible(false);
    }

    public String getTableName() {
        return this.nameTB.getText();
    }

    public String getTablePath() {
        return this.pathTB.getText();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.okClicked = false;
        this.setVisible(false);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        this.fc.setFileSelectionMode(0);
        this.fc.setFileFilter(this.filter);
        this.fc.setCurrentDirectory(new File(Globals.execDir));
        int n = this.fc.showOpenDialog(jFrame);
        if (n == 0) {
            File file = this.fc.getSelectedFile();
            this.nameTB.setText(file.getName());
            this.pathTB.setText(this.fc.getCurrentDirectory().getAbsolutePath());
        }
    }

    public boolean showDialog(ISAM_MODE iSAM_MODE, String string) {
        this.isamMode = iSAM_MODE;
        switch (iSAM_MODE) {
            case DB_CREATE: {
                this.setTitle("Create Database");
                this.pathTB.setEditable(false);
                this.browseButton.setEnabled(false);
                this.filter = new FileNameExtensionFilter("Database files (.fdd)", "fdd");
                break;
            }
            case DB_ADD: {
                this.setTitle("Add Database");
                this.filter = new FileNameExtensionFilter("Database files (.fdd)", "fdd");
                break;
            }
            case DB_DROP: {
                this.nameTB.setEnabled(false);
                this.pathTB.setEditable(false);
                this.nameTB.setText(string);
                this.browseButton.setEnabled(false);
                this.warningLabel.setText(null);
                this.setTitle("Drop Database");
                break;
            }
            case DB_DELETE: {
                this.nameTB.setEnabled(false);
                this.pathTB.setEditable(false);
                this.nameTB.setText(string);
                this.browseButton.setEnabled(false);
                this.warningLabel.setText("Warning: This action deletes the Database file from disk");
                this.setTitle("Delete Database");
                break;
            }
            case TABLE_ADD: {
                this.setTitle("Add Table");
                this.filter = new FileNameExtensionFilter("Table files (.dat)", "dat");
                break;
            }
            case TABLE_DROP: {
                this.nameTB.setEnabled(false);
                this.pathTB.setEditable(false);
                this.nameTB.setText(string);
                this.browseButton.setEnabled(false);
                this.warningLabel.setText(null);
                this.setTitle("Drop Table");
                break;
            }
            case TABLE_DELETE: {
                this.nameTB.setEnabled(false);
                this.pathTB.setEditable(false);
                this.nameTB.setText(string);
                this.browseButton.setEnabled(false);
                this.warningLabel.setText("Warning: This action deletes the Table file from disk");
                this.setTitle("Delete Table");
                break;
            }
            case OPEN_EXTERNAL: {
                this.warningLabel.setVisible(false);
                this.setTitle("Open External Table");
                this.filter = new FileNameExtensionFilter("Table files (.dat)", "dat");
                this.browseButton.setEnabled(true);
                if (string == null) break;
                this.pathTB.setEditable(false);
                this.nameTB.setText(string);
            }
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
        return this.okClicked;
    }

    public void showDialog(SQL_MODE sQL_MODE, String string) {
        this.sqlMode = sQL_MODE;
        switch (sQL_MODE) {
            case DATABASE_CREATE: {
                this.setTitle("Create Database");
                this.pathTB.setEditable(false);
                this.browseButton.setEnabled(false);
                this.filter = new FileNameExtensionFilter("Database files (.fdd)", "fdd");
                break;
            }
            case DATABASE_ADD: {
                this.setTitle("Add Database");
                this.pathTB.setEditable(false);
                this.filter = new FileNameExtensionFilter("Database files (.fdd)", "fdd");
            }
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }
}

