/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.AddTableDialog;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ISAM_MODE;
import ctreeaceexplorer.IsamTree;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.TREE_OBJECT;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JTree
implements TreeSelectionListener {
    protected MyTreeNode rootNode;
    protected DefaultTreeModel myTreeModel;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected Color foregroundColor = null;
    protected boolean comboMode = false;
    private TreeTransferHandler transferHandle = new TreeTransferHandler();
    private SELECTION_MODE selectionMode = SELECTION_MODE.STANDARD;
    private Object dropTarget;

    public DynamicTree(CtreeACEExplorerView ctreeACEExplorerView) {
        this.rootNode = new MyTreeNode("Root Node", this);
        this.myTreeModel = new DefaultTreeModel(this.rootNode);
        this.myTreeModel.addTreeModelListener(new MyTreeModelListener());
        this.setModel(this.myTreeModel);
        this.setEditable(false);
        this.setRowHeight(18);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(8);
        basicTreeUI.setLeftChildIndent(8);
        this.setCellRenderer(new CheckRenderer());
        this.addMouseListener(new NodeSelectionListener(this));
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(this);
        this.setTransferHandler(this.transferHandle);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.myTreeModel.reload();
    }

    public void clearNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.removeAllChildren();
        this.myTreeModel.reload(defaultMutableTreeNode);
    }

    public void setComboMode(boolean bl) {
        this.comboMode = bl;
        this.setVisible(false);
        this.setVisible(true);
    }

    public void setSelectionMode(SELECTION_MODE sELECTION_MODE) {
        this.selectionMode = sELECTION_MODE;
    }

    public SELECTION_MODE getSelectionMode() {
        return this.selectionMode;
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.myTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            return;
        }
        this.toolkit.beep();
    }

    public MyTreeNode addObject(MyTreeNode myTreeNode) {
        MyTreeNode myTreeNode2 = null;
        TreePath treePath = this.getSelectionPath();
        myTreeNode2 = treePath == null ? this.rootNode : (MyTreeNode)treePath.getLastPathComponent();
        return this.addObject(myTreeNode2, myTreeNode, true);
    }

    public MyTreeNode addObject(MyTreeNode myTreeNode, MyTreeNode myTreeNode2) {
        return this.addObject(myTreeNode, myTreeNode2, false);
    }

    public MyTreeNode addObject(MyTreeNode myTreeNode, MyTreeNode myTreeNode2, boolean bl) {
        if (myTreeNode == null) {
            myTreeNode = this.rootNode;
        }
        this.myTreeModel.insertNodeInto(myTreeNode2, myTreeNode, myTreeNode.getChildCount());
        if (bl) {
            this.scrollPathToVisible(new TreePath(myTreeNode2.getPath()));
        }
        return myTreeNode2;
    }

    public void expandNode() {
        this.expandPath(new TreePath(this.rootNode.getPath()));
    }

    public void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    class TreeTransferHandler
    extends TransferHandler {
        TreeTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            Object object;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                object = transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            List list = null;
            if (object instanceof List) {
                list = (List)object;
            }
            File file = (File)list.get(0);
            String string = file.getPath();
            Component component = transferSupport.getComponent();
            if (component instanceof IsamTree) {
                IsamTree isamTree = (IsamTree)component;
                if (DynamicTree.this.dropTarget != null) {
                    AddTableDialog addTableDialog = new AddTableDialog((Frame)Globals.appFrame.getFrame(), true);
                    addTableDialog.setLocationRelativeTo(Globals.appFrame.getFrame());
                    Rectangle rectangle = addTableDialog.getBounds();
                    addTableDialog.setLocation(rectangle.x, rectangle.y - 150);
                    addTableDialog.showDialog(ISAM_MODE.TABLE_ADD, string);
                } else {
                    CtreeACEExplorerView ctreeACEExplorerView = (CtreeACEExplorerView)CtreeACEExplorerApp.getApplication().getMainView();
                    ctreeACEExplorerView.openExternal(string);
                }
                isamTree.refresh();
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            Component component = transferSupport.getComponent();
            if (component instanceof IsamTree) {
                JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
                TreePath treePath = dropLocation.getPath();
                if (treePath != null) {
                    MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
                    if (myTreeNode.getType() == TREE_OBJECT.DATABASE) {
                        DynamicTree.this.dropTarget = myTreeNode;
                        return true;
                    }
                    return false;
                }
                DynamicTree.this.dropTarget = null;
                return true;
            }
            return false;
        }
    }

    class CheckRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JCheckBox check;
        protected TreeLabel label;
        MyTreeNode node = null;

        public CheckRenderer() {
            this.setLayout(null);
            this.check = new JCheckBox();
            this.add(this.check);
            this.label = new TreeLabel();
            this.add(this.label);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.setEnabled(jTree.isEnabled());
            this.setOpaque(false);
            this.node = (MyTreeNode)object;
            if (DynamicTree.this.comboMode && this.node.showCheckBox) {
                this.check.setVisible(true);
                this.check.setSelected(this.node.isChecked());
            } else {
                this.check.setVisible(false);
            }
            this.label.setFont(jTree.getFont());
            this.label.setText(string);
            this.label.setSelected(bl);
            this.label.setFocus(bl4);
            if (bl) {
                if (Globals.os.toLowerCase().startsWith("win")) {
                    this.label.setForeground(Color.WHITE);
                }
            } else if (DynamicTree.this.foregroundColor != null) {
                this.label.setForeground(DynamicTree.this.foregroundColor);
            } else {
                this.label.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            this.label.setIcon(((MyTreeNode)object).leafIcon);
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.label.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.label.getPreferredSize();
            int n = 0;
            int n2 = 0;
            if (dimension.height < dimension2.height) {
                n = (dimension2.height - dimension.height) / 2;
            } else {
                n2 = (dimension.height - dimension2.height) / 2;
            }
            this.check.setBounds(-3, n - 2, dimension.width, dimension.height);
            if (DynamicTree.this.comboMode && this.node != null && this.node.showCheckBox) {
                this.label.setBounds(dimension.width, n2, dimension2.width, dimension2.height);
            } else {
                this.label.setBounds(1, n2, dimension2.width, dimension2.height);
            }
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public class TreeLabel
        extends JLabel {
            boolean isSelected;
            boolean hasFocus;

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void paint(Graphics graphics) {
                String string = this.getText();
                if (string != null && 0 < string.length()) {
                    if (this.isSelected) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        graphics.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension dimension = this.getPreferredSize();
                    int n = 0;
                    Icon icon = this.getIcon();
                    if (icon != null) {
                        n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    graphics.fillRect(n, 0, dimension.width - 1 - n, dimension.height);
                    if (this.hasFocus) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    }
                }
                super.paint(graphics);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension != null) {
                    dimension = new Dimension(dimension.width + 3, dimension.height + 5);
                }
                return dimension;
            }

            public void setSelected(boolean bl) {
                this.isSelected = bl;
            }

            public void setFocus(boolean bl) {
                this.hasFocus = bl;
            }
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null) {
                MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
                Rectangle rectangle = this.tree.getPathBounds(treePath);
                if (mouseEvent.getX() >= rectangle.x && mouseEvent.getX() < rectangle.x + 15) {
                    boolean bl = !myTreeNode.isChecked();
                    myTreeNode.setChecked(bl);
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(myTreeNode);
                this.tree.revalidate();
                this.tree.repaint();
            }
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            int n = treeModelEvent.getChildIndices()[0];
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    public static enum SELECTION_MODE {
        STANDARD,
        SELECT_UPPER,
        NO_SELECT_LOWER;

    }
}

