/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import FairCom.CtreeDb.CTException;
import ctreeaceexplorer.AppProperties;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.EXIT_CODE;
import ctreeaceexplorer.IsamConnection;
import ctreeaceexplorer.sql.SqlConnection;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Globals {
    public static String execDir = "";
    public static String os = "";
    public static AppProperties appProps = new AppProperties();
    public static SqlConnection currentSqlConnection;
    public static IsamConnection currentIsamConnection;
    public static Set<SqlConnection> sqlConnections;
    public static Set<IsamConnection> isamConnections;
    public static final boolean SQL = true;
    public static final boolean ISAM = false;
    public static boolean sqlMultipleConnections;
    public static boolean isamMultipleConnections;
    public static boolean sqlTreeNodeChanged;
    public static boolean isamTreeNodeChanged;
    public static boolean isDBA;
    public static boolean hasResource;
    public static boolean appMode;
    public static boolean sqlConnected;
    public static boolean isamConnected;
    public static boolean isamShowDebugColumns;
    public static boolean isamTableLoading;
    public static boolean isamExportMode;
    public static int isamOpenMode;
    public static CtreeACEExplorerView appFrame;
    public static String[] args;
    public static boolean advancedMode;
    public static boolean sqlMultiSelectMode;
    public static boolean isamMultiSelectMode;
    public static boolean openRaw;
    public static Boolean stopFetching;
    public static UIManager.LookAndFeelInfo[] lfInfo;

    public static void showException(Throwable throwable, String string, boolean bl) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = "A %s application error occurred. Please contact FairCom with the following information:\n\n";
        string2 = String.format(string2, jFrame.getTitle());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(throwable.toString()).append("\n");
        int n = 15;
        if (bl) {
            n = stackTraceElementArray.length;
        }
        int n2 = stackTraceElementArray.length;
        for (int i = 0; i < n2 && i < n; ++i) {
            stringBuffer.append(stackTraceElementArray[i].getFileName()).append(":").append(stackTraceElementArray[i].getLineNumber());
            stringBuffer.append(">> ").append(stackTraceElementArray[i].getMethodName()).append("()\n");
        }
        Object[] objectArray = null;
        objectArray = bl ? new Object[]{"Close", "Copy to Clipboard"} : new Object[]{"Close", "Copy to Clipboard", "Full StackTrace"};
        n2 = JOptionPane.showOptionDialog(jFrame, stringBuffer, "Program Exception", 0, 0, null, objectArray, objectArray[0]);
        if (n2 == 2) {
            Globals.showException(throwable, string, true);
        } else if (n2 == 1) {
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
            Globals.showException(throwable, string, bl);
        }
        System.exit(1);
    }

    public static void showExceptionWithStmt(SQLException sQLException, String string, String string2) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, "Error # : " + sQLException.getErrorCode() + "\n\nError Description : " + sQLException.getMessage() + "\n\nStatement :\n " + string2, string, 0);
    }

    public static void showException(SQLException sQLException, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, "Error # : " + sQLException.getErrorCode() + "\n\nError Description : " + sQLException.getMessage(), string, 0);
    }

    public static void showException(SQLException sQLException, String string, String string2) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, "Error # : " + sQLException.getErrorCode() + "\n\nError Description : " + sQLException.getMessage() + "\n\n" + string, string2, 0);
    }

    public static void showException(CTException cTException, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        long l = cTException.GetErrorCode();
        String string2 = cTException.GetErrorMsg();
        if (l == 401L || l == 408L || l == 438L) {
            string2 = string2 + "\n\nThis table does not have the required schema meta-data\n to allow its use with this utility";
        }
        JOptionPane.showMessageDialog(jFrame, "\nError # : " + l + "\nError Description : " + string2, string, 0);
    }

    public static void showException(Exception exception, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, "\n\nError Description : " + exception.getMessage(), string, 0);
    }

    public static void showException(Error error, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, "\n\nError Description : " + error.getMessage(), string, 0);
    }

    public static EXIT_CODE showAbortRetryException(SQLException sQLException, String string, String string2) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        Object[] objectArray = new Object[]{"Retry", "Abort", "Reload"};
        int n = JOptionPane.showOptionDialog(jFrame, "Error # : " + sQLException.getErrorCode() + "\nError Description : " + sQLException.getMessage() + "\n\nExtra Info :\n" + string, string2, 0, 0, null, objectArray, objectArray[0]);
        if (n == 0) {
            return EXIT_CODE.RETRY;
        }
        if (n == 1) {
            return EXIT_CODE.ABORT;
        }
        return EXIT_CODE.RELOAD;
    }

    public static EXIT_CODE showAbortRetryException(CTException cTException, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        Object[] objectArray = new Object[]{"Retry", "Abort", "Reload"};
        int n = JOptionPane.showOptionDialog(jFrame, "Error # : " + cTException.GetErrorCode() + "\nError Description : " + cTException.GetErrorMsg(), string, 0, 0, null, objectArray, objectArray[0]);
        if (n == 0) {
            return EXIT_CODE.RETRY;
        }
        if (n == 1) {
            return EXIT_CODE.ABORT;
        }
        return EXIT_CODE.RELOAD;
    }

    public static void showMessage(String string, String string2) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, string, string2, 0);
    }

    public static void showWarningMessage(String string, String string2) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, string, string2, 2);
    }

    public static void showOKMessage(String string, String string2) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(jFrame, string, string2, 1);
    }

    public static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    public static String singleQuote(String string) {
        return "'" + string + "'";
    }

    public static ImageIcon getIcon(String string) {
        URL uRL = CtreeACEExplorerView.class.getResource("images/" + string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public static void ShowWaitCursor() {
        appFrame.getComponent().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void ShowNormalCursor() {
        appFrame.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public static void setLookAndFeel(JFrame jFrame) {
        String string = null;
        if (jFrame == null) {
            lfInfo = UIManager.getInstalledLookAndFeels();
        }
        if (Globals.appProps.lookAndFeel.equals("System")) {
            string = UIManager.getSystemLookAndFeelClassName();
        } else {
            for (int i = 0; i < lfInfo.length; ++i) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = lfInfo[i];
                String string2 = lookAndFeelInfo.getName();
                if (!string2.equals(Globals.appProps.lookAndFeel)) continue;
                string = lookAndFeelInfo.getClassName();
                break;
            }
        }
        if (string == null) {
            Globals.showMessage("Invalid Look & Feel", "Error");
            return;
        }
        try {
            UIManager.setLookAndFeel(string);
            if (jFrame != null) {
                SwingUtilities.updateComponentTreeUI(jFrame);
                jFrame.pack();
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Globals.showMessage("Invalid Look & Feel", "Invalid Look & Feel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Globals.showMessage("Class not found : " + classNotFoundException.getLocalizedMessage(), "Invalid Look & Feel");
        }
        catch (InstantiationException instantiationException) {
            Globals.showException(instantiationException, "Invalid Look & Feel");
        }
        catch (IllegalAccessException illegalAccessException) {
            Globals.showException(illegalAccessException, "Invalid Look & Feel");
        }
    }

    static {
        sqlConnections = new HashSet<SqlConnection>();
        isamConnections = new HashSet<IsamConnection>();
        sqlMultipleConnections = false;
        isamMultipleConnections = false;
        isamOpenMode = 0;
        advancedMode = false;
        stopFetching = false;
    }
}

