/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;

public class ImageViewer
extends JDialog {
    Image image = null;
    Image originalImage = null;
    Image scaledImage = null;
    ImagePanel imgPanel;
    double zoom = 1.0;
    private JButton CloseButton;
    private JButton autoSizeBT;
    private JLabel imgData;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton realSizeBT;
    private JButton zoomInBT;
    private JButton zoomOutBT;

    public ImageViewer(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.CloseButton = new JButton();
        this.realSizeBT = new JButton();
        this.autoSizeBT = new JButton();
        this.zoomInBT = new JButton();
        this.zoomOutBT = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.imgData = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Column : ");
        this.jPanel2.setBorder(new LineBorder(new Color(204, 204, 204), 1, true));
        this.jPanel2.setName("jPanel2");
        this.CloseButton.setMnemonic('C');
        this.CloseButton.setText("Close");
        this.CloseButton.setName("CloseButton");
        this.CloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.CloseButtonActionPerformed(actionEvent);
            }
        });
        this.realSizeBT.setMnemonic('R');
        this.realSizeBT.setText("Real Size");
        this.realSizeBT.setName("realSizeBT");
        this.realSizeBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.realSizeBTActionPerformed(actionEvent);
            }
        });
        this.autoSizeBT.setMnemonic('A');
        this.autoSizeBT.setText("AutoSize");
        this.autoSizeBT.setName("autoSizeBT");
        this.autoSizeBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.autoSizeBTActionPerformed(actionEvent);
            }
        });
        this.zoomInBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/ZoomIn.png")));
        this.zoomInBT.setMnemonic('I');
        this.zoomInBT.setName("zoomInBT");
        this.zoomInBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.zoomInBTActionPerformed(actionEvent);
            }
        });
        this.zoomOutBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/ZoomOut.png")));
        this.zoomOutBT.setMnemonic('O');
        this.zoomOutBT.setName("zoomOutBT");
        this.zoomOutBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.zoomOutBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap(212, Short.MAX_VALUE).addComponent(this.realSizeBT).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zoomOutBT, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zoomInBT, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSizeBT).addGap(80, 80, 80).addComponent(this.CloseButton).addGap(55, 55, 55)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.realSizeBT).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoSizeBT, -1, -1, Short.MAX_VALUE).addComponent(this.CloseButton, -1, -1, Short.MAX_VALUE)).addComponent(this.zoomInBT, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.zoomOutBT, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setName("jScrollPane1");
        this.jPanel1.setBorder(new LineBorder(new Color(204, 204, 204), 1, true));
        this.jPanel1.setName("jPanel1");
        this.imgData.setText("Image Data :");
        this.imgData.setName("imgData");
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.imgData).addContainerGap(551, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.imgData).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 626, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addComponent(this.jScrollPane1, -2, 405, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void CloseButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void autoSizeBTActionPerformed(ActionEvent actionEvent) {
        this.realSizeBT.setEnabled(true);
        this.autoSizeBT.setEnabled(false);
        this.zoom = 1.0;
        int n = this.jScrollPane1.getWidth() - 5;
        int n2 = this.jScrollPane1.getHeight() - 5;
        this.imgPanel = new ImagePanel(n, n2);
        this.jScrollPane1.setViewportView(this.imgPanel);
        this.scaledImage = this.image = this.originalImage.getScaledInstance(-1, n2, 4);
    }

    private void zoomInBTActionPerformed() {
        this.realSizeBT.setEnabled(true);
        this.autoSizeBT.setEnabled(true);
        this.zoom += 0.1;
        int n = this.scaledImage.getHeight(null);
        this.image = this.scaledImage.getScaledInstance(-1, (int)((double)n * this.zoom), 4);
        int n2 = this.image.getWidth(null);
        n = this.image.getHeight(null);
        this.imgPanel = new ImagePanel(n2, n);
        this.jScrollPane1.setViewportView(this.imgPanel);
    }

    private void zoomInBTActionPerformed(ActionEvent actionEvent) {
        this.zoomInBTActionPerformed();
    }

    private void zoomOutBTActionPerformed() {
        this.realSizeBT.setEnabled(true);
        this.autoSizeBT.setEnabled(true);
        this.zoom -= 0.1;
        int n = (int)((double)this.scaledImage.getHeight(null) * this.zoom);
        if (n > 0) {
            this.image = this.scaledImage.getScaledInstance(-1, n, 4);
        } else {
            this.zoom += 0.2;
        }
        int n2 = this.image.getWidth(null);
        n = this.image.getHeight(null);
        this.imgPanel = new ImagePanel(n2, n);
        this.jScrollPane1.setViewportView(this.imgPanel);
    }

    private void zoomOutBTActionPerformed(ActionEvent actionEvent) {
        this.zoomOutBTActionPerformed();
    }

    private void realSizeBTActionPerformed(ActionEvent actionEvent) {
        this.realSizeBT.setEnabled(false);
        this.autoSizeBT.setEnabled(true);
        this.zoom = 1.0;
        this.scaledImage = this.image = this.originalImage;
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        this.imgPanel = new ImagePanel(n, n2);
        this.jScrollPane1.setViewportView(this.imgPanel);
    }

    public boolean showDialog(String string, byte[] byArray) {
        this.setTitle("Column : " + string);
        Globals.ShowWaitCursor();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.originalImage = this.image = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            Logger.getLogger(ImageViewer.class.getName()).log(Level.SEVERE, null, iOException);
        }
        if (this.image == null) {
            Globals.ShowNormalCursor();
            Globals.showMessage("Invalid or Unknown Format", "Image Viewer");
            return false;
        }
        ColorModel colorModel = ((BufferedImage)this.image).getColorModel();
        int n = colorModel.getPixelSize();
        int n2 = this.image.getWidth(null);
        int n3 = this.image.getHeight(null);
        this.imgData.setText("Image Data :  Width = " + n2 + "  -  Height = " + n3 + "  -  Pixel Format = " + n + " bits x pixel");
        int n4 = this.jScrollPane1.getWidth() - 5;
        int n5 = this.jScrollPane1.getHeight() - 5;
        this.scaledImage = this.image = this.image.getScaledInstance(-1, n5, 4);
        this.imgPanel = new ImagePanel(n4, n5);
        this.jScrollPane1.setViewportView(this.imgPanel);
        this.jScrollPane1.addMouseWheelListener(new WheelListener());
        Globals.ShowNormalCursor();
        this.autoSizeBT.setEnabled(false);
        this.getRootPane().setDefaultButton(this.CloseButton);
        this.setVisible(true);
        return true;
    }

    public class ImagePanel
    extends JPanel {
        public ImagePanel(int n, int n2) {
            this.setPreferredSize(new Dimension(n, n2));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(ImageViewer.this.image, this.getWidth() / 2 - ImageViewer.this.image.getWidth(null) / 2, this.getHeight() / 2 - ImageViewer.this.image.getHeight(null) / 2, null);
        }
    }

    public class WheelListener
    implements MouseWheelListener {
        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            int n2 = mouseWheelEvent.getModifiersEx();
            if ((n2 & 0x80) == 128) {
                if (n > 0) {
                    ImageViewer.this.zoomOutBTActionPerformed();
                } else if (n < 0) {
                    ImageViewer.this.zoomInBTActionPerformed();
                }
                mouseWheelEvent.consume();
            }
        }
    }
}

