/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ImportScriptDialog
extends JDialog {
    static String fileName;
    static String directoryName;
    JFrame mainFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
    BufferedWriter writer = null;
    boolean retOK = false;
    private JCheckBox appendCB;
    private JButton browseBTN;
    private JButton cancelButton;
    private JLabel fileLabel;
    private JTextField fileNameTB;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okButton;
    private JCheckBox openScriptCB;

    public ImportScriptDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    public boolean showDialog() {
        this.fileNameTB.setText(fileName);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
        return this.retOK;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public boolean getOpenScript() {
        return this.openScriptCB.isSelected();
    }

    public String getWriterFilename() {
        return fileName;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.openScriptCB = new JCheckBox();
        this.appendCB = new JCheckBox();
        this.fileLabel = new JLabel();
        this.fileNameTB = new JTextField();
        this.browseBTN = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Schema");
        this.setResizable(false);
        this.jPanel1.setName("jPanel1");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportScriptDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('E');
        this.cancelButton.setText("Exit");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportScriptDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(91, 91, 91).addComponent(this.okButton, -2, 75, -2).addGap(63, 63, 63).addComponent(this.cancelButton, -2, 76, -2).addContainerGap(100, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Output File"));
        this.jPanel2.setName("jPanel2");
        this.openScriptCB.setSelected(true);
        this.openScriptCB.setText("Open in \"Scripts\" pane when done");
        this.openScriptCB.setName("openScriptCB");
        this.openScriptCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ImportScriptDialog.this.openScriptCBItemStateChanged(itemEvent);
            }
        });
        this.appendCB.setText("Append To Output Fille");
        this.appendCB.setName("appendCB");
        this.fileLabel.setText("Output File :");
        this.fileLabel.setName("fileLabel");
        this.fileNameTB.setName("fileNameTB");
        this.browseBTN.setText("...");
        this.browseBTN.setName("browseBTN");
        this.browseBTN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportScriptDialog.this.browseBTNActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.appendCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 29, Short.MAX_VALUE).addComponent(this.openScriptCB)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.fileNameTB, -1, 322, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseBTN, -2, 25, -2)).addComponent(this.fileLabel)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openScriptCB).addComponent(this.appendCB)).addGap(18, 18, 18).addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameTB, -2, -1, -2).addComponent(this.browseBTN)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.fileNameTB.getText().isEmpty()) {
            Globals.showMessage("Please input a filename", "Error");
            return;
        }
        this.setWriter();
        this.retOK = true;
        this.setVisible(false);
    }

    private void setWriter() {
        String string;
        String string2 = string = this.fileNameTB.getText();
        boolean bl = this.appendCB.isSelected();
        if (!string2.contains(".s")) {
            string2 = string2 + ".sql";
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            FileWriter fileWriter = new FileWriter(string2, bl);
            fileName = string2;
            this.writer = new BufferedWriter(fileWriter);
        }
        catch (IOException iOException) {
            Globals.showException(iOException, "Export Schema");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void browseBTNActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("script files (*.sql)", "sql");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        fileName = Globals.execDir;
        jFileChooser.setCurrentDirectory(new File(fileName));
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showSaveDialog(this.mainFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            fileName = file.getAbsolutePath();
            this.fileNameTB.setText(fileName);
        }
    }

    private void openScriptCBItemStateChanged(ItemEvent itemEvent) {
    }
}

