/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.DynamicTree;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.ForeignServer;
import ctreeaceexplorer.sql.MySQLServer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TreeSelectionEvent;

public class ImportTree
extends DynamicTree {
    CtreeACEExplorerView appFrame;

    public ImportTree(CtreeACEExplorerView ctreeACEExplorerView) {
        super(ctreeACEExplorerView);
        this.appFrame = ctreeACEExplorerView;
        this.setComboMode(true);
        this.setSelectionMode(DynamicTree.SELECTION_MODE.SELECT_UPPER);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.valueChanged();
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void valueChanged() {
        MyTreeNode myTreeNode = (MyTreeNode)this.getLastSelectedPathComponent();
        if (myTreeNode != null) {
            switch (myTreeNode.getType()) {
                case DATABASE: {
                    if (myTreeNode.isUpdated()) break;
                    ForeignServer foreignServer = this.appFrame.importer.getSourceServer();
                    foreignServer.changeDb(myTreeNode.name);
                    this.clearNode(myTreeNode);
                    MyTreeNode myTreeNode2 = this.addObject(myTreeNode, new MyTreeNode("Tables", TREE_OBJECT.TABLES, true, this));
                    MyTreeNode myTreeNode3 = this.addObject(myTreeNode, new MyTreeNode("Views", TREE_OBJECT.TABLES, true, this));
                    MyTreeNode myTreeNode4 = null;
                    if (!(foreignServer instanceof MySQLServer)) {
                        myTreeNode4 = this.addObject(myTreeNode, new MyTreeNode("Synonyms", TREE_OBJECT.TABLES, true, this));
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                    ArrayList<String> arrayList2 = foreignServer.readServerTables(myTreeNode.name);
                    for (String arrayList3 : arrayList2) {
                        this.addObject(myTreeNode2, new MyTreeNode(arrayList3, TREE_OBJECT.TABLE, true, this));
                    }
                    ArrayList<String> arrayList4 = foreignServer.readServerViews(myTreeNode.name);
                    Iterator iterator = arrayList4.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        this.addObject(myTreeNode3, new MyTreeNode(string, TREE_OBJECT.VIEW, true, this));
                    }
                    if (foreignServer instanceof MySQLServer) break;
                    ArrayList<String> arrayList = foreignServer.readServerSynonyms(myTreeNode.name);
                    for (String string : arrayList) {
                        this.addObject(myTreeNode4, new MyTreeNode(string, TREE_OBJECT.SYNONYM, true, this));
                    }
                    break;
                }
            }
        }
    }
}

