/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTIndex;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTSegment;
import FairCom.CtreeDb.CTSession;
import FairCom.CtreeDb.CTTable;
import FairCom.Helper.Classes.CtreeServer;
import FairCom.Helper.Dialogs.ConnectDialog;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Field;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.Index;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.Segment;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class IsamConnection
extends CtreeServer {
    private String selectedUser;
    private MyTreeNode treeNode;
    private String dbEngine;
    private String indexName = "";
    private CTSession session = null;
    private CTDatabase db = null;
    private ArrayList<Field> fields = new ArrayList();
    private ArrayList<Index> indexes = new ArrayList();
    public boolean isExternalTable;

    public IsamConnection(boolean bl, String string, int n, String string2, boolean bl2, String string3, String string4, boolean bl3) {
        super(string, n, string2, bl2, string3, string4);
        this.isExternalTable = bl;
        this.connect(bl3);
    }

    public IsamConnection(boolean bl, CtreeServer ctreeServer, boolean bl2, boolean bl3) {
        super(ctreeServer);
        this.isExternalTable = bl;
        if (bl3) {
            this.connect(bl2);
        }
    }

    public void close() {
        if (this.session != null) {
            try {
                this.session.Logoff();
                this.session.UnLoadCallbackLib(false);
            }
            catch (CTException cTException) {
                Logger.getLogger(IsamConnection.class.getName()).log(Level.SEVERE, null, cTException);
            }
        }
    }

    private boolean connect(boolean bl) {
        Object[] objectArray;
        Object object2;
        if (bl || this.getPassword().isEmpty()) {
            object2 = CtreeACEExplorerApp.getApplication().getMainFrame();
            ConnectDialog object3 = new ConnectDialog((Frame)object2, true);
            object3.setLocationRelativeTo((Component)object2);
            objectArray = object3.showDialog((CtreeServer)this, false);
            if (!objectArray.booleanValue()) {
                return false;
            }
            if (object3.jComboBox1.getSelectedIndex() == 1) {
                this.setUseServerPort(true);
            } else {
                this.setUseServerPort(false);
            }
        }
        this.dbEngine = this.isUseServerPort() ? "#" + this.getServerPort() : this.getServerName();
        if (this.getHostNameOrAddress().length() > 0) {
            this.dbEngine = this.dbEngine + "@" + this.getHostNameOrAddress();
        }
        try {
            for (IsamConnection isamConnection : Globals.isamConnections) {
                if (isamConnection.dbEngine == null || !isamConnection.dbEngine.equals(this.dbEngine)) continue;
                this.session = isamConnection.session;
                break;
            }
            if (this.session == null || !this.session.IsActive()) {
                if (this.session == null) {
                    if (this.isExternalTable) {
                        this.session = new CTSession(1);
                        this.dbEngine = "FAIRCOMS";
                        this.setLoggedUser("ADMIN");
                        this.setPassword("ADMIN");
                    } else {
                        this.session = new CTSession(2);
                    }
                }
                if (!Globals.appProps.callBackLib.isEmpty()) {
                    this.session.LoadCallbackLib(Globals.appProps.callBackLib, "", true);
                }
                this.session.Logon(this.dbEngine, this.getLoggedUser(), this.getPassword());
                object2 = System.getenv("COMPUTERNAME");
                if (object2 == null) {
                    object2 = System.getenv("HOSTNAME");
                }
                if (object2 == null) {
                    object2 = "c-treeACE Explorer";
                }
                this.session.SetCurrentNodeName((String)object2);
                String string = this.getDatabaseName();
                if (!string.isEmpty()) {
                    this.connectDatabase(string);
                }
            }
            this.setConnected(true);
        }
        catch (CTException cTException) {
            if (cTException.GetErrorCode() == 12L) {
                JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                Toolkit.getDefaultToolkit().beep();
                objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(jFrame, "Session file not found !\n\nDo you want to create a new session file ?", "Error", 0, 1, null, objectArray, objectArray[0]);
                if (n == 0) {
                    try {
                        this.session.Create(this.dbEngine, this.getLoggedUser(), this.getPassword());
                        this.session.Logon(this.dbEngine, this.getLoggedUser(), this.getPassword());
                        String string = System.getenv("COMPUTERNAME");
                        if (string == null) {
                            string = System.getenv("HOSTNAME");
                        }
                        if (string == null) {
                            string = "c-treeACE Explorer";
                        }
                        this.session.SetCurrentNodeName(string);
                        this.setConnected(true);
                    }
                    catch (CTException cTException2) {
                        Globals.showException(cTException2, "CTSession create");
                    }
                }
            } else {
                Globals.showException(cTException, "CTSession connect");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
            objectArray = "32";
            String string = "64";
            String string2 = System.getProperty("os.arch");
            String string3 = unsatisfiedLinkError.getMessage();
            String string4 = "";
            if (string2.contains("64")) {
                objectArray = "64";
                string = "32";
            }
            if (jFrame != null) {
                Toolkit.getDefaultToolkit().beep();
                string4 = string3.contains("path") ? "mtclijni" + (String)objectArray + " library not found." : "Mismatch found between JVM version and mtclijni library.\n\nThe JVM is " + (String)objectArray + " bit while mtclijni is " + string + " bit.";
                string4 = string4 + "\n\nPlease install the appropriate version of the mtclijni library for your Java platform.";
                JOptionPane.showMessageDialog(jFrame, string4, "Application Error", 0);
            }
        }
        catch (Error error) {
            Globals.showException(error, "CTSession connect");
        }
        return false;
    }

    public void disconnect() {
        this.close();
        this.setConnected(false);
    }

    public String getServerId() {
        if (this.isUseServerPort()) {
            if (this.getHostNameOrAddress().length() > 0) {
                return this.getServerPort() + "@" + this.getHostNameOrAddress();
            }
            return this.getServerPort() + "";
        }
        if (this.getHostNameOrAddress().length() > 0) {
            return this.getServerName() + "@" + this.getHostNameOrAddress();
        }
        return this.getServerName();
    }

    public Object[] splitServerId(String string) {
        String[] stringArray = string.split("@");
        if (stringArray.length == 2) {
            String string2 = stringArray[1];
            String string3 = stringArray[0];
            if (this.isUseServerPort()) {
                int n = Integer.parseInt(string3.trim());
                return new Object[]{string2, n};
            }
            return new Object[]{string2, string3};
        }
        if (stringArray.length == 1) {
            String string4 = "";
            String string5 = stringArray[0];
            if (this.isUseServerPort()) {
                int n = Integer.parseInt(string5.trim());
                return new Object[]{string4, n};
            }
            return new Object[]{string4, string5};
        }
        return null;
    }

    public String getSelectedUser() {
        return this.selectedUser;
    }

    public void setSelectedUser(String string) {
        this.selectedUser = string;
    }

    public ArrayList<Object[]> readDatabases() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        StringBuffer stringBuffer = new StringBuffer(128);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        try {
            if (this.session.IsActive() && this.session.FirstDatabase(stringBuffer, stringBuffer2)) {
                do {
                    Object[] objectArray = new Object[]{stringBuffer.toString(), stringBuffer2.toString()};
                    arrayList.add(objectArray);
                } while (this.session.NextDatabase(stringBuffer, stringBuffer2));
            }
        }
        catch (CTException cTException) {
            Globals.showException(cTException, this.dbEngine);
        }
        return arrayList;
    }

    public ArrayList<Object[]> readTables(boolean bl) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        StringBuffer stringBuffer = new StringBuffer(128);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        try {
            if (this.getDb().FirstTable(stringBuffer, stringBuffer2)) {
                do {
                    if (stringBuffer2.toString().contains("SQL_SYS") != bl) continue;
                    Object[] objectArray = new Object[]{stringBuffer.toString(), stringBuffer2.toString()};
                    arrayList.add(objectArray);
                } while (this.getDb().NextTable(stringBuffer, stringBuffer2));
            }
        }
        catch (CTException cTException) {
            Globals.showException(cTException, this.dbEngine);
        }
        return arrayList;
    }

    public ArrayList<Object[]> readTableProperties(String string) {
        boolean bl = false;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        CTTable cTTable = null;
        try {
            String string2;
            if (string.equals("SessionFile")) {
                bl = true;
                cTTable = new CTTable(this.session);
                cTTable.Attach(2);
            } else if (string.equals("DatabaseFile")) {
                bl = true;
                cTTable = new CTTable(this.session);
                cTTable.Attach(8);
            } else if (this.isExternalTable) {
                cTTable = new CTTable(this.session);
                cTTable.SetPath(this.getHostNameOrAddress());
                cTTable.Open(string, Globals.isamOpenMode);
            } else {
                cTTable = new CTTable(this.getDb());
                cTTable.Open(string, Globals.isamOpenMode);
            }
            CTRecord cTRecord = new CTRecord(cTTable);
            Object[] objectArray = new Object[]{"Path", cTTable.GetPath()};
            arrayList.add(objectArray);
            try {
                string2 = Long.toString(cTRecord.GetRecordCount());
            }
            catch (CTException cTException) {
                string2 = "Unknown";
            }
            objectArray = new Object[]{"Number of Records", string2};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Datafile Extension", cTTable.GetDataExtension()};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Datafile Extent Size", Integer.toString(cTTable.GetDataDefaultExtentSize())};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Indexfile Extension", cTTable.GetIndexExtension()};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Indexfile Extent Size", Integer.toString(cTTable.GetIndexDefaultExtentSize())};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Record Length", Integer.toString(cTRecord.GetRecordLength())};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Pad Char", Integer.toString(cTTable.GetPadChar())};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Field Delimiter", Integer.toString(cTTable.GetDlmChar())};
            arrayList.add(objectArray);
            int n = cTTable.GetCreateMode();
            int n2 = n & 0x10;
            objectArray = new Object[]{"VLENGTH", n2 == 0 ? "No" : "Yes"};
            arrayList.add(objectArray);
            n2 = n & 1;
            objectArray = new Object[]{"PREIMG", n2 == 0 ? "No" : "Yes"};
            arrayList.add(objectArray);
            n2 = n & 2;
            objectArray = new Object[]{"TRNLOG", n2 == 0 ? "No" : "Yes"};
            arrayList.add(objectArray);
            n2 = n & 4;
            objectArray = new Object[]{"WRITETHRU", n2 == 0 ? "No" : "Yes"};
            arrayList.add(objectArray);
            n2 = n & 8;
            objectArray = new Object[]{"CHECKLOCK", n2 == 0 ? "No" : "Yes"};
            arrayList.add(objectArray);
            n2 = n & 0x80;
            objectArray = new Object[]{"CHECKREAD", n2 == 0 ? "No" : "Yes"};
            arrayList.add(objectArray);
            n2 = n & 0x100;
            objectArray = new Object[]{"HUGEFILE", n2 == 0 ? "No" : "Yes"};
            arrayList.add(objectArray);
            n2 = n & 0x20;
            objectArray = new Object[]{"NORECBYT", cTTable.HasRecbyt() ? "No" : "Yes"};
            arrayList.add(objectArray);
            objectArray = new Object[]{"NOROWID", cTTable.HasRowid() ? "No" : "Yes"};
            arrayList.add(objectArray);
            objectArray = new Object[]{"NODELFLD", cTTable.HasDelField() ? "No" : "Yes"};
            arrayList.add(objectArray);
            objectArray = new Object[]{"NONULFLD", cTTable.HasNullFieldSupport() ? "No" : "Yes"};
            arrayList.add(objectArray);
            objectArray = new Object[]{"Partitioned", cTTable.GetPartitionIndexNbr() >= 0 ? "Yes" : "No"};
            arrayList.add(objectArray);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "readTableProperties");
        }
        if (cTTable != null) {
            try {
                if (bl) {
                    cTTable.Detach();
                } else {
                    cTTable.Close();
                }
            }
            catch (CTException cTException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public ArrayList<Field> getTableFields() {
        return this.fields;
    }

    public ArrayList<Index> getTableIndexes() {
        return this.indexes;
    }

    public ArrayList<Segment> getIndexSegments(String string, String string2) {
        return this.readIndexSegments(string, string2);
    }

    public ArrayList<Field> readTableFields(String string) {
        boolean bl = false;
        this.fields.clear();
        CTTable cTTable = null;
        try {
            if (string.equals("SessionFile")) {
                bl = true;
                cTTable = new CTTable(this.session);
                cTTable.Attach(2);
            } else if (string.equals("DatabaseFile")) {
                bl = true;
                cTTable = new CTTable(this.session);
                cTTable.Attach(8);
            } else if (this.isExternalTable) {
                cTTable = new CTTable(this.session);
                cTTable.SetPath(this.getHostNameOrAddress());
                cTTable.Open(string, Globals.isamOpenMode);
            } else {
                cTTable = new CTTable(this.getDb());
                cTTable.Open(string, Globals.isamOpenMode);
            }
            CTRecord cTRecord = new CTRecord(cTTable);
            CTField cTField = null;
            try {
                cTRecord.First();
            }
            catch (CTException cTException) {
                // empty catch block
            }
            String string2 = cTTable.GetIdentityField();
            int n = cTTable.GetFieldCount();
            for (int i = 0; i < n; ++i) {
                Field field = new Field();
                cTField = cTTable.GetField(i);
                field.name = cTField.GetName();
                if (string2 != null && field.name.equals(string2)) {
                    field.isIdentity = true;
                    field.seed = cTTable.GetIdentityFieldSeed();
                    field.increment = cTTable.GetIdentityFieldIncrement();
                }
                field.type = cTField.GetType();
                field.length = cTField.GetLength();
                field.nullAllowed = !cTField.GetNullFlag();
                field.precision = cTField.GetPrecision();
                field.scale = cTField.GetScale();
                field.binFlag = cTField.GetFieldBinaryFlag();
                this.fields.add(field);
            }
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "readTableFiels");
        }
        if (cTTable != null) {
            try {
                if (bl) {
                    cTTable.Detach();
                } else {
                    cTTable.Close();
                }
            }
            catch (CTException cTException) {
                // empty catch block
            }
        }
        return this.fields;
    }

    public ArrayList<Index> readTableIndexes(String string) {
        boolean bl = false;
        this.indexes.clear();
        CTTable cTTable = null;
        try {
            if (string.equals("SessionFile")) {
                bl = true;
                cTTable = new CTTable(this.session);
                cTTable.Attach(2);
            } else if (string.equals("DatabaseFile")) {
                bl = true;
                cTTable = new CTTable(this.session);
                cTTable.Attach(8);
            } else if (this.isExternalTable) {
                cTTable = new CTTable(this.session);
                cTTable.SetPath(this.getHostNameOrAddress());
                cTTable.Open(string, Globals.isamOpenMode);
            } else {
                cTTable = new CTTable(this.getDb());
                cTTable.Open(string, Globals.isamOpenMode);
            }
            CTIndex cTIndex = new CTIndex();
            CTIndex cTIndex2 = new CTIndex();
            Boolean bl2 = false;
            if (cTTable.GetPartitionIndexNbr() > -1) {
                cTIndex2 = cTTable.GetIndex(cTTable.GetPartitionIndexNbr());
                bl2 = true;
            }
            int n = cTTable.GetIndexCount();
            for (int i = 0; i < n; ++i) {
                cTIndex = cTTable.GetIndex(i);
                Index index = new Index();
                index.name = cTIndex.GetName();
                index.fileName = cTIndex.GetFilename();
                index.type = cTIndex.GetKeyType();
                index.length = cTIndex.GetKeyLength();
                index.nullDisallowed = !cTIndex.GetNullFlag();
                boolean bl3 = index.dupDisallowed = !cTIndex.GetDuplicateFlag();
                if (!bl) {
                    index.condition = cTTable.GetCndxIndex(i);
                }
                index.segmentCount = cTIndex.GetSegmentCount();
                index.isPartition = bl2.booleanValue() ? cTIndex.GetName() == cTIndex2.GetName() : false;
                this.indexes.add(index);
            }
            if (cTTable.HasRecbyt()) {
                Index index = new Index();
                index.name = "Internal RECBYT Index";
                index.isInternal = true;
                this.indexes.add(index);
            }
            if (cTTable.HasRowid()) {
                Index index = new Index();
                index.name = "Internal ROWNUM Index";
                this.indexes.add(index);
                index.isInternal = true;
            }
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "readTablesIndexes");
        }
        if (cTTable != null) {
            try {
                if (bl) {
                    cTTable.Detach();
                } else {
                    cTTable.Close();
                }
            }
            catch (CTException cTException) {
                // empty catch block
            }
        }
        return this.indexes;
    }

    public ArrayList<Segment> readIndexSegments(String string, String string2) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        CTTable cTTable = null;
        if (string2.startsWith("Internal")) {
            return arrayList;
        }
        try {
            if (Globals.currentIsamConnection.isExternalTable) {
                cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                cTTable.SetPath(Globals.currentIsamConnection.getHostNameOrAddress());
            } else {
                cTTable = new CTTable(this.getDb());
            }
            CTIndex cTIndex = new CTIndex();
            CTSegment cTSegment = new CTSegment();
            cTTable.Open(string, Globals.isamOpenMode);
            cTIndex = cTTable.GetIndex(string2);
            int n = cTIndex.GetSegmentCount();
            for (int i = 0; i < n; ++i) {
                cTSegment = cTIndex.GetSegment(i);
                Segment segment = new Segment();
                segment.fieldName = cTSegment.GetFieldName();
                int n2 = cTSegment.GetMode();
                if ((n2 & 0x10) == 16) {
                    segment.descending = true;
                }
                segment.mode = n2 & 0xFFFFFFEF;
                arrayList.add(segment);
            }
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "readIndexSegments");
        }
        if (cTTable != null) {
            try {
                cTTable.Close();
            }
            catch (CTException cTException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public MyTreeNode getTreeNode() {
        return this.treeNode;
    }

    public void setTreeNode(MyTreeNode myTreeNode) {
        this.treeNode = myTreeNode;
    }

    public void setDefaultIndexName(String string) {
        this.indexName = string;
    }

    public boolean connectDatabase(String string) {
        try {
            this.db = new CTDatabase(this.session);
            this.getDb().Connect(string);
            return true;
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "ConnectDatabase");
            return false;
        }
    }

    public boolean disconnectDatabase() {
        try {
            CTDatabase cTDatabase = this.getDb();
            if (cTDatabase != null && cTDatabase.IsActive()) {
                this.getDb().Disconnect();
            }
            return true;
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "DisconnectDatabase");
            return false;
        }
    }

    public CTDatabase getDb() {
        return this.db;
    }

    public CTSession getSession() {
        return this.session;
    }

    public void setDefaultIndex(CTRecord cTRecord) {
        if ((Globals.isamOpenMode & 0x40) == 64) {
            try {
                cTRecord.SetDefaultIndex(10002);
            }
            catch (CTException cTException) {
                Globals.showException(cTException, "setDefaultIndex");
            }
        }
        if (!this.indexName.isEmpty()) {
            try {
                if (this.indexName.equals("Internal RECBYT Index")) {
                    cTRecord.SetDefaultIndex(10000);
                } else if (this.indexName.equals("Internal ROWNUM Index")) {
                    cTRecord.SetDefaultIndex(10001);
                } else if (this.indexName.equals("DATA (No Index)")) {
                    cTRecord.SetDefaultIndex(10002);
                } else {
                    cTRecord.SetDefaultIndex(this.indexName);
                }
            }
            catch (CTException cTException) {
                Globals.showException(cTException, "setDefaultIndex");
            }
        }
    }

    public void createDatabase(String string, String string2) {
        try {
            this.session.CreateDatabase(string, string2);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Create Db");
        }
    }

    public void addDatabase(String string, String string2) {
        try {
            this.session.AddDatabase(string, string2);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Add Db");
        }
    }

    public void dropDatabase(String string) {
        try {
            this.session.DropDatabase(string);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Drop Db");
        }
    }

    public void deleteDatabase(String string) {
        try {
            this.session.DisconnectAll();
            this.session.DeleteDatabase(string);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Delete Db");
        }
    }

    public void addTable(String string, String string2) {
        try {
            this.db.AddTable(string, string2);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Add Table");
        }
    }

    public void addTableXtd(String string, String string2, String string3) {
        try {
            this.db.AddTableXtd(string, string2, string3);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Add Table");
        }
    }

    public void dropTable(String string) {
        try {
            this.db.DropTable(string);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Drop Db");
        }
    }

    public void deleteTable(String string) {
        try {
            this.db.DeleteTable(string, null);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Delete Db");
        }
    }
}

