/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ImageViewer;
import ctreeaceexplorer.IsamTableModel;
import ctreeaceexplorer.LVBViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class IsamDynamicTable
extends FcBaseDynamicTable {
    private IsamTableModel isamTableModel;
    protected boolean inError;
    private Color readOnlyColor = new Color(255, 244, 221);

    public IsamDynamicTable(boolean bl) {
        this.isamTableModel = new IsamTableModel(this, bl);
        this.setModel(this.isamTableModel);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public IsamTableModel getModel() {
        return this.isamTableModel;
    }

    public void setModel(IsamTableModel isamTableModel) {
        this.isamTableModel = isamTableModel;
        super.setModel((TableModel)((Object)isamTableModel));
    }

    public ImageIcon getCellIconAt(int n, int n2) {
        if (this.isamTableModel.tableType == 1 && this.isamTableModel.getTagAt(n, n2) != null) {
            return Globals.getIcon("Alert.png");
        }
        return null;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        Object object = this.isamTableModel.getTagAt(n, n2);
        if (object != null && component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setToolTipText("<html>Column has been truncated to " + Globals.appProps.maxCharsInColumns + " bytes." + "<br>Click \"View in Window\" to view the whole column</html>");
        }
        if (!this.isamTableModel.isReadOnly() && Globals.isamShowDebugColumns && n2 < 3) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if ((Integer)this.isamTableModel.columnsMode.get(this.isamTableModel.getDataColumnNumber(n2)) == this.isamTableModel.HEX) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if ((Integer)this.isamTableModel.columnsMode.get(this.isamTableModel.getDataColumnNumber(n2)) == this.isamTableModel.IMG) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if (!this.isamTableModel.isReadOnly() && this.isamTableModel.isColumnReadOnly(n2)) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if (this.isamTableModel.getTagAt(n, n2) != null) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        return component;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionModel.getMinSelectionIndex();
        if (this.previousRow == -1 && n == 0) {
            this.previousRow = 0;
        }
        if (!this.inError && this.previousRow >= 0 && !this.getModel().rowChanged(this.previousRow)) {
            this.inError = true;
            this.editCellAt(this.previousRow, 0);
            this.setRowSelectionInterval(this.previousRow, this.previousRow);
        } else {
            this.inError = false;
            int n2 = -1;
            if (n >= 0) {
                n2 = this.convertRowIndexToModel(n);
            }
            this.previousRow = n2;
        }
        Globals.appFrame.isamTableSelectedRecord.setText(Integer.toString(n + 1));
        super.valueChanged(listSelectionEvent);
    }

    class ViewAsAction
    implements ActionListener {
        int column;
        int mode;

        public ViewAsAction(int n, int n2) {
            this.column = n;
            this.mode = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IsamTableModel isamTableModel = IsamDynamicTable.this.getModel();
            int n = IsamDynamicTable.this.getCurrentRow();
            int n2 = isamTableModel.getDataColumnNumber(this.column);
            String string = isamTableModel.getColumnName(this.column);
            if (this.mode < 100) {
                ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.columnsMode.set(n2, this.mode);
                ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.mustResizeRows = true;
                IsamDynamicTable.this.isamTableModel.fireTableDataChanged();
            } else {
                this.mode -= 100;
                if (this.mode == isamTableModel.LOAD) {
                    JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    int n3 = jFileChooser.showOpenDialog(jFrame);
                    if (n3 == 0) {
                        FileInputStream fileInputStream = null;
                        try {
                            int n4;
                            File file = jFileChooser.getSelectedFile();
                            long l = file.length();
                            if (l > Integer.MAX_VALUE) {
                                throw new IOException("File too big" + file.getName());
                            }
                            byte[] byArray = new byte[(int)l];
                            fileInputStream = new FileInputStream(file);
                            int n5 = 0;
                            for (n4 = 0; n4 < byArray.length && (n5 = fileInputStream.read(byArray, n4, byArray.length - n4)) >= 0; n4 += n5) {
                            }
                            if (n4 < byArray.length) {
                                throw new IOException("Could not completely read file " + file.getName());
                            }
                            IsamDynamicTable.this.setValueAt(byArray, n, this.column);
                            IsamDynamicTable.this.isamTableModel.setColumnDirty(this.column);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Globals.showMessage(fileNotFoundException.getMessage(), "Load from File");
                        }
                        catch (IOException iOException) {
                            Globals.showMessage(iOException.getMessage(), "Load from File");
                        }
                        finally {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                Globals.showMessage(iOException.getMessage(), "Load from File");
                            }
                        }
                    }
                } else if (this.mode == isamTableModel.SAVE) {
                    JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    int n6 = jFileChooser.showSaveDialog(jFrame);
                    if (n6 == 0) {
                        Globals.ShowWaitCursor();
                        Object object = isamTableModel.getSpecialValueAt(n, isamTableModel.getDataColumnNumber(this.column));
                        if (object instanceof byte[]) {
                            byte[] byArray = (byte[])object;
                            FileOutputStream fileOutputStream = null;
                            try {
                                File file = jFileChooser.getSelectedFile();
                                fileOutputStream = new FileOutputStream(file);
                                if (byArray == null) {
                                    file.delete();
                                    file.createNewFile();
                                } else {
                                    fileOutputStream.write(byArray);
                                }
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                Globals.showMessage(fileNotFoundException.getMessage(), "Save To File");
                            }
                            catch (IOException iOException) {
                                Globals.showMessage(iOException.getMessage(), "Save To File");
                            }
                            finally {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    Globals.showMessage(iOException.getMessage(), "Save To File");
                                }
                            }
                            Globals.ShowNormalCursor();
                        }
                    }
                } else if (this.mode == isamTableModel.NULL) {
                    IsamDynamicTable.this.setValueAt(null, n, this.column);
                    IsamDynamicTable.this.isamTableModel.setColumnDirty(this.column);
                } else {
                    byte[] byArray;
                    Object object = isamTableModel.getSpecialValueAt(n, isamTableModel.getDataColumnNumber(this.column));
                    if (object instanceof byte[] && (byArray = (byte[])object) != null) {
                        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                        if (this.mode == 2) {
                            ImageViewer imageViewer = new ImageViewer((Frame)jFrame, true);
                            imageViewer.setLocationRelativeTo(jFrame);
                            imageViewer.showDialog(string, byArray);
                            imageViewer.dispose();
                        } else {
                            LVBViewer lVBViewer = new LVBViewer((Frame)jFrame, true);
                            lVBViewer.setLocationRelativeTo(jFrame);
                            lVBViewer.showDialog(string, this.mode, byArray);
                        }
                        byArray = null;
                    }
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = null;
            Component component = mouseEvent.getComponent();
            if (component.getClass() == IsamDynamicTable.class) {
                IsamDynamicTable isamDynamicTable = (IsamDynamicTable)((Object)component);
                IsamTableModel isamTableModel = isamDynamicTable.getModel();
                int n = isamDynamicTable.columnAtPoint(mouseEvent.getPoint());
                int n2 = isamDynamicTable.rowAtPoint(mouseEvent.getPoint());
                if (n2 == -1) {
                    isamTableModel.fireTableDataChanged();
                }
                if (mouseEvent.isPopupTrigger()) {
                    TableCellEditor tableCellEditor = isamDynamicTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                    IsamDynamicTable.this.changeSelection(n2, n, false, false);
                    if (!isamTableModel.isReadOnly()) {
                        jPopupMenu = new JPopupMenu();
                        int n3 = isamTableModel.getDataColumnNumber(n);
                        int n4 = (Integer)((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.columnsMode.get(n3);
                        if (n4 == -1) {
                            n4 = ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.TEXT;
                        }
                        switch (isamTableModel.getColumnType(n3)) {
                            case 128: 
                            case 144: 
                            case 146: 
                            case 152: 
                            case 154: 
                            case 160: 
                            case 162: 
                            case 168: 
                            case 170: {
                                JMenuItem jMenuItem = new JCheckBoxMenuItem("View as Text");
                                jMenuItem.addActionListener(new ViewAsAction(n, ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.TEXT));
                                if (n4 == ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.TEXT) {
                                    jMenuItem.setSelected(true);
                                }
                                jPopupMenu.add(jMenuItem);
                                jMenuItem = new JCheckBoxMenuItem("View as Byte Array");
                                jMenuItem.addActionListener(new ViewAsAction(n, ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.BYTE));
                                if (n4 == ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.BYTE) {
                                    jMenuItem.setSelected(true);
                                }
                                jPopupMenu.add(jMenuItem);
                                jMenuItem = new JCheckBoxMenuItem("View as Hex/ASCII");
                                jMenuItem.addActionListener(new ViewAsAction(n, ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.HEX));
                                if (n4 == ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.HEX) {
                                    jMenuItem.setSelected(true);
                                }
                                jPopupMenu.add(jMenuItem);
                                jMenuItem = new JCheckBoxMenuItem("View as Image");
                                jMenuItem.addActionListener(new ViewAsAction(n, ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.IMG));
                                if (n4 == ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.IMG) {
                                    jMenuItem.setSelected(true);
                                }
                                jPopupMenu.add(jMenuItem);
                                JPopupMenu.Separator separator = new JPopupMenu.Separator();
                                jPopupMenu.add(separator);
                                jMenuItem = new JMenuItem("View in Window");
                                jMenuItem.addActionListener(new ViewAsAction(n, 100 + n4));
                                jPopupMenu.add(jMenuItem);
                                separator = new JPopupMenu.Separator();
                                jPopupMenu.add(separator);
                                jMenuItem = new JMenuItem("Load from File");
                                jMenuItem.addActionListener(new ViewAsAction(n, 100 + ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.LOAD));
                                jPopupMenu.add(jMenuItem);
                                jMenuItem = new JMenuItem("Save to File");
                                jMenuItem.addActionListener(new ViewAsAction(n, 100 + ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.SAVE));
                                jPopupMenu.add(jMenuItem);
                                jMenuItem = new JMenuItem("Set NULL");
                                jMenuItem.addActionListener(new ViewAsAction(n, 100 + ((IsamDynamicTable)IsamDynamicTable.this).isamTableModel.NULL));
                                jPopupMenu.add(jMenuItem);
                                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                    }
                }
            }
        }
    }
}

