/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTIndex;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTSegment;
import FairCom.CtreeDb.CTTable;
import FairCom.Helper.Classes.BitConverter;
import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.Dictionary;
import ctreeaceexplorer.EXIT_CODE;
import ctreeaceexplorer.Field;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.Index;
import ctreeaceexplorer.IsamDynamicTable;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.Segment;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

class IsamTableModel
extends FcBaseTableModel {
    private IsamDynamicTable isamTable;
    static Dictionary fieldTypes = new Dictionary();
    static Dictionary binaryFlags = new Dictionary();
    static Dictionary keyTypes = new Dictionary();
    static Dictionary segModes = new Dictionary();
    String tableName;
    int tableType;
    public boolean mustResizeRows;
    static final int maxFieldLen = 8192;
    DateFormat dateFormatter = DateFormat.getDateInstance(3);
    DateFormat timeFormatter = DateFormat.getTimeInstance(2);
    DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(3, 2);
    FontMetrics metrics;
    static final String HEXES = "0123456789ABCDEF";

    public IsamTableModel(IsamDynamicTable isamDynamicTable, boolean bl) {
        super((FcBaseDynamicTable)isamDynamicTable, bl);
        this.isamTable = isamDynamicTable;
        this.inittypes();
    }

    public void addRowNum(ResultSet resultSet, int n) {
        try {
            while (resultSet.next()) {
                long l = resultSet.getLong(1);
                this.setValueAt(l, n, 0);
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Sql Exception");
        }
        this.fireTableDataChanged();
    }

    public void addRecord(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.columnsType.size(); ++i) {
            if (bl && i < 3) {
                arrayList.add(-1L);
                continue;
            }
            this.dirtyColumns.set(i, true);
            arrayList.add(this.getDefaultColumnValue((Integer)this.columnsType.get(i)));
        }
        FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
        this.addRow(rowData);
        this.fireTableDataChanged();
    }

    public void deleteRecord() {
        boolean bl = false;
        if (this.isamTable.getCellEditor() != null) {
            this.isamTable.getCellEditor().cancelCellEditing();
        }
        this.hasDirtyColumns = false;
        CTTable cTTable = null;
        CTRecord cTRecord = null;
        EXIT_CODE eXIT_CODE = EXIT_CODE.OK;
        int n = this.isamTable.getCurrentRow();
        if (n >= 0) {
            try {
                long l = 0L;
                if (this.tableName.equals("SessionFile")) {
                    bl = true;
                    cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                    cTTable.Attach(2);
                } else if (this.tableName.equals("DatabaseFile")) {
                    bl = true;
                    cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                    cTTable.Attach(8);
                } else if (Globals.currentIsamConnection.isExternalTable) {
                    cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                    cTTable.SetPath(Globals.currentIsamConnection.getHostNameOrAddress());
                    cTTable.Open(this.tableName, Globals.isamOpenMode);
                } else {
                    cTTable = new CTTable(Globals.currentIsamConnection.getDb());
                    cTTable.Open(this.tableName, Globals.isamOpenMode | 1);
                }
                cTRecord = new CTRecord(cTTable);
                if (cTTable.HasRowid()) {
                    l = (Long)this.getSpecialValueAt(n, 1);
                    boolean bl2 = cTRecord.FindRowid(l, 0);
                    if (!bl2 && l != -1L) {
                        throw new CTException(101, "DeleteRecord  - Record not found");
                    }
                } else {
                    l = (Long)this.getSpecialValueAt(n, 2);
                    cTRecord.SeekRecord(l);
                }
                cTRecord.Begin();
                cTRecord.Lock(3);
                cTRecord.Delete();
                cTRecord.Lock(0);
                cTRecord.Commit();
                if (bl) {
                    cTTable.Detach();
                } else {
                    cTTable.Close();
                }
            }
            catch (CTException cTException) {
                eXIT_CODE = EXIT_CODE.ABORT;
                if (cTRecord != null && cTRecord.IsTransActive()) {
                    try {
                        cTRecord.Abort();
                    }
                    catch (CTException cTException2) {
                        Logger.getLogger(IsamTableModel.class.getName()).log(Level.SEVERE, null, cTException2);
                    }
                }
                if (cTTable != null) {
                    try {
                        if (bl) {
                            cTTable.Detach();
                        } else {
                            cTTable.Close();
                        }
                    }
                    catch (CTException cTException3) {
                        Logger.getLogger(IsamTableModel.class.getName()).log(Level.SEVERE, null, cTException3);
                    }
                }
                eXIT_CODE = Globals.showAbortRetryException(cTException, "DeleteRecord");
            }
            if (eXIT_CODE == EXIT_CODE.OK) {
                this.deleteRow(n);
            } else if (eXIT_CODE == EXIT_CODE.RETRY) {
                this.deleteRecord();
            } else if (eXIT_CODE == EXIT_CODE.RELOAD) {
                this.populateRecords();
            }
        }
    }

    public void populateDbTables(ArrayList<Object[]> arrayList, boolean bl) {
        String[] stringArray;
        this.clearTable();
        if (bl) {
            stringArray = new String[]{"Database Name", "Database Path"};
            this.addColumns(stringArray);
        } else {
            stringArray = new String[]{"Table Name", "Table Path"};
            this.addColumns(stringArray);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnsType.set(i, 144);
            this.autoSizeColumns.set(i, true);
        }
        this.suspendAutoSize = false;
        super.setRowSorter();
        super.fireTableStructureChanged();
        for (Object[] objectArray : arrayList) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 1; i <= this.numberOfColumns; ++i) {
                arrayList2.add(objectArray[0].toString());
                arrayList2.add(objectArray[1].toString());
            }
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
            this.addRow(rowData);
        }
        this.resizeRows();
        this.fireTableDataChanged();
    }

    void populateExtTables(MyTreeNode myTreeNode) {
        this.clearTable();
        this.numberOfColumns = 2;
        this.allocateArrays(this.numberOfColumns);
        String[] stringArray = new String[]{"Table Name", "Table Path"};
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnsName.set(i, stringArray[i]);
            this.columnsType.set(i, 144);
        }
        super.fireTableStructureChanged();
        if (myTreeNode.getChildCount() >= 0) {
            Enumeration<TreeNode> enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
                arrayList.add(myTreeNode2.name);
                arrayList.add(myTreeNode2.path);
                FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
                this.addRow(rowData);
            }
        }
        this.resizeRows();
        this.fireTableDataChanged();
    }

    public void populateTableFields(ArrayList<Field> arrayList) {
        String[] stringArray = new String[]{"Name", "Type", "Length", "Null Allowed", "Precision", "Scale", "Identity", "Seed", "Increment", "Position"};
        Integer[] integerArray = new Integer[]{144, 144, 51, 144, 51, 51, 144, 231, 231, 51};
        this.populateTableFields(arrayList, stringArray, integerArray);
    }

    public void populateTableFields(ArrayList<Field> arrayList, String[] stringArray, Integer[] integerArray) {
        this.clearTable();
        this.addColumns(stringArray, integerArray);
        this.setAutosizeColumns(true);
        super.fireTableStructureChanged();
        int n = 1;
        for (Field field : arrayList) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(field.name);
            String string = (String)fieldTypes.get(field.type);
            arrayList2.add(string);
            if (field.type == 170 || field.type == 146) {
                arrayList2.add(0);
            } else {
                arrayList2.add(field.length);
            }
            arrayList2.add(field.nullAllowed ? "Yes" : "No");
            if (field.type == 105) {
                arrayList2.add(field.precision);
                arrayList2.add(field.scale);
            } else {
                arrayList2.add("-");
                arrayList2.add("-");
            }
            if (field.isIdentity) {
                arrayList2.add("Yes");
                arrayList2.add(field.seed);
                arrayList2.add(field.increment);
            } else {
                arrayList2.add("No");
                arrayList2.add(null);
                arrayList2.add(null);
            }
            arrayList2.add(n);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
            this.addRow(rowData);
            ++n;
        }
        this.resizeRows();
        this.fireTableDataChanged();
    }

    public void populateTableProperties(ArrayList<Object[]> arrayList) {
        String[] stringArray = new String[]{"Property", "Value"};
        this.clearTable();
        this.addColumns(stringArray);
        this.setAutosizeColumns(true);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnsName.set(i, stringArray[i]);
            this.columnsType.set(i, 144);
        }
        super.setRowSorter();
        super.fireTableStructureChanged();
        for (Object[] objectArray : arrayList) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(objectArray[0]);
            arrayList2.add(objectArray[1]);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
            this.addRow(rowData);
        }
        this.resizeRows();
        this.fireTableDataChanged();
    }

    public void populateTableIndexes(ArrayList<Index> arrayList) {
        String[] stringArray = new String[]{"Name", "Filename", "Type", "Length", "Dup Allowed", "Null Allowed", "Condition", "# of Segments"};
        Integer[] integerArray = new Integer[]{144, 144, 144, 51, 144, 144, 144, 51};
        this.clearTable();
        this.numberOfColumns = stringArray.length;
        this.addColumns(stringArray, integerArray);
        super.fireTableStructureChanged();
        int n = 1;
        for (Index index : arrayList) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(index.name);
            arrayList2.add(index.fileName);
            String string = (String)keyTypes.get(index.type);
            arrayList2.add(string);
            arrayList2.add(index.length);
            arrayList2.add(index.dupDisallowed ? "No" : "Yes");
            arrayList2.add(index.nullDisallowed ? "No" : "Yes");
            arrayList2.add(index.condition);
            arrayList2.add(index.segmentCount);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
            this.addRow(rowData);
            ++n;
        }
        this.resizeRows();
        this.fireTableDataChanged();
    }

    public void populateIndexSegments(ArrayList<Segment> arrayList) {
        String string = "";
        String[] stringArray = new String[]{"Field Name", "Segment Mode", "Descending"};
        this.clearTable();
        this.numberOfColumns = stringArray.length;
        this.allocateArrays(this.numberOfColumns);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.columnsName.set(i, stringArray[i]);
            this.columnsType.set(i, 144);
        }
        super.fireTableStructureChanged();
        for (Segment segment : arrayList) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(segment.fieldName);
            boolean bl = false;
            if ((segment.mode & 0x20) == 32) {
                string = string + "ALTSEG / ";
            }
            if ((segment.mode & 0x40) == 64) {
                string = string + "ENDSEG / ";
            }
            if ((segment.mode & 0x80) == 128) {
                string = string + "UNCSEG / ";
            }
            if ((segment.mode & 0x100) == 256) {
                if ((segment.mode & 0x101) == 257) {
                    string = string + "SCHSRL / ";
                    segment.mode = 0;
                    bl = true;
                } else {
                    string = string + "RECBYT / ";
                }
            }
            if ((segment.mode & 0x400) == 1024) {
                string = string + "GNXSEG / ";
            }
            segment.mode &= 0xF;
            if (!bl) {
                string = string + (String)segModes.get(segment.mode);
            }
            arrayList2.add(string);
            arrayList2.add(segment.descending ? "Yes" : "No");
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
            this.addRow(rowData);
        }
        this.resizeRows();
        this.fireTableDataChanged();
    }

    public void populateRecords() {
        if (this.tableName != null) {
            this.populateRecords(this.tableName);
        }
    }

    public void populateRecords(String string) {
        this.metrics = this.table.getFontMetrics(this.table.getFont());
        boolean bl = false;
        Globals.ShowWaitCursor();
        this.tableName = string;
        this.suspendAutoSize = false;
        CTTable cTTable = null;
        try {
            Object object;
            if (string.equals("SessionFile")) {
                bl = true;
                cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                cTTable.Attach(2);
            } else if (string.equals("DatabaseFile")) {
                bl = true;
                cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                cTTable.Attach(8);
            } else if (Globals.currentIsamConnection.isExternalTable) {
                cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                cTTable.SetPath(Globals.currentIsamConnection.getHostNameOrAddress());
                cTTable.Open(string, Globals.isamOpenMode);
            } else {
                cTTable = new CTTable(Globals.currentIsamConnection.getDb());
                cTTable.Open(string, Globals.isamOpenMode);
            }
            CTRecord cTRecord = new CTRecord(cTTable);
            this.clearTable();
            this.tableType = 1;
            ArrayList<Field> arrayList = Globals.currentIsamConnection.getTableFields();
            this.numberOfColumns = arrayList.size() + 3;
            ArrayList arrayList2 = null;
            if (this.columnsMode != null && !this.columnsMode.isEmpty()) {
                arrayList2 = new ArrayList(this.columnsMode);
            }
            this.allocateArrays(this.numberOfColumns);
            if (arrayList2 != null) {
                this.columnsMode = new ArrayList(arrayList2);
            }
            this.hasDirtyColumns = false;
            int n = 0;
            this.columnsName.set(n, "Grid Row #");
            this.columnsType.set(n, 231);
            this.columnsScale.set(n, 0);
            this.columnsName.set(++n, "RowID");
            this.columnsType.set(n, 231);
            this.columnsScale.set(n, 0);
            this.columnsName.set(++n, "RecByt");
            this.columnsType.set(n, 231);
            this.columnsScale.set(n, 0);
            ++n;
            if (!Globals.isamShowDebugColumns) {
                this.hiddenColumns.set(0, true);
                this.hiddenColumns.set(1, true);
                this.hiddenColumns.set(2, true);
            }
            for (Field field : arrayList) {
                this.columnsName.set(n, field.name);
                this.columnsType.set(n, field.type);
                if (field.type == 103 || field.type == 91 || field.type == 119) {
                    this.columnsScale.set(n, -1);
                } else {
                    this.columnsScale.set(n, field.scale);
                }
                this.columnsFlag.set(n, field.binFlag);
                ++n;
            }
            super.fireTableStructureChanged();
            TableColumnModel tableColumnModel = this.isamTable.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                object = tableColumnModel.getColumn(i);
                String string2 = (String)this.columnsName.get(this.getDataColumnNumber(i));
                int n2 = this.metrics.stringWidth(string2) + 15;
                ((TableColumn)object).setPreferredWidth(n2);
            }
            Globals.currentIsamConnection.setDefaultIndex(cTRecord);
            CtreeACEExplorerView ctreeACEExplorerView = (CtreeACEExplorerView)CtreeACEExplorerApp.getApplication().getMainView();
            object = ctreeACEExplorerView.keyValueTB.getText();
            int n3 = 30;
            long l = 1000L;
            String string3 = (String)ctreeACEExplorerView.maxRowsCombo.getSelectedItem();
            l = string3.equals("All") ? Long.MAX_VALUE : (long)Integer.parseInt(string3);
            String string4 = (String)ctreeACEExplorerView.findModeCB.getSelectedItem();
            if (((String)object).isEmpty() || string4.startsWith("ALL")) {
                if (cTRecord.First()) {
                    --l;
                    int n4 = 1;
                    this.readFields(cTRecord, n4++);
                    while (l-- > 0L && cTRecord.Next()) {
                        this.readFields(cTRecord, n4++);
                    }
                }
            } else {
                cTRecord.First();
                int n5 = cTRecord.GetDefaultIndex();
                CTIndex cTIndex = cTTable.GetIndex(n5);
                CTSegment cTSegment = cTIndex.GetSegment(0);
                CTField cTField = cTSegment.GetField();
                String string5 = cTField.GetName();
                cTRecord.SetFieldAsString(string5, (String)object);
                String[] stringArray = string4.split(" ");
                int n6 = 0;
                if (stringArray.length > 0) {
                    String string6 = stringArray[0];
                    if (string6.equals("LE")) {
                        n6 = 2;
                    } else if (string6.equals("LT")) {
                        n6 = 1;
                    } else if (string6.equals("GE")) {
                        n6 = 4;
                    } else if (string6.equals("GT")) {
                        n6 = 3;
                    }
                }
                if (cTRecord.Find(n6)) {
                    int n7 = 1;
                    this.readFields(cTRecord, n7++);
                    while (cTRecord.Next()) {
                        this.readFields(cTRecord, n7++);
                        if (n3-- <= 0) continue;
                    }
                }
            }
            this.fireTableDataChanged();
            if (this.getRowCount() > 0) {
                this.isamTable.setRowSelectionInterval(0, 0);
                this.isamTable.setColumnSelectionInterval(0, 0);
            }
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "readTablesFiels");
        }
        if (cTTable != null) {
            try {
                if (bl) {
                    cTTable.Detach();
                } else {
                    cTTable.Close();
                }
            }
            catch (CTException cTException) {
                // empty catch block
            }
        }
        Globals.appFrame.isamTableRecordCount.setText(" of " + Integer.toString(this.getRowCount()));
        Globals.ShowNormalCursor();
    }

    public void clearTable() {
        super.clearTable();
        this.tableType = 0;
    }

    public void clearTableNavigator() {
        Globals.appFrame.isamTableRecordCount.setText(" of ");
        Globals.appFrame.isamTableSelectedRecord.setText("");
    }

    public void showHideColumns() {
        this.hiddenColumns.set(0, !Globals.isamShowDebugColumns);
        this.hiddenColumns.set(1, !Globals.isamShowDebugColumns);
        this.hiddenColumns.set(2, !Globals.isamShowDebugColumns);
        super.fireTableStructureChanged();
        this.resizeRows();
    }

    private void readFields(CTRecord cTRecord, int n) {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        arrayList.add(Integer.valueOf(n));
        try {
            arrayList.add(Long.valueOf(cTRecord.GetRowid()));
        }
        catch (CTException cTException) {
            arrayList.add(null);
        }
        try {
            arrayList.add(Long.valueOf(cTRecord.GetRecordPos()));
        }
        catch (CTException cTException) {
            arrayList.add(null);
        }
        int n2 = 3;
        String string = "";
        for (int i = 0; i < this.numberOfColumns - n2; ++i) {
            int n3;
            int n4 = (Integer)this.columnsType.get(i + n2);
            Object object = null;
            try {
                n3 = cTRecord.GetFieldLength(i);
                switch (n4) {
                    case 8: {
                        object = cTRecord.GetFieldAsBoolean(i);
                        break;
                    }
                    case 128: 
                    case 144: 
                    case 146: 
                    case 152: 
                    case 154: 
                    case 160: 
                    case 162: 
                    case 168: 
                    case 170: 
                    case 177: 
                    case 185: 
                    case 193: 
                    case 201: {
                        if (!cTRecord.IsNullField(i)) {
                            object = cTRecord.GetFieldAsBytes(i);
                        }
                        break;
                    }
                    case 16: 
                    case 24: 
                    case 33: 
                    case 41: 
                    case 51: 
                    case 59: {
                        object = cTRecord.GetFieldAsInt(i);
                        break;
                    }
                    case 231: 
                    case 239: {
                        object = cTRecord.GetFieldAsLong(i);
                        break;
                    }
                    case 75: {
                        Calendar calendar = cTRecord.GetFieldAsCalendar(i);
                        if (calendar != null) {
                            Date date = new Date(calendar.getTimeInMillis());
                            object = date;
                            string = this.dateFormatter.format(date);
                        }
                        break;
                    }
                    case 83: 
                    case 258: {
                        Calendar calendar = cTRecord.GetFieldAsCalendar(i);
                        if (calendar != null) {
                            Time time = new Time(calendar.getTimeInMillis());
                            object = time;
                            string = this.timeFormatter.format(time);
                        }
                        break;
                    }
                    case 124: 
                    case 257: {
                        Calendar calendar = cTRecord.GetFieldAsCalendar(i);
                        if (calendar != null) {
                            Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                            object = timestamp;
                            string = this.dateTimeFormatter.format(timestamp);
                        }
                        break;
                    }
                    case 91: {
                        Double d = cTRecord.GetFieldAsDouble(i);
                        if (d != null) {
                            object = Float.valueOf(d.floatValue());
                        }
                        break;
                    }
                    case 67: 
                    case 103: 
                    case 119: {
                        object = cTRecord.GetFieldAsDouble(i);
                        break;
                    }
                    case 105: 
                    case 143: {
                        object = cTRecord.GetFieldAsBigDecimal(i);
                        break;
                    }
                    default: {
                        object = cTRecord.GetFieldAsString(i);
                        break;
                    }
                }
            }
            catch (CTException cTException) {
                // empty catch block
            }
            if (n < 30) {
                n3 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = i;
                if (Globals.isamShowDebugColumns) {
                    n8 += n2;
                }
                TableColumn tableColumn = this.isamTable.getColumnModel().getColumn(n8);
                String string2 = (String)tableColumn.getHeaderValue();
                n3 = this.metrics.stringWidth(string2) + 15;
                n5 = object == null ? this.metrics.stringWidth("(null)") + 10 : (n4 == 75 || n4 == 83 || n4 == 124 ? this.metrics.stringWidth(string) + 10 : this.metrics.stringWidth(object.toString()) + 10);
                n7 = Math.max(n3, n5);
                n6 = tableColumn.getPreferredWidth();
                int n9 = Math.max(n6, n7);
                tableColumn.setPreferredWidth(n9);
            }
            arrayList.add((Serializable)object);
        }
        FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
        this.addRow(rowData);
    }

    public static String getHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(HEXES.charAt((by & 0xF0) >> 4)).append(HEXES.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static byte[] stringToBytes(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            StringBuilder stringBuilder = new StringBuilder(2);
            char c = string.charAt(n2);
            stringBuilder.append(c);
            char c2 = '0';
            if (n2 < n - 1) {
                c2 = string.charAt(++n2);
            }
            stringBuilder.append(c2);
            int n4 = Integer.parseInt(stringBuilder.toString(), 16);
            byArray[n3] = (byte)n4;
            ++n2;
            ++n3;
        }
        return byArray;
    }

    public Object getDefaultColumnValue(int n) {
        switch (n) {
            case 8: {
                return false;
            }
            case 144: 
            case 152: 
            case 177: 
            case 185: 
            case 193: 
            case 201: {
                return "";
            }
            case 16: 
            case 24: 
            case 33: 
            case 41: 
            case 51: 
            case 59: {
                return 0;
            }
            case 231: 
            case 239: {
                return 0L;
            }
            case 75: 
            case 83: 
            case 124: {
                return new Date();
            }
            case 91: {
                return Float.valueOf(0.0f);
            }
            case 67: 
            case 103: 
            case 119: {
                return 0.0;
            }
            case 146: 
            case 154: {
                return null;
            }
            case 128: 
            case 160: 
            case 162: 
            case 168: {
                return null;
            }
            case 170: {
                return null;
            }
            case 105: 
            case 143: {
                return new BigDecimal(0);
            }
        }
        return null;
    }

    public byte[] getLongField(int n, String string) {
        CTTable cTTable = null;
        CTRecord cTRecord = null;
        EXIT_CODE eXIT_CODE = EXIT_CODE.OK;
        try {
            long l = 0L;
            if (Globals.currentIsamConnection.isExternalTable) {
                cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                cTTable.SetPath(Globals.currentIsamConnection.getHostNameOrAddress());
            } else {
                cTTable = new CTTable(Globals.currentIsamConnection.getDb());
            }
            cTRecord = new CTRecord(cTTable);
            cTTable.Open(this.tableName, Globals.isamOpenMode);
            if (cTTable.HasRowid()) {
                l = (Long)this.getSpecialValueAt(n, 1);
                boolean bl = cTRecord.FindRowid(l, 0);
                if (!bl && l != -1L) {
                    throw new CTException(101, "getLongField  - Record not found");
                }
            } else {
                l = (Long)this.getSpecialValueAt(n, 2);
                cTRecord.SeekRecord(l);
            }
            byte[] byArray = cTRecord.GetFieldAsBytes(string);
            cTTable.Close();
            return byArray;
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "getLongField");
            if (cTTable != null && cTTable.IsActive()) {
                try {
                    cTTable.Close();
                }
                catch (CTException cTException2) {
                    Logger.getLogger(IsamTableModel.class.getName()).log(Level.SEVERE, null, cTException2);
                }
            }
            return null;
        }
    }

    public Object getValueAt(int n, int n2) {
        if (this.tableType == 1) {
            int n3 = Globals.appProps.maxCharsInColumns;
            Object object = super.getValueAt(n, n2);
            Class clazz = this.getColumnClass(n2);
            int n4 = (Integer)this.columnsMode.get(this.getDataColumnNumber(n2));
            if (clazz == String.class && object instanceof byte[] && object != null) {
                Object object2;
                if (((byte[])object).length > n3) {
                    object2 = new byte[n3];
                    this.setTagAt(n, n2, 1);
                    System.arraycopy((byte[])object, 0, object2, 0, n3);
                    object = object2;
                } else {
                    this.setTagAt(n, n2, null);
                }
                object2 = "";
                if (n4 == -1 || n4 == this.TEXT) {
                    object2 = new String((byte[])object).trim();
                } else if (n4 == this.BYTE) {
                    object2 = BitConverter.toHexString((byte[])((byte[])object), (boolean)true);
                } else if (n4 == this.HEX) {
                    object2 = BitConverter.toHexAscii((byte[])((byte[])object));
                } else {
                    if (n4 == this.IMG) {
                        return object;
                    }
                    return object;
                }
                return object2;
            }
            return object;
        }
        return super.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.tableType == 1) {
            Class clazz = this.getColumnClass(n2);
            int n3 = (Integer)this.columnsMode.get(this.getDataColumnNumber(n2));
            if (clazz == String.class && object instanceof String && object != null) {
                if (n3 == -1 || n3 == this.TEXT) {
                    byte[] byArray = BitConverter.getBytes((String)((String)object));
                    super.setValueAt((Object)byArray, n, n2);
                } else if (n3 == this.BYTE) {
                    byte[] byArray = BitConverter.getBytesFromBytes((String)((String)object));
                    super.setValueAt((Object)byArray, n, n2);
                }
            } else {
                super.setValueAt(object, n, n2);
            }
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    public Class getColumnClass(int n) {
        Class clazz = String.class;
        n = this.getDataColumnNumber(n);
        if (this.columnsType.size() > n) {
            int n2 = (Integer)this.columnsType.get(n);
            switch (n2) {
                case 8: {
                    clazz = Boolean.class;
                    break;
                }
                case 144: 
                case 152: 
                case 160: 
                case 168: 
                case 177: 
                case 185: 
                case 193: 
                case 201: {
                    clazz = String.class;
                    break;
                }
                case 16: 
                case 24: 
                case 33: 
                case 41: 
                case 51: 
                case 59: {
                    clazz = Integer.class;
                    break;
                }
                case 231: 
                case 239: {
                    clazz = Long.class;
                    break;
                }
                case 75: {
                    clazz = Date.class;
                    break;
                }
                case 83: 
                case 258: {
                    clazz = Time.class;
                    break;
                }
                case 124: 
                case 257: {
                    clazz = Timestamp.class;
                    break;
                }
                case 91: {
                    clazz = Float.class;
                    break;
                }
                case 67: 
                case 103: 
                case 119: {
                    clazz = Double.class;
                    break;
                }
                case 128: {
                    clazz = String.class;
                    break;
                }
                case 146: 
                case 154: {
                    clazz = String.class;
                    break;
                }
                case 162: {
                    clazz = String.class;
                    break;
                }
                case 170: {
                    clazz = String.class;
                    break;
                }
                case 105: 
                case 143: {
                    clazz = BigDecimal.class;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    Globals.showMessage("Type not found", "getColumnClass");
                }
            }
        }
        return clazz;
    }

    private void updateRowHeights() {
        try {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                int n = this.table.getRowHeight();
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    Component component = this.table.prepareRenderer(this.table.getCellRenderer(i, j), i, j);
                    n = Math.max(n, component.getPreferredSize().height);
                }
                this.table.setRowHeight(i, n);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isColumnReadOnly(n2)) {
            return false;
        }
        if (Globals.isamShowDebugColumns && n2 < 3) {
            return false;
        }
        if ((Integer)this.columnsMode.get(this.getDataColumnNumber(n2)) == this.HEX) {
            return false;
        }
        if ((Integer)this.columnsMode.get(this.getDataColumnNumber(n2)) == this.IMG) {
            return false;
        }
        return this.getTagAt(n, n2) == null;
    }

    public boolean rowChanged(int n) {
        Object object;
        if (!this.hasDirtyColumns) {
            return true;
        }
        boolean bl = false;
        CTTable cTTable = null;
        CTRecord cTRecord = null;
        EXIT_CODE eXIT_CODE = EXIT_CODE.OK;
        try {
            long l;
            block36: {
                l = -1L;
                if (this.tableName.equals("SessionFile")) {
                    object = this.showSystablesWarning();
                    if (object == EXIT_CODE.ABORT) {
                        this.populateRecords();
                        return true;
                    }
                    bl = true;
                    cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                    cTTable.Attach(2);
                } else if (this.tableName.equals("DatabaseFile")) {
                    object = this.showSystablesWarning();
                    if (object == EXIT_CODE.ABORT) {
                        this.populateRecords();
                        return true;
                    }
                    bl = true;
                    cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                    cTTable.Attach(8);
                } else if (Globals.currentIsamConnection.isExternalTable) {
                    cTTable = new CTTable(Globals.currentIsamConnection.getSession());
                    cTTable.SetPath(Globals.currentIsamConnection.getHostNameOrAddress());
                    cTTable.Open(this.tableName, Globals.isamOpenMode);
                } else {
                    cTTable = new CTTable(Globals.currentIsamConnection.getDb());
                    cTTable.Open(this.tableName, Globals.isamOpenMode);
                }
                cTRecord = new CTRecord(cTTable);
                if (cTTable.HasRowid()) {
                    boolean bl2;
                    object = this.getSpecialValueAt(n, 2);
                    if (object != null) {
                        l = (Long)this.getSpecialValueAt(n, 1);
                    }
                    if (!(bl2 = cTRecord.FindRowid(l, 0)) && l != -1L) {
                        throw new CTException(101, "RowChanged  - Record not found");
                    }
                } else {
                    object = this.getSpecialValueAt(n, 2);
                    if (object != null) {
                        l = (Long)this.getSpecialValueAt(n, 2);
                    }
                    try {
                        cTRecord.SeekRecord(l);
                    }
                    catch (CTException cTException) {
                        if (l == -1L) break block36;
                        throw new CTException(101, "RowChanged  - Record not found");
                    }
                }
            }
            object = this.getRow(n);
            this.writeFields(cTRecord, (FcBaseTableModel.RowData)object);
            cTRecord.Begin();
            if (l == -1L) {
                cTRecord.SetNew(true);
            } else {
                cTRecord.Lock(3);
            }
            cTRecord.Write();
            if (l == -1L) {
                object.setValue(0, this.getRowCount());
                long l2 = cTRecord.GetRecordPos();
                object.setValue(2, l2);
                if (cTTable.HasRowid()) {
                    long l3 = cTRecord.GetRowid();
                    object.setValue(1, l3);
                }
            } else {
                cTRecord.Lock(0);
            }
            cTRecord.Commit();
            if (bl) {
                cTTable.Detach();
            } else {
                cTTable.Close();
            }
        }
        catch (CTException cTException) {
            if (cTRecord != null && cTRecord.IsTransActive()) {
                try {
                    cTRecord.Abort();
                }
                catch (CTException cTException2) {
                    Logger.getLogger(IsamTableModel.class.getName()).log(Level.SEVERE, null, cTException2);
                }
            }
            if (cTTable != null) {
                try {
                    if (bl) {
                        cTTable.Detach();
                    } else {
                        cTTable.Close();
                    }
                }
                catch (CTException cTException3) {
                    Logger.getLogger(IsamTableModel.class.getName()).log(Level.SEVERE, null, cTException3);
                }
            }
            eXIT_CODE = Globals.showAbortRetryException(cTException, "AddRecord");
        }
        if (eXIT_CODE == EXIT_CODE.ABORT || eXIT_CODE == EXIT_CODE.OK) {
            this.hasDirtyColumns = false;
            Integer n2 = 0;
            while (n2 < this.numberOfColumns) {
                this.dirtyColumns.set(n2, false);
                Integer n3 = n2;
                n2 = n2 + 1;
                object = n2;
            }
            return true;
        }
        if (eXIT_CODE == EXIT_CODE.RELOAD) {
            this.populateRecords();
            return true;
        }
        return false;
    }

    private void writeFields(CTRecord cTRecord, FcBaseTableModel.RowData rowData) {
        int n = 3;
        for (int i = 3; i < this.numberOfColumns; ++i) {
            if (!((Boolean)this.dirtyColumns.get(i)).booleanValue()) continue;
            try {
                int n2 = cTRecord.GetFieldLength(i);
                FcBaseTableModel.CellData cellData = rowData.getData(i);
                Object object = cellData.getData();
                switch ((Integer)this.columnsType.get(i)) {
                    case 8: {
                        if (object == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        if (((Boolean)object).booleanValue()) {
                            cTRecord.SetFieldAsBoolean(i - n, Boolean.valueOf(true));
                            break;
                        }
                        cTRecord.SetFieldAsBoolean(i - n, Boolean.valueOf(false));
                        break;
                    }
                    case 128: 
                    case 144: 
                    case 146: 
                    case 152: 
                    case 154: 
                    case 160: 
                    case 162: 
                    case 168: 
                    case 170: 
                    case 177: 
                    case 185: 
                    case 193: 
                    case 201: {
                        if (object == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        if (!(object instanceof byte[])) break;
                        cTRecord.SetFieldAsBytes(i - n, (byte[])object);
                        break;
                    }
                    case 16: 
                    case 24: 
                    case 33: 
                    case 41: 
                    case 51: 
                    case 59: {
                        Integer n3 = (Integer)object;
                        if (n3 == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        cTRecord.SetFieldAsInt(i - n, n3);
                        break;
                    }
                    case 231: 
                    case 239: {
                        Long l = (Long)object;
                        if (l == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        cTRecord.SetFieldAsLong(i - n, l);
                        break;
                    }
                    case 75: 
                    case 83: 
                    case 124: {
                        Date date = (Date)object;
                        Calendar calendar = Calendar.getInstance();
                        if (date == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        calendar.setTimeInMillis(date.getTime());
                        cTRecord.SetFieldAsCalendar(i - n, calendar);
                        break;
                    }
                    case 91: {
                        Float f = (Float)object;
                        if (f == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        cTRecord.SetFieldAsDouble(i - n, Double.valueOf(f.doubleValue()));
                        break;
                    }
                    case 67: 
                    case 103: 
                    case 119: {
                        Double d = (Double)object;
                        if (d == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        cTRecord.SetFieldAsDouble(i - n, d);
                        break;
                    }
                    case 105: 
                    case 143: {
                        BigDecimal bigDecimal = (BigDecimal)object;
                        if (bigDecimal == null) {
                            cTRecord.ClearField(i - n);
                            break;
                        }
                        cTRecord.SetFieldAsBigDecimal(i - n, bigDecimal);
                    }
                }
                continue;
            }
            catch (CTException cTException) {
                try {
                    Globals.showMessage(cTException.GetErrorMsg() + "\n\nField in error : " + cTRecord.GetFieldName(i - n), "writeFields");
                    continue;
                }
                catch (CTException cTException2) {
                    // empty catch block
                }
            }
        }
    }

    public void selectRecord(int n) {
        int n2 = this.isamTable.getRowCount();
        if (n > 0 && n <= n2) {
            if (this.isamTable.getCellEditor() != null) {
                this.isamTable.getCellEditor().cancelCellEditing();
            }
            int n3 = this.isamTable.getSelectedColumn();
            this.isamTable.changeSelection(n - 1, n3, false, false);
        }
    }

    public void selectFirstRecord() {
        int n = this.isamTable.getSelectedRow();
        if (n > 0) {
            if (this.isamTable.getCellEditor() != null) {
                this.isamTable.getCellEditor().cancelCellEditing();
            }
            int n2 = this.isamTable.getSelectedColumn();
            this.isamTable.changeSelection(0, n2, false, false);
        }
    }

    public void selectPreviousRecord() {
        int n = this.isamTable.getSelectedRow();
        if (n > 0) {
            if (this.isamTable.getCellEditor() != null) {
                this.isamTable.getCellEditor().cancelCellEditing();
            }
            int n2 = this.isamTable.getSelectedColumn();
            this.isamTable.changeSelection(--n, n2, false, false);
        }
    }

    public void selectNextRecord() {
        int n = this.isamTable.getRowCount();
        int n2 = this.isamTable.getSelectedRow();
        if (n2 < n - 1) {
            if (this.isamTable.getCellEditor() != null) {
                this.isamTable.getCellEditor().cancelCellEditing();
            }
            int n3 = this.isamTable.getSelectedColumn();
            this.isamTable.changeSelection(++n2, n3, false, false);
        }
    }

    public void selectLastRecord() {
        int n = this.isamTable.getRowCount();
        if (this.isamTable.getCellEditor() != null) {
            this.isamTable.getCellEditor().cancelCellEditing();
        }
        int n2 = this.isamTable.getSelectedColumn();
        this.isamTable.changeSelection(n - 1, n2, false, false);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        int n = this.getRowCount();
        this.updateRowHeights();
        if (this.mustResizeRows) {
            this.mustResizeRows = false;
            this.resizeRows(n);
        }
    }

    private void resizeRows() {
        int n = this.getRowCount();
        this.resizeRows(n);
        this.fireTableDataChanged();
    }

    protected void selectRow(int n) {
        this.isamTable.changeSelection(n, 0, false, false);
    }

    private void resizeRows(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.metrics = this.isamTable.getFontMetrics(this.isamTable.getFont());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int n5;
            n3 = 0;
            TableColumnModel tableColumnModel = this.isamTable.getColumnModel();
            if (tableColumnModel.getColumnCount() <= 0) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n6 = this.getDataColumnNumber(i);
            int n7 = this.metrics.stringWidth((String)this.columnsName.get(n6)) + 15;
            for (n5 = 0; n5 < n; ++n5) {
                String string;
                if (this.getRowCount() <= n5) continue;
                FcBaseTableModel.RowData rowData = this.getRow(n5);
                FcBaseTableModel.CellData cellData = rowData.getData(n6);
                int n8 = (Integer)this.columnsType.get(n6);
                Object object = cellData.getData();
                if (object == null) {
                    n2 = this.metrics.stringWidth("(null)") + 10;
                } else if (n8 == 75) {
                    string = this.dateFormatter.format(object);
                    n2 = this.metrics.stringWidth(string) + 10;
                } else if (n8 == 83) {
                    string = this.timeFormatter.format(object);
                    n2 = this.metrics.stringWidth(string) + 10;
                } else if (n8 == 124) {
                    string = this.dateTimeFormatter.format(object);
                    n2 = this.metrics.stringWidth(string) + 10;
                } else {
                    n2 = this.metrics.stringWidth(object.toString()) + 10;
                }
                n3 = n4 = Math.max(n3, n2);
            }
            n5 = Math.max(n7, n4);
            tableColumn.setPreferredWidth(n5);
        }
    }

    private EXIT_CODE showSystablesWarning() {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        Object[] objectArray = new Object[]{"Proceed", "Abort"};
        int n = JOptionPane.showOptionDialog(jFrame, "Updates to system tables may render the system unusable", "Update System Table", 0, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            return EXIT_CODE.RETRY;
        }
        if (n == 1) {
            return EXIT_CODE.ABORT;
        }
        return EXIT_CODE.RELOAD;
    }

    private void inittypes() {
        fieldTypes.put(8, "CT_BOOL");
        fieldTypes.put(16, "CT_CHAR");
        fieldTypes.put(24, "CT_CHARU");
        fieldTypes.put(16, "CT_CHAR");
        fieldTypes.put(33, "CT_INT2");
        fieldTypes.put(41, "CT_INT2U");
        fieldTypes.put(51, "CT_INT4");
        fieldTypes.put(59, "CT_INT4U");
        fieldTypes.put(231, "CT_INT8");
        fieldTypes.put(239, "CT_INT8U");
        fieldTypes.put(67, "CT_MONEY");
        fieldTypes.put(75, "CT_DATE");
        fieldTypes.put(83, "CT_TIME");
        fieldTypes.put(124, "CT_TIMES");
        fieldTypes.put(91, "CT_SFLOAT");
        fieldTypes.put(103, "CT_DFLOAT");
        fieldTypes.put(119, "CT_EFLOAT");
        fieldTypes.put(128, "CT_ARRAY");
        fieldTypes.put(144, "CT_FSTRING");
        fieldTypes.put(152, "CT_FPSTRING");
        fieldTypes.put(160, "CT_F2STRING");
        fieldTypes.put(168, "CT_F4STRING");
        fieldTypes.put(146, "CT_STRING");
        fieldTypes.put(154, "CT_PSTRING");
        fieldTypes.put(162, "CT_2STRING");
        fieldTypes.put(170, "CT_4STRING");
        fieldTypes.put(177, "CT_FUNICODE");
        fieldTypes.put(193, "CT_F2UNICODE");
        fieldTypes.put(185, "CT_VUNICODE");
        fieldTypes.put(201, "CT_V2UNICODE");
        fieldTypes.put(231, "CT_BIGINT");
        fieldTypes.put(105, "CT_NUMBER");
        fieldTypes.put(143, "CT_CURRENCY");
        keyTypes.put(0, "FIXED");
        keyTypes.put(4, "LEADING");
        keyTypes.put(8, "PADDING");
        keyTypes.put(12, "LEADPAD");
        segModes.put(0, "REGSEG");
        segModes.put(1, "INTSEG");
        segModes.put(2, "UREGSEG");
        segModes.put(3, "SRLSEG");
        segModes.put(4, "VARSEG");
        segModes.put(5, "UVARSEG");
        segModes.put(8, "SGNSEG");
        segModes.put(9, "FLTSEG");
        segModes.put(10, "DECSEG");
        segModes.put(11, "BCDSEG");
        segModes.put(12, "SCHSEG");
        segModes.put(13, "USCHSEG");
        segModes.put(14, "VSCHSEG");
        segModes.put(15, "UVSCHSEG");
        segModes.put(32, "ALTSEG");
        segModes.put(64, "ENDSEG");
        segModes.put(128, "UNCSEG");
        segModes.put(256, "RECBYT");
        segModes.put(257, "SCHSRL");
        segModes.put(1024, "GNXSEG");
        binaryFlags.put(1, "BINARY_FIXED");
        binaryFlags.put(4, "BINARY_VARCHAR");
    }
}

