/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import FairCom.Helper.Classes.CtreeServer;
import ctreeaceexplorer.AddTableDialog;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.DbTableDialog;
import ctreeaceexplorer.DynamicTree;
import ctreeaceexplorer.Field;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ISAM_MODE;
import ctreeaceexplorer.Index;
import ctreeaceexplorer.IsamConnection;
import ctreeaceexplorer.IsamTableModel;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.RebuildDialog;
import ctreeaceexplorer.Segment;
import ctreeaceexplorer.TAB_PAGES;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.TableSchemaEditor;
import ctreeaceexplorer.sql.SqlConnection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IsamTree
extends DynamicTree {
    CtreeACEExplorerView appFrame;
    private MyTreeNode currentNode;
    public MyTreeNode externalTablesNode;
    private ArrayList<String> servers = new ArrayList();
    private JPopupMenu popup = null;
    private ArrayList<MyTreeNode> selectedExportFiles = new ArrayList();
    private MouseListener popupListener = new PopupListener();

    public IsamTree(CtreeACEExplorerView ctreeACEExplorerView) {
        super(ctreeACEExplorerView);
        this.appFrame = ctreeACEExplorerView;
        this.addMouseListener(this.popupListener);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.valueChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.servers.clear();
    }

    public void valueChanged() {
        this.appFrame.isamObjectLabel.setText("Current Object = ");
        this.appFrame.isamObjectLabel.setEnabled(false);
        this.appFrame.isamObjectLabel1.setText("Current Object = ");
        this.appFrame.isamObjectLabel1.setEnabled(false);
        this.appFrame.showRowNumCB.setEnabled(false);
        MyTreeNode myTreeNode = (MyTreeNode)this.getLastSelectedPathComponent();
        if (myTreeNode == null || myTreeNode.name.equals("Root Node")) {
            return;
        }
        TAB_PAGES tAB_PAGES = this.appFrame.getSelectedPane();
        this.appFrame.rightTabbedPanel.removeAll();
        if (myTreeNode == null) {
            this.appFrame.rightTabbedPanel.add("Database Tables", this.appFrame.isamItemsViewPane);
            this.clearRecordsViewTable();
            this.clearItemsViewTable();
            this.clearTblPropViewTable();
            return;
        }
        if (this.currentNode != myTreeNode) {
            Globals.isamTreeNodeChanged = true;
        }
        this.currentNode = myTreeNode;
        this.refreshCurrentConnection();
        if (myTreeNode.getType() == TREE_OBJECT.SERVER) {
            this.clearRecordsViewTable();
            this.clearTblPropViewTable();
            this.appFrame.rightTabbedPanel.add("Session Databases", this.appFrame.isamItemsViewPane);
        } else if (myTreeNode.getType() == TREE_OBJECT.EXTERNAL_ROOT) {
            this.clearRecordsViewTable();
            this.clearTblPropViewTable();
            this.appFrame.rightTabbedPanel.add("External Tables", this.appFrame.isamItemsViewPane);
        } else if (myTreeNode.getType() != TREE_OBJECT.TABLE && myTreeNode.getType() != TREE_OBJECT.SYSTABLE && myTreeNode.getType() != TREE_OBJECT.EXTERNAL_TABLE) {
            this.clearRecordsViewTable();
            this.clearTblPropViewTable();
            this.appFrame.rightTabbedPanel.add("Database Tables", this.appFrame.isamItemsViewPane);
        } else {
            this.appFrame.rightTabbedPanel.add("Table Fields", this.appFrame.isamItemsViewPane);
            this.appFrame.rightTabbedPanel.add("Table Properties", this.appFrame.isamTblPropViewPane);
            this.appFrame.rightTabbedPanel.add("Table Records", this.appFrame.isamRecordsViewPane);
        }
        String string = myTreeNode.getName();
        this.setupActions(myTreeNode.getType());
        boolean bl = true;
        TREE_OBJECT tREE_OBJECT = TREE_OBJECT.SYSTABLE;
        TREE_OBJECT tREE_OBJECT2 = TREE_OBJECT.SYSINDEXES;
        TREE_OBJECT tREE_OBJECT3 = TREE_OBJECT.SYSINDEX;
        switch (myTreeNode.getType()) {
            case SERVER: {
                this.clearItemsViewTable();
                ArrayList<Object[]> arrayList = Globals.currentIsamConnection.readDatabases();
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    for (Object[] objectArray : arrayList) {
                        MyTreeNode myTreeNode2 = new MyTreeNode(objectArray[0].toString(), TREE_OBJECT.DATABASE, (DynamicTree)this);
                        this.addObject(myTreeNode, myTreeNode2);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
                isamTableModel.populateDbTables(arrayList, true);
                break;
            }
            case EXTERNAL_ROOT: {
                this.clearItemsViewTable();
                IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
                isamTableModel.populateExtTables(myTreeNode);
                break;
            }
            case DATABASE: {
                this.clearItemsViewTable();
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    this.addObject(myTreeNode, new MyTreeNode("Tables", TREE_OBJECT.TABLES, (DynamicTree)this));
                    this.addObject(myTreeNode, new MyTreeNode("System Tables", TREE_OBJECT.SYSTABLES, (DynamicTree)this));
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                ArrayList<Object[]> arrayList = Globals.currentIsamConnection.readTables(false);
                IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
                isamTableModel.populateDbTables(arrayList, false);
                break;
            }
            case TABLES: {
                bl = false;
                tREE_OBJECT = TREE_OBJECT.TABLE;
            }
            case SYSTABLES: {
                ArrayList<Object[]> arrayList = Globals.currentIsamConnection.readTables(bl);
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    for (Object[] objectArray : arrayList) {
                        MyTreeNode myTreeNode3 = new MyTreeNode(objectArray[0].toString(), tREE_OBJECT, true, this);
                        this.addObject(myTreeNode, myTreeNode3);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
                isamTableModel.populateDbTables(arrayList, false);
                break;
            }
            case INDEXES: {
                tREE_OBJECT3 = TREE_OBJECT.INDEX;
            }
            case SYSINDEXES: 
            case TBLINDEXES: {
                String string2 = ((MyTreeNode)myTreeNode.getParent()).name;
                this.appFrame.isamObjectLabel.setText("Current Object = Table : " + string2);
                this.appFrame.isamObjectLabel.setEnabled(true);
                this.appFrame.isamObjectLabel1.setText("Current Object = Table : " + string2);
                this.appFrame.isamObjectLabel1.setEnabled(true);
                this.appFrame.rightTabbedPanel.removeAll();
                this.appFrame.rightTabbedPanel.add("Table Indexes", this.appFrame.isamItemsViewPane);
                ArrayList<Index> arrayList = Globals.currentIsamConnection.readTableIndexes(string2);
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    for (Index index : arrayList) {
                        MyTreeNode myTreeNode4 = new MyTreeNode(index.name, tREE_OBJECT3, (DynamicTree)this);
                        this.addObject(myTreeNode, myTreeNode4);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
                isamTableModel.populateTableIndexes(arrayList);
                break;
            }
            case TABLE: 
            case EXTERNAL_TABLE: {
                tREE_OBJECT2 = TREE_OBJECT.INDEXES;
            }
            case SYSTABLE: {
                this.appFrame.isamObjectLabel.setText("Current Object = Table : " + string);
                this.appFrame.isamObjectLabel.setEnabled(true);
                this.appFrame.isamObjectLabel1.setText("Current Object = Table : " + string);
                this.appFrame.isamCurrentTable.setText("Current Table : " + string);
                this.appFrame.isamObjectLabel1.setEnabled(true);
                Globals.currentIsamConnection.setDefaultIndexName("");
                this.appFrame.keyValueTB.setEnabled(false);
                this.appFrame.keyValueTB.setText("");
                Globals.isamTableLoading = true;
                if (myTreeNode.getChildCount() == 0) {
                    this.addObject(myTreeNode, new MyTreeNode("Indexes", tREE_OBJECT2, (DynamicTree)this));
                }
                if (Globals.isamTreeNodeChanged) {
                    this.appFrame.indexCB.removeAllItems();
                    if ((Globals.isamOpenMode & 0x40) != 64) {
                        ArrayList<Index> arrayList = Globals.currentIsamConnection.readTableIndexes(string);
                        if (arrayList == null || arrayList.isEmpty()) break;
                        String string3 = "";
                        for (Index index : arrayList) {
                            this.appFrame.indexCB.addItem(index.name);
                            Globals.currentIsamConnection.setDefaultIndexName(index.name);
                            this.appFrame.indexCB.setSelectedItem(index.name);
                            this.appFrame.keyValueTB.setEnabled(true);
                            string3 = index.name;
                        }
                        if (string3.startsWith("Internal")) {
                            this.appFrame.keyValueTB.setEnabled(false);
                            this.appFrame.keyValueTB.setText("");
                        }
                    }
                    this.fillItemViewTable(string);
                    this.fillTblPropViewTable(string);
                    if (this.appFrame.getSelectedPane() == TAB_PAGES.ISAM_RECORDS_VIEW && (Globals.isamOpenMode & 0x40) != 64) {
                        this.fillRecordsViewTable(string);
                        Globals.isamTreeNodeChanged = false;
                    }
                }
                Globals.isamTableLoading = false;
                break;
            }
            case INDEX: 
            case TBLINDEXCON: 
            case SYSINDEX: {
                String string4 = ((MyTreeNode)myTreeNode.getParent().getParent()).name;
                this.appFrame.isamObjectLabel.setText("Current Object = Index : " + string);
                this.appFrame.isamObjectLabel.setEnabled(true);
                this.appFrame.isamObjectLabel1.setText("Current Object = Index : " + string);
                this.appFrame.isamObjectLabel1.setEnabled(true);
                this.appFrame.rightTabbedPanel.removeAll();
                this.appFrame.rightTabbedPanel.add("Index Segments", this.appFrame.isamItemsViewPane);
                ArrayList<Segment> arrayList = Globals.currentIsamConnection.readIndexSegments(string4, string);
                IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
                isamTableModel.populateIndexSegments(arrayList);
            }
        }
        this.appFrame.setSelectedPane(tAB_PAGES);
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private void fillItemViewTable(String string) {
        ArrayList<Field> arrayList = Globals.currentIsamConnection.readTableFields(string);
        IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
        isamTableModel.populateTableFields(arrayList);
    }

    private void fillTblPropViewTable(String string) {
        ArrayList<Object[]> arrayList = Globals.currentIsamConnection.readTableProperties(string);
        IsamTableModel isamTableModel = this.appFrame.isamTblPropViewTable.getModel();
        isamTableModel.populateTableProperties(arrayList);
    }

    public void fillRecordsViewTable(String string) {
        if (string.equals("SessionFile") || string.equals("DatabaseFile")) {
            Globals.showWarningMessage("Updates to system tables may render the system unusable", "Warning");
        }
        IsamTableModel isamTableModel = this.appFrame.isamRecordsViewTable.getModel();
        isamTableModel.clearTable();
        isamTableModel.columnsMode = null;
        isamTableModel.populateRecords(string);
    }

    private void clearItemsViewTable() {
        IsamTableModel isamTableModel = this.appFrame.isamItemsViewTable.getModel();
        isamTableModel.clearTable();
    }

    private void clearTblPropViewTable() {
        IsamTableModel isamTableModel = this.appFrame.isamTblPropViewTable.getModel();
        isamTableModel.clearTable();
    }

    private void clearRecordsViewTable() {
        IsamTableModel isamTableModel = this.appFrame.isamRecordsViewTable.getModel();
        isamTableModel.clearTable();
        isamTableModel.clearTableNavigator();
    }

    private void refreshCurrentConnection() {
        String string = "";
        String string2 = "";
        String string3 = "";
        block6: for (MyTreeNode myTreeNode = this.currentNode; myTreeNode != null && myTreeNode.getType() != null; myTreeNode = (MyTreeNode)myTreeNode.getParent()) {
            switch (myTreeNode.getType()) {
                case SERVER: {
                    string = myTreeNode.getName();
                    continue block6;
                }
                case DATABASE: {
                    string2 = myTreeNode.getName();
                    continue block6;
                }
                case USER: {
                    string3 = myTreeNode.getName();
                    continue block6;
                }
                case EXTERNAL_TABLE: {
                    if (Globals.currentIsamConnection == null) continue block6;
                    Globals.currentIsamConnection.isExternalTable = true;
                    Globals.currentIsamConnection.setHostNameOrAddress(myTreeNode.path);
                }
            }
        }
        if (this.currentNode.getType() == TREE_OBJECT.EXTERNAL_TABLE) {
            this.changeConnection(this.currentNode.path, this.currentNode.name, true);
        }
        if (string2.isEmpty()) {
            return;
        }
        if (!string.equals(Globals.currentIsamConnection.getServerId()) || !string2.equals(Globals.currentIsamConnection.getDatabaseName())) {
            this.changeConnection(string, string2, false);
        }
        Globals.currentIsamConnection.setSelectedUser(string3);
    }

    private IsamConnection checkConnections(String string, String string2, boolean bl) {
        for (IsamConnection isamConnection : Globals.isamConnections) {
            if (bl && isamConnection.isExternalTable) {
                isamConnection.setHostNameOrAddress(string);
                isamConnection.setDatabaseName(string2);
                return isamConnection;
            }
            if (!string.equals(isamConnection.getServerId()) || !string2.equals(isamConnection.getDatabaseName()) || !isamConnection.isConnected()) continue;
            return isamConnection;
        }
        return null;
    }

    private void changeConnection(String string, String string2, boolean bl) {
        IsamConnection isamConnection = Globals.currentIsamConnection;
        IsamConnection isamConnection2 = this.checkConnections(string, string2, bl);
        if (isamConnection2 != null) {
            Globals.currentIsamConnection = Globals.isamMultipleConnections ? isamConnection2 : new IsamConnection(bl, isamConnection2.getHostNameOrAddress(), isamConnection2.getServerPort(), string, Globals.currentIsamConnection.isUseServerPort(), isamConnection2.getLoggedUser(), isamConnection2.getPassword(), false);
        } else {
            if (bl) {
                Globals.currentIsamConnection = new IsamConnection(bl, string, 0, string2, false, "", "", false);
                Globals.isamConnections.add(Globals.currentIsamConnection);
            } else {
                if (!string.equals(Globals.currentIsamConnection.getServerId())) {
                    Object[] objectArray = Globals.currentIsamConnection.splitServerId(string);
                    Globals.currentIsamConnection = Globals.currentIsamConnection.isUseServerPort() ? new IsamConnection(bl, (String)objectArray[0], (Integer)objectArray[1], string, Globals.currentIsamConnection.isUseServerPort(), Globals.currentIsamConnection.getLoggedUser(), Globals.currentIsamConnection.getPassword(), false) : new IsamConnection(bl, (String)objectArray[0], Globals.currentIsamConnection.getServerPort(), (String)objectArray[1], Globals.currentIsamConnection.isUseServerPort(), Globals.currentIsamConnection.getLoggedUser(), Globals.currentIsamConnection.getPassword(), false);
                }
                if (Globals.currentIsamConnection.getDatabaseName().isEmpty()) {
                    if (Globals.currentIsamConnection.connectDatabase(string2)) {
                        Globals.currentIsamConnection.setDatabaseName(string2);
                    }
                } else {
                    Globals.currentIsamConnection.disconnectDatabase();
                    if (Globals.currentIsamConnection.connectDatabase(string2)) {
                        Globals.currentIsamConnection.setDatabaseName(string2);
                    }
                }
            }
            if (!Globals.currentIsamConnection.isConnected()) {
                Globals.currentIsamConnection = isamConnection;
            }
        }
        this.updateStatusBar();
    }

    public void updateStatusBar() {
        if (Globals.currentIsamConnection != null) {
            if (Globals.currentIsamConnection.isConnected()) {
                String string = Globals.currentIsamConnection.getDatabaseName();
                this.appFrame.connectSBLabel.setText("Connected to : " + Globals.currentIsamConnection.getServerId());
                this.appFrame.userSBLabel.setText("Connected as : " + Globals.currentIsamConnection.getLoggedUser());
            } else {
                this.appFrame.connectSBLabel.setText("Disconnected ");
                this.appFrame.userSBLabel.setText("");
            }
        }
    }

    public synchronized void addBroadCastingServer(String string) {
        for (String object2 : this.servers) {
            if (!object2.equals(string)) continue;
            return;
        }
        MyTreeNode myTreeNode = (MyTreeNode)this.getModel().getRoot();
        MyTreeNode myTreeNode2 = new MyTreeNode(string, TREE_OBJECT.SERVER, (DynamicTree)this);
        this.addObject(myTreeNode, myTreeNode2);
        this.servers.add(string);
    }

    public void createNewServer(CtreeServer ctreeServer, boolean bl, boolean bl2) {
        Globals.currentIsamConnection = bl ? new IsamConnection(false, ctreeServer, false, bl2) : new IsamConnection(false, ctreeServer, true, bl2);
        if (Globals.currentIsamConnection.isConnected()) {
            this.addFirstServerToTree();
            this.updateStatusBar();
        }
        Globals.isamConnections.add(Globals.currentIsamConnection);
    }

    public void createNewServer(boolean bl) {
        if (bl) {
            if (Globals.appProps.isamAutoConnect && !Globals.appProps.isamUserPassword.isEmpty()) {
                Globals.currentIsamConnection = new IsamConnection(false, Globals.appProps.isamHostNameOrAddress, Globals.appProps.isamServerPort, Globals.appProps.isamServerName, Globals.appProps.isamUseServerPort, Globals.appProps.isamUserName, Globals.appProps.isamUserPassword, false);
            } else {
                if (!Globals.appProps.isamRememberPassword) {
                    Globals.appProps.isamUserPassword = "";
                }
                Globals.currentIsamConnection = new IsamConnection(false, Globals.appProps.isamHostNameOrAddress, Globals.appProps.isamServerPort, Globals.appProps.isamServerName, Globals.appProps.isamUseServerPort, Globals.appProps.isamUserName, Globals.appProps.isamUserPassword, true);
            }
            if (Globals.currentIsamConnection.isConnected()) {
                Globals.appProps.saveProperties();
            }
        } else {
            IsamConnection isamConnection = new IsamConnection(false, Globals.appProps.isamHostNameOrAddress, Globals.appProps.isamServerPort, Globals.appProps.isamServerName, Globals.appProps.isamUseServerPort, Globals.appProps.isamUserName, Globals.appProps.isamUserPassword, true);
            if (isamConnection != null && isamConnection.isConnected()) {
                Globals.currentIsamConnection = isamConnection;
            }
            Globals.appProps.saveProperties();
        }
        if (Globals.currentIsamConnection.isConnected()) {
            this.addFirstServerToTree();
            this.updateStatusBar();
            Globals.appProps.isamHostNameOrAddress = Globals.currentIsamConnection.getHostNameOrAddress();
            Globals.appProps.isamServerPort = Globals.currentIsamConnection.getServerPort();
            Globals.appProps.isamUseServerPort = Globals.currentIsamConnection.isUseServerPort();
            Globals.appProps.isamUserName = Globals.currentIsamConnection.getLoggedUser();
            Globals.appProps.isamUserPassword = Globals.currentIsamConnection.getPassword();
            Globals.appProps.saveProperties();
        }
        Globals.isamConnections.add(Globals.currentIsamConnection);
    }

    public MyTreeNode getCurrentNode() {
        return this.currentNode;
    }

    void refresh() {
        this.resetIsNodeUpdated(this.currentNode);
        Globals.isamTreeNodeChanged = true;
        this.valueChanged();
    }

    public void refreshRightTables() {
        this.valueChanged();
    }

    private void resetIsNodeUpdated(MyTreeNode myTreeNode) {
        if (myTreeNode != null) {
            myTreeNode.setUpdated(false);
            for (int i = 0; i < myTreeNode.getChildCount(); ++i) {
                MyTreeNode myTreeNode2 = (MyTreeNode)myTreeNode.getChildAt(i);
                this.resetIsNodeUpdated(myTreeNode2);
            }
        }
    }

    void addDatabases(MyTreeNode myTreeNode) {
        ArrayList<Object[]> arrayList = Globals.currentIsamConnection.readDatabases();
        for (Object[] objectArray : arrayList) {
            MyTreeNode myTreeNode2 = new MyTreeNode(objectArray[0].toString(), TREE_OBJECT.DATABASE, (DynamicTree)this);
            this.addObject(myTreeNode, myTreeNode2);
        }
        this.expandNode();
        this.expandNode(myTreeNode);
    }

    void addFirstServerToTree() {
        MyTreeNode myTreeNode = null;
        MyTreeNode myTreeNode2 = new MyTreeNode(Globals.currentIsamConnection.getServerId(), TREE_OBJECT.SERVER, (DynamicTree)this);
        Globals.currentIsamConnection.setTreeNode(myTreeNode2);
        MyTreeNode myTreeNode3 = this.addObject(null, myTreeNode2);
        ArrayList<Object[]> arrayList = Globals.currentIsamConnection.readDatabases();
        for (Object[] objectArray : arrayList) {
            MyTreeNode myTreeNode4 = new MyTreeNode(objectArray[0].toString(), TREE_OBJECT.DATABASE, (DynamicTree)this);
            this.addObject(myTreeNode3, myTreeNode4);
            if (!objectArray[0].toString().equals(Globals.currentIsamConnection.getDatabaseName())) continue;
            myTreeNode = myTreeNode4;
        }
        this.expandNode();
        this.expandNode(myTreeNode3);
        this.setSelectionPath(new TreePath(myTreeNode3.getPath()));
        this.servers.add(Globals.currentIsamConnection.getServerId());
    }

    private void DumpStructure() {
        this.selectedExportFiles.clear();
        MyTreeNode myTreeNode = (MyTreeNode)this.getModel().getRoot();
        this.visitAllNodes(myTreeNode);
    }

    private void visitAllNodes(MyTreeNode myTreeNode) {
        boolean bl = false;
        boolean bl2 = false;
        if (myTreeNode.getChildCount() >= 0) {
            Enumeration<TreeNode> enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
                if (myTreeNode2.isChecked) {
                    bl = true;
                    this.selectedExportFiles.add(myTreeNode2);
                    this.exportNode(myTreeNode2);
                }
                this.visitAllNodes(myTreeNode2);
            }
        }
    }

    private void exportNode(MyTreeNode myTreeNode) {
        BufferedWriter bufferedWriter = null;
        File file = new File(this.appFrame.exportDir + File.pathSeparator + myTreeNode.name);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            ArrayList<Index> arrayList = Globals.currentIsamConnection.getTableIndexes();
            for (Index index : arrayList) {
                bufferedWriter.write("ISEG " + myTreeNode.name.toUpperCase() + "_ISEGS[] = { /* ISEGS */");
                index.segments = Globals.currentIsamConnection.getIndexSegments(myTreeNode.name, index.name);
                for (Segment segment : index.segments) {
                    bufferedWriter.write(", " + segment.mode);
                    bufferedWriter.write("},");
                }
            }
        }
        catch (IOException iOException) {
            Globals.showMessage("Cannot create " + file.getName() + " file", "Table Export error");
        }
    }

    private void setupActions(TREE_OBJECT tREE_OBJECT) {
        this.popup = new JPopupMenu();
        this.appFrame.actionsMenu.removeAll();
        MouseListener[] mouseListenerArray = this.appFrame.actionsMenu.getMouseListeners();
        if (mouseListenerArray.length == 1) {
            this.appFrame.actionsMenu.addMouseListener(this.popupListener);
        }
        boolean bl = false;
        if (Globals.isamExportMode) {
            switch (tREE_OBJECT) {
                case DATABASE: 
                case TABLE: {
                    if (this.currentNode.getChildCount() <= 0) break;
                    this.addMenuItem("Export ISAM Level Header File", null, Character.valueOf('E'), new IsamActions(ISAM_MODE.TABLE_EXPORT, ""), false, false);
                    bl = true;
                }
            }
        } else {
            switch (tREE_OBJECT) {
                case SERVER: {
                    if (Globals.currentIsamConnection.isConnected()) {
                        this.addMenuItem("Disconnect From This Server", "Disconnect.png", Character.valueOf('D'), new DisconnectFromAction(), false, false);
                        this.addMenuItem("Add Existing Database", null, Character.valueOf('A'), new IsamActions(ISAM_MODE.DB_ADD, ""), false, false);
                        this.addMenuItem("Create New Database", null, Character.valueOf('C'), new IsamActions(ISAM_MODE.DB_CREATE, ""), false, false);
                        if (Globals.advancedMode) {
                            this.addMenuItem("Show Session File", null, Character.valueOf('S'), new AdvancedAction(1), false, false);
                        }
                        bl = true;
                        break;
                    }
                    this.addMenuItem("Connect To This Server", "Connect.png", Character.valueOf('C'), new ConnectToNewAction(), false, false);
                    bl = true;
                    break;
                }
                case DATABASE: {
                    this.addMenuItem("Add Existing Table", null, Character.valueOf('A'), new IsamActions(ISAM_MODE.TABLE_ADD, ""), false, false);
                    this.addMenuItem("Create New Table", null, Character.valueOf('C'), new IsamActions(ISAM_MODE.TABLE_CREATE, ""), false, false);
                    this.addMenuItem("Delete Database", null, Character.valueOf('D'), new IsamActions(ISAM_MODE.DB_DELETE, this.currentNode.getName()), false, false);
                    this.addMenuItem("Drop Database", null, Character.valueOf('P'), new IsamActions(ISAM_MODE.DB_DROP, this.currentNode.getName()), false, false);
                    if (Globals.advancedMode) {
                        this.addMenuItem("Show Database File", null, Character.valueOf('S'), new AdvancedAction(2), false, false);
                    }
                    bl = true;
                    break;
                }
                case USER: {
                    break;
                }
                case TABLES: {
                    break;
                }
                case SYSTABLES: {
                    break;
                }
                case INDEXES: {
                    break;
                }
                case SYSINDEXES: {
                    break;
                }
                case TABLE: {
                    this.addMenuItem("Delete Table", null, Character.valueOf('D'), new IsamActions(ISAM_MODE.TABLE_DELETE, this.currentNode.getName()), false, false);
                    this.addMenuItem("Drop Table", null, Character.valueOf('P'), new IsamActions(ISAM_MODE.TABLE_DROP, this.currentNode.getName()), false, false);
                    this.addMenuItem("Modify Table", null, Character.valueOf('M'), new IsamActions(ISAM_MODE.TABLE_MODIFY, this.currentNode.getName()), false, false);
                    this.addMenuItem("Rebuild / Compact Table", null, Character.valueOf('R'), new IsamActions(ISAM_MODE.TABLE_REBUILD, this.currentNode.getName()), false, false);
                    bl = true;
                    break;
                }
                case SYSTABLE: {
                    break;
                }
                case INDEX: {
                    break;
                }
                case SYSINDEX: {
                    break;
                }
                case EXTERNAL_ROOT: {
                    this.addMenuItem("Open External Table", null, Character.valueOf('O'), new IsamActions(ISAM_MODE.OPEN_EXTERNAL, this.currentNode.getName()), false, false);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.appFrame.actionsMenu.add(new JPopupMenu.Separator());
            this.popup.add(new JPopupMenu.Separator());
        }
        this.addMenuItem("Refresh", "Refresh.png", Character.valueOf('R'), new RefreshAction(), false, false);
    }

    private void addMenuItem(String string, String string2, Character c, ActionListener actionListener, boolean bl, boolean bl2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        JMenuItem jMenuItem2 = new JMenuItem(string);
        if (string2 != null) {
            jMenuItem.setIcon(Globals.getIcon(string2));
            jMenuItem2.setIcon(Globals.getIcon(string2));
        }
        if (c != null) {
            jMenuItem.setMnemonic(c.charValue());
            jMenuItem2.setMnemonic(c.charValue());
        }
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
        this.popup.add(jMenuItem);
        this.appFrame.actionsMenu.add(jMenuItem2);
    }

    void setForegroundColor(Color color) {
        this.foregroundColor = color;
        this.setVisible(false);
        this.setVisible(true);
    }

    void addExternalTablesNode() {
        if (this.externalTablesNode == null) {
            MyTreeNode myTreeNode = (MyTreeNode)this.getModel().getRoot();
            this.externalTablesNode = new MyTreeNode("External Tables", TREE_OBJECT.EXTERNAL_ROOT, (DynamicTree)this);
            this.addObject(myTreeNode, this.externalTablesNode);
        }
    }

    void addExternalTable(String string, String string2) {
        if (this.externalTablesNode != null) {
            MyTreeNode myTreeNode = new MyTreeNode(string, TREE_OBJECT.EXTERNAL_TABLE, (DynamicTree)this);
            myTreeNode.setTablePath(string2);
            this.addObject(this.externalTablesNode, myTreeNode);
            this.expandNode(this.externalTablesNode);
        }
    }

    class AdvancedAction
    implements ActionListener {
        int mode;

        public AdvancedAction(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IsamTree.this.appFrame.rightTabbedPanel.removeAll();
            IsamTree.this.appFrame.rightTabbedPanel.add("Table Fields", IsamTree.this.appFrame.isamItemsViewPane);
            IsamTree.this.appFrame.rightTabbedPanel.add("Table Properties", IsamTree.this.appFrame.isamTblPropViewPane);
            IsamTree.this.appFrame.rightTabbedPanel.add("Table Records", IsamTree.this.appFrame.isamRecordsViewPane);
            String string = this.mode == 1 ? "SessionFile" : "DatabaseFile";
            IsamTree.this.appFrame.indexCB.removeAllItems();
            Globals.isamTableLoading = true;
            Globals.currentIsamConnection.setDefaultIndexName("");
            ArrayList<Index> arrayList = Globals.currentIsamConnection.readTableIndexes(string);
            for (Index index : arrayList) {
                IsamTree.this.appFrame.indexCB.addItem(index.name);
            }
            IsamTree.this.fillItemViewTable(string);
            IsamTree.this.fillTblPropViewTable(string);
            IsamTree.this.fillRecordsViewTable(string);
            Globals.isamTreeNodeChanged = false;
            Globals.isamTableLoading = false;
        }
    }

    class IsamActions
    implements ActionListener {
        ISAM_MODE mode;
        String name;

        public IsamActions(ISAM_MODE iSAM_MODE, String string) {
            this.mode = iSAM_MODE;
            this.name = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
            if (this.mode == ISAM_MODE.TABLE_CREATE || this.mode == ISAM_MODE.TABLE_MODIFY) {
                boolean bl = Globals.isamShowDebugColumns;
                IsamTree.this.appFrame.showInfoCB.setSelected(false);
                Globals.isamShowDebugColumns = false;
                TableSchemaEditor tableSchemaEditor = new TableSchemaEditor((Frame)jFrame, true);
                tableSchemaEditor.setLocationRelativeTo(jFrame);
                tableSchemaEditor.showDialog(this.mode, this.name);
                IsamTree.this.appFrame.showInfoCB.setSelected(bl);
                Globals.isamShowDebugColumns = bl;
                if (this.mode == ISAM_MODE.TABLE_CREATE) {
                    IsamTree.this.currentNode.setUpdated(false);
                    IsamTree.this.refresh();
                    IsamTree.this.expandNode(IsamTree.this.currentNode);
                    MyTreeNode myTreeNode = (MyTreeNode)IsamTree.this.currentNode.getChildAt(0);
                    if (myTreeNode != null) {
                        IsamTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                    }
                    IsamTree.this.refresh();
                } else {
                    IsamTree.this.refresh();
                }
            } else if (this.mode == ISAM_MODE.TABLE_REBUILD) {
                RebuildDialog rebuildDialog = new RebuildDialog((Frame)jFrame, true);
                rebuildDialog.setLocationRelativeTo(jFrame);
                rebuildDialog.showDialog(this.mode, this.name);
            } else if (this.mode == ISAM_MODE.TABLE_EXPORT) {
                if (IsamTree.this.appFrame.exportDir.isEmpty()) {
                    IsamTree.this.appFrame.setExportDir();
                }
                IsamTree.this.DumpStructure();
            } else if (this.mode == ISAM_MODE.TABLE_ADD) {
                AddTableDialog addTableDialog = new AddTableDialog((Frame)jFrame, true);
                addTableDialog.setLocationRelativeTo(jFrame);
                Rectangle rectangle = addTableDialog.getBounds();
                addTableDialog.setLocation(rectangle.x, rectangle.y - 150);
                addTableDialog.showDialog(this.mode, null);
                IsamTree.this.refresh();
            } else if (this.mode == ISAM_MODE.OPEN_EXTERNAL) {
                DbTableDialog dbTableDialog = new DbTableDialog((Frame)jFrame, true);
                dbTableDialog.setLocationRelativeTo(jFrame);
                boolean bl = dbTableDialog.showDialog(ISAM_MODE.OPEN_EXTERNAL, "");
                if (bl) {
                    String string = dbTableDialog.getTableName();
                    String string2 = dbTableDialog.getTablePath();
                    IsamTree.this.addExternalTablesNode();
                    IsamTree.this.addExternalTable(string, string2);
                }
                IsamTree.this.refresh();
            } else {
                DbTableDialog dbTableDialog = new DbTableDialog((Frame)jFrame, true);
                dbTableDialog.setLocationRelativeTo(jFrame);
                dbTableDialog.showDialog(this.mode, this.name);
                switch (this.mode) {
                    case DB_ADD: {
                        break;
                    }
                    case DB_DROP: 
                    case DB_DELETE: {
                        MyTreeNode myTreeNode = (MyTreeNode)IsamTree.this.currentNode.getParent();
                        if (myTreeNode == null) break;
                        IsamTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        break;
                    }
                    case TABLE_DROP: 
                    case TABLE_DELETE: {
                        MyTreeNode myTreeNode = (MyTreeNode)IsamTree.this.currentNode.getParent();
                        if (myTreeNode == null || myTreeNode == null) break;
                        IsamTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                    }
                }
                IsamTree.this.refresh();
            }
        }
    }

    class DisconnectFromAction
    implements ActionListener {
        DisconnectFromAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Globals.currentIsamConnection.disconnect();
            for (IsamConnection isamConnection : Globals.isamConnections) {
                if (isamConnection != Globals.currentIsamConnection) continue;
                Globals.isamConnections.remove((Object)isamConnection);
                break;
            }
            ((IsamTree)IsamTree.this).currentNode.tree.clearNode(IsamTree.this.currentNode);
            IsamTree.this.updateStatusBar();
        }
    }

    class ConnectToNewAction
    implements ActionListener {
        ConnectToNewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IsamConnection isamConnection = Globals.currentIsamConnection;
            String string = IsamTree.this.currentNode.getName();
            Object[] objectArray = SqlConnection.splitServerId(string);
            Globals.currentIsamConnection = objectArray[1] instanceof String ? new IsamConnection(false, (String)objectArray[0], 5595, objectArray[1].toString(), false, Globals.currentIsamConnection.getLoggedUser(), Globals.currentIsamConnection.getPassword(), true) : new IsamConnection(false, (String)objectArray[0], (Integer)objectArray[1], "FAIRCOMS", true, Globals.currentIsamConnection.getLoggedUser(), Globals.currentIsamConnection.getPassword(), true);
            Globals.isamConnections.add(Globals.currentIsamConnection);
            if (!Globals.currentIsamConnection.isConnected()) {
                Globals.currentIsamConnection = isamConnection;
            } else {
                IsamTree.this.addDatabases(IsamTree.this.currentNode);
            }
            IsamTree.this.updateStatusBar();
        }
    }

    class RefreshAction
    implements ActionListener {
        RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IsamTree.this.refresh();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            IsamTree isamTree;
            TreePath treePath;
            Component component = mouseEvent.getComponent();
            if (component.getClass() == IsamTree.class && (treePath = (isamTree = (IsamTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                int n = mouseEvent.getButton();
                if (n == 3) {
                    isamTree.setSelectionPath(treePath);
                    isamTree.scrollPathToVisible(treePath);
                    IsamTree.this.setupActions(isamTree.getCurrentNode().getType());
                }
                if (mouseEvent.isPopupTrigger()) {
                    IsamTree.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

