/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.Globals;
import ctreeaceexplorer.IsamTree;
import ctreeaceexplorer.sql.SqlTree;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.logging.Level;
import java.util.logging.Logger;

class LookUpServer
implements Runnable {
    SqlTree sqlTree;
    IsamTree isamTree;
    InetAddress address;
    static boolean errorDisplayed = false;
    public boolean stopped = false;

    public LookUpServer(SqlTree sqlTree, IsamTree isamTree, InetAddress inetAddress) {
        this.sqlTree = sqlTree;
        this.isamTree = isamTree;
        this.address = inetAddress;
    }

    @Override
    public void run() {
        block5: {
            try {
                InetAddress inetAddress = InetAddress.getByName("234.5.6.7");
                MulticastSocket multicastSocket = new MulticastSocket(5555);
                multicastSocket.setNetworkInterface(NetworkInterface.getByInetAddress(this.address));
                multicastSocket.joinGroup(inetAddress);
                while (!this.stopped) {
                    byte[] byArray = new byte[1000];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    multicastSocket.receive(datagramPacket);
                    String string = new String(datagramPacket.getData());
                    System.out.println(string);
                    System.out.println(this.address);
                    this.updateTree(string);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(LookUpServer.class.getName()).log(Level.SEVERE, null, interruptedException);
                    }
                }
            }
            catch (IOException iOException) {
                if (errorDisplayed) break block5;
                errorDisplayed = true;
                Globals.showMessage(iOException.getMessage() + "\n\nThere may be another tool already listening for broadcasts", "Broadcast Error");
            }
        }
    }

    synchronized void updateTree(String string) {
        String[] stringArray = string.split("\\|");
        if (stringArray.length > 2) {
            String string2 = stringArray[2].replace("\n", "").trim();
            this.isamTree.addBroadCastingServer(string2 + "@" + stringArray[1]);
            if (string2.equals("5597")) {
                string2 = "6597";
            }
            string2 = string2 + "@" + stringArray[1];
            this.sqlTree.addBroadCastingServer(string2);
        }
    }
}

