/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.DynamicTree;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.TREE_OBJECT;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public class MyTreeNode
extends DefaultMutableTreeNode {
    public static final int DIG_IN_SELECTION = 4;
    static int id = 0;
    private int nodeId;
    public String name;
    String path;
    Icon leafIcon;
    Icon closedIcon;
    Icon openIcon;
    private TREE_OBJECT type;
    private boolean updated;
    public DynamicTree tree;
    String text;
    boolean isChecked;
    boolean showCheckBox;
    private int dbVersion = 0;

    public MyTreeNode(String string, DynamicTree dynamicTree) {
        this.name = string;
        this.tree = dynamicTree;
        this.nodeId = ++id;
    }

    public MyTreeNode(String string, boolean bl, DynamicTree dynamicTree) {
        this.name = string;
        this.tree = dynamicTree;
        this.isChecked = bl;
        this.nodeId = ++id;
    }

    public MyTreeNode(String string, TREE_OBJECT tREE_OBJECT, DynamicTree dynamicTree) {
        this.name = string;
        this.tree = dynamicTree;
        this.type = tREE_OBJECT;
        this.nodeId = ++id;
        this.setIcon(tREE_OBJECT);
    }

    public MyTreeNode(String string, TREE_OBJECT tREE_OBJECT, boolean bl, DynamicTree dynamicTree) {
        this.name = string;
        this.tree = dynamicTree;
        this.type = tREE_OBJECT;
        this.showCheckBox = bl;
        this.nodeId = ++id;
        this.setIcon(tREE_OBJECT);
    }

    private void setIcon(TREE_OBJECT tREE_OBJECT) {
        switch (tREE_OBJECT) {
            case SERVER: 
            case EXTERNAL_ROOT: {
                this.leafIcon = Globals.getIcon("Server.png");
                break;
            }
            case DATABASE: {
                this.leafIcon = Globals.getIcon("Database.png");
                break;
            }
            case USER: {
                this.leafIcon = Globals.getIcon("User.png");
                break;
            }
            case TABLES: {
                this.leafIcon = Globals.getIcon("Tables.png");
                break;
            }
            case TABLE: 
            case EXTERNAL_TABLE: {
                this.leafIcon = Globals.getIcon("Table.png");
                break;
            }
            case TABLE_RTG: {
                this.leafIcon = Globals.getIcon("TableRTG.png");
                break;
            }
            case TABLE_LINKED: {
                this.leafIcon = Globals.getIcon("TableLinked.png");
                break;
            }
            case SYSTABLES: {
                this.leafIcon = Globals.getIcon("TablesPlus.png");
                break;
            }
            case SYSTABLE: {
                this.leafIcon = Globals.getIcon("TablePlus.png");
                break;
            }
            case VIEWS: {
                this.leafIcon = Globals.getIcon("Views.png");
                break;
            }
            case VIEW: {
                this.leafIcon = Globals.getIcon("View.png");
                break;
            }
            case BPROCEDURES: {
                this.leafIcon = Globals.getIcon("BProcedures.png");
                break;
            }
            case BPROCEDURE: {
                this.leafIcon = Globals.getIcon("BProcedure.png");
                break;
            }
            case UPROCEDURES: {
                this.leafIcon = Globals.getIcon("UProcedures.png");
                break;
            }
            case UPROCEDURE: {
                this.leafIcon = Globals.getIcon("UProcedure.png");
                break;
            }
            case UDFS: {
                this.leafIcon = Globals.getIcon("Udfs.png");
                break;
            }
            case UDF: {
                this.leafIcon = Globals.getIcon("Udf.png");
                break;
            }
            case INDEXES: 
            case TBLINDEXES: {
                this.leafIcon = Globals.getIcon("Indexes.png");
                break;
            }
            case INDEX: 
            case TBLINDEX: {
                this.leafIcon = Globals.getIcon("Index.png");
                break;
            }
            case INDEXCON: 
            case TBLINDEXCON: {
                this.leafIcon = Globals.getIcon("IndexCon.png");
                break;
            }
            case SYSINDEXES: {
                this.leafIcon = Globals.getIcon("IndexesPlus.png");
                break;
            }
            case SYSINDEX: {
                this.leafIcon = Globals.getIcon("IndexPlus.png");
                break;
            }
            case SYNONYMS: {
                this.leafIcon = Globals.getIcon("Synonyms.png");
                break;
            }
            case SYNONYM: {
                this.leafIcon = Globals.getIcon("Synonym.png");
                break;
            }
            case TRIGGERS: {
                this.leafIcon = Globals.getIcon("Triggers.png");
                break;
            }
            case TRIGGER: {
                this.leafIcon = Globals.getIcon("Trigger.png");
                break;
            }
            case PLAN_TABLES: {
                this.leafIcon = Globals.getIcon("Statements.png");
                break;
            }
            case PLAN_TABLE: {
                this.leafIcon = Globals.getIcon("Statements.png");
                break;
            }
            case STATEMENT: {
                this.leafIcon = Globals.getIcon("Statement.png");
                break;
            }
            case COLUMNS: {
                this.leafIcon = Globals.getIcon("Columns.png");
            }
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getTablePath() {
        return this.path;
    }

    public void setTablePath(String string) {
        this.path = string;
    }

    public String getText() {
        return this.text;
    }

    public void setChecked(boolean bl) {
        Object object;
        if (this.tree.getSelectionMode() == DynamicTree.SELECTION_MODE.SELECT_UPPER) {
            object = (MyTreeNode)this.parent;
            while (object != null) {
                if (bl) {
                    ((MyTreeNode)object).isChecked = bl;
                }
                object = (MyTreeNode)((MyTreeNode)object).parent;
            }
        }
        this.isChecked = bl;
        if ((this.tree.getSelectionMode() == DynamicTree.SELECTION_MODE.STANDARD || this.tree.getSelectionMode() == DynamicTree.SELECTION_MODE.SELECT_UPPER) && this.children != null) {
            object = this.children.elements();
            while (object.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)object.nextElement();
                myTreeNode.setChecked(bl);
            }
        }
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean bl) {
        this.updated = bl;
    }

    public TREE_OBJECT getType() {
        return this.type;
    }

    public int getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(int n) {
        this.dbVersion = n;
    }
}

